/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _ZEP_MEMMAP_H
#define _ZEP_MEMMAP_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             zep_memmap.h
 * DESCRIPTION:      Memory map definition
 *
 **********************************************************************/


// Definitions for overhead FIFOS
#define  NUM_FIFOS   3

#define BYTES_IN_TX_FIFO0  32
#define BYTES_IN_TX_FIFO1  32
#define BYTES_IN_TX_FIFO2  6

#define BYTES_IN_RX_FIFO0  32
#define BYTES_IN_RX_FIFO1  32
#define BYTES_IN_RX_FIFO2  6
/**********************************************************************
* Sample Memory map for Zephyr RAM  blocks
**********************************************************************/

#ifdef VRX518
#define ZEP_REG_TX_BASE_GLOBAL         (uint32)(0x30D800)
#define ZEP_REG_RX_BASE_GLOBAL         (uint32)(0x30DC00)
#else
#define ZEP_REG_TX_BASE_GLOBAL         (uint32)(0x20D800)
#define ZEP_REG_RX_BASE_GLOBAL         (uint32)(0x20DC00)
#endif

#ifdef VRX518
#define ZEP_RAM_RX_CW_ADDR          (uint32)(0x30C000)
#define ZEP_RAM_RX_CW_SIZE          (2*512)

#define ZEP_RAM_IIBRAM_ADDR         (uint32)(0x40000)
#define ZEP_RAM_IIBRAM_SIZE         425984 /*(416*1024)*/

// Data Transfer Buffer
#define ZEP_ILV_RAM_DTB_ADDR        (uint32)(0x344000)  //Tx/Rx Data Transfer Buffer
#define ZEP_ILV_RAM_DTB_SIZE        (4*2816)
#else
#define ZEP_RAM_RX_CW_ADDR          (uint32)(0x20C000)
#define ZEP_RAM_RX_CW_SIZE              (2*512)

#define ZEP_RAM_IIBRAM_ADDR            (uint32)(0x40000)
#define ZEP_RAM_IIBRAM_SIZE            (2*84*1024)

// Data Transfer Buffer
#define ZEP_ILV_RAM_DTB_ADDR        (uint32)(0x254000)   //Tx/Rx Data Transfer Buffer
#define ZEP_ILV_RAM_DTB_SIZE        (4*2816)
#endif

////////////////////////////////////
#ifdef VRX518
#define ZEP_ILV_RAM_DMET_ADDR    (uint32)(0x34C000) // RX Deinterleave Metric RAM (byte access)
#define ZEP_ILV_RAM_DMET_SIZE    (4*512)
#else
#define ZEP_ILV_RAM_DMET_ADDR       (uint32)(0x257000) // RX Deinterleave Metric RAM (byte access)
#define ZEP_ILV_RAM_DMET_SIZE       (4*512)
#endif

/**********************************************************************
 * Memory map for Global Zephyr-FC registers
 **********************************************************************/


/**********************************************************************
 * Memory map Zephyr-FCI registers
 **********************************************************************/
// Per LP Registers
#define  ZT_R0_OFFSET            (0x00)
#define  ZT_R4_OFFSET            (0x04)
#define  ZT_R8_OFFSET            (0x08)
#define  ZT_R12_OFFSET           (0x0C)
#define  ZT_CODEWORD_OFFSET           (0x10)
#define  ZT_VBC_SIZE_OFFSET           (0x14)
#define  ZT_FRAMING_OFFSET       (0x18)
#define  ZT_OHRATE_OFFSET             (0x1C)
#define  ZT_FLAG_CTRL0_OFFSET         (0x20)
#define  ZT_FLAG_CTRL1_OFFSET         (0x24)
#define  ZT_CRC0_OFFSET               (0x28)
#define  ZT_CRC_POLY0_OFFSET          (0x2C)
#define  ZT_CRC_CTRL0_OFFSET          (0x30)
#define  ZT_CRC1_OFFSET               (0x34)
#define  ZT_CRC_POLY1_OFFSET          (0x38)
#define  ZT_CRC_CTRL1_OFFSET          (0x3C)
#define  ZT_SCR_OFFSET                (0x40)
#define  ZT_SCR_POLY_OFFSET         (0x44)
#define  ZT_SCR_CTRL_OFFSET         (0x48)
#define  ZT_SCR_STATE_OFFSET          (0x4C)
#define  ZT_DTB_CTRL_OFFSET         (0x50)
#define  ZT_DTB_PTRS_OFFSET         (0x54)
#define  ZT_ILVB_WRAD_OFFSET          (0x58)
#define  ZT_ILVB_RDAD_OFFSET          (0x5C)
#define  ZT_ILVB_WRPTR_OFFSET         (0x60)
#define  ZT_ILVB_RDPTR_OFFSET         (0x64)
#define  ZT_FIFO_BASE0_OFFSET         (0x68)
#define  ZT_FIFO_PTRS0_OFFSET         (0x6C)
#define  ZT_FIFO_CNST0_OFFSET         (0x70)
#define  ZT_FIFO_BASE1_OFFSET         (0x74)
#define  ZT_FIFO_PTRS1_OFFSET         (0x78)
#define  ZT_FIFO_CNST1_OFFSET         (0x7C)
#define  ZT_FIFO_BASE2_OFFSET         (0x80)
#define  ZT_FIFO_PTRS2_OFFSET         (0x84)
#define  ZT_FIFO_CNST2_OFFSET         (0x88)
#define  ZT_FIFO_BASE3_OFFSET         (0x8C)
#define  ZT_FIFO_PTRS3_OFFSET         (0x90)
#define  ZT_FIFO_CNST3_OFFSET         (0x94)
#define  ZT_DEPTH_OFFSET              (0x98)
#define  ZT_ILV_PARAMS0_OFFSET        (0x9C)
#define  ZT_ILV_BASE0_OFFSET          (0xA0)
#define  ZT_ILV_SIZE0_OFFSET          (0xA4)
#define  ZT_ILV_MAX_FULLNESS0_OFFSET  (0xA8)
#define  ZT_ILV_MIN_FULLNESS0_OFFSET  (0xAC)
#define  ZT_ILV_FULLNESS0_OFFSET      (0xB0)
#define  ZT_ILV_CNTRS0_OFFSET       (0xB4)
#define  ZT_ILV_PMS_CNTRS0_OFFSET   (0xB8)
#define  ZT_ILV_PMD_CNTRS0_OFFSET   (0xBC)
#define  ZT_ILV_PARAMS1_OFFSET        (0xC0)
#define  ZT_ILV_BASE1_OFFSET          (0xC4)
#define  ZT_ILV_SIZE1_OFFSET          (0xC8)
#define  ZT_ILV_MAX_FULLNESS1_OFFSET  (0xCC)
#define  ZT_ILV_MIN_FULLNESS1_OFFSET  (0xD0)
#define  ZT_ILV_FULLNESS1_OFFSET      (0xD4)
#define  ZT_ILV_CNTRS1_OFFSET         (0xD8)
#define  ZT_ILV_PMS_CNTRS1_OFFSET   (0xDC)
#define  ZT_ILV_PMD_CNTRS1_OFFSET   (0xE0)
#define  ZT_CHECKBYTE0_OFFSET    (0xE4)
#define  ZT_CHECKBYTE1_OFFSET    (0xE8)
#define  ZT_CHECKBYTE2_OFFSET    (0xEC)
#define  ZT_CHECKBYTE3_OFFSET    (0xF0)
#define  ZT_TCSRC_STATE_OFFSET      (0xF4)
#define  ZT_UPROC_ENA_OFFSET     (0xF8)
#define  ZT_UPROC01_BASE_OFFSET     (0xFC)
#define  ZT_UPROC23_BASE_OFFSET     (0x100)
#define  ZT_UPROC45_BASE_OFFSET     (0x104)
#define  ZT_UPROC67_BASE_OFFSET     (0x108)
#define  ZT_UPROC89_BASE_OFFSET     (0x10C)
#define  ZT_UPROC_INT_OFFSET     (0x110)
#define  ZT_UPROC0_STATE0_OFFSET    (0x114)
#define  ZT_ALU_CLI_REQ_OFFSET        (0x1E4)
#ifdef VRX518
#define  ZT_UPROC5_BASE_OFFSET_35B    (ZT_ALU_CLI_REQ_OFFSET + 0x04)
#define  ZT_UPROC6_BASE_OFFSET_35B    (ZT_ALU_CLI_REQ_OFFSET + 0x08)
#define  ZT_UPROC7_BASE_OFFSET_35B    (ZT_ALU_CLI_REQ_OFFSET + 0x0C)
#define  ZT_UPROC8_BASE_OFFSET_35B    (ZT_ALU_CLI_REQ_OFFSET + 0x10)
#define  ZT_UPROC9_BASE_OFFSET_35B    (ZT_ALU_CLI_REQ_OFFSET + 0x14)
#endif

//////////////////////////////////////////////////////////////////////////////////////////////////////
#define ZEP_TX_START_ADDRESS                ZEP_REG_TX_BASE_GLOBAL

// Per LP Registers
#define ZEP_REG_ZT_R0_ADDR             (uint32)(ZEP_REG_TX_BASE_GLOBAL +  ZT_R0_OFFSET       )
#define ZEP_REG_ZT_R4_ADDR             (uint32)(ZEP_REG_TX_BASE_GLOBAL +  ZT_R4_OFFSET          )
#define ZEP_REG_ZT_R8_ADDR             (uint32)(ZEP_REG_TX_BASE_GLOBAL +  ZT_R8_OFFSET          )
#define ZEP_REG_ZT_R12_ADDR               (uint32)(ZEP_REG_TX_BASE_GLOBAL +  ZT_R12_OFFSET         )
#define ZEP_REG_ZT_CODEWORD_ADDR            (uint32)(ZEP_REG_TX_BASE_GLOBAL +  ZT_CODEWORD_OFFSET       )
#define ZEP_REG_ZT_VBC_SIZE_ADDR            (uint32)(ZEP_REG_TX_BASE_GLOBAL +  ZT_VBC_SIZE_OFFSET       )
#define ZEP_REG_ZT_FRAMING_ADDR           (uint32)(ZEP_REG_TX_BASE_GLOBAL +  ZT_FRAMING_OFFSET     )
#define ZEP_REG_ZT_OHRATE_ADDR              (uint32)(ZEP_REG_TX_BASE_GLOBAL +  ZT_OHRATE_OFFSET         )
#define ZEP_REG_ZT_FLAG_CTRL0_ADDR          (uint32)(ZEP_REG_TX_BASE_GLOBAL +  ZT_FLAG_CTRL0_OFFSET     )
#define ZEP_REG_ZT_FLAG_CTRL1_ADDR          (uint32)(ZEP_REG_TX_BASE_GLOBAL +  ZT_FLAG_CTRL1_OFFSET     )
#define ZEP_REG_ZT_CRC0_ADDR                (uint32)(ZEP_REG_TX_BASE_GLOBAL +  ZT_CRC0_OFFSET           )
#define ZEP_REG_ZT_CRC_POLY0_ADDR           (uint32)(ZEP_REG_TX_BASE_GLOBAL +  ZT_CRC_POLY0_OFFSET      )
#define ZEP_REG_ZT_CRC_CTRL0_ADDR           (uint32)(ZEP_REG_TX_BASE_GLOBAL +  ZT_CRC_CTRL0_OFFSET      )
#define ZEP_REG_ZT_CRC1_ADDR                (uint32)(ZEP_REG_TX_BASE_GLOBAL +  ZT_CRC1_OFFSET           )
#define ZEP_REG_ZT_CRC_POLY1_ADDR           (uint32)(ZEP_REG_TX_BASE_GLOBAL +  ZT_CRC_POLY1_OFFSET      )
#define ZEP_REG_ZT_CRC_CTRL1_ADDR           (uint32)(ZEP_REG_TX_BASE_GLOBAL +  ZT_CRC_CTRL1_OFFSET      )
#define ZEP_REG_ZT_SCR_ADDR                 (uint32)(ZEP_REG_TX_BASE_GLOBAL +  ZT_SCR_OFFSET            )
#define ZEP_REG_ZT_SCR_POLY_ADDR       (uint32)(ZEP_REG_TX_BASE_GLOBAL +  ZT_SCR_POLY_OFFSET    )
#define ZEP_REG_ZT_SCR_CTRL_ADDR       (uint32)(ZEP_REG_TX_BASE_GLOBAL +  ZT_SCR_CTRL_OFFSET    )
#define ZEP_REG_ZT_SCR_STATE_ADDR           (uint32)(ZEP_REG_TX_BASE_GLOBAL +  ZT_SCR_STATE_OFFSET      )
#define ZEP_REG_ZT_DTB_CTRL_ADDR       (uint32)(ZEP_REG_TX_BASE_GLOBAL +  ZT_DTB_CTRL_OFFSET    )
#define ZEP_REG_ZT_DTB_PTRS_ADDR       (uint32)(ZEP_REG_TX_BASE_GLOBAL +  ZT_DTB_PTRS_OFFSET    )
#define ZEP_REG_ZT_ILVB_WRAD_ADDR           (uint32)(ZEP_REG_TX_BASE_GLOBAL +  ZT_ILVB_WRAD_OFFSET      )
#define ZEP_REG_ZT_ILVB_RDAD_ADDR           (uint32)(ZEP_REG_TX_BASE_GLOBAL +  ZT_ILVB_RDAD_OFFSET      )
#define ZEP_REG_ZT_ILVB_WRPTR_ADDR          (uint32)(ZEP_REG_TX_BASE_GLOBAL +  ZT_ILVB_WRPTR_OFFSET     )
#define ZEP_REG_ZT_ILVB_RDPTR_ADDR          (uint32)(ZEP_REG_TX_BASE_GLOBAL +  ZT_ILVB_RDPTR_OFFSET     )
#define ZEP_REG_ZT_FIFO_BASE0_ADDR          (uint32)(ZEP_REG_TX_BASE_GLOBAL +  ZT_FIFO_BASE0_OFFSET     )
#define ZEP_REG_ZT_FIFO_PTRS0_ADDR          (uint32)(ZEP_REG_TX_BASE_GLOBAL +  ZT_FIFO_PTRS0_OFFSET     )
#define ZEP_REG_ZT_FIFO_CNST0_ADDR          (uint32)(ZEP_REG_TX_BASE_GLOBAL +  ZT_FIFO_CNST0_OFFSET     )
#define ZEP_REG_ZT_FIFO_BASE1_ADDR          (uint32)(ZEP_REG_TX_BASE_GLOBAL +  ZT_FIFO_BASE1_OFFSET     )
#define ZEP_REG_ZT_FIFO_PTRS1_ADDR          (uint32)(ZEP_REG_TX_BASE_GLOBAL +  ZT_FIFO_PTRS1_OFFSET     )
#define ZEP_REG_ZT_FIFO_CNST1_ADDR          (uint32)(ZEP_REG_TX_BASE_GLOBAL +  ZT_FIFO_CNST1_OFFSET     )
#define ZEP_REG_ZT_FIFO_BASE2_ADDR          (uint32)(ZEP_REG_TX_BASE_GLOBAL +  ZT_FIFO_BASE2_OFFSET     )
#define ZEP_REG_ZT_FIFO_PTRS2_ADDR          (uint32)(ZEP_REG_TX_BASE_GLOBAL +  ZT_FIFO_PTRS2_OFFSET     )
#define ZEP_REG_ZT_FIFO_CNST2_ADDR          (uint32)(ZEP_REG_TX_BASE_GLOBAL +  ZT_FIFO_CNST2_OFFSET     )
#define ZEP_REG_ZT_FIFO_BASE3_ADDR          (uint32)(ZEP_REG_TX_BASE_GLOBAL +  ZT_FIFO_BASE3_OFFSET     )
#define ZEP_REG_ZT_FIFO_PTRS3_ADDR          (uint32)(ZEP_REG_TX_BASE_GLOBAL +  ZT_FIFO_PTRS3_OFFSET     )
#define ZEP_REG_ZT_FIFO_CNST3_ADDR          (uint32)(ZEP_REG_TX_BASE_GLOBAL +  ZT_FIFO_CNST3_OFFSET     )
#define ZEP_REG_ZT_DEPTH_ADDR               (uint32)(ZEP_REG_TX_BASE_GLOBAL +  ZT_DEPTH_OFFSET          )
#define ZEP_REG_ZT_ILV_PARAMS0_ADDR         (uint32)(ZEP_REG_TX_BASE_GLOBAL +  ZT_ILV_PARAMS0_OFFSET    )
#define ZEP_REG_ZT_ILV_BASE0_ADDR           (uint32)(ZEP_REG_TX_BASE_GLOBAL + ZT_ILV_BASE0_OFFSET         )
#define ZEP_REG_ZT_ILV_SIZE0_ADDR           (uint32)(ZEP_REG_TX_BASE_GLOBAL + ZT_ILV_SIZE0_OFFSET         )
#define ZEP_REG_ZT_ILV_MAX_FULLNESS0_ADDR   (uint32)(ZEP_REG_TX_BASE_GLOBAL + ZT_ILV_MAX_FULLNESS0_OFFSET )
#define ZEP_REG_ZT_ILV_MIN_FULLNESS0_ADDR   (uint32)(ZEP_REG_TX_BASE_GLOBAL + ZT_ILV_MIN_FULLNESS0_OFFSET )
#define ZEP_REG_ZT_ILV_FULLNESS0_ADDR       (uint32)(ZEP_REG_TX_BASE_GLOBAL + ZT_ILV_FULLNESS0_OFFSET     )
#define ZEP_REG_ZT_ILV_CNTRS0_ADDR          (uint32)(ZEP_REG_TX_BASE_GLOBAL + ZT_ILV_CNTRS0_OFFSET       )
#define ZEP_REG_ZT_ILV_PMS_CNTRS0_ADDR       (uint32)(ZEP_REG_TX_BASE_GLOBAL + ZT_ILV_PMS_CNTRS0_OFFSET     )
#define ZEP_REG_ZT_ILV_PMD_CNTRS0_ADDR       (uint32)(ZEP_REG_TX_BASE_GLOBAL + ZT_ILV_PMD_CNTRS0_OFFSET     )
#define ZEP_REG_ZT_ILV_PARAMS1_ADDR         (uint32)(ZEP_REG_TX_BASE_GLOBAL + ZT_ILV_PARAMS1_OFFSET       )
#define ZEP_REG_ZT_ILV_BASE1_ADDR           (uint32)(ZEP_REG_TX_BASE_GLOBAL + ZT_ILV_BASE1_OFFSET         )
#define ZEP_REG_ZT_ILV_SIZE1_ADDR           (uint32)(ZEP_REG_TX_BASE_GLOBAL + ZT_ILV_SIZE1_OFFSET         )
#define ZEP_REG_ZT_ILV_MAX_FULLNESS1_ADDR   (uint32)(ZEP_REG_TX_BASE_GLOBAL + ZT_ILV_MAX_FULLNESS1_OFFSET )
#define ZEP_REG_ZT_ILV_MIN_FULLNESS1_ADDR   (uint32)(ZEP_REG_TX_BASE_GLOBAL + ZT_ILV_MIN_FULLNESS1_OFFSET )
#define ZEP_REG_ZT_ILV_FULLNESS1_ADDR       (uint32)(ZEP_REG_TX_BASE_GLOBAL + ZT_ILV_FULLNESS1_OFFSET     )
#define ZEP_REG_ZT_ILV_CNTRS1_ADDR          (uint32)(ZEP_REG_TX_BASE_GLOBAL + ZT_ILV_CNTRS1_OFFSET        )
#define ZEP_REG_ZT_ILV_PMS_CNTRS1_ADDR       (uint32)(ZEP_REG_TX_BASE_GLOBAL + ZT_ILV_PMS_CNTRS1_OFFSET     )
#define ZEP_REG_ZT_ILV_PMD_CNTRS1_ADDR       (uint32)(ZEP_REG_TX_BASE_GLOBAL + ZT_ILV_PMD_CNTRS1_OFFSET     )
#define ZEP_REG_ZT_CHECKBYTE0_ADDR        (uint32)(ZEP_REG_TX_BASE_GLOBAL + ZT_CHECKBYTE0_OFFSET      )
#define ZEP_REG_ZT_CHECKBYTE1_ADDR        (uint32)(ZEP_REG_TX_BASE_GLOBAL + ZT_CHECKBYTE1_OFFSET      )
#define ZEP_REG_ZT_CHECKBYTE2_ADDR        (uint32)(ZEP_REG_TX_BASE_GLOBAL + ZT_CHECKBYTE2_OFFSET      )
#define ZEP_REG_ZT_CHECKBYTE3_ADDR        (uint32)(ZEP_REG_TX_BASE_GLOBAL + ZT_CHECKBYTE3_OFFSET      )
#define ZEP_REG_ZT_TCSRC_STATE_ADDR       (uint32)(ZEP_REG_TX_BASE_GLOBAL + ZT_TCSRC_STATE_OFFSET     )
#define ZEP_REG_ZT_UPROC_ENA_ADDR         (uint32)(ZEP_REG_TX_BASE_GLOBAL + ZT_UPROC_ENA_OFFSET    )
#define ZEP_REG_ZT_UPROC01_BASE_ADDR      (uint32)(ZEP_REG_TX_BASE_GLOBAL + ZT_UPROC01_BASE_OFFSET    )
#define ZEP_REG_ZT_UPROC23_BASE_ADDR      (uint32)(ZEP_REG_TX_BASE_GLOBAL + ZT_UPROC23_BASE_OFFSET    )
#define ZEP_REG_ZT_UPROC45_BASE_ADDR      (uint32)(ZEP_REG_TX_BASE_GLOBAL + ZT_UPROC45_BASE_OFFSET    )
#define ZEP_REG_ZT_UPROC67_BASE_ADDR      (uint32)(ZEP_REG_TX_BASE_GLOBAL + ZT_UPROC67_BASE_OFFSET    )
#define ZEP_REG_ZT_UPROC89_BASE_ADDR      (uint32)(ZEP_REG_TX_BASE_GLOBAL + ZT_UPROC89_BASE_OFFSET    )
#define ZEP_REG_ZT_UPROC_INT_ADDR         (uint32)(ZEP_REG_TX_BASE_GLOBAL + ZT_UPROC_INT_OFFSET    )
#define ZEP_REG_ZT_UPROC0_STATE0_ADDR     (uint32)(ZEP_REG_TX_BASE_GLOBAL + ZT_UPROC0_STATE0_OFFSET   )

#define ZEP_REG_ZT_UPROC0_STATE1_ADDR     (uint32)(ZEP_REG_ZT_UPROC0_STATE0_ADDR + 0x4)
#define ZEP_REG_ZT_UPROC0_STATE2_ADDR     (uint32)(ZEP_REG_ZT_UPROC0_STATE0_ADDR + 0x8)
#define ZEP_REG_ZT_UPROC0_STATE3_ADDR     (uint32)(ZEP_REG_ZT_UPROC0_STATE0_ADDR + 0xc)
#define ZEP_REG_ZT_UPROC0_STATE4_ADDR     (uint32)(ZEP_REG_ZT_UPROC0_STATE0_ADDR + 0x10)
#define ZEP_REG_ZT_UPROC1_STATE0_ADDR     (uint32)(ZEP_REG_ZT_UPROC0_STATE0_ADDR + 0x14)
#define ZEP_REG_ZT_UPROC1_STATE1_ADDR     (uint32)(ZEP_REG_ZT_UPROC1_STATE0_ADDR + 0x4)
#define ZEP_REG_ZT_UPROC1_STATE2_ADDR     (uint32)(ZEP_REG_ZT_UPROC1_STATE0_ADDR + 0x8)
#define ZEP_REG_ZT_UPROC1_STATE3_ADDR     (uint32)(ZEP_REG_ZT_UPROC1_STATE0_ADDR + 0xc)
#define ZEP_REG_ZT_UPROC1_STATE4_ADDR     (uint32)(ZEP_REG_ZT_UPROC1_STATE0_ADDR + 0x10)
#define ZEP_REG_ZT_UPROC2_STATE0_ADDR     (uint32)(ZEP_REG_ZT_UPROC1_STATE0_ADDR + 0x14)
#define ZEP_REG_ZT_UPROC2_STATE1_ADDR     (uint32)(ZEP_REG_ZT_UPROC2_STATE0_ADDR + 0x4)
#define ZEP_REG_ZT_UPROC2_STATE2_ADDR     (uint32)(ZEP_REG_ZT_UPROC2_STATE0_ADDR + 0x8)
#define ZEP_REG_ZT_UPROC2_STATE3_ADDR     (uint32)(ZEP_REG_ZT_UPROC2_STATE0_ADDR + 0xc)
#define ZEP_REG_ZT_UPROC2_STATE4_ADDR     (uint32)(ZEP_REG_ZT_UPROC2_STATE0_ADDR + 0x10)
#define ZEP_REG_ZT_UPROC3_STATE0_ADDR     (uint32)(ZEP_REG_ZT_UPROC2_STATE0_ADDR + 0x14)
#define ZEP_REG_ZT_UPROC3_STATE1_ADDR     (uint32)(ZEP_REG_ZT_UPROC3_STATE0_ADDR + 0x4)
#define ZEP_REG_ZT_UPROC3_STATE2_ADDR     (uint32)(ZEP_REG_ZT_UPROC3_STATE0_ADDR + 0x8)
#define ZEP_REG_ZT_UPROC3_STATE3_ADDR     (uint32)(ZEP_REG_ZT_UPROC3_STATE0_ADDR + 0xc)
#define ZEP_REG_ZT_UPROC3_STATE4_ADDR     (uint32)(ZEP_REG_ZT_UPROC3_STATE0_ADDR + 0x10)
#define ZEP_REG_ZT_UPROC4_STATE0_ADDR     (uint32)(ZEP_REG_ZT_UPROC3_STATE0_ADDR + 0x14)
#define ZEP_REG_ZT_UPROC4_STATE1_ADDR     (uint32)(ZEP_REG_ZT_UPROC4_STATE0_ADDR + 0x4)
#define ZEP_REG_ZT_UPROC4_STATE2_ADDR     (uint32)(ZEP_REG_ZT_UPROC4_STATE0_ADDR + 0x8)
#define ZEP_REG_ZT_UPROC4_STATE3_ADDR     (uint32)(ZEP_REG_ZT_UPROC4_STATE0_ADDR + 0xc)
#define ZEP_REG_ZT_UPROC4_STATE4_ADDR     (uint32)(ZEP_REG_ZT_UPROC4_STATE0_ADDR + 0x10)
#define ZEP_REG_ZT_UPROC5_STATE0_ADDR     (uint32)(ZEP_REG_ZT_UPROC4_STATE0_ADDR + 0x14)
#define ZEP_REG_ZT_UPROC5_STATE1_ADDR     (uint32)(ZEP_REG_ZT_UPROC5_STATE0_ADDR + 0x4)
#define ZEP_REG_ZT_UPROC5_STATE2_ADDR     (uint32)(ZEP_REG_ZT_UPROC5_STATE0_ADDR + 0x8)
#define ZEP_REG_ZT_UPROC5_STATE3_ADDR     (uint32)(ZEP_REG_ZT_UPROC5_STATE0_ADDR + 0xc)
#define ZEP_REG_ZT_UPROC5_STATE4_ADDR     (uint32)(ZEP_REG_ZT_UPROC5_STATE0_ADDR + 0x10)
#define ZEP_REG_ZT_UPROC6_STATE0_ADDR     (uint32)(ZEP_REG_ZT_UPROC5_STATE0_ADDR + 0x14)
#define ZEP_REG_ZT_UPROC6_STATE1_ADDR     (uint32)(ZEP_REG_ZT_UPROC6_STATE0_ADDR + 0x4)
#define ZEP_REG_ZT_UPROC6_STATE2_ADDR     (uint32)(ZEP_REG_ZT_UPROC6_STATE0_ADDR + 0x8)
#define ZEP_REG_ZT_UPROC6_STATE3_ADDR     (uint32)(ZEP_REG_ZT_UPROC6_STATE0_ADDR + 0xc)
#define ZEP_REG_ZT_UPROC6_STATE4_ADDR     (uint32)(ZEP_REG_ZT_UPROC6_STATE0_ADDR + 0x10)
#define ZEP_REG_ZT_UPROC7_STATE0_ADDR     (uint32)(ZEP_REG_ZT_UPROC6_STATE0_ADDR + 0x14)
#define ZEP_REG_ZT_UPROC7_STATE1_ADDR     (uint32)(ZEP_REG_ZT_UPROC7_STATE0_ADDR + 0x4)
#define ZEP_REG_ZT_UPROC7_STATE2_ADDR     (uint32)(ZEP_REG_ZT_UPROC7_STATE0_ADDR + 0x8)
#define ZEP_REG_ZT_UPROC7_STATE3_ADDR     (uint32)(ZEP_REG_ZT_UPROC7_STATE0_ADDR + 0xc)
#define ZEP_REG_ZT_UPROC7_STATE4_ADDR     (uint32)(ZEP_REG_ZT_UPROC7_STATE0_ADDR + 0x10)
#define ZEP_REG_ZT_UPROC8_STATE0_ADDR     (uint32)(ZEP_REG_ZT_UPROC7_STATE0_ADDR + 0x14)
#define ZEP_REG_ZT_UPROC8_STATE1_ADDR     (uint32)(ZEP_REG_ZT_UPROC8_STATE0_ADDR + 0x4)
#define ZEP_REG_ZT_UPROC8_STATE2_ADDR     (uint32)(ZEP_REG_ZT_UPROC8_STATE0_ADDR + 0x8)
#define ZEP_REG_ZT_UPROC8_STATE3_ADDR     (uint32)(ZEP_REG_ZT_UPROC8_STATE0_ADDR + 0xc)
#define ZEP_REG_ZT_UPROC8_STATE4_ADDR     (uint32)(ZEP_REG_ZT_UPROC8_STATE0_ADDR + 0x10)
#define ZEP_REG_ZT_UPROC9_STATE0_ADDR     (uint32)(ZEP_REG_ZT_UPROC8_STATE0_ADDR + 0x14)
#define ZEP_REG_ZT_UPROC9_STATE1_ADDR     (uint32)(ZEP_REG_ZT_UPROC9_STATE0_ADDR + 0x4)
#define ZEP_REG_ZT_UPROC9_STATE2_ADDR     (uint32)(ZEP_REG_ZT_UPROC9_STATE0_ADDR + 0x8)
#define ZEP_REG_ZT_UPROC9_STATE3_ADDR     (uint32)(ZEP_REG_ZT_UPROC9_STATE0_ADDR + 0xc)
#define ZEP_REG_ZT_UPROC9_STATE4_ADDR     (uint32)(ZEP_REG_ZT_UPROC9_STATE0_ADDR + 0x10)
#define ZEP_REG_ZT_UPROC_STATE5_ADDR      (uint32)(ZEP_REG_ZT_UPROC9_STATE4_ADDR + 0x4)
#define ZEP_REG_ZT_ALU_STATE_ADDR         (uint32)(ZEP_REG_ZT_UPROC_STATE5_ADDR + 0x4)
#define ZEP_REG_ZT_ALU_CLI_REQ_ADDR             (uint32)(ZEP_REG_ZT_ALU_STATE_ADDR + 0x4)

#define ZEP_REG_Z_VERSION_ADDR            (uint32)(ZEP_REG_TX_BASE_GLOBAL + 0x1E8 )  /* 0x1E8 = 0x114 +  4(bytes)*5(states)*10(proc) +3*4 */
#define ZEP_REG_Z_MBOX_ACCESS_ADDR        (uint32)(ZEP_REG_Z_VERSION_ADDR + 4)

//Per Port Registers
#define ZEP_REG_ZT_FIFO_ACCESS_ADDR       (uint32)(ZEP_REG_Z_MBOX_ACCESS_ADDR + 4)
#define ZEP_REG_ZT_CONFIG_ADDR            (uint32)(ZEP_REG_ZT_FIFO_ACCESS_ADDR +4)
#define ZEP_REG_ZT_PMS_SIZE_ADDR       (uint32)(ZEP_REG_ZT_CONFIG_ADDR     +4)
#define ZEP_REG_ZT_DT_SIZE_ADDR           (uint32)(ZEP_REG_ZT_PMS_SIZE_ADDR   +4)
#define ZEP_REG_ZT_QTDTB_CONFIG_LP0_ADDR  (uint32)(ZEP_REG_ZT_DT_SIZE_ADDR +4)
#define ZEP_REG_ZT_QTDTB_CONFIG_LP1_ADDR  (uint32)(ZEP_REG_ZT_QTDTB_CONFIG_LP0_ADDR   +4)
#define ZEP_REG_ZT_QTDTB_CONFIG_LP2_ADDR  (uint32)(ZEP_REG_ZT_QTDTB_CONFIG_LP1_ADDR   +4)
#define ZEP_REG_ZT_QTDTB_ADDR_LP01_ADDR      (uint32)(ZEP_REG_ZT_QTDTB_CONFIG_LP2_ADDR   +4)
#define ZEP_REG_ZT_QTDTB_ADDR_LP2_ADDR    (uint32)(ZEP_REG_ZT_QTDTB_ADDR_LP01_ADDR  +4)
#define ZEP_REG_ZT_DTB_OFFSET_ADDR        (uint32)(ZEP_REG_ZT_QTDTB_ADDR_LP2_ADDR      +4)
#define ZEP_REG_ZT_ERR_STAT_ADDR       (uint32)(ZEP_REG_ZT_DTB_OFFSET_ADDR +4)
// #define ZEP_REG_ZT_NTR_IBITS_ADDR      (uint32)(ZEP_REG_ZT_ERR_STAT_ADDR +4)
// #define ZEP_REG_ZT_NTR_CLK_ADDR        (uint32)(ZEP_REG_ZT_NTR_IBITS_ADDR  +4)
// #define ZEP_REG_ZT_LTR_CLK_ADDR        (uint32)(ZEP_REG_ZT_NTR_CLK_ADDR  +4)

#define ZEP_REG_ZT_ALU_CLI_REQ_ALIAS0_ADDR      (uint32)(ZEP_REG_ZT_ERR_STAT_ADDR         + 0x4)
#define ZEP_REG_ZT_ALU_CLI_REQ_ALIAS1_ADDR      (uint32)(ZEP_REG_ZT_ALU_CLI_REQ_ALIAS0_ADDR  + 0x4)
#define ZEP_REG_ZT_ALU_CLI_REQ_ALIAS2_ADDR      (uint32)(ZEP_REG_ZT_ALU_CLI_REQ_ALIAS1_ADDR  + 0x4)


#define ZEP_REG_NUM_TX_WORDS           (uint32)((ZEP_REG_ZT_ALU_CLI_REQ_ALIAS2_ADDR - ZEP_REG_ZT_R0_ADDR + 4)/4)
#ifdef VRX518
//OPEN_VRX518 -Done
#define ZEP_REG_TX_PRAM_SIZE           (uint32)((ZEP_PRAM_ZT_UPROC9_BASE_LP0_35B_ADDR - ZEP_PRAM_ZT_R0_LP0_ADDR + 4)/4)
#else
#define ZEP_REG_TX_PRAM_SIZE           (uint32)((ZEP_REG_ZT_ALU_CLI_REQ_ADDR - ZEP_REG_ZT_R0_ADDR + 4)/4)
#endif //VRX518

#define ZEP_REG_GLBTX_SIZE             (uint32)((ZEP_REG_ZT_ALU_CLI_REQ_ALIAS2_ADDR - ZEP_REG_Z_VERSION_ADDR + 4)/4)



/**********************************************************************
 * Memory map RX PRAM Zephyr-FC registers
 **********************************************************************/

 // offsets
// Per Lp Registers
 #define ZR_R0_OFFSET               (0x00)
 #define ZR_R4_OFFSET               (0x04)
 #define ZR_R8_OFFSET               (0x08)
 #define ZR_R12_OFFSET              (0x0C)
 #define ZR_CODEWORD_OFFSET            (0x10)
 #define ZR_VBC_SIZE_OFFSET            (0x14)
 #define ZR_FRAMING_OFFSET          (0x18)
 #define ZR_OHRATE_OFFSET             (0x1C)
 #define ZR_FLAG_CTRL0_OFFSET         (0x20)
 #define ZR_FLAG_CTRL1_OFFSET         (0x24)
 #define ZR_CRC0_OFFSET               (0x28)
 #define ZR_CRC_POLY0_OFFSET          (0x2C)
 #define ZR_CRC_CTRL0_OFFSET          (0x30)
 #define ZR_CRC1_OFFSET               (0x34)
 #define ZR_CRC_POLY1_OFFSET          (0x38)
 #define ZR_CRC_CTRL1_OFFSET          (0x3C)
 #define ZR_SCR_OFFSET                (0x40)
 #define ZR_SCR_POLY_OFFSET         (0x44)
 #define ZR_SCR_CTRL_OFFSET         (0x48)
 #define ZR_SCR_STATE_OFFSET          (0x4C)
 #define ZR_DTB_CTRL_OFFSET         (0x50)
 #define ZR_DTB_PTRS_OFFSET         (0x54)
 #define ZR_ILVB_WRAD_OFFSET          (0x58)
 #define ZR_ILVB_RDAD_OFFSET          (0x5C)
 #define ZR_ILVB_WRPTR_OFFSET         (0x60)
 #define ZR_ILVB_RDPTR_OFFSET         (0x64)
 #define ZR_FIFO_BASE0_OFFSET         (0x68)
 #define ZR_FIFO_PTRS0_OFFSET         (0x6C)
 #define ZR_FIFO_CNST0_OFFSET         (0x70)
 #define ZR_FIFO_BASE1_OFFSET         (0x74)
 #define ZR_FIFO_PTRS1_OFFSET         (0x78)
 #define ZR_FIFO_CNST1_OFFSET         (0x7C)
 #define ZR_FIFO_BASE2_OFFSET         (0x80)
 #define ZR_FIFO_PTRS2_OFFSET         (0x84)
 #define ZR_FIFO_CNST2_OFFSET         (0x88)
 #define ZR_FIFO_BASE3_OFFSET         (0x8C)
 #define ZR_FIFO_PTRS3_OFFSET         (0x90)
 #define ZR_FIFO_CNST3_OFFSET         (0x94)
 #define ZR_DEPTH_OFFSET              (0x98)
 #define ZR_ILV_PARAMS0_OFFSET        (0x9C)
 #define ZR_ILV_BASE0_OFFSET          (0xA0)
 #define ZR_ILV_SIZE0_OFFSET          (0xA4)
 #define ZR_ILV_MAX_FULLNESS0_OFFSET  (0xA8)
 #define ZR_ILV_MIN_FULLNESS0_OFFSET  (0xAC)
 #define ZR_ILV_FULLNESS0_OFFSET      (0xB0)
 #define ZR_ILV_CNTRS0_OFFSET         (0xB4)
 #define ZR_ILV_PMS_CNTRS0_OFFSET     (0xB8)
 #define ZR_ILV_PMD_CNTRS0_OFFSET     (0xBC)
 #define ZR_ILV_PARAMS1_OFFSET        (0xC0)
 #define ZR_ILV_BASE1_OFFSET          (0xC4)
 #define ZR_ILV_SIZE1_OFFSET          (0xC8)
 #define ZR_ILV_MAX_FULLNESS1_OFFSET  (0xCC)
 #define ZR_ILV_MIN_FULLNESS1_OFFSET  (0xD0)
 #define ZR_ILV_FULLNESS1_OFFSET      (0xD4)
 #define ZR_ILV_CNTRS1_OFFSET         (0xD8)
 #define ZR_ILV_PMS_CNTRS1_OFFSET     (0xDC)
 #define ZR_ILV_PMD_CNTRS1_OFFSET     (0xE0)
 #define ZIR_DL_REL0_OFFSET         (0xE4)
 #define ZIR_NL_REL0_OFFSET         (0xE8)
 #define ZIR_DMETRIC0_OFFSET        (0xEC)
 #define ZIR_DMETRIC_CTRL_OFFSET    (0xF0)
 #define ZIR_LPBITS_OFFSET       (0xF4)
 #define ZR_CW_COUNT_OFFSET         (0xF8)
 #define ZR_FEC_CNT_OFFSET       (0xFC)
 #define ZR_UNCORR_CW0_OFFSET       (0x100)
 #define ZR_UNCORR_CW1_OFFSET       (0x104)
 #define ZR_WB_SCORE_CTL_OFFSET     (0x108)
 #define ZR_WB_SCORE2_OFFSET        (0x10C)
 #define ZR_UPROC_ENA_OFFSET        (0x110)
 #define ZR_UPROC01_BASE_OFFSET     (0x114)
 #define ZR_UPROC23_BASE_OFFSET     (0x118)
 #define ZR_UPROC45_BASE_OFFSET     (0x11C)
 #define ZR_UPROC67_BASE_OFFSET     (0x120)
 #define ZR_UPROC89_BASE_OFFSET     (0x124)
 #define ZR_UPROC_INT_OFFSET        (0x128)
 #define ZR_UPROC0_STATE0_OFFSET    (0x12C)
 #define ZR_ALU_CLI_REQ_OFFSET      (0x1FC)
#ifdef VRX518
 #define ZR_UPROC5_BASE_OFFSET_35B   (ZR_ALU_CLI_REQ_OFFSET + 0x04)
 #define ZR_UPROC6_BASE_OFFSET_35B   (ZR_ALU_CLI_REQ_OFFSET + 0x08)
 #define ZR_UPROC7_BASE_OFFSET_35B   (ZR_ALU_CLI_REQ_OFFSET + 0x0C)
 #define ZR_UPROC8_BASE_OFFSET_35B   (ZR_ALU_CLI_REQ_OFFSET + 0x10)
 #define ZR_UPROC9_BASE_OFFSET_35B   (ZR_ALU_CLI_REQ_OFFSET + 0x14)
#endif




 ///////----------------------

#define ZEP_RX_START_ADDRESS                ZEP_REG_RX_BASE_GLOBAL

// Per Lp Registers
#define ZEP_REG_ZR_R0_ADDR             (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_R0_OFFSET           )
#define ZEP_REG_ZR_R4_ADDR             (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_R4_OFFSET           )
#define ZEP_REG_ZR_R8_ADDR             (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_R8_OFFSET           )
#define ZEP_REG_ZR_R12_ADDR            (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_R12_OFFSET          )
#define ZEP_REG_ZR_CODEWORD_ADDR           (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_CODEWORD_OFFSET         )
#define ZEP_REG_ZR_VBC_SIZE_ADDR           (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_VBC_SIZE_OFFSET         )
#define ZEP_REG_ZR_FRAMING_ADDR        (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_FRAMING_OFFSET         )
#define ZEP_REG_ZR_OHRATE_ADDR             (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_OHRATE_OFFSET           )
#define ZEP_REG_ZR_FLAG_CTRL0_ADDR         (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_FLAG_CTRL0_OFFSET       )
#define ZEP_REG_ZR_FLAG_CTRL1_ADDR         (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_FLAG_CTRL1_OFFSET       )
#define ZEP_REG_ZR_CRC0_ADDR               (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_CRC0_OFFSET             )
#define ZEP_REG_ZR_CRC_POLY0_ADDR          (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_CRC_POLY0_OFFSET        )
#define ZEP_REG_ZR_CRC_CTRL0_ADDR          (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_CRC_CTRL0_OFFSET        )
#define ZEP_REG_ZR_CRC1_ADDR               (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_CRC1_OFFSET             )
#define ZEP_REG_ZR_CRC_POLY1_ADDR          (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_CRC_POLY1_OFFSET        )
#define ZEP_REG_ZR_CRC_CTRL1_ADDR          (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_CRC_CTRL1_OFFSET        )
#define ZEP_REG_ZR_SCR_ADDR                (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_SCR_OFFSET              )
#define ZEP_REG_ZR_SCR_POLY_ADDR       (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_SCR_POLY_OFFSET     )
#define ZEP_REG_ZR_SCR_CTRL_ADDR       (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_SCR_CTRL_OFFSET     )
#define ZEP_REG_ZR_SCR_STATE_ADDR          (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_SCR_STATE_OFFSET        )
#define ZEP_REG_ZR_DTB_CTRL_ADDR       (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_DTB_CTRL_OFFSET     )
#define ZEP_REG_ZR_DTB_PTRS_ADDR       (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_DTB_PTRS_OFFSET     )
#define ZEP_REG_ZR_ILVB_WRAD_ADDR          (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_ILVB_WRAD_OFFSET        )
#define ZEP_REG_ZR_ILVB_RDAD_ADDR          (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_ILVB_RDAD_OFFSET        )
#define ZEP_REG_ZR_ILVB_WRPTR_ADDR         (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_ILVB_WRPTR_OFFSET       )
#define ZEP_REG_ZR_ILVB_RDPTR_ADDR         (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_ILVB_RDPTR_OFFSET       )
#define ZEP_REG_ZR_FIFO_BASE0_ADDR         (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_FIFO_BASE0_OFFSET       )
#define ZEP_REG_ZR_FIFO_PTRS0_ADDR         (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_FIFO_PTRS0_OFFSET       )
#define ZEP_REG_ZR_FIFO_CNST0_ADDR         (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_FIFO_CNST0_OFFSET       )
#define ZEP_REG_ZR_FIFO_BASE1_ADDR         (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_FIFO_BASE1_OFFSET       )
#define ZEP_REG_ZR_FIFO_PTRS1_ADDR         (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_FIFO_PTRS1_OFFSET       )
#define ZEP_REG_ZR_FIFO_CNST1_ADDR         (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_FIFO_CNST1_OFFSET       )
#define ZEP_REG_ZR_FIFO_BASE2_ADDR         (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_FIFO_BASE2_OFFSET       )
#define ZEP_REG_ZR_FIFO_PTRS2_ADDR         (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_FIFO_PTRS2_OFFSET       )
#define ZEP_REG_ZR_FIFO_CNST2_ADDR         (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_FIFO_CNST2_OFFSET       )
#define ZEP_REG_ZR_FIFO_BASE3_ADDR         (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_FIFO_BASE3_OFFSET       )
#define ZEP_REG_ZR_FIFO_PTRS3_ADDR         (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_FIFO_PTRS3_OFFSET       )
#define ZEP_REG_ZR_FIFO_CNST3_ADDR         (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_FIFO_CNST3_OFFSET       )
#define ZEP_REG_ZR_DEPTH_ADDR              (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_DEPTH_OFFSET            )
#define ZEP_REG_ZR_ILV_PARAMS0_ADDR        (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_ILV_PARAMS0_OFFSET      )
#define ZEP_REG_ZR_ILV_BASE0_ADDR          (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_ILV_BASE0_OFFSET        )
#define ZEP_REG_ZR_ILV_SIZE0_ADDR          (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_ILV_SIZE0_OFFSET        )
#define ZEP_REG_ZR_ILV_MAX_FULLNESS0_ADDR  (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_ILV_MAX_FULLNESS0_OFFSET)
#define ZEP_REG_ZR_ILV_MIN_FULLNESS0_ADDR  (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_ILV_MIN_FULLNESS0_OFFSET)
#define ZEP_REG_ZR_ILV_FULLNESS0_ADDR      (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_ILV_FULLNESS0_OFFSET    )
#define ZEP_REG_ZR_ILV_CNTRS0_ADDR         (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_ILV_CNTRS0_OFFSET       )
#define ZEP_REG_ZR_ILV_PMS_CNTRS0_ADDR     (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_ILV_PMS_CNTRS0_OFFSET   )
#define ZEP_REG_ZR_ILV_PMD_CNTRS0_ADDR     (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_ILV_PMD_CNTRS0_OFFSET   )
#define ZEP_REG_ZR_ILV_PARAMS1_ADDR        (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_ILV_PARAMS1_OFFSET      )
#define ZEP_REG_ZR_ILV_BASE1_ADDR          (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_ILV_BASE1_OFFSET        )
#define ZEP_REG_ZR_ILV_SIZE1_ADDR          (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_ILV_SIZE1_OFFSET        )
#define ZEP_REG_ZR_ILV_MAX_FULLNESS1_ADDR  (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_ILV_MAX_FULLNESS1_OFFSET)
#define ZEP_REG_ZR_ILV_MIN_FULLNESS1_ADDR  (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_ILV_MIN_FULLNESS1_OFFSET)
#define ZEP_REG_ZR_ILV_FULLNESS1_ADDR      (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_ILV_FULLNESS1_OFFSET    )
#define ZEP_REG_ZR_ILV_CNTRS1_ADDR         (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_ILV_CNTRS1_OFFSET       )
#define ZEP_REG_ZR_ILV_PMS_CNTRS1_ADDR     (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_ILV_PMS_CNTRS1_OFFSET   )
#define ZEP_REG_ZR_ILV_PMD_CNTRS1_ADDR     (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_ILV_PMD_CNTRS1_OFFSET   )
#define ZEP_REG_ZIR_DL_REL0_ADDR       (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZIR_DL_REL0_OFFSET     )
#define ZEP_REG_ZIR_NL_REL0_ADDR       (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZIR_NL_REL0_OFFSET     )
#define ZEP_REG_ZIR_DMETRIC0_ADDR         (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZIR_DMETRIC0_OFFSET    )
#define ZEP_REG_ZIR_DMETRIC_CTRL_ADDR     (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZIR_DMETRIC_CTRL_OFFSET   )
#define ZEP_REG_ZIR_LPBITS_ADDR        (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZIR_LPBITS_OFFSET         )
#define ZEP_REG_ZR_CW_COUNT_ADDR       (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_CW_COUNT_OFFSET     )
#define ZEP_REG_ZR_FEC_CNT_ADDR        (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_FEC_CNT_OFFSET         )
#define ZEP_REG_ZR_UNCORR_CW0_ADDR        (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_UNCORR_CW0_OFFSET      )
#define ZEP_REG_ZR_UNCORR_CW1_ADDR        (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_UNCORR_CW1_OFFSET      )
#define ZEP_REG_ZR_WB_SCORE_CTL_ADDR      (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_WB_SCORE_CTL_OFFSET )
#define ZEP_REG_ZR_WB_SCORE2_ADDR         (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_WB_SCORE2_OFFSET    )
#define ZEP_REG_ZR_UPROC_ENA_ADDR         (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_UPROC_ENA_OFFSET    )
#define ZEP_REG_ZR_UPROC01_BASE_ADDR      (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_UPROC01_BASE_OFFSET )
#define ZEP_REG_ZR_UPROC23_BASE_ADDR      (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_UPROC23_BASE_OFFSET )
#define ZEP_REG_ZR_UPROC45_BASE_ADDR      (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_UPROC45_BASE_OFFSET )
#define ZEP_REG_ZR_UPROC67_BASE_ADDR      (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_UPROC67_BASE_OFFSET )
#define ZEP_REG_ZR_UPROC89_BASE_ADDR      (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_UPROC89_BASE_OFFSET )
#define ZEP_REG_ZR_UPROC_INT_ADDR         (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_UPROC_INT_OFFSET    )
#define ZEP_REG_ZR_UPROC0_STATE0_ADDR     (uint32)(ZEP_REG_RX_BASE_GLOBAL + ZR_UPROC0_STATE0_OFFSET   )

#define ZEP_REG_ZR_UPROC0_STATE1_ADDR     (uint32)(ZEP_REG_ZR_UPROC0_STATE0_ADDR + 0x4)
#define ZEP_REG_ZR_UPROC0_STATE2_ADDR     (uint32)(ZEP_REG_ZR_UPROC0_STATE0_ADDR + 0x8)
#define ZEP_REG_ZR_UPROC0_STATE3_ADDR     (uint32)(ZEP_REG_ZR_UPROC0_STATE0_ADDR + 0xc)
#define ZEP_REG_ZR_UPROC0_STATE4_ADDR     (uint32)(ZEP_REG_ZR_UPROC0_STATE0_ADDR + 0x10)
#define ZEP_REG_ZR_UPROC1_STATE0_ADDR     (uint32)(ZEP_REG_ZR_UPROC0_STATE0_ADDR + 0x14)
#define ZEP_REG_ZR_UPROC1_STATE1_ADDR     (uint32)(ZEP_REG_ZR_UPROC1_STATE0_ADDR + 0x4)
#define ZEP_REG_ZR_UPROC1_STATE2_ADDR     (uint32)(ZEP_REG_ZR_UPROC1_STATE0_ADDR + 0x8)
#define ZEP_REG_ZR_UPROC1_STATE3_ADDR     (uint32)(ZEP_REG_ZR_UPROC1_STATE0_ADDR + 0xc)
#define ZEP_REG_ZR_UPROC1_STATE4_ADDR     (uint32)(ZEP_REG_ZR_UPROC1_STATE0_ADDR + 0x10)
#define ZEP_REG_ZR_UPROC2_STATE0_ADDR     (uint32)(ZEP_REG_ZR_UPROC1_STATE0_ADDR + 0x14)
#define ZEP_REG_ZR_UPROC2_STATE1_ADDR     (uint32)(ZEP_REG_ZR_UPROC2_STATE0_ADDR + 0x4)
#define ZEP_REG_ZR_UPROC2_STATE2_ADDR     (uint32)(ZEP_REG_ZR_UPROC2_STATE0_ADDR + 0x8)
#define ZEP_REG_ZR_UPROC2_STATE3_ADDR     (uint32)(ZEP_REG_ZR_UPROC2_STATE0_ADDR + 0xc)
#define ZEP_REG_ZR_UPROC2_STATE4_ADDR     (uint32)(ZEP_REG_ZR_UPROC2_STATE0_ADDR + 0x10)
#define ZEP_REG_ZR_UPROC3_STATE0_ADDR     (uint32)(ZEP_REG_ZR_UPROC2_STATE0_ADDR + 0x14)
#define ZEP_REG_ZR_UPROC3_STATE1_ADDR     (uint32)(ZEP_REG_ZR_UPROC3_STATE0_ADDR + 0x4)
#define ZEP_REG_ZR_UPROC3_STATE2_ADDR     (uint32)(ZEP_REG_ZR_UPROC3_STATE0_ADDR + 0x8)
#define ZEP_REG_ZR_UPROC3_STATE3_ADDR     (uint32)(ZEP_REG_ZR_UPROC3_STATE0_ADDR + 0xc)
#define ZEP_REG_ZR_UPROC3_STATE4_ADDR     (uint32)(ZEP_REG_ZR_UPROC3_STATE0_ADDR + 0x10)
#define ZEP_REG_ZR_UPROC4_STATE0_ADDR     (uint32)(ZEP_REG_ZR_UPROC3_STATE0_ADDR + 0x14)
#define ZEP_REG_ZR_UPROC4_STATE1_ADDR     (uint32)(ZEP_REG_ZR_UPROC4_STATE0_ADDR + 0x4)
#define ZEP_REG_ZR_UPROC4_STATE2_ADDR     (uint32)(ZEP_REG_ZR_UPROC4_STATE0_ADDR + 0x8)
#define ZEP_REG_ZR_UPROC4_STATE3_ADDR     (uint32)(ZEP_REG_ZR_UPROC4_STATE0_ADDR + 0xc)
#define ZEP_REG_ZR_UPROC4_STATE4_ADDR     (uint32)(ZEP_REG_ZR_UPROC4_STATE0_ADDR + 0x10)
#define ZEP_REG_ZR_UPROC5_STATE0_ADDR     (uint32)(ZEP_REG_ZR_UPROC4_STATE0_ADDR + 0x14)
#define ZEP_REG_ZR_UPROC5_STATE1_ADDR     (uint32)(ZEP_REG_ZR_UPROC5_STATE0_ADDR + 0x4)
#define ZEP_REG_ZR_UPROC5_STATE2_ADDR     (uint32)(ZEP_REG_ZR_UPROC5_STATE0_ADDR + 0x8)
#define ZEP_REG_ZR_UPROC5_STATE3_ADDR     (uint32)(ZEP_REG_ZR_UPROC5_STATE0_ADDR + 0xc)
#define ZEP_REG_ZR_UPROC5_STATE4_ADDR     (uint32)(ZEP_REG_ZR_UPROC5_STATE0_ADDR + 0x10)
#define ZEP_REG_ZR_UPROC6_STATE0_ADDR     (uint32)(ZEP_REG_ZR_UPROC5_STATE0_ADDR + 0x14)
#define ZEP_REG_ZR_UPROC6_STATE1_ADDR     (uint32)(ZEP_REG_ZR_UPROC6_STATE0_ADDR + 0x4)
#define ZEP_REG_ZR_UPROC6_STATE2_ADDR     (uint32)(ZEP_REG_ZR_UPROC6_STATE0_ADDR + 0x8)
#define ZEP_REG_ZR_UPROC6_STATE3_ADDR     (uint32)(ZEP_REG_ZR_UPROC6_STATE0_ADDR + 0xc)
#define ZEP_REG_ZR_UPROC6_STATE4_ADDR     (uint32)(ZEP_REG_ZR_UPROC6_STATE0_ADDR + 0x10)
#define ZEP_REG_ZR_UPROC7_STATE0_ADDR     (uint32)(ZEP_REG_ZR_UPROC6_STATE0_ADDR + 0x14)
#define ZEP_REG_ZR_UPROC7_STATE1_ADDR     (uint32)(ZEP_REG_ZR_UPROC7_STATE0_ADDR + 0x4)
#define ZEP_REG_ZR_UPROC7_STATE2_ADDR     (uint32)(ZEP_REG_ZR_UPROC7_STATE0_ADDR + 0x8)
#define ZEP_REG_ZR_UPROC7_STATE3_ADDR     (uint32)(ZEP_REG_ZR_UPROC7_STATE0_ADDR + 0xc)
#define ZEP_REG_ZR_UPROC7_STATE4_ADDR     (uint32)(ZEP_REG_ZR_UPROC7_STATE0_ADDR + 0x10)
#define ZEP_REG_ZR_UPROC8_STATE0_ADDR     (uint32)(ZEP_REG_ZR_UPROC7_STATE0_ADDR + 0x14)
#define ZEP_REG_ZR_UPROC8_STATE1_ADDR     (uint32)(ZEP_REG_ZR_UPROC8_STATE0_ADDR + 0x4)
#define ZEP_REG_ZR_UPROC8_STATE2_ADDR     (uint32)(ZEP_REG_ZR_UPROC8_STATE0_ADDR + 0x8)
#define ZEP_REG_ZR_UPROC8_STATE3_ADDR     (uint32)(ZEP_REG_ZR_UPROC8_STATE0_ADDR + 0xc)
#define ZEP_REG_ZR_UPROC8_STATE4_ADDR     (uint32)(ZEP_REG_ZR_UPROC8_STATE0_ADDR + 0x10)
#define ZEP_REG_ZR_UPROC9_STATE0_ADDR     (uint32)(ZEP_REG_ZR_UPROC8_STATE0_ADDR + 0x14)
#define ZEP_REG_ZR_UPROC9_STATE1_ADDR     (uint32)(ZEP_REG_ZR_UPROC9_STATE0_ADDR + 0x4)
#define ZEP_REG_ZR_UPROC9_STATE2_ADDR     (uint32)(ZEP_REG_ZR_UPROC9_STATE0_ADDR + 0x8)
#define ZEP_REG_ZR_UPROC9_STATE3_ADDR     (uint32)(ZEP_REG_ZR_UPROC9_STATE0_ADDR + 0xc)
#define ZEP_REG_ZR_UPROC9_STATE4_ADDR     (uint32)(ZEP_REG_ZR_UPROC9_STATE0_ADDR + 0x10)
#define ZEP_REG_ZR_UPROC_STATE5_ADDR      (uint32)(ZEP_REG_ZR_UPROC9_STATE4_ADDR + 0x4)
#define ZEP_REG_ZR_ALU_STATE_ADDR         (uint32)(ZEP_REG_ZR_UPROC_STATE5_ADDR + 0x4)
#define ZEP_REG_ZR_ALU_CLI_REQ_ADDR             (uint32)(ZEP_REG_ZR_ALU_STATE_ADDR + 0x4)

//Per Instance Registers
#define ZEP_REG_ZR_WB_DBG_ADDR            (uint32)(ZEP_REG_RX_BASE_GLOBAL + 0x200)
#define ZEP_REG_ZR_WB_RCHK0_ADDR       (uint32)(ZEP_REG_ZR_WB_DBG_ADDR + 4)
#define ZEP_REG_ZR_WB_RCHK1_ADDR       (uint32)(ZEP_REG_ZR_WB_RCHK0_ADDR + 4)
#define ZEP_REG_ZR_WB_RCHK2_ADDR       (uint32)(ZEP_REG_ZR_WB_RCHK1_ADDR + 4)
#define ZEP_REG_ZR_WB_RCHK3_ADDR       (uint32)(ZEP_REG_ZR_WB_RCHK2_ADDR + 4)
#define ZEP_REG_ZR_WB_RSYND0_ADDR         (uint32)(ZEP_REG_ZR_WB_RCHK3_ADDR + 4)
#define ZEP_REG_ZR_WB_RSYND1_ADDR         (uint32)(ZEP_REG_ZR_WB_RSYND0_ADDR + 4)
#define ZEP_REG_ZR_WB_RSYND2_ADDR         (uint32)(ZEP_REG_ZR_WB_RSYND1_ADDR + 4)
#define ZEP_REG_ZR_WB_RSYND3_ADDR         (uint32)(ZEP_REG_ZR_WB_RSYND2_ADDR + 4)
#define ZEP_REG_ZR_WB_AJ0_ADDR            (uint32)(ZEP_REG_ZR_WB_RSYND3_ADDR + 4)
#define ZEP_REG_ZR_WB_AJ1_ADDR            (uint32)(ZEP_REG_ZR_WB_AJ0_ADDR  + 4)
#define ZEP_REG_ZR_WB_AJ2_ADDR            (uint32)(ZEP_REG_ZR_WB_AJ1_ADDR  + 4)
#define ZEP_REG_ZR_WB_AJ3_ADDR            (uint32)(ZEP_REG_ZR_WB_AJ2_ADDR  + 4)

//Per Port Registers
#define ZEP_REG_ZR_FIFO_ACCESS_ADDR       (uint32)(ZEP_REG_RX_BASE_GLOBAL  +  0x234)

#define ZEP_REG_ZR_CONFIG_ADDR            (uint32)(ZEP_REG_ZR_FIFO_ACCESS_ADDR + 4)
#define ZEP_REG_ZR_PMS_SIZE_ADDR       (uint32)(ZEP_REG_ZR_CONFIG_ADDR     + 4)
#define ZEP_REG_ZR_DT_SIZE_ADDR           (uint32)(ZEP_REG_ZR_PMS_SIZE_ADDR   + 4)
#define ZEP_REG_ZR_QTDTB_CONFIG_LP0_ADDR  (uint32)(ZEP_REG_ZR_DT_SIZE_ADDR +4)
#define ZEP_REG_ZR_QTDTB_CONFIG_LP1_ADDR  (uint32)(ZEP_REG_ZR_QTDTB_CONFIG_LP0_ADDR   +4)
#define ZEP_REG_ZR_QTDTB_CONFIG_LP2_ADDR  (uint32)(ZEP_REG_ZR_QTDTB_CONFIG_LP1_ADDR   +4)
#define ZEP_REG_ZR_QTDTB_ADDR_LP01_ADDR      (uint32)(ZEP_REG_ZR_QTDTB_CONFIG_LP2_ADDR   +4)
#define ZEP_REG_ZR_QTDTB_ADDR_LP2_ADDR    (uint32)(ZEP_REG_ZR_QTDTB_ADDR_LP01_ADDR  +4)
#define ZEP_REG_ZR_DTB_OFFSET_ADDR        (uint32)(ZEP_REG_ZR_QTDTB_ADDR_LP2_ADDR + 4)
#define ZEP_REG_ZR_QTSCORE_ADDR           (uint32)(ZEP_REG_ZR_DTB_OFFSET_ADDR    + 4)
#define ZEP_REG_ZR_ERR_STAT_ADDR       (uint32)(ZEP_REG_ZR_QTSCORE_ADDR    + 4)

#define ZEP_REG_ZR_ALU_CLI_REQ_ALIAS0_ADDR      (uint32)(ZEP_REG_ZR_ERR_STAT_ADDR         + 0x4)
#define ZEP_REG_ZR_ALU_CLI_REQ_ALIAS1_ADDR      (uint32)(ZEP_REG_ZR_ALU_CLI_REQ_ALIAS0_ADDR + 0x4)
#define ZEP_REG_ZR_ALU_CLI_REQ_ALIAS2_ADDR      (uint32)(ZEP_REG_ZR_ALU_CLI_REQ_ALIAS1_ADDR + 0x4)

//#define ZEP_REG_NUM_RX_WORDS            (uint16)((ZEP_REG_ZR_ERR_STAT_ADDR - ZEP_REG_ZR_R0_ADDR + 4)/4)
//#define ZEP_REG_RX_PRAM_SIZE            (uint32)((ZEP_REG_ZR_ALU_STATE_ADDR - ZEP_REG_ZR_R0_ADDR + 4)/4)
//#define ZEP_REG_GLBRX_SIZE              (uint32)((ZEP_REG_ZR_ERR_STAT_ADDR - ZEP_REG_ZR_WB_DBG_ADDR + 4)/4)
#define ZEP_REG_NUM_RX_WORDS           (uint16)((ZEP_REG_ZR_ALU_CLI_REQ_ALIAS2_ADDR - ZEP_REG_ZR_R0_ADDR + 4)/4)
#ifdef VRX518
#define ZEP_REG_RX_PRAM_SIZE           (uint32)((ZEP_PRAM_ZR_UPROC9_BASE_LP0_35B_ADDR  - ZEP_PRAM_ZR_R0_LP0_ADDR + 4)/4)
#else
#define ZEP_REG_RX_PRAM_SIZE           (uint32)((ZEP_REG_ZR_ALU_CLI_REQ_ADDR  - ZEP_REG_ZR_R0_ADDR + 4)/4)
#endif // VRX518
#define ZEP_REG_GLBRX_SIZE             (uint32)((ZEP_REG_ZR_ALU_CLI_REQ_ALIAS2_ADDR - ZEP_REG_ZR_WB_DBG_ADDR + 4)/4)

/**********************************************************************
 * Register Masks for test purposes
 **********************************************************************/

// TX Register masks
#define ZEP_REG_ZT_R0_MASK                   (0xFFFFFFFF)
#define ZEP_REG_ZT_R4_MASK                   (0xFFFFFFFF)
#define ZEP_REG_ZT_R8_MASK                   (0xFFFFFFFF)
#define ZEP_REG_ZT_R12_MASK                     (0xFFFFFFFF)
#define ZEP_REG_ZT_CODEWORD_MASK                (0xFFFFFFFF)
#define ZEP_REG_ZT_VBC_SIZE_MASK                (0xFFFFFFFF)
#define ZEP_REG_ZT_FRAMING_MASK                 (0xFFFFFFFF)
#define ZEP_REG_ZT_OHRATE_MASK                  (0xFFFFFFFF)
#define ZEP_REG_ZT_FLAG_CTRL0_MASK              (0x07777777)
#define ZEP_REG_ZT_FLAG_CTRL1_MASK              (0x00000777)
#define ZEP_REG_ZT_CRC0_MASK                 (0xFFFFFFFF)
#define ZEP_REG_ZT_CRC_POLY0_MASK               (0xFFFFFFFF)
#define ZEP_REG_ZT_CRC_CTRL0_MASK               (0xFFFF0003)
//#define ZEP_REG_ZT_CRC_STATE0_MASK               (0xFFFFFFFF)
#define ZEP_REG_ZT_CRC1_MASK                 (0xFFFFFFFF)
#define ZEP_REG_ZT_CRC_POLY1_MASK               (0xFFFFFFFF)
#define ZEP_REG_ZT_CRC_CTRL1_MASK               (0xFFFF0003)
//#define ZEP_REG_ZT_CRC_STATE1_MASK               (0xFFFFFFFF)
#define ZEP_REG_ZT_SCR_MASK                     (0xFFFFFFFF)
#define ZEP_REG_ZT_SCR_POLY_MASK             (0xFFFFFFFF)
#define ZEP_REG_ZT_SCR_CTRL_MASK             (0x0000001F)
#define ZEP_REG_ZT_SCR_STATE_MASK               (0xFFFFFFFF)
#define ZEP_REG_ZT_DTB_CTRL_MASK             (0x0FFF0FFF)
#define ZEP_REG_ZT_DTB_PTRS_MASK             (0xFFFFFFFF)
#define ZEP_REG_ZT_ILVB_WRAD_MASK               (0xFFFFFFFF)
#define ZEP_REG_ZT_ILVB_RDAD_MASK               (0xFFFFFFFF)
#define ZEP_REG_ZT_ILVB_WRPTR_MASK              (0xFFFFFFFF)
#define ZEP_REG_ZT_ILVB_RDPTR_MASK              (0xFFFFFFFF)
#define ZEP_REG_ZT_FIFO_BASE0_MASK              (0xFFFFFFFF)
#define ZEP_REG_ZT_FIFO_PTRS0_MASK              (0xCFFF0FFF)
#define ZEP_REG_ZT_FIFO_CNST0_MASK              (0x00FFFFFF)
#define ZEP_REG_ZT_FIFO_BASE1_MASK              (0xFFFFFFFF)
#define ZEP_REG_ZT_FIFO_PTRS1_MASK              (0xCFFF0FFF)
#define ZEP_REG_ZT_FIFO_CNST1_MASK              (0x00FFFFFF)
#define ZEP_REG_ZT_FIFO_BASE2_MASK              (0xFFFFFFFF)
#define ZEP_REG_ZT_FIFO_PTRS2_MASK              (0xCFFF0FFF)
#define ZEP_REG_ZT_FIFO_CNST2_MASK              (0x00FFFFFF)
#define ZEP_REG_ZT_FIFO_BASE3_MASK              (0xFFFFFFFF)
#define ZEP_REG_ZT_FIFO_PTRS3_MASK              (0xCFFF0FFF)
#define ZEP_REG_ZT_FIFO_CNST3_MASK              (0x01FFFFFF)
#define ZEP_REG_ZT_ILV_CONFIG_MASK              (0xDFFFFFFF)
#define ZEP_REG_ZT_FULLNESS_MASK             (0xFFFFFFFF)
#define ZEP_REG_ZT_DEPTH_MASK                (0xFFFFFFFF)
#define ZEP_REG_ZT_ILV_BASE_LP_MASK             (0x0001FFFF)
#define ZEP_REG_ZT_IBLK_BASE_LP_MASK            (0x0001FFFF)
#define ZEP_REG_ZT_ILV_LIMIT_LP_MASK            (0x0001FFFF)
#define ZEP_REG_ZT_FIFO_CTL_LP_MASK             (0xDFFF1FFF)
#define ZEP_REG_ZT_DCID_CTRL1_LP_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZT_DCID_CTRL2_LP_MASK           (0x3FFF3FFF)
#define ZEP_REG_ZT_IBLK_TRANS_CNT_MASK          (0x0000FFFF)
#define ZEP_REG_ZT_PMD_FIFO_DELAY_MASK          (0x1FFF1FFF)
#define ZEP_REG_ZT_DMAX_FIFO_DELAY_NUM_MASK        (0x01FF01FF)
#define ZEP_REG_ZT_PMD_D_LOWER_FIFO_DELAY_NUM_MASK (0x0000001F)
#define ZEP_REG_ZT_PMS_COUNTERS1_LP_MASK        (0x00001FFF)
#define ZEP_REG_ZT_PMS_COUNTERS2_LP_MASK        (0x01FFFFFF)
#define ZEP_REG_ZT_PMS_COUNTERS3_LP_MASK        (0x3FFF3FFF)
#define ZEP_REG_ZT_PMD_COUNTERS1_LP_MASK        (0x00001FFF)
#define ZEP_REG_ZT_PMD_COUNTERS2_LP_MASK        (0x01FFFFFF)
#define ZEP_REG_ZT_PMD_COUNTERS3_LP_MASK        (0x3FFF3FFF)
#define ZEP_REG_ZT_ILV_DATAI_STATE_MASK            (0xFFFFFFFF)
#define ZEP_REG_ZT_ILV_WR0_STATE_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZT_ILV_WR1_STATE_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZT_ILV_DATAO_STATE_MASK            (0xFFFFFFFF)
#define ZEP_REG_ZT_ILV_RD0_STATE_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZT_ILV_RD1_STATE_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZT_CHECKBYTE0_MASK              (0xFFFFFFFF)
#define ZEP_REG_ZT_CHECKBYTE1_MASK              (0xFFFFFFFF)
#define ZEP_REG_ZT_CHECKBYTE2_MASK              (0xFFFFFFFF)
#define ZEP_REG_ZT_CHECKBYTE3_MASK              (0xFFFFFFFF)
#define ZEP_REG_ZT_TCSRC_STATE_MASK             (0xFFFFFFFF)
#define ZEP_REG_ZT_UPROC_ENA_MASK               (0x000003FF)
#define ZEP_REG_ZT_UPROC01_BASE_MASK            (0xFFFFFFFF)
#define ZEP_REG_ZT_UPROC23_BASE_MASK            (0xFFFFFFFF)
#define ZEP_REG_ZT_UPROC45_BASE_MASK            (0xFFFFFFFF)
#define ZEP_REG_ZT_UPROC67_BASE_MASK            (0xFFFFFFFF)
#define ZEP_REG_ZT_UPROC89_BASE_MASK            (0xFFFFFFFF)
#define ZEP_REG_ZT_UPROC_INT_MASK               (0x000003FF)
#define ZEP_REG_ZT_UPROC0_STATE0_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZT_UPROC0_STATE1_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZT_UPROC0_STATE2_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZT_UPROC0_STATE3_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZT_UPROC1_STATE0_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZT_UPROC1_STATE1_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZT_UPROC1_STATE2_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZT_UPROC1_STATE3_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZT_UPROC2_STATE0_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZT_UPROC2_STATE1_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZT_UPROC2_STATE2_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZT_UPROC2_STATE3_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZT_UPROC3_STATE0_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZT_UPROC3_STATE1_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZT_UPROC3_STATE2_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZT_UPROC3_STATE3_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZT_UPROC4_STATE0_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZT_UPROC4_STATE1_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZT_UPROC4_STATE2_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZT_UPROC4_STATE3_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZT_UPROC5_STATE0_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZT_UPROC5_STATE1_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZT_UPROC5_STATE2_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZT_UPROC5_STATE3_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZT_UPROC6_STATE0_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZT_UPROC6_STATE1_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZT_UPROC6_STATE2_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZT_UPROC6_STATE3_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZT_UPROC7_STATE0_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZT_UPROC7_STATE1_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZT_UPROC7_STATE2_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZT_UPROC7_STATE3_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZT_UPROC8_STATE0_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZT_UPROC8_STATE1_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZT_UPROC8_STATE2_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZT_UPROC8_STATE3_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZT_UPROC9_STATE0_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZT_UPROC9_STATE1_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZT_UPROC9_STATE2_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZT_UPROC9_STATE3_MASK           (0xFFFFFFFF)
#define ZEP_REG_Z_VERSION_MASK                  (0x000000FF)
#define ZEP_REG_ZT_FIFO_ACCESS_MASK             (0x0000FFFF)
#define ZEP_REG_ZT_CONFIG_MASK                  (0x0000FFFF)
#define ZEP_REG_ZT_PMS_SIZE_MASK             (0xFFFFFFFF)
#define ZEP_REG_ZT_DT_SIZE_MASK                 (0xFFFFFFFF)

#define ZEP_REG_ZT_QTDTB_CONFIG_MASK            (0x000F07FF)
#define ZEP_REG_ZT_DTB_OFFSET_MASK              (0x000007FF)
#define ZEP_REG_ZT_NTR_IBITS_MASK               (0x07FFFFFF)
#define ZEP_REG_ZT_NTR_CLK_MASK                 (0x800FFFFF)
#define ZEP_REG_ZT_LTR_CLK_MASK                 (0xFFFFFFFF)

// RX Register masks
#define ZEP_REG_ZR_R0_MASK                   (0xFFFFFFFF)
#define ZEP_REG_ZR_R4_MASK                   (0xFFFFFFFF)
#define ZEP_REG_ZR_R8_MASK                   (0xFFFFFFFF)
#define ZEP_REG_ZR_R12_MASK                     (0xFFFFFFFF)
#define ZEP_REG_ZR_CODEWORD_MASK             (0xFFFFFFFF)
#define ZEP_REG_ZR_VBC_SIZE_MASK             (0xFFFFFFFF)
#define ZEP_REG_ZR_FRAMING_MASK                 (0xFFFFFFFF)
#define ZEP_REG_ZR_OHRATE_MASK                  (0xFFFFFFFF)
#define ZEP_REG_ZR_FLAG_CTRL0_MASK              (0x07777777)
#define ZEP_REG_ZR_FLAG_CTRL1_MASK              (0x00000077)
#define ZEP_REG_ZR_CRC0_MASK                 (0xFFFFFFFF)
#define ZEP_REG_ZR_CRC_POLY0_MASK               (0xFFFFFFFF)
#define ZEP_REG_ZR_CRC_CTRL0_MASK               (0xFFFF0003)
//#define ZEP_REG_ZR_CRC_STATE0_MASK               (0xFFFFFFFF)
#define ZEP_REG_ZR_CRC1_MASK                 (0xFFFFFFFF)
#define ZEP_REG_ZR_CRC_POLY1_MASK               (0xFFFFFFFF)
#define ZEP_REG_ZR_CRC_CTRL1_MASK               (0xFFFF0003)
//#define ZEP_REG_ZR_CRC_STATE1_MASK               (0xFFFFFFFF)
#define ZEP_REG_ZR_SCR_MASK                     (0xFFFFFFFF)
#define ZEP_REG_ZR_SCR_POLY_MASK             (0xFFFFFFFF)
#define ZEP_REG_ZR_SCR_CTRL_MASK             (0x0000001F)
#define ZEP_REG_ZR_SCR_STATE_MASK               (0xFFFFFFFF)
#define ZEP_REG_ZR_DTB_CTRL_MASK             (0x0FFF0FFF)
#define ZEP_REG_ZR_DTB_PTRS_MASK             (0xFFFFFFFF)
#define ZEP_REG_ZR_ILVB_WRAD_MASK               (0xFFFFFFFF)
#define ZEP_REG_ZR_ILVB_RDAD_MASK               (0xFFFFFFFF)
#define ZEP_REG_ZR_ILVB_WRPTR_MASK              (0xFFFFFFFF)
#define ZEP_REG_ZR_ILVB_RDPTR_MASK              (0xFFFFFFFF)
#define ZEP_REG_ZR_FIFO_BASE0_MASK              (0xFFFFFFFF)
#define ZEP_REG_ZR_FIFO_PTRS0_MASK              (0xCFFF0FFF)
#define ZEP_REG_ZR_FIFO_CNST0_MASK              (0x00FFFFFF)
#define ZEP_REG_ZR_FIFO_BASE1_MASK              (0xFFFFFFFF)
#define ZEP_REG_ZR_FIFO_PTRS1_MASK              (0xCFFF0FFF)
#define ZEP_REG_ZR_FIFO_CNST1_MASK              (0x00FFFFFF)
#define ZEP_REG_ZR_FIFO_BASE2_MASK              (0xFFFFFFFF)
#define ZEP_REG_ZR_FIFO_PTRS2_MASK              (0xCFFF0FFF)
#define ZEP_REG_ZR_FIFO_CNST2_MASK              (0x00FFFFFF)
#define ZEP_REG_ZR_FIFO_BASE3_MASK              (0xFFFFFFFF)
#define ZEP_REG_ZR_FIFO_PTRS3_MASK              (0xCFFF0FFF)
#define ZEP_REG_ZR_FIFO_CNST3_MASK              (0x00FFFFFF)
#define ZEP_REG_ZR_ILV_CONFIG_MASK              (0xDFFFFFFF)
#define ZEP_REG_ZR_FULLNESS_MASK             (0xFFFFFFFF)
#define ZEP_REG_ZR_DEPTH_MASK                (0x1FFF1FFF)
#define ZEP_REG_ZR_ILV_BASE_LP_MASK             (0x0001FFFF)
#define ZEP_REG_ZR_IBLK_BASE_LP_MASK            (0x0001FFFF)
#define ZEP_REG_ZR_ILV_LIMIT_LP_MASK            (0x0001FFFF)
#define ZEP_REG_ZR_FIFO_CTL_LP_MASK             (0xDFFF1FFF)
#define ZEP_REG_ZR_DCID_CTRL1_LP_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZR_DCID_CTRL2_LP_MASK           (0x3FFF3FFF)
#define ZEP_REG_ZR_IBLK_TRANS_CNT_MASK          (0x0000FFFF)
#define ZEP_REG_ZR_PMD_FIFO_DELAY_MASK          (0x1FFF1FFF)
#define ZEP_REG_ZR_DMAX_FIFO_DELAY_NUM_MASK        (0x01FF01FF)
#define ZEP_REG_ZR_PMD_D_LOWER_FIFO_DELAY_NUM_MASK (0x0000001F)
#define ZEP_REG_ZR_PMS_COUNTERS1_LP_MASK        (0x00001FFF)
#define ZEP_REG_ZR_PMS_COUNTERS2_LP_MASK        (0x01FFFFFF)
#define ZEP_REG_ZR_PMS_COUNTERS3_LP_MASK        (0x3FFF3FFF)
#define ZEP_REG_ZR_PMD_COUNTERS1_LP_MASK        (0x00001FFF)
#define ZEP_REG_ZR_PMD_COUNTERS2_LP_MASK        (0x01FFFFFF)
#define ZEP_REG_ZR_PMD_COUNTERS3_LP_MASK        (0x3FFF3FFF)
#define ZEP_REG_ZR_ILV_DATAI_STATE_MASK            (0xFFFFFFFF)
#define ZEP_REG_ZR_ILV_WR0_STATE_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZR_ILV_WR1_STATE_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZR_ILV_DATAO_STATE_MASK            (0xFFFFFFFF)
#define ZEP_REG_ZR_ILV_RD0_STATE_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZR_ILV_RD1_STATE_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZIR_DL_REL0_MASK             (0x03FFFFFF)
#define ZEP_REG_ZIR_NL_REL0_MASK             (0x03FF07FF)
#define ZEP_REG_ZIR_DMETRIC0_MASK               (0x03FFFFFF)
#define ZEP_REG_ZIR_DMETRIC_CTRL_MASK           (0x000303FF)
#define ZEP_REG_ZR_CW_COUNT_MASK             (0x0000FFFF)
#define ZEP_REG_ZR_FEC_CNT_MASK                 (0xFFFFFFFF)
#define ZEP_REG_ZR_UNCORR_CW0_MASK              (0xFFFFFFFF)
#define ZEP_REG_ZR_UNCORR_CW1_MASK              (0xFFFFFFFF)
#define ZEP_REG_ZR_WB_SCORE_CTL_MASK            (0xBF3F5FFF)
#define ZEP_REG_ZR_WB_SCORE2_MASK               (0x0000FFFF)
//#define ZEP_REG_ZR_TCSNK_STATE_MASK              (0xFFFFFFFF)
#define ZEP_REG_ZR_RSDEC_STATE_MASK             (0xFFFFFFFF)
#define ZEP_REG_ZR_UPROC_ENA_MASK               (0x000003FF)
#define ZEP_REG_ZR_UPROC01_BASE_MASK            (0xFFFFFFFF)
#define ZEP_REG_ZR_UPROC23_BASE_MASK            (0xFFFFFFFF)
#define ZEP_REG_ZR_UPROC45_BASE_MASK            (0xFFFFFFFF)
#define ZEP_REG_ZR_UPROC67_BASE_MASK            (0xFFFFFFFF)
#define ZEP_REG_ZR_UPROC89_BASE_MASK            (0xFFFFFFFF)
#define ZEP_REG_ZR_UPROC_INT_MASK               (0x000003FF)
#define ZEP_REG_ZR_UPROC0_STATE0_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZR_UPROC0_STATE1_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZR_UPROC0_STATE2_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZR_UPROC0_STATE3_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZR_UPROC0_STATE4_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZR_UPROC1_STATE0_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZR_UPROC1_STATE1_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZR_UPROC1_STATE2_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZR_UPROC1_STATE3_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZR_UPROC1_STATE4_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZR_UPROC2_STATE0_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZR_UPROC2_STATE1_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZR_UPROC2_STATE2_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZR_UPROC2_STATE3_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZR_UPROC2_STATE4_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZR_UPROC3_STATE0_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZR_UPROC3_STATE1_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZR_UPROC3_STATE2_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZR_UPROC3_STATE3_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZR_UPROC3_STATE4_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZR_UPROC4_STATE0_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZR_UPROC4_STATE1_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZR_UPROC4_STATE2_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZR_UPROC4_STATE3_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZR_UPROC4_STATE4_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZR_UPROC5_STATE0_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZR_UPROC5_STATE1_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZR_UPROC5_STATE2_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZR_UPROC5_STATE3_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZR_UPROC5_STATE4_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZR_UPROC6_STATE0_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZR_UPROC6_STATE1_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZR_UPROC6_STATE2_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZR_UPROC6_STATE3_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZR_UPROC6_STATE4_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZR_UPROC7_STATE0_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZR_UPROC7_STATE1_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZR_UPROC7_STATE2_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZR_UPROC7_STATE3_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZR_UPROC7_STATE4_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZR_UPROC8_STATE0_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZR_UPROC8_STATE1_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZR_UPROC8_STATE2_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZR_UPROC8_STATE3_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZR_UPROC8_STATE4_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZR_UPROC9_STATE0_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZR_UPROC9_STATE1_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZR_UPROC9_STATE2_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZR_UPROC9_STATE3_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZR_UPROC9_STATE4_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZR_WB_DBG_MASK                  (0x000001FF)
#define ZEP_REG_ZR_WB_RCHK0_MASK             (0xFFFFFFFF)
#define ZEP_REG_ZR_WB_RCHK1_MASK             (0xFFFFFFFF)
#define ZEP_REG_ZR_WB_RCHK2_MASK             (0xFFFFFFFF)
#define ZEP_REG_ZR_WB_RCHK3_MASK             (0xFFFFFFFF)
#define ZEP_REG_ZR_WB_RSYND0_MASK               (0xFFFFFFFF)
#define ZEP_REG_ZR_WB_RSYND1_MASK               (0xFFFFFFFF)
#define ZEP_REG_ZR_WB_RSYND2_MASK               (0xFFFFFFFF)
#define ZEP_REG_ZR_WB_RSYND3_MASK               (0xFFFFFFFF)
#define ZEP_REG_ZR_WB_AJ0_MASK                  (0xFFFFFFFF)
#define ZEP_REG_ZR_WB_AJ1_MASK                  (0xFFFFFFFF)
#define ZEP_REG_ZR_WB_AJ2_MASK                  (0xFFFFFFFF)
#define ZEP_REG_ZR_WB_AJ3_MASK                  (0xFFFFFFFF)
#define ZEP_REG_ZR_FIFO_ACCESS_MASK             (0x0000FFFF)
#define ZEP_REG_ZR_CONFIG_MASK                  (0x0000FFFF)
#define ZEP_REG_ZR_PMS_SIZE_MASK             (0xFFFFFFFF)
#define ZEP_REG_ZR_DT_SIZE_MASK                 (0xFFFFFFFF)
#define ZEP_REG_ZR_QTDTB_CONFIG_MASK            (0x000F07FF)
#define ZEP_REG_ZR_DTB_OFFSET_MASK              (0x000007FF)
#define ZEP_REG_ZR_QTSCORE_MASK                 (0x000000FF)

//Remapping to 35B
//For VRX518, new fileds added into these registers. Earlier bit fileds till remains same.


#endif //_ZEP_MEMMAP_H  Do not add anything below this line.



