/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _ZEP_PRIVATE_H
#define _ZEP_PRIVATE_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             zep_private.h
 * DESCRIPTION:      Header file declaring Zephyr's internal functions
 *             None of these files are visible in the API
 **********************************************************************/

// Operation mode definitions...
//#define TS_MODE       0
//#define CASCADE_MODE  1
//#define REG_START_MODE   2

// crc.c
void crcAccum(uint8 uc_Byte, uint8 *puc_crc);
void crcCalc(uint8 uc_byte, uint32 *pul_state, uint32 ul_polynomial);
void crcGenerate(uint8 uc_Byte , uint32 *pul_CRC_state , uint32 ul_polyReg, uint8 uc_lengthReg);
uint32 Zep_BitRev(uint32 ul_Index, int16 s_Nbits);
// rs_dec.c
uint8 ReedSolomonCorrect(int16 s_lp);

// rs_enc.c
void ReedSolomonEncode_AccumCheckBytes(uint8 uc_Byte, uint16 s_lp);

// scramble.c
void ScrambleByte(uint8 *puc_Byte);
void DescrambleByte(uint8 *puc_Byte);

//zep_tx.c
/* Call to process one Zephyr clock cycle. */
int32 ZEP_Clock_Tx(Zephyr_Input_t t_ZEPInput, Zephyr_Output_t *pt_ZEPOutput);
int32 ZEP_Initialize_Tx();
void ResetTxState(void);
void ZEP_FCI_Save_Tx_uProc();
void ZEP_FCI_Restore_Tx_uProc();
uint8 mailboxRead( uint16 us_mbAddress );
uint8 mailboxWrite( uint16 us_mbAddress , uint8 data);
uint8 mailboxStateMachine( t_mailbox *pt_mbox, uint8 inOutReqest, uint8 uc_byte , uint8 uc_flag );
#ifdef NO_TLM
void TLM_ZEP_PushDtbFifo(uint8 uc_byte);
#endif
void Compute_ALU(uint8 uc_direction, uint8 uc_data_in, uint8 uc_flag_in);
uint8 ReturnParity(uint16 uc_data);

//zep_rx.c
/* Call to process one Rx Zephyr clock cycle. */
int32 ZEP_Clock_Rx(Zephyr_Input_t t_ZEPInput, Zephyr_Output_t *pt_ZEPOutput);
int32 ZEP_Initialize_Rx();
void ResetRxState(void);
void ZEP_FCI_Save_Rx_uProc();
void ZEP_FCI_Restore_Rx_uProc();

#ifdef NO_TLM
void TLM_ZEP_PopDtbFifo(uint8 *uc_byte);
#endif

// zephyr.c
int32 ZEP_ClockTxFrame(void);
int32 ZEP_ClockRxFrame(void);
void ZEP_SetPortMode(uint8 uc_port_mode);
void WriteToByteBuffer(uint8 *puc_addr, uint32 ul_offset, uint32 ul_data, uint8 uc_ByteEnable);
void ReadFromByteBuffer(uint8 *puc_addr, uint32 ul_offset, uint32 *pul_data);
uint8 deriveEFF_DIS_var(uint8 ilvType);
void ResetRegisters(uint8 port);
void ResetTxRegisters(uint8 uc_port);
void ResetRxRegisters(uint8 uc_port);

//zep_engine_tlm.c
uint8 ZEP_DataFlagManipulation(uint8 uc_direction, uint8 engine_id, uint8 *puc_byte, uint8 *puc_flag);
uint8 ZEP_OutputFlagManipulation(uint8 uc_direction, uint8 engine_id, uint8 *puc_flag);
uint8 fifo_pop(uint8 uc_direction, uint8 engine_id, uint8 *puc_byte, uint8 *puc_flag);
uint8 fifo_output(uint8 uc_direction, uint8 engine_id, uint8 *puc_byte, uint8 *puc_flag);
uint8 fifo_push(uint8 uc_direction, uint8 engine_id, uint8 uc_byte, uint8 uc_flag);
uint8 fifo_pushByte(uint8 uc_direction, uint8 engine_id, uint8 uc_byte);
uint8 fifo_pushFlag(uint8 uc_direction, uint8 engine_id, uint8 uc_byte);
uint8 fifo_full(uint8 uc_direction, uint8 engine_id);
uint8 fifo_empty(uint8 uc_direction, uint8 engine_id);
uint8 fifo_peek(uint8 uc_direction, uint8 engine_id, uint8 *puc_byte, uint8 *puc_flag);
int32 ZEP_CodeBlockDone(uint8 uc_tx, uint8 uc_src);
int32 ZEP_GetRegisterValue(uint8 uc_tx, uint16 us_address, uint16 *us_val) ;
int32 ZEP_WriteRegisterValue(uint8 uc_tx, uint16 us_address, uint16 us_val, uint8 uc_ByteEn) ;
int32 ZEP_FetchInstruction(uint32 ul_address, uint32 *pul_instr) ;
int32 ZEP_MasterInputReq(uint8 uc_tx, uint8 uc_src, uint8 uc_dest) ;
int32 ZEP_SlaveInputAck(uint8 uc_tx, uint8 uc_src, uint8 uc_dest) ;
int32 ZEP_SlaveOutputAck(uint8 uc_tx, uint8 uc_src, uint8 uc_dest, uint8 uc_data, uint8 uc_flag) ;
int32 ZEP_MasterOutputReq(uint8 uc_tx, uint8 uc_src, uint8 uc_dest, uint8 uc_data, uint8 uc_flag);
int32 ZEP_CRI_CodeBlockInterrupt(uint8 uc_tx, uint8 uc_src) ;
void TLM_CRI_Check_Fci_Int(uint8 port, uint8 mask, uint8 *status);
uint8  checkBreakonFlag( t_code_engine *pt_CodeEngine, uint8 uc_flag);
#ifdef NO_TLM
void TLM_ZEP_CRI_CodeBlockInterrupt(uint8 uc_tx, uint8 uc_src);
void TLM_ZEP_SlaveInputAck(uint8 uc_tx, uint8 uc_src, uint8 uc_dest) ;
void TLM_ZEP_MasterInputReq(uint8 uc_tx, uint8 uc_src, uint8 uc_dest ) ;
void TLM_ZEP_MasterOutputReq(uint8 uc_tx, uint8 uc_src, uint8 uc_dest, uint8 uc_data, uint8 uc_flag) ;
void TLM_ZEP_SlaveOutputAck(uint8 uc_tx, uint8 uc_src, uint8 uc_dest, uint8 uc_data, uint8 uc_flag) ;
void TLM_ZEP_FetchInstruction(uint32 ul_address, uint32 *pul_instr) ;
void TLM_ZEP_GetRegisterValue(uint8 uc_tx, uint16 us_address, uint16 *us_val) ;
void TLM_ZEP_WriteRegisterValue(uint8 uc_tx, uint16 us_address, uint16 us_val, uint8 uc_ByteEn) ;
void TLM_ZEP_CodeBlockDone(uint8 uc_tx, uint8 uc_src) ;
#endif
//end of zep_engine_tlm.c

//zep_tc_fifo.c
uint8 GetByteFromTxFifo(uint8 uc_port, int16 s_FifoNumber);
uint8 GetByteFromRxFifo(uint8 uc_port, int16 s_FifoNumber);
void PutByteInTxFifo(uint8 uc_port, int16 s_FifoNumber, uint8 uc_byte);
void PutByteInRxFifo(uint8 uc_port, int16 s_FifoNumber, uint8 uc_byte);
void CheckTxFifoAccess(uint8 uc_port);
void CheckRxFifoAccess(uint8 uc_port);
void GetTxFIFOState(uint8 uc_port, uint8 uc_LP, int16 s_FifoNumber);
void PutTxFIFOState(uint8 uc_port, uint8 uc_LP, int16 s_FifoNumber);
void GetRxFIFOState(uint8 uc_port, uint8 uc_LP, int16 s_FifoNumber);
void PutRxFIFOState(uint8 uc_port, uint8 uc_LP, int16 s_FifoNumber);
uint8 isTxFifoEmpty(uint8 uc_port, int16 s_FifoNumber);
uint8 isRxFifoEmpty(uint8 uc_port, int16 s_FifoNumber);
uint8 PutVBC0Byte(uint8 , uint8 );
uint8 PutVBC1Byte(uint8 , uint8 );
uint8 GetVBC1Byte(uint8 );
uint8 GetVBC0Byte(uint8 );

//zep_ilv_tx.c
int32 DirectWriteByteToTxILVB(uint8 uc_byte , int16 ilvSelect);
int32 DirectReadByteFromTxILVB(uint8 *puc_byte, int16 ilvSelect);
int32 UpdateTxWRAD();
int32 UpdateTxRDAD();
int32 WriteByteToTxILVB(int16 s_lp, uint8 uc_byte, int16 ilvSelect);
int32 ReadByteFromTxILVB(int16 s_lp, uint8 *puc_byte , int16 ilvSelect);
void ZEP_ILV_Tx_Pms_PointersBlockInefficient( uint32 *ul_pms_ptr, int16 s_lp , int16 ilvSelect );
void ZEP_ILV_Tx_Pmd_PointersBlockInefficient( uint32 *ul_pms_ptr, int16 s_lp , int16 ilvSelect );
void ZEP_ILV_Tx_Pms_Pointers(uint16 *us_pms_pointer, uint32 *ul_pms_base, int16 s_lp, int16  ilvSelect);
void ZEP_ILV_Tx_Skip_Dummy_Pms_Fifo(int16 s_lp, int16 ilvSelect);
void ZEP_ILV_Tx_Pms_Skip_Shalf_Fifos(int16 s_lp, int16 toggle, int16 ilvSelect);
void ZEP_ILV_Tx_Update_Pms_Base_Ptr(int16 s_lp, int16 ilvSelect);
void ZEP_ILV_Tx_Pmd_Pointers(uint32 *ul_pmd_base,  int16 s_lp , int16 ilvSelect);
void ZEP_ILV_Update_Pmd_Base_Ptr(int16 s_lp, int16 ilvSelect);
void ZEP_ILV_Tx_Skip_Dummy_Pmd_Fifo(int16 s_lp);
void ZEP_ILV_Tx_Pmd_DCID_Update(int16 s_lp);
void ZEP_ILV_Tx_Pmd_Skip_Shalf_Fifos(int16 s_lp, int16 toggle);

//zep_ilv_rx.c
int32 ZEP_ILV_GetByteFromRxDILVB(int16 s_lp, uint8 *puc_byte , uint8 *puc_metric, int16 ilvSelect);
int32 WriteByteToRxDILVB(int16 s_lp, uint8 uc_byte, int16 ilvSelect);
int32 ReadByteFromRxDILVB(int16 s_lp, uint8 *puc_byte, int16 ilvSelect);
int32 ReadByteMetricFromMetricBuffer(int16 s_lp, uint8 *puc_metric);
int32 UpdateRxWRAD();
int32 UpdateRxRDAD();
int32 DirectWriteByteToRxDILVB(uint8 uc_byte, int16 ilvSelect);
int32 DirectReadByteFromRxDILVB(uint8 *puc_byte, int16 ilvSelect);
void ZEP_ILV_Rx_Pms_Pointers( uint32 *ul_pms_base, int16 s_lp , int16 ilvSelect);
void ZEP_ILV_Rx_Pmd_Pointers( uint32 *ul_pmd_base, int16 s_lp, int16 ilvSelect);
void ZEP_ILV_Rx_Pmd_DCID_Update(int16 s_lp);
void UpdatePmsFifo(int16 s_lp);
void UpdatePmdFifo(int16 s_lp);
void ZEP_ILV_Pms_Pmd_Update(int16 s_lp);
void ZEP_ILV_Rx_Pms_PointersBlockInefficient( uint32 *ul_pms_ptr, int16 s_lp , int16 ilvSelect );
void ZEP_ILV_Rx_Pmd_PointersBlockInefficient( uint32 *ul_pms_ptr, int16 s_lp , int16 ilvSelect );
uint8 calculateGarbageFlag(  uint32 ul_ILVSize,
                     uint32 *pul_ILV_PmdCntrs ,uint16 *puc_ILV_PmdCntrsMsb,
                     uint32 ul_Dlarger, uint32 ul_Dsmaller,
                     uint16 us_ILV_I, uint16 us_PmdStep
                     );
//zep_ilv_io.c
uint32 ZEP_ILV_Calc_Ptr(uint16 uc_I, uint8 uc_fifo, uint16 *pus_iover2_ptr,
                          uint16 us_len, uint16 us_Dmax_len, uint16 us_fifo_width,
                  uint16 us_gl_ptr);
uint16 ZEP_ILV_Fifo_Delay(uint16 uc_I, uint16 us_D, uint8 uc_fifo);
uint16 ZEP_ILV_Find_Pmd_Step(uint16 s_D, uint16 s_I, uint8 uc_Rx_Eff_Dis);
uint16 ZEP_ILV_Tx_Fifo_Footprint(uint16 us_Tx_fifo_ext, uint16 us_Dmax_fifo_delay);
uint16 ZEP_ILV_Rx_Fifo_Footprint(uint16 us_Rx_fifo_ext, uint16 us_Dmax_fifo_delay, uint16 us_I, uint16 us_Dmax);

#endif // _ZEP_PRIVATE_H

