/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: cri_dsp_interface.h
;
;  Description:    Specifies DSP to CRI interface.  This interface
;              consists of the register offsets (from register
;              base), the register masks, memory lengths, and other
;              #define's that specify the hardware.
;
*****************************************************************************/

#ifndef _CRI_DSP_INTERFACE_H
#define _CRI_DSP_INTERFACE_H

// Register Offsets
#define CRI_CCR0_OFFSET         (0x00)   //Clock Control 0 Register
#define CRI_CCR1_OFFSET         (0x01)   //Clock Control 1 Register
#define CRI_RST_OFFSET          (0x02)   //Reset Control Register
#define CRI_MASK0_TX_OFFSET     (0x03)   //Interrupt Mask 0 TX Register
#define CRI_MASK0_RX_OFFSET     (0x04)   //Interrupt Mask 0 RX Register
#define CRI_MASK1_TX_OFFSET     (0x05)   //Interrupt Mask 1 TX Register
#define CRI_MASK1_RX_OFFSET     (0x06)   //Interrupt Mask 1 RX Register
#define CRI_STATUS0_OFFSET      (0x07)   //Interrupt Status 0 Register
#define CRI_STATUS1_OFFSET      (0x08)   //Interrupt Status 1 Register
#define CRI_AMASK0_TX_OFFSET    (0x09)   //Active Interrupt Mask 0 TX Register
#define CRI_AMASK0_RX_OFFSET    (0x0A)   //Active Interrupt Mask 0 RX Register
#define CRI_AMASK1_TX_OFFSET    (0x0B)   //Active Interrupt Mask 1 TX Register
#define CRI_AMASK1_RX_OFFSET    (0x0C)   //Active Interrupt Mask 1 RX Register
#define CRI_UPDCTL_OFFSET       (0x0D)   //Mask Update Control Register
#define CRI_EVENT_OFFSET        (0x0E)   //Event Status Register
#define CRI_TX_TIMER_OFFSET     (0x0F)   //Transmit Timer Register
#define CRI_TX_TIMER_CTL_OFFSET (0x10)   //Transmit Timer Control Register
#define CRI_RX_TIMER_OFFSET     (0x11)   //Receive Timer Register
#define CRI_RX_TIMER_CTL_OFFSET (0x12)   //Receive Timer Control Register
#define CRI_TX_AXTC_CTL_OFFSET  (0x13)   //Transmit Alphaeus-XTC Interface Control Register
#define CRI_TX_BCR_CTL_OFFSET   (0x14)   //Transmit Bearer Channel Router Control Register
#define CRI_TX_FC_CTL_OFFSET    (0x15)   //Transmit FC Core Control Register
#define CRI_TX_QT_CTL_OFFSET    (0x16)   //Transmit QT Core Control Register
#define CRI_TX_IFFT_CTL_OFFSET  (0x17)   //Transmit IFFT Core Control Register
#define CRI_TX_PARR_CTL_OFFSET  (0x18)   //Transmit PARR Core Control Register
#define CRI_RX_FFT_CTL_OFFSET   (0x19)   //Receive FFT Core Control Register
#define CRI_RX_QT_CTL_OFFSET    (0x1A)   //Receive QT Core Control Register
#define CRI_RX_FC_CTL_OFFSET    (0x1B)   //Receive FC Core Control Register
#define CRI_RX_BCR_CTL_OFFSET   (0x1C)   //Receive Bearer Channel Router Control Register
#define CRI_RX_AXTC_CTL_OFFSET  (0x1D)   //Receive Alphaeus-XTC Interface Control Register
#define CRI_DBGVIS_CFG_OFFSET   (0x1E)   //Debug Visibility Port Config Register
#define CRI_DBGVIS_DCTL_OFFSET  (0x1F)   //Debug Visibility Port Data Control Register


#define CRI_MAX_REG_OFFSET      (0x1F)
// CRI Reset Interface
void CRI_Reset(void);

#endif //_CRI_DSP_INTERFACE_H
