/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: cri_cocomo_interface.h
;
;  Description:    Specifies Cocomo to CRI interface.  This interface
;              includes the register read/write functions, a core
;              reset function, a BM intialization function, and any
;              other cocomo/BM only functions/variables that are
;              required to run a HW Engine simulation.  These functions
;              are NOT required by, and unavailable for, actual HW.
;
*****************************************************************************/

#ifndef _CRI_COCOMO_INTERFACE_H
#define _CRI_COCOMO_INTERFACE_H

#include "cri_basic_type.h"

//Functions called by other core BMs
void CRI_Reset(void);
int32 CRI_ReadWord(uint8 uc_port, uint32 ul_PhysAddr, uint32 *pul_word, uint8 uc_ByteEnable);
int32 CRI_WriteWord(uint8 uc_port, uint32 ul_PhysAddr, uint32 ul_word, uint8 uc_ByteEnable);
void CRI_TxBufferSwap(uint8 uc_port);
void CRI_RxBufferSwap(uint8 uc_port);
void CRI_FFT_Done(uint8 uc_port);
void CRI_Event_Notification(uint8 uc_port, uint32 ul_word);
void CRI_DelayedTxQtGoDrop (uint8 uc_port, uint8 go, uint8 stall);
void CRI_DelayedRxQtGoDrop (uint8 uc_port, uint8 go, uint8 stall);
void CRI_IncrementFixedTsTimerValues (void);
void CRI_IncrementPMDTimerValues (void);
void CRI_GetInterruptStatus(uint8 uc_port, uint32 *ul_int0, uint32 *ul_int1);

#endif //_CRI_COCOMO_INTERFACE_H

