/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright 1998-2008 (c) Aware, Inc.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//--
//
// The software is owned by Aware, Inc. and is protected by United States
// copyright laws and international treaty provisions. Therefore, you must treat
// the software like any other copyrighted material.  You may not use or copy
// the software or any accompanying written materials for any other purpose than
// what is described in the Development and License Agreement
// entered into with Aware Inc. (the "Agreement").  Except as
// expressly provided in the Agreement, Aware does not grant any express or
// implied rights to you to or under Aware or any third party patents, copyrights,
// trademarks, or trade secret information.  Additionally, you shall reproduce
// and apply any copyright or other proprietary rights notices included on or
// embedded in the software to any copies or derivative works made thereof, in
// whole or in part, in any form.  These rights are provided for information
// clarification, other restrictions of rights may apply as well.
//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//
//
// Filename : $RCSfile: cri_const.h $
// Creator  : Aware, Inc.
// Created  : 03/11/2007
// Revision : $Revision: 1.1 $
// Rev Date : $Date: 2008/10/30 15:48:18Z $
//
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// Description: Constant Definitions for the CRI BM
//
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

#ifndef _CRI_CONST_H
#define _CRI_CONST_H


#define MAX_NUM_PORTS (4)

//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//  EXCEPTIONS
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

#define NO_EXCEPTION            (0)   // Default value
#define INVALID_MEM_ACCESS      (5)   // Invalid access to memory

#define RX (0)
#define TX (1)

// --- misc start constants --
#define CRI_TIMER_START       (0x2)
#define CRI_BUFFER_SWAP_START (0x3)
#define CRI_TSC_START         (0x4)

// --- cascade mode constants --
#define CRI_TX_PMS_FOLLOWS_QT    (0x5)
#define CRI_TX_PMS_FOLLOWS_IFFT  (0x6)
#define CRI_TX_PMS_FOLLOWS_PARR  (0x7)

#define CRI_TX_QTP_FOLLOWS_PMS   (0x5)
#define CRI_TX_QTP_FOLLOWS_QT    (0x6)
#define CRI_TX_QTP_FOLLOWS_IFFT  (0x7)

#define CRI_TX_QT_FOLLOWS_PMS    (0x5)
#define CRI_TX_QT_FOLLOWS_IFFT   (0x6)
#define CRI_TX_QT_FOLLOWS_PARR   (0x7)

#define CRI_TX_IFFT_FOLLOWS_PMS  (0x5)
#define CRI_TX_IFFT_FOLLOWS_QT   (0x6)
#define CRI_TX_IFFT_FOLLOWS_PARR (0x7)

#define CRI_TX_PARR_FOLLOWS_PMS  (0x5)
#define CRI_TX_PARR_FOLLOWS_QT   (0x6)
#define CRI_TX_PARR_FOLLOWS_IFFT (0x7)

#define CRI_RX_FFT_FOLLOWS_QT    (0x5)
#define CRI_RX_FFT_FOLLOWS_PMS   (0x6)

#define CRI_RX_QT_FOLLOWS_FFT    (0x5)
#define CRI_RX_QT_FOLLOWS_PMS    (0x6)

#define CRI_RX_QTP_FOLLOWS_FFT   (0x5)
#define CRI_RX_QTP_FOLLOWS_PMS   (0x6)
#define CRI_RX_QTP_FOLLOWS_QT    (0x7)

#define CRI_RX_PMS_FOLLOWS_FFT   (0x5)
#define CRI_RX_PMS_FOLLOWS_QT    (0x6)






//-- byte enable masks --
#define CRI_NO_BYTE_EN     (0x0)
#define CRI_BYTE0_EN       (0x1)
#define CRI_BYTE1_EN       (0x2)
#define CRI_BYTE2_EN       (0x4)
#define CRI_BYTE3_EN       (0x8)
#define CRI_LOWER_WORD_EN  (CRI_BYTE1_EN | CRI_BYTE0_EN)
#define CRI_UPPER_WORD_EN  (CRI_BYTE3_EN | CRI_BYTE2_EN)
#define CRI_LONGWORD_EN    (CRI_UPPER_WORD_EN | CRI_LOWER_WORD_EN)

//-- byte masks --
#define BYTE0_MASK       (0x000000FF)
#define BYTE1_MASK       (0x0000FF00)
#define BYTE2_MASK       (0x00FF0000)
#define BYTE3_MASK       (0xFF000000)
#define LOWER_WORD_MASK  (BYTE1_MASK | BYTE0_MASK)
#define UPPER_WORD_MASK  (BYTE3_MASK | BYTE2_MASK)
#define LONGWORD_MASK    (UPPER_WORD_MASK | LOWER_WORD_MASK)

#endif // _CRI_CONST_H


//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// Modification History:
//
//   $Log: cri_const.h $
//   Revision 1.1  2008/10/30 15:48:18Z  myong
//   Initial revision
//   Revision 1.7  2008-07-14 14:31:11-04  astone
//   FTB FFT start mode eliminated.
//
//   Revision 1.6  2008-04-17 17:57:39-04  astone
//   Define RX and TX as 0 and 1
//
//   Revision 1.5  2008-03-24 18:03:20-04  astone
//   CRI_TIMER_START
//
//   Revision 1.4  2008-03-24 16:34:56-04  astone
//   CRI_TSC_START
//
//   Revision 1.3  2008-03-24 11:10:25-04  astone
//   Add FTB FFT start mode
//
//   Revision 1.2  2008-03-21 16:22:00-04  astone
//   Create constants for cascade start mode settings.
//
//   Revision 1.1  2008-03-13 14:25:25-04  astone
//   Initial Revision
//
//
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

