/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright 1998-2008 (c) Aware, Inc.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//--
//
// The software is owned by Aware, Inc. and is protected by United States
// copyright laws and international treaty provisions. Therefore, you must treat
// the software like any other copyrighted material.  You may not use or copy
// the software or any accompanying written materials for any other purpose than
// what is described in the Development and License Agreement
// entered into with Aware Inc. (the "Agreement").  Except as
// expressly provided in the Agreement, Aware does not grant any express or
// implied rights to you to or under Aware or any third party patents, copyrights,
// trademarks, or trade secret information.  Additionally, you shall reproduce
// and apply any copyright or other proprietary rights notices included on or
// embedded in the software to any copies or derivative works made thereof, in
// whole or in part, in any form.  These rights are provided for information
// clarification, other restrictions of rights may apply as well.
//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//
//
// Filename : $RCSfile: cri_memmap.h $
// Creator  : Aware, Inc.
// Created  : 03/11/2008
// Revision : $Revision: 1.7 $
// Rev Date : $Date: 2009/04/02 19:46:39Z $
//
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// Description: Memory Map Constants for CRI BM
//
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

#ifndef _CRI_MEMMAP_H
#define _CRI_MEMMAP_H


/********** REGISTER PARAMETERS **********/

//----- addresses -----
#ifdef VRX518
#define CRI_REG_BASE_ADDR      (0x30C400)
#else
#define CRI_REG_BASE_ADDR      (0x20C400)
#endif

#define CRI_CCR_OFFSET                (0x00<<2)
#define CRI_RST_OFFSET                (0x01<<2)
#define CRI_PORT_MODE_OFFSET          (0x02<<2)
#define CRI_TSC_CTRL_OFFSET           (0x03<<2)
#define CRI_TSC_STATUS_OFFSET         (0x04<<2)
#define CRI_TX_TSLOTC_A_OFFSET        (0x05<<2)
#define CRI_TX_TSLOTC_B_OFFSET        (0x06<<2)
#define CRI_TX_TSLOT0_OFFSET          (0x07<<2)
#define CRI_TX_TSLOT1_OFFSET          (0x08<<2)
#define CRI_RX_TSLOTC_A_OFFSET        (0x09<<2)
#define CRI_RX_TSLOTC_B_OFFSET        (0x0A<<2)
#define CRI_RX_TSLOT0_OFFSET          (0x0B<<2)
#define CRI_RX_TSLOT1_OFFSET          (0x0C<<2)
#define CRI_TX_ATSLOTC_A_OFFSET       (0x0D<<2)
#define CRI_TX_ATSLOTC_B_OFFSET       (0x0E<<2)
#define CRI_TX_ATSLOT0_OFFSET         (0x0F<<2)
#define CRI_TX_ATSLOT1_OFFSET         (0x10<<2)
#define CRI_RX_ATSLOTC_A_OFFSET       (0x11<<2)
#define CRI_RX_ATSLOTC_B_OFFSET       (0x12<<2)
#define CRI_RX_ATSLOT0_OFFSET         (0x13<<2)
#define CRI_RX_ATSLOT1_OFFSET         (0x14<<2)
#define CRI_RXGP0_CTL_OFFSET          (0x15<<2)
#define CRI_RXGP1_CTL_OFFSET          (0x16<<2)
#define CRI_TXGP0_CTL_OFFSET          (0x17<<2)
#define CRI_TXGP1_CTL_OFFSET          (0x18<<2)
#define CRI_RXGP0_VAL_OFFSET          (0x19<<2)
#define CRI_RXGP1_VAL_OFFSET          (0x1A<<2)
#define CRI_TXGP0_MCNT_OFFSET         (0x1B<<2)
#define CRI_TXGP1_MCNT_OFFSET         (0x1C<<2)
#define CRI_MASK0_TX_OFFSET           (0x1D<<2)
#define CRI_MASK0_RX_OFFSET           (0x1E<<2)
#define CRI_MASK1_TX_OFFSET           (0x1F<<2)
#define CRI_MASK1_RX_OFFSET           (0x20<<2)
#define CRI_STATUS0_OFFSET            (0x21<<2)
#define CRI_STATUS1_OFFSET            (0x22<<2)
#define CRI_AMASK0_TX_OFFSET          (0x23<<2)
#define CRI_AMASK0_RX_OFFSET          (0x24<<2)
#define CRI_AMASK1_TX_OFFSET          (0x25<<2)
#define CRI_AMASK1_RX_OFFSET          (0x26<<2)
#define CRI_UPDCTL_OFFSET             (0x27<<2)
#define CRI_EVENT_OFFSET              (0x28<<2)
#define CRI_TX_TIMER_OFFSET           (0x29<<2)
#define CRI_TX_TIMER_CTL_OFFSET       (0x2A<<2)
#define CRI_RX_TIMER_OFFSET           (0x2B<<2)
#define CRI_RX_TIMER_CTL_OFFSET       (0x2C<<2)
#define CRI_TX_PMS_CTL_OFFSET         (0x2D<<2)
#define CRI_TX_QTP_CTL_OFFSET         (0x2E<<2)
#define CRI_TX_QT_CTL_OFFSET          (0x2F<<2)
#define CRI_TX_IFFT_CTL_OFFSET        (0x30<<2)
#define CRI_RX_FFT_CTL_OFFSET         (0x31<<2)
#define CRI_RX_QT_CTL_OFFSET          (0x32<<2)
#define CRI_RX_QTP_CTL_OFFSET         (0x33<<2)
#define CRI_RX_PMS_CTL_OFFSET         (0x34<<2)
#define CRI_TX_QT_STALL_OFFSET        (0x35<<2)
#define CRI_RX_QT_STALL_OFFSET        (0x36<<2)
#define CRI_RX_FFT_STALL_CTL_OFFSET   (0x37<<2)
#define CRI_NTR_CPE_CTRL_OFFSET       (0x38<<2)
#define CRI_NTR_SRCFR_OFFSET          (0x39<<2)
#define CRI_NTR_PHASE_OFFSET          (0x3A<<2)
#define CRI_NTR_CO_CTRL_OFFSET        (0x3B<<2)
#define CRI_NTR_CO_PERP_NUM_OFFSET    (0x3C<<2)
#define CRI_NTR_CO_PERP_DENOM_OFFSET  (0x3D<<2)
#define CRI_FCIMASK2_TX_OFFSET        (0x3E<<2)
#define CRI_FCIMASK2_RX_OFFSET        (0x3F<<2)
#define CRI_FCIMASK3_TX_OFFSET        (0x40<<2)
#define CRI_FCIMASK3_RX_OFFSET        (0x41<<2)
#define CRI_FCISTATUS2_OFFSET         (0x42<<2)
#define CRI_FCISTATUS3_OFFSET         (0x43<<2)

#ifdef VRX518
#define CRI_35B_CTRL_OFFSET         (0x44<<2)
#define CRI_LD_DOUT_OFFSET            (0x45<<2)
#define CRI_LD_CTRL_OFFSET            (0x46<<2)
#define CRI_REG_MAX_OFFSET     (CRI_LD_CTRL_OFFSET)
#else
#define CRI_REG_MAX_OFFSET     (CRI_FCISTATUS3_OFFSET)
#endif
#define CRI_REG_MAX_ADDR       (CRI_REG_BASE_ADDR + CRI_REG_MAX_OFFSET)


#define CRI_CCR_ADDR                (CRI_REG_BASE_ADDR + CRI_CCR_OFFSET)
#define CRI_RST_ADDR                (CRI_REG_BASE_ADDR + CRI_RST_OFFSET)
#define CRI_PORT_MODE_ADDR          (CRI_REG_BASE_ADDR + CRI_PORT_MODE_OFFSET)
#define CRI_TSC_CTRL_ADDR           (CRI_REG_BASE_ADDR + CRI_TSC_CTRL_OFFSET)
#define CRI_TSC_STATUS_ADDR         (CRI_REG_BASE_ADDR + CRI_TSC_STATUS_OFFSET)
#define CRI_TX_TSLOTC_A_ADDR        (CRI_REG_BASE_ADDR + CRI_TX_TSLOTC_A_OFFSET)
#define CRI_TX_TSLOTC_B_ADDR        (CRI_REG_BASE_ADDR + CRI_TX_TSLOTC_B_OFFSET)
#define CRI_TX_TSLOT0_ADDR          (CRI_REG_BASE_ADDR + CRI_TX_TSLOT0_OFFSET)
#define CRI_TX_TSLOT1_ADDR          (CRI_REG_BASE_ADDR + CRI_TX_TSLOT1_OFFSET)
#define CRI_RX_TSLOTC_A_ADDR        (CRI_REG_BASE_ADDR + CRI_RX_TSLOTC_A_OFFSET)
#define CRI_RX_TSLOTC_B_ADDR        (CRI_REG_BASE_ADDR + CRI_RX_TSLOTC_B_OFFSET)
#define CRI_RX_TSLOT0_ADDR          (CRI_REG_BASE_ADDR + CRI_RX_TSLOT0_OFFSET)
#define CRI_RX_TSLOT1_ADDR          (CRI_REG_BASE_ADDR + CRI_RX_TSLOT1_OFFSET)
#define CRI_TX_ATSLOTC_A_ADDR       (CRI_REG_BASE_ADDR + CRI_TX_ATSLOTC_A_OFFSET)
#define CRI_TX_ATSLOTC_B_ADDR       (CRI_REG_BASE_ADDR + CRI_TX_ATSLOTC_B_OFFSET)
#define CRI_TX_ATSLOT0_ADDR         (CRI_REG_BASE_ADDR + CRI_TX_ATSLOT0_OFFSET)
#define CRI_TX_ATSLOT1_ADDR         (CRI_REG_BASE_ADDR + CRI_TX_ATSLOT1_OFFSET)
#define CRI_RX_ATSLOTC_A_ADDR       (CRI_REG_BASE_ADDR + CRI_RX_ATSLOTC_A_OFFSET)
#define CRI_RX_ATSLOTC_B_ADDR       (CRI_REG_BASE_ADDR + CRI_RX_ATSLOTC_B_OFFSET)
#define CRI_RX_ATSLOT0_ADDR         (CRI_REG_BASE_ADDR + CRI_RX_ATSLOT0_OFFSET)
#define CRI_RX_ATSLOT1_ADDR         (CRI_REG_BASE_ADDR + CRI_RX_ATSLOT1_OFFSET)
#define CRI_RXGP0_CTL_ADDR          (CRI_REG_BASE_ADDR + CRI_RXGP0_CTL_OFFSET)
#define CRI_RXGP1_CTL_ADDR          (CRI_REG_BASE_ADDR + CRI_RXGP1_CTL_OFFSET)
#define CRI_TXGP0_CTL_ADDR          (CRI_REG_BASE_ADDR + CRI_TXGP0_CTL_OFFSET)
#define CRI_TXGP1_CTL_ADDR          (CRI_REG_BASE_ADDR + CRI_TXGP1_CTL_OFFSET)
#define CRI_RXGP0_VAL_ADDR          (CRI_REG_BASE_ADDR + CRI_RXGP0_VAL_OFFSET)
#define CRI_RXGP1_VAL_ADDR          (CRI_REG_BASE_ADDR + CRI_RXGP1_VAL_OFFSET)
#define CRI_TXGP0_MCNT_ADDR         (CRI_REG_BASE_ADDR + CRI_TXGP0_MCNT_OFFSET)
#define CRI_TXGP1_MCNT_ADDR         (CRI_REG_BASE_ADDR + CRI_TXGP1_MCNT_OFFSET)
#define CRI_MASK0_TX_ADDR           (CRI_REG_BASE_ADDR + CRI_MASK0_TX_OFFSET)
#define CRI_MASK0_RX_ADDR           (CRI_REG_BASE_ADDR + CRI_MASK0_RX_OFFSET)
#define CRI_MASK1_TX_ADDR           (CRI_REG_BASE_ADDR + CRI_MASK1_TX_OFFSET)
#define CRI_MASK1_RX_ADDR           (CRI_REG_BASE_ADDR + CRI_MASK1_RX_OFFSET)
#define CRI_STATUS0_ADDR            (CRI_REG_BASE_ADDR + CRI_STATUS0_OFFSET)
#define CRI_STATUS1_ADDR            (CRI_REG_BASE_ADDR + CRI_STATUS1_OFFSET)
#define CRI_AMASK0_TX_ADDR          (CRI_REG_BASE_ADDR + CRI_AMASK0_TX_OFFSET)
#define CRI_AMASK0_RX_ADDR          (CRI_REG_BASE_ADDR + CRI_AMASK0_RX_OFFSET)
#define CRI_AMASK1_TX_ADDR          (CRI_REG_BASE_ADDR + CRI_AMASK1_TX_OFFSET)
#define CRI_AMASK1_RX_ADDR          (CRI_REG_BASE_ADDR + CRI_AMASK1_RX_OFFSET)
#define CRI_UPDCTL_ADDR             (CRI_REG_BASE_ADDR + CRI_UPDCTL_OFFSET)
#define CRI_EVENT_ADDR              (CRI_REG_BASE_ADDR + CRI_EVENT_OFFSET)
#define CRI_TX_TIMER_ADDR           (CRI_REG_BASE_ADDR + CRI_TX_TIMER_OFFSET)
#define CRI_TX_TIMER_CTL_ADDR       (CRI_REG_BASE_ADDR + CRI_TX_TIMER_CTL_OFFSET)
#define CRI_RX_TIMER_ADDR           (CRI_REG_BASE_ADDR + CRI_RX_TIMER_OFFSET)
#define CRI_RX_TIMER_CTL_ADDR       (CRI_REG_BASE_ADDR + CRI_RX_TIMER_CTL_OFFSET)
#define CRI_TX_PMS_CTL_ADDR         (CRI_REG_BASE_ADDR + CRI_TX_PMS_CTL_OFFSET)
#define CRI_TX_QTP_CTL_ADDR         (CRI_REG_BASE_ADDR + CRI_TX_QTP_CTL_OFFSET)
#define CRI_TX_QT_CTL_ADDR          (CRI_REG_BASE_ADDR + CRI_TX_QT_CTL_OFFSET)
#define CRI_TX_IFFT_CTL_ADDR        (CRI_REG_BASE_ADDR + CRI_TX_IFFT_CTL_OFFSET)
#define CRI_RX_FFT_CTL_ADDR         (CRI_REG_BASE_ADDR + CRI_RX_FFT_CTL_OFFSET)
#define CRI_RX_QT_CTL_ADDR          (CRI_REG_BASE_ADDR + CRI_RX_QT_CTL_OFFSET)
#define CRI_RX_QTP_CTL_ADDR         (CRI_REG_BASE_ADDR + CRI_RX_QTP_CTL_OFFSET)
#define CRI_RX_PMS_CTL_ADDR         (CRI_REG_BASE_ADDR + CRI_RX_PMS_CTL_OFFSET)
#define CRI_TX_QT_STALL_ADDR        (CRI_REG_BASE_ADDR + CRI_TX_QT_STALL_OFFSET)
#define CRI_RX_QT_STALL_ADDR        (CRI_REG_BASE_ADDR + CRI_RX_QT_STALL_OFFSET)
#define CRI_RX_FFT_STALL_CTL_ADDR   (CRI_REG_BASE_ADDR + CRI_RX_FFT_STALL_CTL_OFFSET)
#define CRI_NTR_CPE_CTRL_ADDR       (CRI_REG_BASE_ADDR + CRI_NTR_CPE_CTRL_OFFSET)
#define CRI_NTR_SRCFR_ADDR          (CRI_REG_BASE_ADDR + CRI_NTR_SRCFR_OFFSET)
#define CRI_NTR_PHASE_ADDR          (CRI_REG_BASE_ADDR + CRI_NTR_PHASE_OFFSET)
#define CRI_NTR_CO_CTRL_ADDR        (CRI_REG_BASE_ADDR + CRI_NTR_CO_CTRL_OFFSET)
#define CRI_NTR_CO_PERP_NUM_ADDR    (CRI_REG_BASE_ADDR + CRI_NTR_CO_PERP_NUM_OFFSET)
#define CRI_NTR_CO_PERP_DENOM_ADDR  (CRI_REG_BASE_ADDR + CRI_NTR_CO_PERP_DENOM_OFFSET)
#define CRI_FCIMASK2_TX_ADDR        (CRI_REG_BASE_ADDR + CRI_FCIMASK2_TX_OFFSET)
#define CRI_FCIMASK2_RX_ADDR        (CRI_REG_BASE_ADDR + CRI_FCIMASK2_RX_OFFSET)
#define CRI_FCIMASK3_TX_ADDR        (CRI_REG_BASE_ADDR + CRI_FCIMASK3_TX_OFFSET)
#define CRI_FCIMASK3_RX_ADDR        (CRI_REG_BASE_ADDR + CRI_FCIMASK3_RX_OFFSET)
#define CRI_FCISTATUS2_ADDR         (CRI_REG_BASE_ADDR + CRI_FCISTATUS2_OFFSET)
#define CRI_FCISTATUS3_ADDR         (CRI_REG_BASE_ADDR + CRI_FCISTATUS3_OFFSET)
#ifdef VRX518
#define CRI_35B_CTRL_ADDR        (CRI_REG_BASE_ADDR + CRI_35B_CTRL_OFFSET)
#define CRI_LD_DOUT_ADDR         (CRI_REG_BASE_ADDR + CRI_LD_DOUT_OFFSET)
#define CRI_LD_CTRL_ADDR         (CRI_REG_BASE_ADDR + CRI_LD_CTRL_OFFSET)
#endif
//----- masks -----

#define CRI_CCR_MASK                (0x0000003F)
#define CRI_RST_MASK                (0x0000003F)
#define CRI_PORT_MODE_MASK          (0x00000FFF)
#define CRI_TSC_CTRL_MASK           (0x00000011)
#define CRI_TSC_STATUS_MASK         (0x00000000)
#define CRI_TX_TSLOTC_A_MASK        (0x3FFFFFFF)
#define CRI_TX_TSLOTC_B_MASK        (0x3FFFFFFF)
#define CRI_TX_TSLOT0_MASK          (0x3FFFFFFF)
#define CRI_TX_TSLOT1_MASK          (0x3FFFFFFF)
#define CRI_TX_TSLOT2_MASK          (0x3FFFFFFF)
#define CRI_TX_TSLOT3_MASK          (0x3FFFFFFF)
#define CRI_RX_TSLOTC_A_MASK        (0x3FFFFFFF)
#define CRI_RX_TSLOTC_B_MASK        (0x3FFFFFFF)
#define CRI_RX_TSLOT0_MASK          (0x3FFFFFFF)
#define CRI_RX_TSLOT1_MASK          (0x3FFFFFFF)
#define CRI_RX_TSLOT2_MASK          (0x3FFFFFFF)
#define CRI_RX_TSLOT3_MASK          (0x3FFFFFFF)
#define CRI_TX_ATSLOTC_A_MASK       (0x3E000000)
#define CRI_TX_ATSLOTC_B_MASK       (0x3E000000)
#define CRI_TX_ATSLOT0_MASK         (0x3E000000)
#define CRI_TX_ATSLOT1_MASK         (0x3E000000)
#define CRI_TX_ATSLOT2_MASK         (0x3E000000)
#define CRI_TX_ATSLOT3_MASK         (0x3E000000)
#define CRI_RX_ATSLOTC_A_MASK       (0x3E000000)
#define CRI_RX_ATSLOTC_B_MASK       (0x3E000000)
#define CRI_RX_ATSLOT0_MASK         (0x3E000000)
#define CRI_RX_ATSLOT1_MASK         (0x3E000000)
#define CRI_RX_ATSLOT2_MASK         (0x3E000000)
#define CRI_RX_ATSLOT3_MASK         (0x3E000000)
#define CRI_RXGP0_CTL_MASK          (0x00000000)
#define CRI_RXGP1_CTL_MASK          (0x00000000)
#define CRI_TXGP0_CTL_MASK          (0x00000000)
#define CRI_TXGP1_CTL_MASK          (0x00000000)
#define CRI_RXGP0_VAL_MASK          (0x00000000)
#define CRI_RXGP1_VAL_MASK          (0x00000000)
#define CRI_TXGP0_MCNT_MASK         (0x00000000)
#define CRI_TXGP1_MCNT_MASK         (0x00000000)
#define CRI_MASK0_TX_MASK           (0x37F80014)
#define CRI_MASK0_RX_MASK           (0xC007F329)
#define CRI_MASK1_TX_MASK           (0x37F80014)
#define CRI_MASK1_RX_MASK           (0xC007F329)
#define CRI_STATUS0_MASK            (0x00000000)
#define CRI_STATUS1_MASK            (0x00000000)
#define CRI_AMASK0_TX_MASK          (0x37F80014)
#define CRI_AMASK0_RX_MASK          (0xC007F329)
#define CRI_AMASK1_TX_MASK          (0x37F80014)
#define CRI_AMASK1_RX_MASK          (0xC007F329)
#define CRI_UPDCTL_MASK             (0x0000F1FE)
#define CRI_EVENT_MASK              (0x00000000)
#define CRI_TX_TIMER_MASK           (0x00000000)
#define CRI_TX_TIMER_CTL_MASK       (0x007FFFFF)
#define CRI_RX_TIMER_MASK           (0x00000000)
#define CRI_RX_TIMER_CTL_MASK       (0x007FFFFF)
#define CRI_TX_PMS_CTL_MASK         (0x007FFFFF)
#define CRI_TX_QTP_CTL_MASK         (0x007FFFFF)
#define CRI_TX_QT_CTL_MASK          (0x007FFFFF)
#define CRI_TX_IFFT_CTL_MASK        (0x007FFFFF)
#define CRI_TX_PARR_CTL_MASK        (0x007FFFFF)
#define CRI_RX_FFT_CTL_MASK         (0x007FFFFF)
#define CRI_RX_QT_CTL_MASK          (0x007FFFFF)
#define CRI_RX_QTP_CTL_MASK         (0x007FFFFF)
#define CRI_RX_PMS_CTL_MASK         (0x007FFFFF)
#define CRI_TX_QT_STALL_MASK        (0x0000001F)
#define CRI_RX_QT_STALL_MASK        (0x0000001F)

//******************************************************************************
// TX interrupt bit position ---- common to MASK, STATUS, and EVENT registers
//******************************************************************************
#define CRI_INTRPT_TX_GPIO_INT1           (29)
#define CRI_INTRPT_TX_GPIO_INT0           (28)
#define CRI_INTRPT_TX_PMS_DONE            (26)
#define CRI_INTRPT_TX_QT_DONE               (25)
#define CRI_INTRPT_TX_QTP_DONE              (24)
#define CRI_INTRPT_TX_FT_IFFT_DONE        (23)
//#define CRI_INTRPT_TX_FT_PARR_DONE         (22)
#define CRI_INTRPT_TX_FTB_FRAME           (21)
#define CRI_INTRPT_TX_CRI_TIMER           (20)
#define CRI_INTRPT_TX_TSC_INT          (19)
#define CRI_INTRPT_TX_QT_BAT_ERROR        (4)
//#define CRI_INTRPT_TX_PMS_STALL            (2)

//*****************************************************************************
// TX interrupt mask constants  -
//*****************************************************************************
#define CRI_MASK_TX_GPIO_INT1          (1<<CRI_INTRPT_TX_GPIO_INT1)
#define CRI_MASK_TX_GPIO_INT0          (1<<CRI_INTRPT_TX_GPIO_INT0)
#define CRI_MASK_TX_PMS_DONE           (1<<CRI_INTRPT_TX_PMS_DONE)
#define CRI_MASK_TX_QT_DONE               (1<<CRI_INTRPT_TX_QT_DONE)
#define CRI_MASK_TX_QTP_DONE           (1<<CRI_INTRPT_TX_QTP_DONE)
#define CRI_MASK_TX_FT_IFFT_DONE       (1<<CRI_INTRPT_TX_FT_IFFT_DONE)
//#define CRI_MASK_TX_FT_PARR_DONE        (1<<CRI_INTRPT_TX_FT_PARR_DONE)
#define CRI_MASK_TX_FTB_FRAME          (1<<CRI_INTRPT_TX_FTB_FRAME)
#define CRI_MASK_TX_CRI_TIMER          (1<<CRI_INTRPT_TX_CRI_TIMER)
#define CRI_MASK_TX_TSC_INT               (1<<CRI_INTRPT_TX_TSC_INT)
#define CRI_MASK_TX_QT_BAT_ERROR       (1<<CRI_INTRPT_TX_QT_BAT_ERROR)
//#define CRI_MASK_TX_PMS_STALL           (1<<CRI_INTRPT_TX_PMS_STALL)

//*****************************************************************************
// RX interrupt constants       - common to MASK, STATUS, and EVENT registers                                                */
//*****************************************************************************
#define CRI_INTRPT_RX_GPIO_INT1           (31)
#define CRI_INTRPT_RX_GPIO_INT0           (30)
#define CRI_INTRPT_RX_FTB_FRAME           (18)
#define CRI_INTRPT_RX_FT_FFT_DONE         (17)
#define CRI_INTRPT_RX_QTP_DONE            (16)
#define CRI_INTRPT_RX_QT_DONE          (15)
#define CRI_INTRPT_RX_PMS_DONE            (14)
#define CRI_INTRPT_RX_CRI_TIMER           (13)
#define CRI_INTRPT_RX_TSC_INT          (12)
#define CRI_INTRPT_RX_FC_NTR_INT       (5)
#define CRI_INTRPT_RX_QT_BAT_ERROR        (3)
#define CRI_INTRPT_RX_VFDF_DECDONE        (0)

//*****************************************************************************
// RX interrupt mask constants  - common to MASK, STATUS, and EVENT registers
//*****************************************************************************
#define CRI_MASK_RX_GPIO_INT1          (1<<CRI_INTRPT_RX_GPIO_INT1)
#define CRI_MASK_RX_GPIO_INT0          (1<<CRI_INTRPT_RX_GPIO_INT0)
#define CRI_MASK_RX_FTB_FRAME          (1<<CRI_INTRPT_RX_FTB_FRAME)
#define CRI_MASK_RX_FT_FFT_DONE           (1<<CRI_INTRPT_RX_FT_FFT_DONE)
#define CRI_MASK_RX_QTP_DONE           (1<<CRI_INTRPT_RX_QTP_DONE)
#define CRI_MASK_RX_QT_DONE               (1<<CRI_INTRPT_RX_QT_DONE)
#define CRI_MASK_RX_PMS_DONE           (1<<CRI_INTRPT_RX_PMS_DONE)
#define CRI_MASK_RX_CRI_TIMER          (1<<CRI_INTRPT_RX_CRI_TIMER)
#define CRI_MASK_RX_TSC_INT               (1<<CRI_INTRPT_RX_TSC_INT)
#define CRI_MASK_RX_FC_NTR_INT            (1<<CRI_INTRPT_RX_FC_NTR_INT)
#define CRI_MASK_RX_QT_BAT_ERROR       (1<<CRI_INTRPT_RX_QT_BAT_ERROR)
#define CRI_MASK_RX_VFDF_DECDONE       (1<<CRI_INTRPT_RX_VFDF_DECDONE)

//******************************************************************************
//CRI TX Register bit field definitions
//******************************************************************************
#define REGISTER_START_TX_FC_START        (0x1 << 23)
#define REGISTER_START_TX_FC_SEL       (0x1 << 20)
#define TX_TIMER_START_TX_FC_SEL       (0x2 << 20)
#define TX_BUFFER_SWAP_START_TX_FC_SEL    (0x3 << 20)
#define TX_TSC_START_TX_FC_SEL            (0x4 << 20)
#define TX_QT_DONE_START_TX_FC_SEL        (0x5 << 20)
#define TX_IFFT_DONE_START_TX_FC_SEL      (0x6 << 20)
#define TX_PAR_DONE_START_TX_FC_SEL       (0x7 << 20)

#define REGISTER_START_TX_QTP_START       (0x1 << 23)
#define REGISTER_START_TX_QTP_SEL         (0x1 << 20)
#define TX_TIMER_START_TX_QTP_SEL         (0x2 << 20)
#define TX_BUFFER_SWAP_START_QTP_SEL      (0x3 << 20)
#define TX_TSC_START_TX_QTP_SEL           (0x4 << 20)
#define TX_FC_DONE_START_TX_QTP_SEL       (0x5 << 20)
#define TX_QT_DONE_START_TX_QTP_SEL       (0x6 << 20)
#define TX_IFFT_DONE_START_TX_QTP_SEL     (0x7 << 20)

#define REGISTER_START_TX_QT_START        (0x1 << 23)
#define REGISTER_START_TX_QT_SEL       (0x1 << 20)
#define TX_TIMER_START_TX_QT_SEL       (0x2 << 20)
#define TX_BUFFER_SWAP_START_QT_SEL       (0x3 << 20)
#define TX_TSC_START_TX_QT_SEL            (0x4 << 20)
#define TX_FC_DONE_START_TX_QT_SEL        (0x5 << 20)
#define TX_IFFT_DONE_START_TX_QT_SEL      (0x6 << 20)
#define TX_PAR_DONE_START_TX_QT_SEL       (0x7 << 20)

#define REGISTER_START_TX_IFFT_START      (0x1 << 23)
#define REGISTER_START_TX_IFFT_SEL        (0x1 << 20)
#define TX_TIMER_START_TX_IFFT_SEL        (0x2 << 20)
#define TX_BUFFER_SWAP_START_IFFT_SEL     (0x3 << 20)
#define TX_TSC_START_TX_IFFT_SEL       (0x4 << 20)
#define TX_FC_DONE_START_TX_IFFT_SEL      (0x5 << 20)
#define TX_QT_DONE_START_TX_IFFT_SEL      (0x6 << 20)
#define TX_PARR_DONE_START_TX_IFFT_SEL    (0x7 << 20)

#define REGISTER_START_TX_PARR_START      (0x1 << 23)
#define REGISTER_START_TX_PARR_SEL        (0x1 << 20)
#define TX_TIMER_START_TX_PARR_SEL        (0x2 << 20)
#define TX_BUFFER_SWAP_START_TX_PARR_SEL  (0x3 << 20)
#define TX_TSC_START_TX_PARR_SEL       (0x4 << 20)
#define TX_FC_DONE_START_TX_PARR_SEL      (0x5 << 20)
#define TX_QT_DONE_START_TX_PARR_SEL      (0x6 << 20)
#define TX_IFFT_DONE_START_TX_PARR_SEL    (0x7 << 20)

//******************************************************************************
//CRI RX Register bit field definitions
//******************************************************************************
#define REGISTER_START_RX_FFT_START       (0x1 << 23)
#define RX_NO_FFT_START_RX_FFT_SEL        (0x0 << 20)
#define REGISTER_START_RX_FFT_SEL         (0x1 << 20)
#define RX_TIMER_START_RX_FFT_SEL         (0x2 << 20)
#define RX_BUFFER_SWAP_START_RX_FFT_SEL      (0x3 << 20)
#define RX_TSC_START_RX_FFT_SEL           (0x4 << 20)
#define RX_QT_DONE_START_RX_FFT_SEL       (0x5 << 20)
#define RX_FC_DONE_START_RX_FFT_SEL       (0x6 << 20)

#define REGISTER_START_RX_QT_START        (0x1 << 23)
#define REGISTER_START_RX_QT_SEL       (0x1 << 20)
#define RX_TIMER_START_RX_QT_SEL       (0x2 << 20)
#define RX_BUFFER_SWAP_START_RX_QT_SEL    (0x3 << 20)
#define RX_TSC_START_RX_QT_SEL            (0x4 << 20)
#define RX_FFT_DONE_START_RX_QT_SEL       (0x5 << 20)
#define RX_FC_DONE_START_RX_QT_SEL        (0x6 << 20)

#define REGISTER_START_RX_QTP_START       (0x1 << 23)
#define REGISTER_START_RX_QTP_SEL         (0x1 << 20)
#define RX_TIMER_START_RX_QTP_SEL         (0x2 << 20)
#define RX_BUFFER_SWAP_START_RX_QTP_SEL      (0x3 << 20)
#define RX_TSC_START_RX_QTP_SEL           (0x4 << 20)
#define RX_FFT_DONE_START_RX_QTP_SEL      (0x5 << 20)
#define RX_FC_DONE_START_RX_QTP_SEL       (0x6 << 20)
#define RX_QT_DONE_START_RX_QTP_SEL       (0x7 << 20)

#define REGISTER_START_RX_FC_START        (0x1 << 23)
#define REGISTER_START_RX_FC_SEL       (0x1 << 20)
#define RX_TIMER_START_RX_FC_SEL       (0x2 << 20)
#define RX_BUFFER_SWAP_START_RX_FC_SEL    (0x3 << 20)
#define RX_TSC_START_RX_FC_SEL            (0x4 << 20)
#define RX_FFT_DONE_START_RX_FC_SEL       (0x5 << 20)
#define RX_QT_DONE_START_RX_FC_SEL        (0x6 << 20)

#define REGISTER_START_RX_BCR_START       (0x1 << 23)
#define REGISTER_START_RX_BCR_SEL         (0x1 << 20)
#define RX_TIMER_START_RX_BCR_SEL         (0x2 << 20)
#define RX_BUFFER_SWAP_START_RX_BCR_SEL      (0x3 << 20)
#define RX_FFT_DONE_START_RX_BCR_SEL      (0x4 << 20)
#define RX_QT_DONE_START_RX_BCR_SEL       (0x5 << 20)
#define RX_FC_DONE_START_RX_BCR_SEL       (0x6 << 20)


/********** MEMORY PARAMETERS **********/

// The CRI has no memories, only registers.


#endif //_CRI_MEMMAP_H



//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// Modification History:
//
//   $Log: cri_memmap.h $
//   Revision 1.7  2009/04/02 19:46:39Z  wwu
//   (04/02/09 Wei Wu)
//
//   Highlights:
//   -----------
//   1) Updated CRI BM with ASIC group's latest version and spec.
//   1.1) FCI status registers and NTR registers have been added to the CRI spec. Relevant CRI BM files
//   are modified to reflect the change.
//   1.2) A new function CRI_FFT_STALL_DONE() is added. In ASIC testing environment, a TLM function will
//   be called. In COCOMO, however, we should call the FTB BM function instead.
//   1.3) Add compiler definition NO_TLM for CRI_BM project.
//
//   [cri.pj]
//   ----------------------------------
//   Bm_6.2\cri_6.2\build\Model\cri.dsp (1)
//   Bm_6.2\cri_6.2\source\Model\cri.c (1)
//   Bm_6.2\cri_6.2\source\Model\cri_init.c (1)
//   Bm_6.2\cri_6.2\source\Model\cri_io.c (1)
//   Bm_6.2\cri_6.2\source\Model\include\cri_memmap.h (1)
//   Bm_6.2\cri_6.2\source\Model\include\cri_typedef.h (1)
//   Revision 1.14  2009-02-12 15:06:38-05  kelliher
//   Added FCI IRQ registers
//
//   Revision 1.13  2009-02-03 20:21:10-05  kelliher
//   moved to facilitate ARC small mem model
//
//
//   Revision 1.12  2009-02-02 16:48:34-05  kelliher
//   added ntr co registers
//
//   Revision 1.11  2009-01-29 15:29:48-05  kelliher
//   added tc_mlbx_irqs
//
//   Revision 1.10  2009-01-26 12:45:15-05  kelliher
//   added NTR cpe register
//
//   Revision 1.9  2008-09-12 14:27:17-04  jgross
//   Remove unused registers
//
//   Revision 1.8  2008-06-18 10:36:08-04  astone
//   CRI_TSC_CONFIG eliminated.
//
//   Revision 1.7  2008-06-13 13:27:24-04  astone
//   Support for 2 time slots per core in 1 port mode.
//
//   Revision 1.6  2008-05-21 18:18:23-04  astone
//   TSC Config updates
//
//   Revision 1.5  2008-04-09 17:54:56-04  astone
//   CRI_RX_FFT_STALL_CTL
//
//   Revision 1.4  2008-03-21 16:22:03-04  astone
//   Populate CRI_TX_QT_STALL and CRI_RX_QT_STALL
//
//   Revision 1.3  2008-03-20 14:05:20-04  astone
//   Populate CRI_TX_QTP_CTL and CRI_RX_QTP_CTL
//
//   Revision 1.2  2008-03-19 16:19:13-04  astone
//   Populate masks.
//
//   Revision 1.1  2008-03-13 14:25:27-04  astone
//   Initial Revision
//
//
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
