/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright 1998-2008 (c) Aware, Inc.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//--
//
// The software is owned by Aware, Inc. and is protected by United States
// copyright laws and international treaty provisions. Therefore, you must treat
// the software like any other copyrighted material.  You may not use or copy
// the software or any accompanying written materials for any other purpose than
// what is described in the Development and License Agreement
// entered into with Aware Inc. (the "Agreement").  Except as
// expressly provided in the Agreement, Aware does not grant any express or
// implied rights to you to or under Aware or any third party patents, copyrights,
// trademarks, or trade secret information.  Additionally, you shall reproduce
// and apply any copyright or other proprietary rights notices included on or
// embedded in the software to any copies or derivative works made thereof, in
// whole or in part, in any form.  These rights are provided for information
// clarification, other restrictions of rights may apply as well.
//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//
//
// Filename : $RCSfile: cri_typedef.h $
// Creator  : Aware, INc.
// Created  : 03/12/2008
// Revision : $Revision: 1.3 $
// Rev Date : $Date: 2009/04/02 19:46:40Z $
//
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// Description: Data Types in CRI BM
//
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

#ifndef _CRI_TYPEDEF_H
#define _CRI_TYPEDEF_H

#include "cri_basic_type.h"  // include basic types

//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//  MEMORY PARAMETERS
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

// no CRI Memories


//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//  REGISTER SETTINGS
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-


// not replicated per port
typedef struct {
  // CRI CCR:
  int16 ltr_clk_dis;
  int16 vfdf_clk_dis;
  int16 ftb_clk_dis;
  int16 ft_clk_dis;
  int16 qt_clk_dis;
  int16 pms_clk_dis;

  // CRI_RST:
  int16 tc_0_init;
  int16 tc_1_init;
  int16 vfdf_sw_rst;
  int16 ftb_sw_rst;
  int16 ft_sw_rst;
  int16 qt_sw_rst;
  int16 pms_sw_rst;

  // CRI_PORT_MODE:
  int16 cri_portmode;
  int16 dsp_portmode;
  int16 vfdf_portmode;
  int16 ftb_portmode;
  int16 ft_portmode;
  int16 qt_portmode;
  int16 pms_portmode;


  // CRI_TSC_CTRL:
  int16 tsc_enable;
  int16 num_clks_l;
  int32 num_clks;
  int16 num_ts;

  // CRI_TSC_STATUS:
  int32 curr_clk;
  int32 curr_ts;

  // CRI_TX_SLOTC:
  // No fields defined, this register is
  // just a window into 0,1,2,3

  // CRI_TX_SLOT[0:3]:
  int16 tx_dsp_ts[MAX_NUM_PORTS];
  int16 tx_par_ts[MAX_NUM_PORTS];
  int16 tx_ifft_ts[MAX_NUM_PORTS];
  int16 tx_qt_ts[MAX_NUM_PORTS];
  int16 tx_pms_ts[MAX_NUM_PORTS];
  int16 tx_qtp_ts[MAX_NUM_PORTS];



  // CRI_RX_SLOTC:
  // No fields defined, this register is
  // just a window into 0,1,2,3

  // CRI_RX_SLOT[0:3]
  int16 rx_dsp_ts[MAX_NUM_PORTS];
  int16 rx_fft_ts[MAX_NUM_PORTS];
  int16 rx_qt_ts[MAX_NUM_PORTS];
  int16 rx_pms_ts[MAX_NUM_PORTS];
  int16 rx_qtp_ts[MAX_NUM_PORTS];

  // CRI_TX_ATSLOTC:
  // No fields defined, this register is
  // just a window into 0,1,2,3

  // CRI_TX_ATSLOT0:
  int16 tx_dsp_ats_0;

  // CRI_TX_ATSLOT1:
  int16 tx_dsp_ats_1;

  // CRI_TX_ATSLOT2:
  int16 tx_dsp_ats_2;

  // CRI_TX_ATSLOT3:
  int16 tx_dsp_ats_3;

  // CRI_RX_ATSLOTC:
  // No fields defined, this register is
  // just a window into 0,1,2,3

  // CRI_RX_ATSLOT0:
  int16 rx_dsp_ats_0;

  // CRI_RX_ATSLOT1:
  int16 rx_dsp_ats_1;

  // CRI_RX_ATSLOT2:
  int16 rx_dsp_ats_2;

  // CRI_RX_ATSLOT3:
  int16 rx_dsp_ats_3;

  //NTR
  int16 ntr_cpe_ena;
  int16 ntr_port_sel;
  int16 ntr_source_sel;
  int16 ntr_phase_sel;
  int16 ntrcnt;
  int32 ntrsrcfr;
  int32 ntrphase;


} CRIReg_g;

// replicated per port
typedef struct {


  // CRI_RXGP0_CTL:
  int16 rxgp0_int_rep;
  int16 rxgp0_cnt_trig;
  int16 rxgp0_cnt_ena;

  // CRI_RXGP1_CTL:
  int16 rxgp1_int_rep;
  int16 rxgp1_cnt_trig;
  int16 rxgp1_cnt_ena;

  // CRI_TXGP0_CTL:
  int16 txgp0_int_rep;
  int16 txgp0_cnt_trig;
  int16 txgp0_cnt_ena;

  // CRI_TXGP1_CTL:
  int16 txgp1_int_rep;
  int16 txgp1_cnt_trig;
  int16 txgp1_cnt_ena;

  // CRI_RXGP0_VAL:
  int32 rxgp0_val;

  // CRI_RXGP1_VAL:
  int32 rxgp1_val;

  // CRI_TXGP0_MCNT:
  int32 txgp0_mcnt;

  // CRI_TXGP1_MCNT:
  int32 txgp1_mcnt;

  // CRI_MASK0_TX:
  int16 mask0_gpio_tx_int1;
  int16 mask0_gpio_tx_int0;
  int16 mask0_pms_tx_done;
  int16 mask0_qt_tx_done;
  int16 mask0_qtp_tx_done;
  int16 mask0_ft_ifft_done;
  int16 mask0_ft_parr_done;
  int16 mask0_ftb_tx_frame;
  int16 mask0_cri_tx_timer;
  int16 mask0_tsc_tx_int;
  int16 mask0_qt_tx_bat_err;
  int16 mask0_pms_tx_stall;
  int16 mask0_qt_tx_go;

  // CRI_MASK0_RX:
  int16 mask0_gpio_rx_int1;
  int16 mask0_gpio_rx_int0;
  int16 mask0_ftb_rx_frame;
  int16 mask0_ft_fft_done;
  int16 mask0_qtp_rx_done;
  int16 mask0_qt_rx_done;
  int16 mask0_pms_rx_done;
  int16 mask0_cri_rx_timer;
  int16 mask0_tsc_rx_int;
  int16 mask0_tc_mlbx1_int;
  int16 mask0_tc_mlbx0_int;
  int16 mask0_fc_ntr_int;
  int16 mask0_qt_rx_bat_err;
  int16 mask0_qt_rx_go;
  int16 mask0_tc_bc0_busy_fall;
  int16 mask0_tc_bc0_busy_rise;
  int16 mask0_tc_bc1_busy_fall;
  int16 mask0_tc_bc1_busy_rise;
  int16 mask0_fci_gpflag;
  int16 mask0_ntr_ibits_avail;
  int16 mask0_vfdf_dec_done;

  // CRI_MASK1_TX:
  int16 mask1_gpio_tx_int1;
  int16 mask1_gpio_tx_int0;
  int16 mask1_pms_tx_done;
  int16 mask1_qt_tx_done;
  int16 mask1_qtp_tx_done;
  int16 mask1_ft_ifft_done;
  int16 mask1_ft_parr_done;
  int16 mask1_ftb_tx_frame;
  int16 mask1_cri_tx_timer;
  int16 mask1_tsc_tx_int;
  int16 mask1_qt_tx_bat_err;
  int16 mask1_pms_tx_stall;
  int16 mask1_qt_tx_go;

  // CRI_MASK1_RX:
  int16 mask1_gpio_rx_int1;
  int16 mask1_gpio_rx_int0;
  int16 mask1_ftb_rx_frame;
  int16 mask1_ft_fft_done;
  int16 mask1_qtp_rx_done;
  int16 mask1_qt_rx_done;
  int16 mask1_pms_rx_done;
  int16 mask1_cri_rx_timer;
  int16 mask1_tsc_rx_int;
  int16 mask1_tc_mlbx1_int;
  int16 mask1_tc_mlbx0_int;
  int16 mask1_fc_ntr_int;
  int16 mask1_qt_rx_bat_err;
  int16 mask1_qt_rx_go;
  int16 mask1_tc_bc0_busy_fall;
  int16 mask1_tc_bc0_busy_rise;
  int16 mask1_tc_bc1_busy_fall;
  int16 mask1_tc_bc1_busy_rise;
  int16 mask1_fci_gpflag;
  int16 mask1_ntr_ibits_avail;
  int16 mask1_vfdf_dec_done;

  // CRI_STATUS0:
  int16 status0_gpio_rx_int1;
  int16 status0_gpio_rx_int0;
  int16 status0_gpio_tx_int1;
  int16 status0_gpio_tx_int0;
  int16 status0_fci_gpflag;
  int16 status0_ntr_ibits_avail;
  int16 status0_pms_tx_done;
  int16 status0_qt_tx_done;
  int16 status0_qtp_tx_done;
  int16 status0_ft_ifft_done;
  int16 status0_ft_parr_done;
  int16 status0_ftb_tx_frame;
  int16 status0_cri_tx_timer;
  int16 status0_tsc_tx_int;
  int16 status0_ftb_rx_frame;
  int16 status0_ft_fft_done;
  int16 status0_qtp_rx_done;
  int16 status0_qt_rx_done;
  int16 status0_pms_rx_done;
  int16 status0_cri_rx_timer;
  int16 status0_tsc_rx_int;
  int16 status0_tc_mlbx1_int;
  int16 status0_tc_mlbx0_int;
  int16 status0_qt_rx_go;
  int16 status0_qt_tx_go;
  int16 status0_fc_ntr_int;
  int16 status0_qt_tx_bat_err;
  int16 status0_qt_rx_bat_err;
  int16 status0_pms_tx_stall;
  int16 status0_tc_bc0_busy_fall;
  int16 status0_tc_bc0_busy_rise;
  int16 status0_tc_bc1_busy_fall;
  int16 status0_tc_bc1_busy_rise;
  int16 status0_vfdf_dec_done;


  // CRI_STATUS1:
  int16 status1_gpio_rx_int1;
  int16 status1_gpio_rx_int0;
  int16 status1_gpio_tx_int1;
  int16 status1_gpio_tx_int0;
  int16 status1_fci_gpflag;
  int16 status1_ntr_ibits_avail;
  int16 status1_pms_tx_done;
  int16 status1_qt_tx_done;
  int16 status1_qtp_tx_done;
  int16 status1_ft_ifft_done;
  int16 status1_ft_parr_done;
  int16 status1_ftb_tx_frame;
  int16 status1_cri_tx_timer;
  int16 status1_tsc_tx_int;
  int16 status1_ftb_rx_frame;
  int16 status1_ft_fft_done;
  int16 status1_qtp_rx_done;
  int16 status1_qt_rx_done;
  int16 status1_pms_rx_done;
  int16 status1_cri_rx_timer;
  int16 status1_tsc_rx_int;
  int16 status1_tc_mlbx1_int;
  int16 status1_tc_mlbx0_int;
  int16 status1_qt_rx_go;
  int16 status1_qt_tx_go;
  int16 status1_fc_ntr_int;
  int16 status1_qt_tx_bat_err;
  int16 status1_qt_rx_bat_err;
  int16 status1_pms_tx_stall;
  int16 status1_tc_bc0_busy_fall;
  int16 status1_tc_bc0_busy_rise;
  int16 status1_tc_bc1_busy_fall;
  int16 status1_tc_bc1_busy_rise;
  int16 status1_vfdf_dec_done;

  // CRI_AMASK0_TX:
  int16 amask0_gpio_tx_int1;
  int16 amask0_gpio_tx_int0;
  int16 amask0_pms_tx_done;
  int16 amask0_qt_tx_done;
  int16 amask0_qtp_tx_done;
  int16 amask0_ft_ifft_done;
  int16 amask0_ft_parr_done;
  int16 amask0_ftb_tx_frame;
  int16 amask0_cri_tx_timer;
  int16 amask0_tsc_tx_int;
  int16 amask0_qt_tx_bat_err;
  int16 amask0_pms_tx_stall;
  int16 amask0_qt_tx_go;

  // CRI_AMASK0_RX:
  int16 amask0_gpio_rx_int1;
  int16 amask0_gpio_rx_int0;
  int16 amask0_ftb_rx_frame;
  int16 amask0_ft_fft_done;
  int16 amask0_qtp_rx_done;
  int16 amask0_qt_rx_done;
  int16 amask0_pms_rx_done;
  int16 amask0_cri_rx_timer;
  int16 amask0_tsc_rx_int;
  int16 amask0_tc_mlbx1_int;
  int16 amask0_tc_mlbx0_int;
  int16 amask0_fc_ntr_int;
  int16 amask0_qt_rx_go;
  int16 amask0_qt_rx_bat_err;
  int16 amask0_tc_bc0_busy_fall;
  int16 amask0_tc_bc0_busy_rise;
  int16 amask0_tc_bc1_busy_fall;
  int16 amask0_tc_bc1_busy_rise;
  int16 amask0_fci_gpflag;
  int16 amask0_ntr_ibits_avail;
  int16 amask0_vfdf_dec_done;

  // CRI_AMASK1_TX:
  int16 amask1_gpio_tx_int1;
  int16 amask1_gpio_tx_int0;
  int16 amask1_pms_tx_done;
  int16 amask1_qt_tx_done;
  int16 amask1_qtp_tx_done;
  int16 amask1_ft_ifft_done;
  int16 amask1_ft_parr_done;
  int16 amask1_ftb_tx_frame;
  int16 amask1_cri_tx_timer;
  int16 amask1_tsc_tx_int;
  int16 amask1_qt_tx_bat_err;
  int16 amask1_pms_tx_stall;
  int16 amask1_qt_tx_go;

  // CRI_AMASK1_RX:
  int16 amask1_gpio_rx_int1;
  int16 amask1_gpio_rx_int0;
  int16 amask1_ftb_rx_frame;
  int16 amask1_ft_fft_done;
  int16 amask1_qtp_rx_done;
  int16 amask1_qt_rx_done;
  int16 amask1_pms_rx_done;
  int16 amask1_cri_rx_timer;
  int16 amask1_tsc_rx_int;
  int16 amask1_tc_mlbx1_int;
  int16 amask1_tc_mlbx0_int;
  int16 amask1_qt_rx_go;
  int16 amask1_fc_ntr_int;
  int16 amask1_qt_rx_bat_err;
  int16 amask1_tc_bc0_busy_fall;
  int16 amask1_tc_bc0_busy_rise;
  int16 amask1_tc_bc1_busy_fall;
  int16 amask1_tc_bc1_busy_rise;
  int16 amask1_fci_gpflag;
  int16 amask1_ntr_ibits_avail;
  int16 amask1_vfdf_dec_done;

  // CRI_UPDCTL:
  int16 dis_rxtsc_upd;
  int16 frc_rxtsc_upd;
  int16 dis_txtsc_upd;
  int16 frc_txtsc_upd;
  int16 mask1_tx_upd;
  int16 mask0_tx_upd;
  int16 mask1_rx_upd;
  int16 mask0_rx_upd;

  // CRI_EVENT:
  int16 gpio_rx_int1;
  int16 gpio_rx_int0;
  int16 gpio_tx_int1;
  int16 gpio_tx_int0;
  int16 fci_gpflag;
  int16 ntr_ibits_avail;
  int16 pms_tx_done;
  int16 qt_tx_done;
  int16 qtp_tx_done;
  int16 ft_ifft_done;
  int16 ft_parr_done;
  int16 ftb_tx_frame;
  int16 cri_tx_timer;
  int16 tsc_tx_int;
  int16 ftb_rx_frame;
  int16 ft_fft_done;
  int16 qtp_rx_done;
  int16 qt_rx_done;
  int16 pms_rx_done;
  int16 cri_rx_timer;
  int16 tsc_rx_int;
  int16 tc_mlbx1_int;
  int16 tc_mlbx0_int;
  int16 qt_rx_go;
  int16 qt_tx_go;
  int16 fc_ntr_int;
  int16 qt_tx_bat_err;
  int16 qt_rx_bat_err;
  int16 tc_bc0_busy_fall;
  int16 tc_bc0_busy_rise;
  int16 tc_bc1_busy_fall;
  int16 tc_bc1_busy_rise;
  int16 pms_tx_stall;
  int16 vfdf_dec_done;

  // CRI_TX_TIMER:
  int32 tx_tim_cnt;

  // CRI_TX_TIMER_CTL:
  int16 tx_tim_start_ctl;
  int16 tx_tim_rlvr;
  int16 tx_tim_enb;
  uint32 tx_irpt_cnt;

  // CRI_RX_TIMER:
  int32 rx_tim_cnt;

  // CRI_RX_TIMER_CTL:
  int16 rx_tim_start_ctl;
  int16 rx_tim_rlvr;
  int16 rx_tim_enb;
  uint32 rx_irpt_cnt;

  // CRI_TX_PMS_CTL:
  int16 tx_pms_start_sel;
  uint32 tx_pms_go_cnt;

  // CRI_TX_QTP_CTL:
  int16 tx_qtp_start_sel;
  uint32 tx_qtp_go_cnt;

  // CRI_TX_QT_CTL:
  int16 tx_qt_start_sel;
  uint32 tx_qt_go_cnt;

  // CRI_TX_IFFT_CTL:
  int16 tx_ifft_start_sel;
  uint32 tx_ifft_go_cnt;

  // CRI_TX_PARR_CTL:
  int16 tx_parr_start_sel;
  uint32 tx_parr_go_cnt;

  // CRI_RX_FFT_CTL:
  int16 rx_fft_start_sel;
  uint32 rx_fft_go_cnt;

  // CRI_RX_QT_CTL:
  int16 rx_qt_start_sel;
  uint32 rx_qt_go_cnt;

  // CRI_RX_QTP_CTL:
  int16 rx_qtp_start_sel;
  uint32 rx_qtp_go_cnt;

  // CRI_RX_PMS_CTL:
  int16 rx_pms_start_sel;
  uint32 rx_pms_go_cnt;

  // CRI_TX_QT_STALL:
  int16 tx_qt_stall_cnt;
  int16 tx_qt_start_drop;
  int16 tx_qt_stall_ena;
  int16 tx_qt_stall_clks;

  // CRI_RX_QT_STALL:
  int16 rx_qt_stall_cnt;
  int16 rx_qt_start_drop;
  int16 rx_qt_stall_ena;
  int16 rx_qt_stall_clks;

  // CRI_RX_FFT_STALL_CTL:
  int16 rx_fft_done_sel;
  uint32 rx_fft_done_cnt;

  //NTR CO
  int16 ntr_co_ena;
  int16 ltr_ntr_freq_ratio;
  int16 ntr_co_capture_source;
  int32 ntr_perp_num;
  int32 ntr_perp_denom;

  // CRI_FCIMASK2_TX:
  int16 fcimask2_gpio_tx_int1;
  int16 fcimask2_gpio_tx_int0;
  int16 fcimask2_pms_tx_done;
  int16 fcimask2_qt_tx_done;
  int16 fcimask2_qtp_tx_done;
  int16 fcimask2_ft_ifft_done;
  int16 fcimask2_ft_parr_done;
  int16 fcimask2_ftb_tx_frame;
  int16 fcimask2_cri_tx_timer;
  int16 fcimask2_tsc_tx_int;
  int16 fcimask2_qt_tx_bat_err;
  int16 fcimask2_pms_tx_stall;
  int16 fcimask2_qt_tx_go;

  // CRI_FCIMASK2_RX:
  int16 fcimask2_gpio_rx_int1;
  int16 fcimask2_gpio_rx_int0;
  int16 fcimask2_ftb_rx_frame;
  int16 fcimask2_ft_fft_done;
  int16 fcimask2_qtp_rx_done;
  int16 fcimask2_qt_rx_done;
  int16 fcimask2_pms_rx_done;
  int16 fcimask2_cri_rx_timer;
  int16 fcimask2_tsc_rx_int;
  int16 fcimask2_tc_mlbx1_int;
  int16 fcimask2_tc_mlbx0_int;
  int16 fcimask2_fc_ntr_int;
  int16 fcimask2_qt_rx_bat_err;
  int16 fcimask2_qt_rx_go;
  int16 fcimask2_tc_bc0_busy_fall;
  int16 fcimask2_tc_bc0_busy_rise;
  int16 fcimask2_tc_bc1_busy_fall;
  int16 fcimask2_tc_bc1_busy_rise;
  int16 fcimask2_fci_gpflag;
  int16 fcimask2_ntr_ibits_avail;
  int16 fcimask2_vfdf_dec_done;

  // CRI_FCIMASK3_TX:
  int16 fcimask3_gpio_tx_int1;
  int16 fcimask3_gpio_tx_int0;
  int16 fcimask3_pms_tx_done;
  int16 fcimask3_qt_tx_done;
  int16 fcimask3_qtp_tx_done;
  int16 fcimask3_ft_ifft_done;
  int16 fcimask3_ft_parr_done;
  int16 fcimask3_ftb_tx_frame;
  int16 fcimask3_cri_tx_timer;
  int16 fcimask3_tsc_tx_int;
  int16 fcimask3_qt_tx_bat_err;
  int16 fcimask3_pms_tx_stall;
  int16 fcimask3_qt_tx_go;

  // CRI_FCIMASK3_RX:
  int16 fcimask3_gpio_rx_int1;
  int16 fcimask3_gpio_rx_int0;
  int16 fcimask3_ftb_rx_frame;
  int16 fcimask3_ft_fft_done;
  int16 fcimask3_qtp_rx_done;
  int16 fcimask3_qt_rx_done;
  int16 fcimask3_pms_rx_done;
  int16 fcimask3_cri_rx_timer;
  int16 fcimask3_tsc_rx_int;
  int16 fcimask3_tc_mlbx1_int;
  int16 fcimask3_tc_mlbx0_int;
  int16 fcimask3_fc_ntr_int;
  int16 fcimask3_qt_rx_bat_err;
  int16 fcimask3_qt_rx_go;
  int16 fcimask3_tc_bc0_busy_fall;
  int16 fcimask3_tc_bc0_busy_rise;
  int16 fcimask3_tc_bc1_busy_fall;
  int16 fcimask3_tc_bc1_busy_rise;
  int16 fcimask3_fci_gpflag;
  int16 fcimask3_ntr_ibits_avail;
  int16 fcimask3_vfdf_dec_done;


  // CRI_FCISTATUS2:
  int16 fcistatus2_gpio_rx_int1;
  int16 fcistatus2_gpio_rx_int0;
  int16 fcistatus2_gpio_tx_int1;
  int16 fcistatus2_gpio_tx_int0;
  int16 fcistatus2_fci_gpflag;
  int16 fcistatus2_ntr_ibits_avail;
  int16 fcistatus2_pms_tx_done;
  int16 fcistatus2_qt_tx_done;
  int16 fcistatus2_qtp_tx_done;
  int16 fcistatus2_ft_ifft_done;
  int16 fcistatus2_ft_parr_done;
  int16 fcistatus2_ftb_tx_frame;
  int16 fcistatus2_cri_tx_timer;
  int16 fcistatus2_tsc_tx_int;
  int16 fcistatus2_ftb_rx_frame;
  int16 fcistatus2_ft_fft_done;
  int16 fcistatus2_qtp_rx_done;
  int16 fcistatus2_qt_rx_done;
  int16 fcistatus2_pms_rx_done;
  int16 fcistatus2_cri_rx_timer;
  int16 fcistatus2_tsc_rx_int;
  int16 fcistatus2_tc_mlbx1_int;
  int16 fcistatus2_tc_mlbx0_int;
  int16 fcistatus2_qt_rx_go;
  int16 fcistatus2_qt_tx_go;
  int16 fcistatus2_fc_ntr_int;
  int16 fcistatus2_qt_tx_bat_err;
  int16 fcistatus2_qt_rx_bat_err;
  int16 fcistatus2_pms_tx_stall;
  int16 fcistatus2_tc_bc0_busy_fall;
  int16 fcistatus2_tc_bc0_busy_rise;
  int16 fcistatus2_tc_bc1_busy_fall;
  int16 fcistatus2_tc_bc1_busy_rise;
  int16 fcistatus2_vfdf_dec_done;

  // CRI_FCISTATUS3:
  int16 fcistatus3_gpio_rx_int1;
  int16 fcistatus3_gpio_rx_int0;
  int16 fcistatus3_gpio_tx_int1;
  int16 fcistatus3_gpio_tx_int0;
  int16 fcistatus3_fci_gpflag;
  int16 fcistatus3_ntr_ibits_avail;
  int16 fcistatus3_pms_tx_done;
  int16 fcistatus3_qt_tx_done;
  int16 fcistatus3_qtp_tx_done;
  int16 fcistatus3_ft_ifft_done;
  int16 fcistatus3_ft_parr_done;
  int16 fcistatus3_ftb_tx_frame;
  int16 fcistatus3_cri_tx_timer;
  int16 fcistatus3_tsc_tx_int;
  int16 fcistatus3_ftb_rx_frame;
  int16 fcistatus3_ft_fft_done;
  int16 fcistatus3_qtp_rx_done;
  int16 fcistatus3_qt_rx_done;
  int16 fcistatus3_pms_rx_done;
  int16 fcistatus3_cri_rx_timer;
  int16 fcistatus3_tsc_rx_int;
  int16 fcistatus3_tc_mlbx1_int;
  int16 fcistatus3_tc_mlbx0_int;
  int16 fcistatus3_qt_rx_go;
  int16 fcistatus3_qt_tx_go;
  int16 fcistatus3_fc_ntr_int;
  int16 fcistatus3_qt_tx_bat_err;
  int16 fcistatus3_qt_rx_bat_err;
  int16 fcistatus3_pms_tx_stall;
  int16 fcistatus3_tc_bc0_busy_fall;
  int16 fcistatus3_tc_bc0_busy_rise;
  int16 fcistatus3_tc_bc1_busy_fall;
  int16 fcistatus3_tc_bc1_busy_rise;
  int16 fcistatus3_vfdf_dec_done;

} CRIReg_t;




#endif // _CRI_TYPEDEF_H

//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// Modification History:
//
//   $Log: cri_typedef.h $
//   Revision 1.3  2009/04/02 19:46:40Z  wwu
//   (04/02/09 Wei Wu)
//
//   Highlights:
//   -----------
//   1) Updated CRI BM with ASIC group's latest version and spec.
//   1.1) FCI status registers and NTR registers have been added to the CRI spec. Relevant CRI BM files
//   are modified to reflect the change.
//   1.2) A new function CRI_FFT_STALL_DONE() is added. In ASIC testing environment, a TLM function will
//   be called. In COCOMO, however, we should call the FTB BM function instead.
//   1.3) Add compiler definition NO_TLM for CRI_BM project.
//
//   [cri.pj]
//   ----------------------------------
//   Bm_6.2\cri_6.2\build\Model\cri.dsp (1)
//   Bm_6.2\cri_6.2\source\Model\cri.c (1)
//   Bm_6.2\cri_6.2\source\Model\cri_init.c (1)
//   Bm_6.2\cri_6.2\source\Model\cri_io.c (1)
//   Bm_6.2\cri_6.2\source\Model\include\cri_memmap.h (1)
//   Bm_6.2\cri_6.2\source\Model\include\cri_typedef.h (1)
//   Revision 1.22  2009-03-27 12:27:29-04  kelliher
//   added ntr_ibits_avail
//
//   Revision 1.21  2009-03-23 18:02:16-04  astone
//   Tx, Rx Timer start control bit added.
//
//   Revision 1.20  2009-02-18 16:58:49-05  kelliher
//   connected up qt_*x_go
//
//   Revision 1.19  2009-02-12 15:06:42-05  kelliher
//   Added FCI IRQ registers
//
//   Revision 1.18  2009-02-09 15:17:36-05  kelliher
//   Made tc_bc_busy 2 bits wide
//
//   Revision 1.17  2009-02-03 18:12:38-05  kelliher
//   updated masks w/ tc irq and qt stall irq.
//
//   Revision 1.16  2009-02-02 16:48:37-05  kelliher
//   added ntr co registers
//
//   Revision 1.15  2009-01-29 15:29:58-05  kelliher
//   added tc_mlbx_irqs
//
//   Revision 1.14  2009-01-26 12:45:16-05  kelliher
//   added NTR cpe register
//
//   Revision 1.13  2008-10-28 17:46:02-04  kelliher
//   added tc_x_init
//
//   Revision 1.12  2008-10-17 10:02:33-04  jgross
//   Add functions useful for firmware core-exec
//
//   Revision 1.11  2008-06-18 10:36:11-04  astone
//   CRI_TSC_CONFIG eliminated.
//
//   Revision 1.10  2008-06-13 13:27:53-04  astone
//   Support for 2 time slots per core in 1 port mode.
//
//   Revision 1.9  2008-05-21 18:18:24-04  astone
//   TSC Config updates
//
//   Revision 1.8  2008-04-17 14:36:30-04  astone
//   Functionality for CRI_STATUS registers
//
//   Revision 1.7  2008-04-16 16:57:15-04  astone
//   Add functionality for CRI_EVENT register
//
//   Revision 1.6  2008-04-09 17:55:00-04  astone
//   Populate CRI_TXGP* and CRI_RXGP* fields to satisfy register test.
//
//   Revision 1.5  2008-03-24 16:34:55-04  astone
//   Use array type for timeslot assignments
//
//   Revision 1.4  2008-03-21 16:22:06-04  astone
//   Populate CRI_TX_QT_STALL and CRI_RX_QT_STALL
//
//   Revision 1.3  2008-03-20 14:05:23-04  astone
//   Populate CRI_TX_QTP_CTL and CRI_RX_QTP_CTL
//
//   Revision 1.2  2008-03-19 16:19:16-04  astone
//   Populate remaining register fields.
//
//   Revision 1.1  2008-03-13 14:25:28-04  astone
//   Initial Revision
//
//
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
