/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: zep_ilv_const.h
*
*   This file contains constant definitions for the ZEP_ILV BM
*
*-------------------------------------------------------------------------------
*/

#ifndef _ZEP_ILV_CONST_H
#define _ZEP_ILV_CONST_H

#ifndef TRUE
#define TRUE         (1)
#endif // TRUE

#ifndef FALSE
#define FALSE        (0)
#endif // FALSE

#ifndef BYTE0_EN
#define NO_BYTE_EN      (0x0)
#define BYTE0_EN     (0x1)
#define BYTE1_EN     (0x2)
#define BYTE2_EN     (0x4)
#define BYTE3_EN     (0x8)
#define LOWER_WORD_EN   (BYTE1_EN | BYTE0_EN)
#define UPPER_WORD_EN   (BYTE3_EN | BYTE2_EN)
#define LONGWORD_EN     (UPPER_WORD_EN | LOWER_WORD_EN)
#endif // BYTE0_EN

#define ZEP_ILV_NUM_LP           (2)

#define ZEP_ILV_LP0              (0)
#define ZEP_ILV_LP1              (1)
#define ZEP_ILV_LP_DISABLED         (0xF)

#define ZEP_ILV_SHALF_DISABLED      (0)
#define ZEP_ILV_SHALF_FIRST_CW      (1)
#define ZEP_ILV_SHALF_SECOND_CW     (2)

#define DATA_TRANSFER_IDLE       (0)
#define DATA_TRANSFER_CHECK_DCID (1)
#define DATA_TRANSFER_READY      (2)
#define DATA_TRANSFER_ON         (3)
#define DATA_TRANSFER_AVAIL      (4)
#define DATA_TRANSFER_WAIT       (5)
#define DATA_TRANSFER_OFF        (6)
#define DATA_TRANSFER_END        (7)

#define DATA_TRANSFER_WAIT_CNT      (10)

#endif //_ZEP_ILV_CONST_H
