/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: zep_ilv_memmap.h
*
*   This file contains ZEP_ILV BM memory map.
*
*-------------------------------------------------------------------------------
*/

#ifndef _ZEP_ILV_MEMMAP_H
#define _ZEP_ILV_MEMMAP_H

// Zephyr-ILV RAM
#define ZEP_ILV_RAM_ILVB_ADDR          (uint32)(0x400000) // TX Interleave/Deinterleave Buffer (byte access)
#define ZEP_ILV_RAM_TXDTB_ADDR            (uint32)(0x114000) // TX Data Transfer Buffer (byte access)
#define ZEP_ILV_RAM_RXDTB_ADDR            (uint32)(0x130000) // RX Data Transfer Buffer (byte access)
#define ZEP_ILV_RAM_DMET_ADDR               (uint32)(0x13B800) // RX Deinterleave Metric RAM (byte access)
#define ZEP_ILV_NUM_RAM_BLOCKS            (4)

// sizes are in bytes
// sizes are defined for 2-port mode
#define ZEP_ILV_RAM_ILVB_SIZE          (4*16896)
#define ZEP_ILV_RAM_TXDTB_SIZE            (4*1520)
#define ZEP_ILV_RAM_RXDTB_SIZE            (4*800)
#define ZEP_ILV_RAM_DMET_SIZE               (4*512)

// Zephyr-ILV TX registers
#define ZEP_ILV_TXPRAM_BASE_ADDR            (uint32)(0x1A3200)

#define ZIT_CONFIG0_ADDR               (uint32)(ZEP_ILV_TXPRAM_BASE_ADDR+0x00)
#define ZIT_DEPTH0_ADDR                (uint32)(ZEP_ILV_TXPRAM_BASE_ADDR+0x04)
#define ZIT_ILV_BASE_LP0_ADDR               (uint32)(ZEP_ILV_TXPRAM_BASE_ADDR+0x08)
#define ZIT_IBLK_BASE_LP0_ADDR              (uint32)(ZEP_ILV_TXPRAM_BASE_ADDR+0x0C)
#define ZIT_ILV_LIMIT_LP0_ADDR              (uint32)(ZEP_ILV_TXPRAM_BASE_ADDR+0x10)
#define ZIT_FIFO_CTL_LP0_ADDR               (uint32)(ZEP_ILV_TXPRAM_BASE_ADDR+0x14)
#define ZIT_DCID_CTRL1_LP0_ADDR             (uint32)(ZEP_ILV_TXPRAM_BASE_ADDR+0x18)
#define ZIT_DCID_CTRL2_LP0_ADDR             (uint32)(ZEP_ILV_TXPRAM_BASE_ADDR+0x1C)
#define ZIT_IBLK_TRANS_CNT0_ADDR            (uint32)(ZEP_ILV_TXPRAM_BASE_ADDR+0x20)
#define ZIT_PMD_FIFO_DELAY0_ADDR            (uint32)(ZEP_ILV_TXPRAM_BASE_ADDR+0x24)
#define ZIT_DMAX_FIFO_DELAY_NUM0_ADDR       (uint32)(ZEP_ILV_TXPRAM_BASE_ADDR+0x28)
#define ZIT_PMD_D_LOWER_FIFO_DELAY_NUM0_ADDR (uint32)(ZEP_ILV_TXPRAM_BASE_ADDR+0x2C)
#define ZIT_PMS_COUNTER1_LP0_ADDR           (uint32)(ZEP_ILV_TXPRAM_BASE_ADDR+0x30)
#define ZIT_PMS_COUNTER2_LP0_ADDR           (uint32)(ZEP_ILV_TXPRAM_BASE_ADDR+0x34)
#define ZIT_PMS_COUNTER3_LP0_ADDR           (uint32)(ZEP_ILV_TXPRAM_BASE_ADDR+0x38)
#define ZIT_PMD_COUNTER1_LP0_ADDR           (uint32)(ZEP_ILV_TXPRAM_BASE_ADDR+0x3C)
#define ZIT_PMD_COUNTER2_LP0_ADDR           (uint32)(ZEP_ILV_TXPRAM_BASE_ADDR+0x40)
#define ZIT_PMD_COUNTER3_LP0_ADDR           (uint32)(ZEP_ILV_TXPRAM_BASE_ADDR+0x44)
#define ZIT_CONFIG1_ADDR               (uint32)(ZEP_ILV_TXPRAM_BASE_ADDR+0x48)
#define ZIT_DEPTH1_ADDR                (uint32)(ZEP_ILV_TXPRAM_BASE_ADDR+0x4C)
#define ZIT_ILV_BASE_LP1_ADDR               (uint32)(ZEP_ILV_TXPRAM_BASE_ADDR+0x50)
#define ZIT_IBLK_BASE_LP1_ADDR              (uint32)(ZEP_ILV_TXPRAM_BASE_ADDR+0x54)
#define ZIT_ILV_LIMIT_LP1_ADDR              (uint32)(ZEP_ILV_TXPRAM_BASE_ADDR+0x58)
#define ZIT_FIFO_CTL_LP1_ADDR               (uint32)(ZEP_ILV_TXPRAM_BASE_ADDR+0x5C)
#define ZIT_DCID_CTRL1_LP1_ADDR             (uint32)(ZEP_ILV_TXPRAM_BASE_ADDR+0x60)
#define ZIT_DCID_CTRL2_LP1_ADDR             (uint32)(ZEP_ILV_TXPRAM_BASE_ADDR+0x64)
#define ZIT_IBLK_TRANS_CNT1_ADDR            (uint32)(ZEP_ILV_TXPRAM_BASE_ADDR+0x68)
#define ZIT_PMD_FIFO_DELAY1_ADDR            (uint32)(ZEP_ILV_TXPRAM_BASE_ADDR+0x6C)
#define ZIT_DMAX_FIFO_DELAY_NUM1_ADDR       (uint32)(ZEP_ILV_TXPRAM_BASE_ADDR+0x70)
#define ZIT_PMD_D_LOWER_FIFO_DELAY_NUM1_ADDR (uint32)(ZEP_ILV_TXPRAM_BASE_ADDR+0x74)
#define ZIT_PMS_COUNTER1_LP1_ADDR           (uint32)(ZEP_ILV_TXPRAM_BASE_ADDR+0x78)
#define ZIT_PMS_COUNTER2_LP1_ADDR           (uint32)(ZEP_ILV_TXPRAM_BASE_ADDR+0x7C)
#define ZIT_PMS_COUNTER3_LP1_ADDR           (uint32)(ZEP_ILV_TXPRAM_BASE_ADDR+0x80)
#define ZIT_PMD_COUNTER1_LP1_ADDR           (uint32)(ZEP_ILV_TXPRAM_BASE_ADDR+0x84)
#define ZIT_PMD_COUNTER2_LP1_ADDR           (uint32)(ZEP_ILV_TXPRAM_BASE_ADDR+0x88)
#define ZIT_PMD_COUNTER3_LP1_ADDR           (uint32)(ZEP_ILV_TXPRAM_BASE_ADDR+0x8C)

// Zephyr-ILV RX registers
#define ZEP_ILV_RXPRAM_BASE_ADDR            (uint32)(0x1A3600)

#define ZIR_CONFIG0_ADDR               (uint32)(ZEP_ILV_RXPRAM_BASE_ADDR+0x00)
#define ZIR_DEPTH0_ADDR                (uint32)(ZEP_ILV_RXPRAM_BASE_ADDR+0x04)
#define ZIR_ILV_BASE_LP0_ADDR               (uint32)(ZEP_ILV_RXPRAM_BASE_ADDR+0x08)
#define ZIR_IBLK_BASE_LP0_ADDR              (uint32)(ZEP_ILV_RXPRAM_BASE_ADDR+0x0C)
#define ZIR_ILV_LIMIT_LP0_ADDR              (uint32)(ZEP_ILV_RXPRAM_BASE_ADDR+0x10)
#define ZIR_FIFO_CTL_LP0_ADDR               (uint32)(ZEP_ILV_RXPRAM_BASE_ADDR+0x14)
#define ZIR_DCID_CTRL1_LP0_ADDR             (uint32)(ZEP_ILV_RXPRAM_BASE_ADDR+0x18)
#define ZIR_DCID_CTRL2_LP0_ADDR             (uint32)(ZEP_ILV_RXPRAM_BASE_ADDR+0x1C)
#define ZIR_IBLK_TRANS_CNT0_ADDR            (uint32)(ZEP_ILV_RXPRAM_BASE_ADDR+0x20)
#define ZIR_DL_REL0_ADDR                    (uint32)(ZEP_ILV_RXPRAM_BASE_ADDR+0x24)
#define ZIR_NL_REL0_ADDR                    (uint32)(ZEP_ILV_RXPRAM_BASE_ADDR+0x28)
#define ZIR_DMETRIC0_ADDR                   (uint32)(ZEP_ILV_RXPRAM_BASE_ADDR+0x2C)
#define ZIR_CONTROL0_ADDR                   (uint32)(ZEP_ILV_RXPRAM_BASE_ADDR+0x30)
#define ZIR_PMD_FIFO_DELAY0_ADDR            (uint32)(ZEP_ILV_RXPRAM_BASE_ADDR+0x34)
#define ZIR_DMAX_FIFO_DELAY_NUM0_ADDR       (uint32)(ZEP_ILV_RXPRAM_BASE_ADDR+0x38)
#define ZIR_PMD_D_LOWER_FIFO_DELAY_NUM0_ADDR (uint32)(ZEP_ILV_RXPRAM_BASE_ADDR+0x3C)
#define ZIR_PMS_COUNTER1_LP0_ADDR           (uint32)(ZEP_ILV_RXPRAM_BASE_ADDR+0x40)
#define ZIR_PMS_COUNTER2_LP0_ADDR           (uint32)(ZEP_ILV_RXPRAM_BASE_ADDR+0x44)
#define ZIR_PMS_COUNTER3_LP0_ADDR           (uint32)(ZEP_ILV_RXPRAM_BASE_ADDR+0x48)
#define ZIR_PMD_COUNTER1_LP0_ADDR           (uint32)(ZEP_ILV_RXPRAM_BASE_ADDR+0x4C)
#define ZIR_PMD_COUNTER2_LP0_ADDR           (uint32)(ZEP_ILV_RXPRAM_BASE_ADDR+0x50)
#define ZIR_PMD_COUNTER3_LP0_ADDR           (uint32)(ZEP_ILV_RXPRAM_BASE_ADDR+0x54)
#define ZIR_DMETRIC_CTRL_ADDR               (uint32)(ZEP_ILV_RXPRAM_BASE_ADDR+0x58)
#define ZIR_CONFIG1_ADDR               (uint32)(ZEP_ILV_RXPRAM_BASE_ADDR+0x5C)
#define ZIR_DEPTH1_ADDR                (uint32)(ZEP_ILV_RXPRAM_BASE_ADDR+0x60)
#define ZIR_ILV_BASE_LP1_ADDR               (uint32)(ZEP_ILV_RXPRAM_BASE_ADDR+0x64)
#define ZIR_IBLK_BASE_LP1_ADDR              (uint32)(ZEP_ILV_RXPRAM_BASE_ADDR+0x68)
#define ZIR_ILV_LIMIT_LP1_ADDR              (uint32)(ZEP_ILV_RXPRAM_BASE_ADDR+0x6C)
#define ZIR_FIFO_CTL_LP1_ADDR               (uint32)(ZEP_ILV_RXPRAM_BASE_ADDR+0x70)
#define ZIR_DCID_CTRL1_LP1_ADDR             (uint32)(ZEP_ILV_RXPRAM_BASE_ADDR+0x74)
#define ZIR_DCID_CTRL2_LP1_ADDR             (uint32)(ZEP_ILV_RXPRAM_BASE_ADDR+0x78)
#define ZIR_IBLK_TRANS_CNT1_ADDR            (uint32)(ZEP_ILV_RXPRAM_BASE_ADDR+0x7C)
#define ZIR_DL_REL1_ADDR                    (uint32)(ZEP_ILV_RXPRAM_BASE_ADDR+0x80)
#define ZIR_NL_REL1_ADDR                    (uint32)(ZEP_ILV_RXPRAM_BASE_ADDR+0x84)
#define ZIR_DMETRIC1_ADDR                   (uint32)(ZEP_ILV_RXPRAM_BASE_ADDR+0x88)
#define ZIR_CONTROL1_ADDR                   (uint32)(ZEP_ILV_RXPRAM_BASE_ADDR+0x8C)
#define ZIR_PMD_FIFO_DELAY1_ADDR            (uint32)(ZEP_ILV_RXPRAM_BASE_ADDR+0x90)
#define ZIR_DMAX_FIFO_DELAY_NUM1_ADDR       (uint32)(ZEP_ILV_RXPRAM_BASE_ADDR+0x94)
#define ZIR_PMD_D_LOWER_FIFO_DELAY_NUM1_ADDR (uint32)(ZEP_ILV_RXPRAM_BASE_ADDR+0x98)
#define ZIR_PMS_COUNTER1_LP1_ADDR           (uint32)(ZEP_ILV_RXPRAM_BASE_ADDR+0x9C)
#define ZIR_PMS_COUNTER2_LP1_ADDR           (uint32)(ZEP_ILV_RXPRAM_BASE_ADDR+0xA0)
#define ZIR_PMS_COUNTER3_LP1_ADDR           (uint32)(ZEP_ILV_RXPRAM_BASE_ADDR+0xA4)
#define ZIR_PMD_COUNTER1_LP1_ADDR           (uint32)(ZEP_ILV_RXPRAM_BASE_ADDR+0xA8)
#define ZIR_PMD_COUNTER2_LP1_ADDR           (uint32)(ZEP_ILV_RXPRAM_BASE_ADDR+0xAC)
#define ZIR_PMD_COUNTER3_LP1_ADDR           (uint32)(ZEP_ILV_RXPRAM_BASE_ADDR+0xB0)


// Zephyr-ILV Global Registers
#define ZEP_ILV_REG_BASE_ADDR               (uint32)(0x7CE00)

#define ZIT_DT_SIZE_ADDR                    (uint32)(ZEP_ILV_REG_BASE_ADDR+0x00)
#define ZIT_DTB_CONFIG_ADDR                 (uint32)(ZEP_ILV_REG_BASE_ADDR+0x04)
#define ZIT_DTB_WR_START_ADDR               (uint32)(ZEP_ILV_REG_BASE_ADDR+0x08)
#define ZIR_DT_SIZE_ADDR                    (uint32)(ZEP_ILV_REG_BASE_ADDR+0x0C)
#define ZIR_DTB_CONFIG_ADDR                 (uint32)(ZEP_ILV_REG_BASE_ADDR+0x10)
#define ZIR_DTB_RD_START_ADDR               (uint32)(ZEP_ILV_REG_BASE_ADDR+0x14)
#define ZIR_QTSCORE_ADDR                    (uint32)(ZEP_ILV_REG_BASE_ADDR+0x18)


#define ZEP_ILV_TX_REG_BASE_ADDR       (ZEP_ILV_TXPRAM_BASE_ADDR)
#define ZEP_ILV_RX_REG_BASE_ADDR       (ZEP_ILV_RXPRAM_BASE_ADDR)
#define ZEP_ILV_GLOBAL_REG_BASE_ADDR        (ZIT_DT_SIZE_ADDR)
#define ZEP_ILV_NUM_TX_REGS               (ZIT_PMD_COUNTER3_LP1_ADDR-ZEP_ILV_TX_REG_BASE_ADDR+4)/4
#define ZEP_ILV_NUM_RX_REGS               (ZIR_PMD_COUNTER3_LP1_ADDR-ZEP_ILV_RX_REG_BASE_ADDR+4)/4
#define ZEP_ILV_NUM_GLOBAL_REGS             (ZIR_QTSCORE_ADDR-ZIT_DT_SIZE_ADDR+4)/4

// constants and masks
#define ZEP_ILV_ADSL_MODE        (0x00)
#define ZEP_ILV_VDSL1_MODE       (0x01)
#define ZEP_ILV_VDSL2_MODE       (0x02)

#define ZEP_ILV_QT_LAT_ENB0         (0x10000000)
#define ZEP_ILV_QT_LAT_ENB1         (0x20000000)

// Zephyr-ILV memory size
#define ZEP_ILV_RAM_ILVB_MASK          (uint32)(0xFFFFFFFF)
#define ZEP_ILV_RAM_DILVB_MASK            (uint32)(0xFFFFFFFF)
#define ZEP_ILV_RAM_TXDTB_MASK            (uint32)(0xFFFFFFFF)
#define ZEP_ILV_RAM_RXDTB_MASK            (uint32)(0xFFFFFFFF)
#define ZEP_ILV_RAM_IFB_MASK           (uint32)(0xFFFFFFFF)
#define ZEP_ILV_RAM_IFWP_MASK          (uint32)(0x00000FFF)
#define ZEP_ILV_RAM_IFRP_MASK          (uint32)(0x00000FFF)
#define ZEP_ILV_RAM_DFB_MASK           (uint32)(0xFFFFFFFF)
#define ZEP_ILV_RAM_DFWP_MASK          (uint32)(0x00000FFF)
#define ZEP_ILV_RAM_DFRP_MASK          (uint32)(0x00000FFF)
#define ZEP_ILV_RAM_IDCID_MASK            (uint32)(0x00000FFF)
#define ZEP_ILV_RAM_DDCID_MASK              (uint32)(0x00000FFF)
#define ZEP_ILV_RAM_DMET_MASK               (uint32)(0xFFFFFFFF)

// Zephyr-ILV TX registers masks
#define ZIT_CONFIG_MASK                (uint32)(0xFFFF0307)
#define ZIT_CW_SIZE_MASK               (uint32)(0xFFFFFFFF)
#define ZIT_ILVB_LEVEL_MASK               (uint32)(0xFFFFFFFF)
#define ZIT_LEVEL_OFFSET_MASK          (uint32)(0xFFFFFFFF)
#define ZIT_CUR_F_IDX_MASK             (uint32)(0xFFFFFFFF)
#define ZIT_DCID_LP0_MASK              (uint32)(0x00FF05FF)
#define ZIT_DCID_LP1_MASK              (uint32)(0x00FF05FF)
#define ZIT_PRE_FC_BYTES_MASK               (uint32)(0x1FFF1FFF)
#define ZIT_ILV_BASE_MASK              (uint32)(0x0001FFFF)

// Zephyr-ILV RX registers masks
#define ZIR_CONFIG_MASK                (uint32)(0xFFFF0037)
#define ZIR_CW_SIZE_MASK               (uint32)(0xFFFFFFFF)
#define ZIR_DILVB_LEVEL0_MASK          (uint32)(0x0001FFFF)
#define ZIR_DILVB_LEVEL1_MASK          (uint32)(0x0001FFFF)
#define ZIR_LEVEL_OFFSET_MASK          (uint32)(0xFFFFFFFF)
#define ZIR_DILVB_AVAIL_MASK           (uint32)(0xFFFFFFFF)
#define ZIR_CUR_F_IDX_MASK             (uint32)(0xFFFFFFFF)
#define ZIR_DCID_LP0_MASK              (uint32)(0x00FF05FF)
#define ZIR_DCID_LP1_MASK              (uint32)(0x00FF05FF)
#define ZIR_DL_REL0_MASK               (uint32)(0x03FFFFFF)
#define ZIR_DL_REL1_MASK               (uint32)(0x03FFFFFF)
#define ZIR_NL_REL0_MASK               (uint32)(0x03FF07FF)
#define ZIR_NL_REL1_MASK               (uint32)(0x03FF07FF)
#define ZIR_DMETRIC_MASK               (uint32)(0xFFFFFFFF)
#define ZIR_DM_CNT_MASK                (uint32)(0xFFFFFFFF)
#define ZIR_LP_BITS_MASK                    (uint32)(0xFFFFFFFF)
#define ZIR_PRE_FC_BYTES_MASK               (uint32)(0x1FFF1FFF)
#define ZIR_ILV_BASE_MASK                   (uint32)(0x0001FFFF)

//Zephyr-ILV Global registers masks
#define ZIT_DT_SIZE_MASK                    (uint32)(0x1FFF1FFF)
#define ZIT_DTB_CONFIG_MASK               (uint32)(0x37FF07FF)
#define ZIR_DT_SIZE_MASK                    (uint32)(0x1FFF1FFF)
#define ZIR_DTB_CONFIG_MASK               (uint32)(0x37FF07FF)
#define ZIR_QTSCORE_MASK                    (uint32)(0x000000FF)


#endif // _ZEP_ILV_MEMMAP_H
