/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: zep_ilv_private.h
*
*   This file contains private functions and variables which are visible
*   by the ZEP_ILV BM only.
*
*-------------------------------------------------------------------------------
*/

#ifndef _ZEP_ILV_PRIVATE_H
#define _ZEP_ILV_PRIVATE_H

// zep_ilv_io.c
void WriteToByteBuffer(uint8 *puc_addr, uint16 us_offset, uint32 ul_data, uint8 uc_ByteEnable);
void ReadFromByteBuffer(uint8 *puc_addr, uint16 us_offset, uint32 *pul_data);
void WriteToWordBuffer(uint16 *pus_addr, uint16 us_offset, uint32 ul_data, uint8 uc_ByteEnable);
void ReadFromWordBuffer(uint16 *pus_addr, uint16 us_offset, uint32 *pul_data);
uint32 ConvertToILVAddr(uint32 ul_addr, uint16 us_ilv_size,uint8 uc_port);
uint16 ZEP_ILV_Tx_Calc_Ptr(uint16 uc_I, uint8 uc_fifo, uint16 *pus_iover2_ptr,
                          uint16 us_len, uint16 us_Dmax_len, uint16 us_fifo_width,
                  uint16 us_gl_ptr);
uint16 ZEP_ILV_Rx_Calc_Ptr(uint16 uc_I, uint8 uc_fifo, uint16 *pus_iover2_ptr,
                          uint16 us_len, uint16 us_Dmax_len, uint16 us_fifo_width,
                  uint16 us_gl_ptr);
uint16 ZEP_ILV_Fifo_Delay(uint16 uc_I, uint16 us_D, uint8 uc_fifo);
uint16 ZEP_ILV_Find_Pmd_Step(uint16 s_D, uint16 s_I, uint8 uc_Rx_Eff_Dis);
uint16 ZEP_ILV_Tx_Fifo_Footprint(uint16 us_Tx_fifo_ext, uint16 us_Dmax_fifo_delay);
uint16 ZEP_ILV_Rx_Fifo_Footprint(uint16 us_Rx_fifo_ext, uint16 us_Dmax_fifo_delay, uint16 us_I, uint16 us_Dmax);

// zep_ilv_tx.c
void ZEP_ILV_Clock_Tx(ZEP_ILV_Input_t *pt_ILVInput, ZEP_ILV_Output_t *pt_ILVOutput);
int32 ZEP_ILV_TxDataTransfer(int16 s_lp);
int32 WriteByteToTxILVB(int16 s_lp, uint8 uc_byte);
int32 ReadByteFromTxILVB(int16 s_lp, uint8 *puc_byte);
void UpdateTxFifoWriteIdx(int16 s_lp);
void UpdateTxFifoReadIdx(int16 s_lp);
uint32 ConvertILVAddr(uint16 us_rd_addr, uint16 us_ilv_size);
void ZEP_ILV_Tx_Pms_Pointers(uint16 *us_pms_pointer, uint32 *ul_pms_base, int16 s_lp);
void ZEP_ILV_Tx_Pmd_Pointers(uint16 *us_pmd_pointer, uint32 *ul_pmd_base, uint8 *uc_is_dummy_byte, int16 s_lp);
void ZEP_ILV_Tx_Pmd_DCID_Update(int16 s_lp);
void UpdateDummyByteRegs(void);
void ZEP_ILV_Tx_Skip_Dummy_Pmd_Fifo(int16 s_lp);
void ZEP_ILV_Tx_Pmd_Skip_Shalf_Fifos(int16 s_lp, int16 toggle);
void ZEP_ILV_Update_Pmd_Base_Ptr(int16 s_lp);
void ZEP_ILV_Tx_Skip_Dummy_Pms_Fifo(int16 s_lp);
void ZEP_ILV_Tx_Pms_Skip_Shalf_Fifos(int16 s_lp, int16 toggle);
void ZEP_ILV_Update_Pms_Base_Ptr(int16 s_lp);

// zep_ilv_rx.c
void ZEP_ILV_Clock_Rx(ZEP_ILV_Input_t *pt_ILVInput, ZEP_ILV_Output_t *pt_ILVOutput);
int32 ZEP_ILV_RxDataTransfer(int16 s_lp);
int32 WriteByteToRxDILVB(int16 s_lp, uint8 uc_byte);
int32 ReadByteFromRxDILVB(int16 s_lp, uint8 *puc_byte);
int32 ReadByteMetricFromMetricBuffer(int16 s_lp, uint8 *puc_byte);
void UpdateRxFifoWriteIdx(int16 s_lp);
void UpdateRxFifoReadIdx(int16 s_lp);
void ZEP_ILV_Rx_Pms_Pointers(uint16 *us_pms_pointer, uint32 *ul_pms_base, int16 s_lp);
void ZEP_ILV_Rx_Pmd_Pointers(uint16 *us_pmd_pointer, uint32 *ul_pmd_base, uint8 *uc_is_dummy_byte, int16 s_lp);
void ZEP_ILV_Rx_Pmd_DCID_Update(int16 s_lp);
void UpdatePmsFifo(int16 s_lp);
void UpdatePmdFifo(int16 s_lp);
void ZEP_ILV_Pms_Pmd_Update(int16 s_lp);

// zep_ilv_init.c
void ZEP_ILV_ResetRegisters(void);
void ZEP_ILV_ResetGlobals(void);

// zep_ilv_io.c
void UpdateTxBMVars(int8 uc_port);
void UpdateRxBMVars(int8 uc_port);

#endif // _ZEP_ILV_PRIVATE_H
