/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: zep_ilv_typedef.h
*
*   This file contains type definitions used by different files.
*
*-------------------------------------------------------------------------------
*/

#ifndef _ZEP_ILV_TYPEDEF_H
#define _ZEP_ILV_TYPEDEF_H

#ifndef _BASIC_TYPES
#define _BASIC_TYPES
// variable type definitions
typedef double           float64;     //prefix d in hungarian notation
typedef int              int32;       //prefix l
typedef char             int8;        //prefix c
typedef short            int16;       //prefix s
typedef unsigned char    uint8;       //prefix uc
typedef unsigned int     uint32;      //prefix ul
typedef unsigned short   uint16;      //prefix us
typedef unsigned int     Float32;     //prefix f
typedef unsigned char    FlagT;       //prefix ft
typedef unsigned short   bool;        //prefix b
#endif // _BASIC_TYPES

// define 64-bit accumulator type
#ifdef UNIX_PLATFORM
#define acc long long
#else
#ifdef MSVC_ONLY
#define acc __int64
#else
#define acc long
#endif
#endif

// structure used for ZEP_ILV TX registers
typedef struct {

   // ZIT_CONFIG
   uint8 uc_Tx_Has_Dummy[ZEP_ILV_NUM_LP];
   uint8 uc_Tx_Eff_Dis[ZEP_ILV_NUM_LP];
   uint16 us_Tx_Pre_Fc[ZEP_ILV_NUM_LP];
   uint16 us_Tx_Fifo_Ext[ZEP_ILV_NUM_LP];
   uint16 us_Tx_Ilv_I[ZEP_ILV_NUM_LP];

   // ZIT_DEPTH
   uint16 us_Tx_D[ZEP_ILV_NUM_LP];
   uint16 us_Tx_D_Shadow[ZEP_ILV_NUM_LP];

    // ZIT_ILV_BASE
   uint32 ul_Tx_Ilv_Base[ZEP_ILV_NUM_LP];

    // ZIT_IBLK_BASE
   uint32 ul_Tx_IBlk_Base[ZEP_ILV_NUM_LP];

    // ZIT_ILV_LIMIT
   uint32 ul_Tx_Ilv_Limit[ZEP_ILV_NUM_LP];

   // ZIT_FIFO_CTL
   uint8 uc_Tx_Shalf_Ctl;
   uint16 us_Tx_Row_Width[ZEP_ILV_NUM_LP];
   uint16 us_Tx_DMax[ZEP_ILV_NUM_LP];


    // ZIT_DCID_CTRL1
   uint16 us_Tx_Pmd_D_Lower[ZEP_ILV_NUM_LP];
   uint8  uc_Tx_Pmd_Dcid_K[ZEP_ILV_NUM_LP];
    uint8  uc_Tx_Pmd_Z[ZEP_ILV_NUM_LP];
   uint8  uc_Tx_Pmd_Last_Fifo_Valid[ZEP_ILV_NUM_LP];
   uint8  uc_Tx_Pmd_DCID_Pending[ZEP_ILV_NUM_LP];
   uint8  uc_Tx_Pmd_Dummies_Last[ZEP_ILV_NUM_LP];

    // ZIT_DCID_CTRL2
   uint16 us_Tx_Pmd_Dcid_Gl_Ptr[ZEP_ILV_NUM_LP];
    uint16 us_Tx_Pmd_Dcid_Ptr_Iover2[ZEP_ILV_NUM_LP];

   // ZIT_PMD_IBLK_TRANS_CNTR
   uint16 us_Tx_Pmd_Iblk_Trans_Cntr[ZEP_ILV_NUM_LP];

   // ZIT_PMD_FIFO_DELAY
   uint16 us_Tx_Pmd_Delay[ZEP_ILV_NUM_LP];

   // ZIT_DMAX_FIFO_DELAY_NUM
    uint16 us_Tx_Pms_Dmax_Fifo_Delay_Num[ZEP_ILV_NUM_LP];
    uint16 us_Tx_Pmd_Dmax_Fifo_Delay_Num[ZEP_ILV_NUM_LP];

    // ZIT_PMD_D_LOWER_FIFO_DELAY_ADDR
   uint16 us_Tx_Pmd_D_Lower_Fifo_Delay[ZEP_ILV_NUM_LP];
    uint16 us_Tx_Pmd_D_Lower_Fifo_Delay_Num[ZEP_ILV_NUM_LP];

   // ZIT_PMS_COUNTER1
   uint16 us_Tx_Pms_Dmax_Fifo_Delay[ZEP_ILV_NUM_LP];

   // ZIT_PMS_COUNTER2
   uint32 ul_Tx_Pms_Base_Ptr[ZEP_ILV_NUM_LP];
   uint8  uc_Tx_Pms_Fifo[ZEP_ILV_NUM_LP];

   // ZIT_PMS_COUNTER3
   uint16 us_Tx_Pms_Ptr_Iover2[ZEP_ILV_NUM_LP];
   uint16 us_Tx_Pms_Gl_Ptr[ZEP_ILV_NUM_LP];

   // ZIT_PMD_COUNTER1
   uint16 us_Tx_Pmd_Dmax_Fifo_Delay[ZEP_ILV_NUM_LP];

   // ZIT_PMD_COUNTER2
   uint32 ul_Tx_Pmd_Base_Ptr[ZEP_ILV_NUM_LP];
   uint8  uc_Tx_Pmd_Fifo[ZEP_ILV_NUM_LP];

   // ZIT_PMD_COUNTER3
   uint16 us_Tx_Pmd_Ptr_Iover2[ZEP_ILV_NUM_LP];
   uint16 us_Tx_Pmd_Gl_Ptr[ZEP_ILV_NUM_LP];

} ZEP_ILV_Tx_Registers_t;

// structure used for ZEP_ILV RX registers
typedef struct {

   // ZIR_CONFIG
   uint8 uc_Rx_Has_Dummy[ZEP_ILV_NUM_LP];
   uint8 uc_Rx_Eff_Dis[ZEP_ILV_NUM_LP];
   uint16 us_Rx_Pre_Fc[ZEP_ILV_NUM_LP];
   uint16 us_Rx_Fifo_Ext[ZEP_ILV_NUM_LP];
   uint16 us_Rx_Dilv_I[ZEP_ILV_NUM_LP];

   // ZIR_DEPTH
   uint16 us_Rx_D[ZEP_ILV_NUM_LP];
   uint16 us_Rx_D_Shadow[ZEP_ILV_NUM_LP];

    // ZIR_ILV_BASE
   uint32 ul_Rx_Ilv_Base[ZEP_ILV_NUM_LP];

    // ZIR_IBLK_BASE
   uint32 ul_Rx_IBlk_Base[ZEP_ILV_NUM_LP];

    // ZIR_ILV_LIMIT
   uint32 ul_Rx_Ilv_Limit[ZEP_ILV_NUM_LP];

   // ZIR_FIFO_CTL
   uint8 uc_Rx_Shalf_Ctl;
   uint16 us_Rx_Row_Width[ZEP_ILV_NUM_LP];
   uint16 us_Rx_DMax[ZEP_ILV_NUM_LP];


    // ZIR_DCID_CTRL1
   uint16 us_Rx_Pmd_D_Lower[ZEP_ILV_NUM_LP];
   uint8  uc_Rx_Pmd_Dcid_K[ZEP_ILV_NUM_LP];
    uint8  uc_Rx_Pmd_Z[ZEP_ILV_NUM_LP];
   uint8  uc_Rx_Pmd_Last_Fifo_Valid[ZEP_ILV_NUM_LP];
   uint8  uc_Rx_Pmd_DCID_Pending[ZEP_ILV_NUM_LP];
   uint8  uc_Rx_Pmd_Dummies_Last[ZEP_ILV_NUM_LP];

    // ZIR_DCID_CTRL2
   uint16 us_Rx_Pmd_Dcid_Gl_Ptr[ZEP_ILV_NUM_LP];
    uint16 us_Rx_Pmd_Dcid_Ptr_Iover2[ZEP_ILV_NUM_LP];

   // ZIR_PMD_IBLK_TRANS_CNTR
   uint16 us_Rx_Pmd_Iblk_Trans_Cntr[ZEP_ILV_NUM_LP];

    // ZIR_DL_REL
    uint16 us_Rx_D_Mod_L[ZEP_ILV_NUM_LP];
   uint16 us_Rx_D_Div_L[ZEP_ILV_NUM_LP];

    // ZIR_NL_REL
    uint16 us_Rx_N_Mod_L[ZEP_ILV_NUM_LP];
   uint16 us_Rx_N_Div_L[ZEP_ILV_NUM_LP];

   // ZIR_DMETRIC
   uint16 us_Rx_Dm_Iblk_Base_Offset[ZEP_ILV_NUM_LP];
   uint16 us_Rx_Dmetric_RdBase[ZEP_ILV_NUM_LP];

    // ZIR_CONTROL
    uint16 us_Rx_Lp_Bits[ZEP_ILV_NUM_LP];
   uint16 us_Rx_Dilv_Level[ZEP_ILV_NUM_LP];

   // ZIR_PMD_FIFO_DELAY
   uint16 us_Rx_Pmd_Delay[ZEP_ILV_NUM_LP];

   // ZIR_DMAX_FIFO_DELAY_NUM
    uint16 us_Rx_Pms_Dmax_Fifo_Delay_Num[ZEP_ILV_NUM_LP];
    uint16 us_Rx_Pmd_Dmax_Fifo_Delay_Num[ZEP_ILV_NUM_LP];

    // ZIR_PMD_D_LOWER_FIFO_DELAY_ADDR
   uint16 us_Rx_Pmd_D_Lower_Fifo_Delay[ZEP_ILV_NUM_LP];
    uint16 us_Rx_Pmd_D_Lower_Fifo_Delay_Num[ZEP_ILV_NUM_LP];

   // ZIR_PMS_COUNTER1
   uint16 us_Rx_Pms_Dmax_Fifo_Delay[ZEP_ILV_NUM_LP];

   // ZIR_PMS_COUNTER2
   uint32 ul_Rx_Pms_Base_Ptr[ZEP_ILV_NUM_LP];
   uint8  uc_Rx_Pms_Fifo[ZEP_ILV_NUM_LP];

   // ZIR_PMS_COUNTER3
   uint16 us_Rx_Pms_Ptr_Iover2[ZEP_ILV_NUM_LP];
   uint16 us_Rx_Pms_Gl_Ptr[ZEP_ILV_NUM_LP];

   // ZIR_PMD_COUNTER1
   uint16 us_Rx_Pmd_Dmax_Fifo_Delay[ZEP_ILV_NUM_LP];

   // ZIR_PMD_COUNTER2
   uint32 ul_Rx_Pmd_Base_Ptr[ZEP_ILV_NUM_LP];
   uint8  uc_Rx_Pmd_Fifo[ZEP_ILV_NUM_LP];

   // ZIR_PMD_COUNTER3
   uint16 us_Rx_Pmd_Ptr_Iover2[ZEP_ILV_NUM_LP];
   uint16 us_Rx_Pmd_Gl_Ptr[ZEP_ILV_NUM_LP];

   // ZIR_DMETRIC_CTRL
   uint16 us_Rx_Dmetric_Wp;
   uint8 uc_Rx_Symbol_Cross_Op;


} ZEP_ILV_Rx_Registers_t;

typedef struct{

   // ZIT_DT_SIZE
   uint16 us_Tx_Dt_Size[ZEP_ILV_NUM_LP];

   // ZIT_DTB_CONFIG
    uint16 us_Tx_DtbRd_Start;
   uint8 uc_Tx_Qt_Latch_En[ZEP_ILV_NUM_LP];

    // ZIT_DTB_WR_START
   uint16 us_Tx_DtbWr_Start[ZEP_ILV_NUM_LP];

    // ZIR_DT_SIZE
   uint16 us_Rx_Dt_Size[ZEP_ILV_NUM_LP];

   // ZIR_DTB_CONFIG
   uint16 us_Rx_DtbWr_Start;
   uint8 uc_Rx_Qt_Latch_En[ZEP_ILV_NUM_LP];

   // ZIR_DTB_RD_START
   uint16 us_Rx_DtbRd_Start[ZEP_ILV_NUM_LP];

    // ZIR_QTSCORE
   uint8 uc_QtScore;

} ZEP_ILV_Global_Registers_t;

// structure used for ZEP_ILV BM internal registers
typedef struct {

   uint8 uc_pre_FC_RX_PROC_DONE; // internal signal to track rising edge of FC_RX_PROC_DONE
   uint8 uc_int_FC_RX_PROC_DONE[ZEP_ILV_NUM_LP]; // internal signal to latch FC_RX_PROC_DONE

   int16 s_Tx_DT_State; // TX data transfer state
   int16 s_Tx_DT_EnabledLP; // TX latency path enabled for data transfer
   uint8 uc_Tx_DT_Start[ZEP_ILV_NUM_LP]; // TX data transfer initiator
   uint8 uc_Tx_DT_Wait_Cnt[ZEP_ILV_NUM_LP]; // TX data transfer wait count
   uint8 uc_Tx_DT_Busy[ZEP_ILV_NUM_LP]; // TX data transfer busy signal

   uint16 us_Tx_NumFifo[ZEP_ILV_NUM_LP]; // # of FIFO's used in interleaving
   uint8 uc_Tx_DummyByte[ZEP_ILV_NUM_LP]; // dummy byte insertion/extraction indicator, 0 is VDSL mode
   uint16 us_Tx_NumDummyByteWr[ZEP_ILV_NUM_LP]; // # of dummy byte inserted
   uint16 us_Tx_NumDummyByteRd[ZEP_ILV_NUM_LP]; // # of dummy byte extracted

   uint8 uc_Tx_Shalf_Rd; // indicate 1st or 2nd CW read (from ILVB) for S=1/2 mode
   uint8 uc_Tx_Shalf_Wr; // indicate 1st or 2nd CW write (to ILVB) for S=1/2 mode

   int16 s_Rx_DT_State; // RX data transfer state
   int16 s_Rx_DT_EnabledLP; // RX latency path enabled for data transfer
   uint8 uc_Rx_DT_Busy[ZEP_ILV_NUM_LP]; // RX data transfer busy signal

   uint16 us_Rx_NumFifo[ZEP_ILV_NUM_LP]; // # of FIFO's used in deinterleaving
   uint8 uc_Rx_DummyByte[ZEP_ILV_NUM_LP]; // dummy byte insertion/extraction indicator, 0 is VDSL mode
   uint16 us_Rx_NumDummyByteWr[ZEP_ILV_NUM_LP]; // # of dummy byte inserted
   uint16 us_Rx_NumDummyByteRd[ZEP_ILV_NUM_LP]; // # of dummy byte extracted

   uint32 ul_Rx_Raw_Dilvb_Level[ZEP_ILV_NUM_LP]; // 17-bit LEVEL counter, increment on write and decrement on read, can be greater than DILVB size

// New registers added to keep Tx/Rx single-port state machine working
// for multi-port BM
   uint16 us_Tx_Dt_Bytes[ZEP_ILV_NUM_LP]; // # of bytes from ILVB to TxDTB
   uint16 us_Rx_Dt_Bytes[ZEP_ILV_NUM_LP]; // # of bytes from RxDTB to DILVB

} ZEP_ILV_BM_Registers_t;

#endif // _ZEP_ILV_TYPEDEF_H
