/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: afeif_cocomo_interface.h
;
*****************************************************************************/

#ifndef _AFEIF_COCOMO_INTERFACE_H
#define _AFEIF_COCOMO_INTERFACE_H

#include "afeif_const.h"

// Reset
void Afeif_Reset(void);

// Interface functions called by V_Strymon (VFDF) and Strymon CPE (FDF) BMs
void Afeif_TxPutSampleFromVfdf(int16 *ps_SamplePtr);
void Afeif_RxGetSampleForVfdf(int16 *ps_SamplePtr);
void Afeif_TxPutSampleFromFdf(int16 *ps_SamplePtr);
void Afeif_AecPutSampleFromFdf(int16 *ps_SamplePtr);
void Afeif_RxGetSampleForFdf(int16 *ps_SamplePtr);

// Prototypes used to interface with AFE BFM in the co-verification environment
#ifdef UNIX_PLATFORM
void TxPutAfeSample(int16 *ps_SamplePtr);
void RxGetAfeSample(int16 *ps_SamplePtr);
void AecPutAfeSample(int16 *ps_SamplePtr);
#endif // UNIX_PLATFORM

// DSP shared-memory interface
int32 Afeif_ReadWord(uint32 ul_PhysAddr, uint32 *pul_word, uint8 uc_ByteEnable);
int32 Afeif_WriteWord(uint32 ul_PhysAddr, uint32 ul_word, uint8 uc_ByteEnable);

// Functions used for setting latency vars
void SetAecRxLoopbackDelay(int16 s_delay);
void SetTxRxLoopbackDelay(int16 s_delay);

// AFEIF input strobe structure
typedef struct {
   uint8 uc_RSTN;             // Asynchronous reset
   uint8 uc_CoreSelect;       // Core select bits from Iridia FT
} AfeifInput_t;

// Extern to public variables
extern AfeifInput_t gt_AfeifInput;

#endif // _AFEIF_COCOMO_INTERFACE_H
