/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: afeif_const.h
;
;   This file contains constant definitions for the AFEIF BM.
;
*****************************************************************************/

#ifndef _AFEIF_CONST_H
#define _AFEIF_CONST_H

// Latency modelling macros
#define MAX_AFEIF_LATENCY 512

// Core select modes
#define VFDF_NORMAL        0
#define FDF_NORMAL         1
#define VFDF_TX_TO_FDF_RX  2
#define FDF_TX_TO_VFDF_RX  3

// Register bit masks
#ifndef MASK_BIT0
#define MASK_BIT0             (0x0001)
#define MASK_BIT1             (0x0002)
#define MASK_BIT2             (0x0004)
#define MASK_BIT3             (0x0008)
#define MASK_BIT4             (0x0010)
#define MASK_BIT5             (0x0020)
#define MASK_BIT6             (0x0040)
#define MASK_BIT7             (0x0080)
#define MASK_BIT8             (0x0100)
#define MASK_BIT9             (0x0200)
#define MASK_BIT10               (0x0400)
#define MASK_BIT11               (0x0800)
#define MASK_BIT12               (0x1000)
#define MASK_BIT13               (0x2000)
#define MASK_BIT14               (0x4000)
#define MASK_BIT15               (0x8000)
#endif // MASK_BIT0

#define MASK_BIT16               (0x00010000)
#define MASK_BIT17               (0x00020000)
#define MASK_BIT18               (0x00040000)
#define MASK_BIT19               (0x00080000)
#define MASK_BIT20               (0x00100000)
#define MASK_BIT21               (0x00200000)
#define MASK_BIT22               (0x00400000)
#define MASK_BIT23               (0x00800000)
#define MASK_BIT24               (0x01000000)
#define MASK_BIT25               (0x02000000)
#define MASK_BIT26               (0x04000000)
#define MASK_BIT27               (0x08000000)
#define MASK_BIT28               (0x10000000)
#define MASK_BIT29               (0x20000000)
#define MASK_BIT30               (0x40000000)
#define MASK_BIT31               (0x80000000)

// Byte enable masks
#define AI_NO_BYTE_EN      (0x0)
#define AI_BYTE0_EN     (0x1)
#define AI_BYTE1_EN     (0x2)
#define AI_BYTE2_EN     (0x4)
#define AI_BYTE3_EN     (0x8)
#define AI_LOWER_WORD_EN   (AI_BYTE1_EN | AI_BYTE0_EN)
#define AI_UPPER_WORD_EN   (AI_BYTE3_EN | AI_BYTE2_EN)
#define AI_LONGWORD_EN     (AI_UPPER_WORD_EN | AI_LOWER_WORD_EN)

// Byte masks
#define BYTE0_MASK      (0x000000FF)
#define BYTE1_MASK      (0x0000FF00)
#define BYTE2_MASK      (0x00FF0000)
#define BYTE3_MASK      (0xFF000000)
#define LOWER_WORD_MASK (BYTE1_MASK | BYTE0_MASK)
#define UPPER_WORD_MASK (BYTE3_MASK | BYTE2_MASK)
#define LONGWORD_MASK   (UPPER_WORD_MASK | LOWER_WORD_MASK)

// Exception definitions
#define NO_EXCEPTION       0     // Default value
#define AFEIF_INVALID_MEM_ACCESS    1     // Invalid access to memory

// Echo model macros
#define ECHO_LEN     256 //2048
#define ECHO_EXP     1 //0
#define MAX_ECHO_LEN 256 //2048
#define LOG2_MAX_ECHO_LEN  8 //12
#define MAX_ECHO_EXP 3
#define ECHO_ACC_WIDTH  (31+LOG2_MAX_ECHO_LEN+MAX_ECHO_EXP)
#define ECHO_ACC_MIN (0xFFFFFFFFC0000000) // minimum value of echo FIR accumulator
#define ECHO_ACC_MAX (0x000000003FFFFFFF) // maximum value of echo FIR accumulator
#define ECHO_OUT_MIN (0x8000)          // minimum echo FIR output
#define ECHO_OUT_MAX (0x7FFF)          // maximum echo FIR output

// FIR filter definitions
#define DELAY     (0)
#define OUTPUT    (1)

#endif // _AFEIF_CONST_H
