/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _ALP_COCOMO_INTERFACE_H
#define _ALP_COCOMO_INTERFACE_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http:// www.aware.com
 *
 * FILE:             alp_cocomo_interface.h
 * DESCRIPTION:      Specifies Cocomo to alphaeus interface.  This interface
 *             includes the register read/write functions, a core
 *             reset function, a BM intialization function, and any
 *             other cocomo/BM only functions/variables that are
 *             required to run a HW Engine simulation.  These functions
 *             are NOT required by, and unavailable for, actual HW.
 *
 **********************************************************************/

#include "alp_typedef.h"

/*  =================================================================================== */
/*  Function for reading and writing data to alphaeus register and cell buffers.        */
/*  Note: uc_ByteEnable must be one of the byte enable masks listed below:              */
/*  =================================================================================== */
// Byte enable masks
#define ALP_NO_BYTE_EN          (0x0)
#define ALP_BYTE0_EN            (0x1)
#define ALP_BYTE1_EN            (0x2)
#define ALP_BYTE2_EN            (0x4)
#define ALP_BYTE3_EN            (0x8)
#define ALP_LOWER_WORD_EN       (ALP_BYTE1_EN | ALP_BYTE0_EN)
#define ALP_UPPER_WORD_EN       (ALP_BYTE3_EN | ALP_BYTE2_EN)
#define ALP_LONGWORD_EN         (ALP_UPPER_WORD_EN | ALP_LOWER_WORD_EN)

int32 ALP_WriteWord(uint32 addr, uint32 ul_data, uint8 uc_ByteEnable);
int32 ALP_ReadWord(uint32 addr, uint32 *pul_data, uint8 uc_ByteEnable);

void ALP_GetTxPages(uint8 uc_bc, uint32 *pul_data);
void ALP_Set_TXPAGE_x(uint8 uc_bc, uint32 pul_data);
void ALP_Set_TXCLAV_x(uint8 uc_bc, uint32 pul_data);
void ALP_GetTxBCAttrib(uint8 uc_bc, uint8 attrib_num, uint32 *pul_data);
void ALP_GetRxBCAttrib(uint8 uc_bc, uint8 attrib_num, uint32 *pul_data);
void ALP_SetTxBCAttrib(uint8 uc_bc, uint8 attrib_num, uint32 pul_data);
void ALP_SetRxBCAttrib(uint8 uc_bc, uint8 attrib_num, uint32 pul_data);

void ALP_GetDCP_Enable(uint32 *pul_data);
void ALP_GetDCP_CHK_DIS(uint32 *pul_data);
void ALP_GetDCP_VPI(uint32 *pul_data);
void ALP_GetDCP_VCI(uint32 *pul_data);
void ALP_GetDCP_Addr(uint32 *pul_data);

void ALP_SetRxDCPFull(uint32 pul_data);
void ALP_GetRxDCPFull(uint32 *pul_data);
void ALP_SetRxDCP_out(uint32 pul_data);

void ALP_SetTxDCP_Empty(uint32 pul_data);
void ALP_GetTxDCP_Empty(uint32 *pul_data);
void ALP_SetTxDCP_out(uint32 pul_data);

/*  ============================================================================= */
/*  Initialization Function */
/*  ============================================================================= */

// Initialization Interface
int32 ALP_InitializeBM(void);
void ALP_Reset(void);

// Alphaeus BM functions
//TBD void ALP_Clock(Alphaeus_Input_t *pt_InSigs, Alphaeus_Output_t *pt_OutSigs);

/* ----- Cell buffers ----- */
void ALP_GetTxCellBuffer(uint8 **puc_BaseAddr);
void ALP_GetRxCellBuffer(uint8 **puc_BaseAddr);

uint8 GetATMByteBC0(uint8 *intr);
uint8 GetATMByteBC1(uint8 *intr);
void ForceCellDecision(void);
void ALP_TxForceCellDecision(uint8 uc_bc);
uint8 ALP_GetTxCellDecision(uint8 uc_bc);

uint8 PutATMByteBC0(uint8 uc_byte);
uint8 PutATMByteBC1(uint8 uc_byte);
void RxForceCellDecision(void);

void RunMisc(void);

/* ----- Frame buffers ----- */
extern uint8* Get_TxFrameBuff(void);
extern uint8* Get_RxFrameBuff(void);

void Alphaeus_CheckForAAISwReset(uint8 aaiSwReset);

#endif /* _ALP_COCOMO_INTERFACE_H */

