/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: alp_io_typedef.h
;
;  This file contains Alphaeus I/O type definitions used by other BMs.
;
*****************************************************************************/

#ifndef _ALP_IO_TYPEDEF_H
#define _ALP_IO_TYPEDEF_H

#include "alp_const.h"
#include "alp_typedef.h"

// Signals to Alphaeus
typedef struct {
   // DSP Interface
   uint8 uc_dsp_ad;     // External bus address for DSP
   uint16 us_dsp_wd;    // External bus write data for DSP
   uint8 uc_dsp_aai_sel;   // Alphaeus select for DSP, active high
   uint8 uc_dsp_write;     // External bus write enable for DSP, active high

   // Clock, Reset and Interrupt Interface
   uint8 uc_ac_clk;     // Aware core clock
   uint8 uc_aai_clk;    // Alphaeus clock
   uint8 uc_aai_tx_clk; // Alphaeus transmit clock
   uint8 uc_aai_rx_clk; // Alphaeus receive clock
   uint8 uc_aai_tx_clk_div;// Alphaeus transmit clock divider
   uint8 uc_aai_rx_clk_div;// Alphaeus receive clock divider
   uint8 uc_aai_rstn;      // Alphaeus Active low asynchronous reset.

   // Cell Buffer Interface
   uint16 us_aai_txcb_rda; // Transmit path cell buffer read data A
   uint16 us_aai_rxcb_wda; // Receive path cell buffer write data A

   // Frame Buffer Interface
   uint8 uc_aai_rxfb_rd;   // Rx frame buffer read data

   // Aware Core Interface
   uint8 uc_go_aai_tx;     // Active high strobe indicates the start
                     // of Alphaeus Tx frame processing.
   uint8 uc_go_aai_rx;     // Active high strobe indicates the start
                     // of Alphaeus Rx frame processing.
   uint8 uca_fci_rx_bsr[MAX_NUM_BC][NUM_STUFF_AND_ROB_BITS];
                     // Stuff and rob control signals
   uint8 uca_fci_tx_bs[MAX_NUM_BC];
                     // Byte stuff control signals.
   uint8 uc_fci_tx_done;   // Active high strobe indicates Zephyr transmit
                     // processing is complete.
   uint8 uc_fci_rx_done;   // Active high strobe indicates Zephyr receive
                     // processing is complete.
   // Utopia Interface
   uint8 uc_utp_txclk;     // UTOPIA transmit clock.  Synchronous to transmit path.
   uint8 uc_utp_txrstn; // Active low reset for the utp_txclk domain.
   uint8 uc_utp_txsoc;     // UTOPIA transmit start of cell.  Active high indicates the
                     // first octet in a cell.
   uint8 uc_utp_txenbn; // UTOPIA transmit enable.  Active low enables the transmission
                     // of a cell on the UTOPIA transmit path.
   uint8 utp_txaddr;    // UTOPIA transmit address.  The address of the port to be
                     // selected is placed on these lines prior to transmission of the data.

   uint8 uc_utp_txdata; // UTOPIA transmit data.
   uint8 uc_utp_rxclk;     // UTOPIA receive clock.  Synchronous to receive path.
   uint8 uc_utp_rxrstn; // Active low reset for the utp_rxclk domain.
   uint8 uc_utp_rxenbn; // UTOPIA receive enable.  Active low enables data to be
                     // transmitted from the Alphaeus to the ATM device.
   uint8 uc_utp_rxaddr; // UTOPIA receive address.  The address of the port to be selected
                     // is placed on these lines prior to transmission of the data.
} Alphaeus_Input_t;

// Signals from Alphaeus
typedef struct {
   // DSP Interface
   uint16 us_dsp_aai_rd;   // External bus read data for DSP
   uint8 uc_aai_tx_on;     // Indicates when the Alphaeus transmit core is active.
                     // When high, the Alphaeus core has access to the transmit
                     // frame buffer and cell buffer.
   uint8 uc_aai_rx_on;     // Indicates when the Alphaeus receive core is active.
                     // When high, Alphaeus the core has access to the receive
                     // frame buffer and cell buffer.

   // Clock, Reset and Interrupt Interface
   uint8 uc_aai_tx_clk_gate;// Alphaeus transmit clock enable
   uint8 uc_aai_rx_clk_gate;// Alphaeus receive clock enable
   uint8 uc_aai_tx_done;   // Indicates that the transmit logic has finished processing a
                     // port. This output is also used for cascading the next
                     // Aware Core processing block (Electra) in the transmit direction
   uint8 uc_aai_rx_done;   // Indicates that the receive logic has finished processing a port

   // Cell Buffer Interface
   uint8 uc_aai_txcb_ena;  // Transmit path cell buffer block select A
   uint8 uc_aai_txcb_ada;  // Transmit path cell buffer address A
   uint8 uc_aai_txcb_enb;  // Transmit path cell buffer block select B
   uint8 uc_aai_txcb_adb;  // Transmit path cell buffer address B
   uint16 us_aai_txcb_wdb; // Transmit path cell buffer write data B
   uint8 uc_aai_rxcb_ena;  // Receive path cell buffer block select A
   uint8 uc_aai_rxcb_ada;  // Receive path cell buffer address A
   uint8 uc_aai_rxcb_enb;  // Receive path cell buffer block select B
   uint8 uc_aai_rxcb_adb;  // Receive path cell buffer address B
   uint16 us_aai_rxcb_rdb; // Receive path cell buffer read data B


   // Frame Buffer Interface
   uint8 uc_aai_txfb_ena;  // Tx frame buffer enable
   uint8 uc_aai_txfb_ad;   // Tx frame buffer address
   uint8 uc_aai_txfb_wd;   // Tx frame buffer write data
   uint8 uc_aai_rxfb_ena;  // Rx frame buffer enable
   uint8 uc_aai_rxfb_ad;   // Rx frame buffer address

   // Aware Core Interface
   uint8 uc_go_stm_tx;     // Active high strobe indicates Alphaeus transmit processing
                     // is complete. This strobe can be used to initiate the Electra
                     // core to transfer its data into the transmit frame buffer.

   //Utopia Interface
   uint8 uc_utp_txclav; // UTOPIA transmit cell available.  Active high indicates that
                     // the Alphaeus is ready to receive a cell from the ATM device.
   uint8 uc_utp_txclav_ena;// Tristate enable for the utp_txclav signal. An active high
                     // indicates that the corresponding output signal should be enabled.
   uint8 uc_utp_rxsoc;     // UTOPIA receive start of cell.  Active high indicates the first
                     // octet in a cell.
   uint8 uc_utp_rxsoc_ena; // Tristate enable for the utp_rxsoc signal.  An active high
                     // indicates that the corresponding output signal should be enabled.

   uint8 uc_utp_rxclav; // UTOPIA receive cell available.  Active high indicates that the
                     // Alphaeus is ready to transmit a cell to the ATM device.
   uint8 uc_utp_rxclav_ena;// Tristate enable for the utp_rxclav signal.  An active high
                     // indicates that the corresponding output signal should be enabled.
   uint8 uc_utp_rxdata; // UTOPIA receive data.
   uint8 uc_utp_rxdata_ena;// Tristate enable for the utp_rxdata signals. An active high indicates that the corresponding output signal should be enabled.

  // Status interrupts
  uint8 uc_aai_txstat;
  uint8 uc_aai_rxstat;

  // DCP interrupts
  uint8 uc_aai_txdcp_empty;
  uint8 uc_aai_rxdcp_full;

} Alphaeus_Output_t;

extern Alphaeus_Input_t  t_Alphaeus_Input;
extern Alphaeus_Output_t t_Alphaeus_Output;


#endif //_ALP_IO_TYPEDEF_H
