/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: alp_memmap.h
;
;  Main header file for alphaeus behavioral model.
;
*****************************************************************************/
#ifndef _ALP_MEMMAP_H
#define _ALP_MEMMAP_H

#include "alp_dsp_interface.h"

/**********************************************************************
 * Memory map for Alphaeus
 **********************************************************************/
#define ALP_REGBLOCK_ADDR        (0xC400)

/* Tx/Rx cell buffer addresses */
#define ALP_TX_CELLBUFFER_ADDR      (0xD000)
#define ALP_RX_CELLBUFFER_ADDR      (0xC800)

#define ALP_DCP_RX_CELLBUFFER_ADDR  (0xD800)
#define ALP_DCP_TX_CELLBUFFER_ADDR  (0xD820)

#define ALP_BASE_GLOBALREG_ADDR     (ALP_REGBLOCK_ADDR + ALP_GLOBALREG_OFFSET)
#define ALP_BASE_TXREG_ADDR         (ALP_REGBLOCK_ADDR + ALP_TXREG_OFFSET)
#define ALP_BASE_RXREG_ADDR         (ALP_REGBLOCK_ADDR + ALP_RXREG_OFFSET)


/* Addresses of global registers */
#define ALP_NUM_GLOBAL_REG       (9)
#define ALP_CVER_ADDR            (ALP_REGBLOCK_ADDR + ALP_CVER_OFFSET)
#define ALP_UTP_CFG_ADDR         (ALP_REGBLOCK_ADDR + ALP_UTP_CFG_OFFSET)
#define ALP_UTP_STAT_ADDR        (ALP_REGBLOCK_ADDR + ALP_UTP_STAT_OFFSET)
#define ALP_INT_STAT_ADDR        (ALP_REGBLOCK_ADDR + ALP_INT_STAT_OFFSET)
#define ALP_INT_MASK_ADDR        (ALP_REGBLOCK_ADDR + ALP_INT_MASK_OFFSET)
#define ALP_DEBUG1_ADDR          (ALP_REGBLOCK_ADDR + ALP_DEBUG1_OFFSET)
#define ALP_DEBUG2_ADDR          (ALP_REGBLOCK_ADDR + ALP_DEBUG2_OFFSET)
#define ALP_DCP_CONFIG_ADDR         (ALP_REGBLOCK_ADDR + ALP_DCP_CONFIG_OFFSET)
#define ALP_DCP_STAT_ADDR           (ALP_REGBLOCK_ADDR + ALP_DCP_STAT_OFFSET)

/* Addresses Tx registers */
#define ALP_NUM_TX_REG_BLOCK1    (4)
//#define ALP_T_CONTROL_ADDR     Obsolete
#define ALP_T_CONFIG_ADDR        (ALP_REGBLOCK_ADDR + ALP_T_CONFIG_OFFSET)
#define ALP_T_CB_STAT_ADDR       (ALP_REGBLOCK_ADDR + ALP_T_CB_STAT_OFFSET)
#define ALP_T_CB_CFG_BC0_ADDR    (ALP_REGBLOCK_ADDR + ALP_T_CB_CFG_BC0_OFFSET)
#define ALP_T_CB_CFG_BC1_ADDR    (ALP_REGBLOCK_ADDR + ALP_T_CB_CFG_BC1_OFFSET)

#define ALP_NUM_TX_REG_BLOCK2    (4)
#define ALP_T_PCNTL_BC0_ADDR     (ALP_REGBLOCK_ADDR + ALP_T_PCNTL_BC0_OFFSET)
#define ALP_T_IDLE_BC0_ADDR         (ALP_REGBLOCK_ADDR + ALP_T_IDLE_BC0_OFFSET)
#define ALP_T_CELL_CNT_BC0_ADDR     (ALP_REGBLOCK_ADDR + ALP_T_CELL_CNT_BC0_OFFSET)
#define ALP_T_IDLE_CNT_BC0_ADDR     (ALP_REGBLOCK_ADDR + ALP_T_IDLE_CNT_BC0_OFFSET)

#define ALP_NUM_TX_REG_BLOCK3    (4)
#define ALP_T_PCNTL_BC1_ADDR     (ALP_REGBLOCK_ADDR + ALP_T_PCNTL_BC1_OFFSET)
#define ALP_T_IDLE_BC1_ADDR         (ALP_REGBLOCK_ADDR + ALP_T_IDLE_BC1_OFFSET)
#define ALP_T_CELL_CNT_BC1_ADDR     (ALP_REGBLOCK_ADDR + ALP_T_CELL_CNT_BC1_OFFSET)
#define ALP_T_IDLE_CNT_BC1_ADDR     (ALP_REGBLOCK_ADDR + ALP_T_IDLE_CNT_BC1_OFFSET)

/* Address offsets of Rx registers */
#define ALP_NUM_RX_REG_BLOCK1    (5)
//#define ALP_R_CONTROL_ADDR        Obsolete
#define ALP_R_CONFIG_ADDR        (ALP_REGBLOCK_ADDR + ALP_R_CONFIG_OFFSET)
#define ALP_R_CB_STAT_ADDR       (ALP_REGBLOCK_ADDR + ALP_R_CB_STAT_OFFSET)
#define ALP_R_CB_CFG_BC0_ADDR    (ALP_REGBLOCK_ADDR + ALP_R_CB_CFG_BC0_OFFSET)
#define ALP_R_CB_CFG_BC1_ADDR       (ALP_REGBLOCK_ADDR + ALP_R_CB_CFG_BC1_OFFSET)
#define ALP_R_IMAHEC_ADDR        (ALP_REGBLOCK_ADDR + ALP_R_IMAHEC_OFFSET)

#define ALP_NUM_RX_REG_BLOCK2    (10)
#define ALP_R_PCNTL_BC0_ADDR     (ALP_REGBLOCK_ADDR + ALP_R_PCNTL_BC0_OFFSET)
#define ALP_R_ATM_STAT_BC0_ADDR     (ALP_REGBLOCK_ADDR + ALP_R_ATM_STAT_BC0_OFFSET)
#define ALP_R_CELL_CNT_BC0_ADDR     (ALP_REGBLOCK_ADDR + ALP_R_CELL_CNT_BC0_OFFSET)
#define ALP_R_IDLE_CNT_BC0_ADDR     (ALP_REGBLOCK_ADDR + ALP_R_IDLE_CNT_BC0_OFFSET)
#define ALP_R_AIDLE_CNT_BC0_ADDR    (ALP_REGBLOCK_ADDR + ALP_R_AIDLE_CNT_BC0_OFFSET)
#define ALP_R_BE_CNT_BC0_ADDR       (ALP_REGBLOCK_ADDR + ALP_R_BE_CNT_BC0_OFFSET)
#define ALP_R_HEC_CNT_BC0_ADDR      (ALP_REGBLOCK_ADDR + ALP_R_HEC_CNT_BC0_OFFSET)
#define ALP_R_CD_CNT_BC0_ADDR       (ALP_REGBLOCK_ADDR + ALP_R_CD_CNT_BC0_OFFSET)
#define ALP_R_IDLE_BC0_ADDR         (ALP_REGBLOCK_ADDR + ALP_R_IDLE_BC0_OFFSET)
#define ALP_R_DELIN_BC0_ADDR     (ALP_REGBLOCK_ADDR + ALP_R_DELIN_BC0_OFFSET)

#define ALP_NUM_RX_REG_BLOCK3    (10)
#define ALP_R_PCNTL_BC1_ADDR     (ALP_REGBLOCK_ADDR + ALP_R_PCNTL_BC1_OFFSET)
#define ALP_R_ATM_STAT_BC1_ADDR     (ALP_REGBLOCK_ADDR + ALP_R_ATM_STAT_BC1_OFFSET)
#define ALP_R_CELL_CNT_BC1_ADDR     (ALP_REGBLOCK_ADDR + ALP_R_CELL_CNT_BC1_OFFSET)
#define ALP_R_IDLE_CNT_BC1_ADDR     (ALP_REGBLOCK_ADDR + ALP_R_IDLE_CNT_BC1_OFFSET)
#define ALP_R_AIDLE_CNT_BC1_ADDR    (ALP_REGBLOCK_ADDR + ALP_R_AIDLE_CNT_BC1_OFFSET)
#define ALP_R_BE_CNT_BC1_ADDR       (ALP_REGBLOCK_ADDR + ALP_R_BE_CNT_BC1_OFFSET)
#define ALP_R_HEC_CNT_BC1_ADDR      (ALP_REGBLOCK_ADDR + ALP_R_HEC_CNT_BC1_OFFSET)
#define ALP_R_CD_CNT_BC1_ADDR       (ALP_REGBLOCK_ADDR + ALP_R_CD_CNT_BC1_OFFSET)
#define ALP_R_IDLE_BC1_ADDR         (ALP_REGBLOCK_ADDR + ALP_R_IDLE_BC1_OFFSET)
#define ALP_R_DELIN_BC1_ADDR     (ALP_REGBLOCK_ADDR + ALP_R_DELIN_BC1_OFFSET)

#define ALP_NUM_TX_XTC_REG_BLOCK1   (14)
#define ALP_T_XTC_CONFIG_ADDR       (ALP_REGBLOCK_ADDR + ALP_T_XTC_CONFIG_OFFSET)
#define ALP_T_XTC_CB_CFG_ADDR       (ALP_REGBLOCK_ADDR + ALP_T_XTC_CB_CFG_OFFSET)
#define ALP_T_XTC_STAT_ADDR         (ALP_REGBLOCK_ADDR + ALP_T_XTC_STAT_OFFSET)
#define ALP_T_XTC_DMT_DLY_ADDR      (ALP_REGBLOCK_ADDR + ALP_T_XTC_DMT_DLY_OFFSET)
#define ALP_T_XTC_DMT_DLY_A_ADDR    (ALP_REGBLOCK_ADDR + ALP_T_XTC_DMT_DLY_A_OFFSET)
#define ALP_T_XTC_SIZE0_ADDR        (ALP_REGBLOCK_ADDR + ALP_T_XTC_SIZE0_OFFSET)
#define ALP_T_XTC_SIZE0_A_ADDR      (ALP_REGBLOCK_ADDR + ALP_T_XTC_SIZE0_A_OFFSET)
#define ALP_T_XTC_SIZE1_ADDR        (ALP_REGBLOCK_ADDR + ALP_T_XTC_SIZE1_OFFSET)
#define ALP_T_XTC_SIZE1_A_ADDR      (ALP_REGBLOCK_ADDR + ALP_T_XTC_SIZE1_A_OFFSET)
#define ALP_T_XTC_BYTE_DLY0_ADDR    (ALP_REGBLOCK_ADDR + ALP_T_XTC_BYTE_DLY0_OFFSET)
#define ALP_T_XTC_BYTE_DLY0_A_ADDR  (ALP_REGBLOCK_ADDR + ALP_T_XTC_BYTE_DLY0_A_OFFSET)
#define ALP_T_XTC_BYTE_DLY1_ADDR    (ALP_REGBLOCK_ADDR + ALP_T_XTC_BYTE_DLY1_OFFSET)
#define ALP_T_XTC_BYTE_DLY1_A_ADDR  (ALP_REGBLOCK_ADDR + ALP_T_XTC_BYTE_DLY1_A_OFFSET)
#define ALP_T_XTC_TCR_ADDR          (ALP_REGBLOCK_ADDR + ALP_T_XTC_TCR_OFFSET)

#define ALP_NUM_RX_XTC_REG_BLOCK1   (14)
#define ALP_R_XTC_CONFIG_ADDR       (ALP_REGBLOCK_ADDR + ALP_R_XTC_CONFIG_OFFSET)
#define ALP_R_XTC_CB_CFG_ADDR       (ALP_REGBLOCK_ADDR + ALP_R_XTC_CB_CFG_OFFSET)
#define ALP_R_XTC_STAT_ADDR         (ALP_REGBLOCK_ADDR + ALP_R_XTC_STAT_OFFSET)
#define ALP_R_XTC_DMT_DLY_ADDR      (ALP_REGBLOCK_ADDR + ALP_R_XTC_DMT_DLY_OFFSET)
#define ALP_R_XTC_DMT_DLY_A_ADDR    (ALP_REGBLOCK_ADDR + ALP_R_XTC_DMT_DLY_A_OFFSET)
#define ALP_R_XTC_SIZE0_ADDR        (ALP_REGBLOCK_ADDR + ALP_R_XTC_SIZE0_OFFSET)
#define ALP_R_XTC_SIZE0_A_ADDR      (ALP_REGBLOCK_ADDR + ALP_R_XTC_SIZE0_A_OFFSET)
#define ALP_R_XTC_SIZE1_ADDR        (ALP_REGBLOCK_ADDR + ALP_R_XTC_SIZE1_OFFSET)
#define ALP_R_XTC_SIZE1_A_ADDR      (ALP_REGBLOCK_ADDR + ALP_R_XTC_SIZE1_A_OFFSET)
#define ALP_R_XTC_BYTE_DLY0_ADDR    (ALP_REGBLOCK_ADDR + ALP_R_XTC_BYTE_DLY0_OFFSET)
#define ALP_R_XTC_BYTE_DLY0_A_ADDR  (ALP_REGBLOCK_ADDR + ALP_R_XTC_BYTE_DLY0_A_OFFSET)
#define ALP_R_XTC_BYTE_DLY1_ADDR    (ALP_REGBLOCK_ADDR + ALP_R_XTC_BYTE_DLY1_OFFSET)
#define ALP_R_XTC_BYTE_DLY1_A_ADDR  (ALP_REGBLOCK_ADDR + ALP_R_XTC_BYTE_DLY1_A_OFFSET)
#define ALP_R_XTC_TCR_ADDR          (ALP_REGBLOCK_ADDR + ALP_R_XTC_TCR_OFFSET)

#endif //_ALP_MEMMAP_H
