/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: alp_typedef.h
;
;  Data types of the Alphaeus behavioral model.
;
*****************************************************************************/

#ifndef _ALP_TYPEDEF_H
#define _ALP_TYPEDEF_H

#include "alp_const.h"


#ifndef FALSE
#define FALSE  0
#endif

#ifndef TRUE
#define TRUE   1
#endif

#ifndef _BASIC_TYPES
#define _BASIC_TYPES

/* Data type definitions */
typedef double           float64;     //prefix d in hungarian notation
typedef int              int32;       //prefix l
typedef char             int8;        //prefix c
typedef short            int16;       //prefix s
typedef unsigned char    uint8;       //prefix uc
typedef unsigned int     uint32;      //prefix ul
typedef unsigned short   uint16;      //prefix us
typedef unsigned int     Float32;     //prefix f
typedef unsigned char    FlagT;       //prefix ft
typedef unsigned short   bool;        //prefix b

#endif //_BASIC_TYPES


typedef union {
   uint32 ula_longwords[(ATM_CELL_SIZE+3) >> 2]; // Dummy. Defined here only to force..
                                                // ..alignment on UNIX machines.
   uint8  uca_bytes[ATM_CELL_SIZE+3];            // as bytes (3 extra for unused bytes)
   struct {
      uint8   uc_head1;    // Header byte 1
      uint8   uc_head2;    // Header byte 2
      uint8   uc_head3;    // Header byte 3
      uint8   uc_head4;    // Header byte 4
      uint8   uc_hec;         // Header error control byte
      uint8   uc_UnusedByte2; // Unused Byte in 56-byte cell page
      uint8   uc_UnusedByte3; // Unused Byte in 56-byte cell page
      uint8   uc_UnusedByte4; // Unused Byte in 56-byte cell page
      uint8   uca_payload[ATM_CELL_PAYLOAD_SIZE];  // Payload bytes
   } fl; // as fields
} Cell_t;   // ATM cell data structure


// DCP (Device Control Protocol) Cell buffer.
typedef union {
   uint32 ula_longwords[32]; // Only the lower 16 bits of each longword are used.
   uint8  uca_bytes[32*4];
} DCPCell_t;   // DCP ATM cell data structure

// Bearer channel cell pages attributes.
typedef struct {
   uint8  uc_StartPage;
   uint8  uc_EndPage;
    uint8  uc_RdPage;
   uint8  uc_WrPage;
   uint8  uc_InterceptPage;  // only used in DSP intercept mode.
   uint8  uc_InterceptDepth; // only used in DSP intercept mode.
   uint8  uc_Depth;
   uint8  uc_Full;
   uint8  uc_Empty;
} BearerCh_t;

#endif //_ALP_TYPEDEF_H
