/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;       Aware DMT Technology. Proprietary and Confidential.
;
;       40 Middlesex Turnpike, Bedford, MA 01730-1413
;       Phone (781) 276 - 4000
;       Fax   (781) 276 - 4001
;
;       File Name: alp_utils.h
;       Author:    Arthur J. Sierzputowski
;
;       Utility functions for RX and TX ATM TC layer.
;
*****************************************************************************/

#ifndef _ALP_UTILS_H
#define _ALP_UTILS_H

#ifdef __cplusplus
extern "C" {
#endif

#define ATM_COSET_PATTERN   0x55


#if defined( UTILS_DEF_LOCAL )

/////////////////////////////////////////////////////////////////////////////
//             Function Prototypes
/////////////////////////////////////////////////////////////////////////////

uint8   CalcHec(uint8 uc_byte, uint8 uc_curHec);
uint8   CalcHeaderHec(uint32 ul_header);

void    ScramInit();
void    DescramInit();
uint8   Scram(uint8 uc_byteIn);
uint8   Descram(uint8 uc_byteIn);

#else // defined( UTILS_DEF_LOCAL )

extern uint8 uc_flipTable[];

/////////////////////////////////////////////////////////////////////////////
//             Function Prototypes
/////////////////////////////////////////////////////////////////////////////

extern uint8   CalcHec(uint8 uc_byte, uint8 uc_curHec);
extern uint8   CalcHeaderHec(uint32 ul_header);

extern void    ScramInit();
extern void    DescramInit();
extern uint8   Scram(uint8 uc_byteIn);
extern uint8   Descram(uint8 uc_byteIn);

void  ReadFromTxRegScram(void);
void  WriteToTxRegScram(void);
void  ReadFromRxRegDescram(void);
void  WriteToRxRegDescram(void);
#endif // defined( UTILS_DEF_LOCAL )

#ifdef __cplusplus
}
#endif

#endif //_ALP_UTILS_H
