/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: corerx.h
;
;  Header file for Alphaeus clock function.
;
*****************************************************************************/

#ifndef _CORERX_H
#define _CORERX_H

#include "alp_typedef.h"

#ifdef __cplusplus
extern "C" {
#endif

#define RX_HUNT_RESET   0x0000
#define RX_HUNT_H1      0x0001  // head byte 1 of cell is loaded in word
#define RX_HUNT_H2      0x0002  // head byte 2 of cell is loaded in word
#define RX_HUNT_H3      0x0004  // head byte 3 of cell is loaded in word
#define RX_HUNT_H4      0x0008  // head byte 4 of cell is loaded in word
#define RX_HUNT_H       0x0010  // hec byte is loaded
#define RX_HUNT_P       0x0020  // peek byte is loaded

#define RX_CKHEC_RESET  0x0000
#define RX_CKHEC_H1     0x0001  // hec on head byte 1 is done
#define RX_CKHEC_H2     0x0002  // hec on head byte 2 is done
#define RX_CKHEC_H3     0x0004  // hec on head byte 3 is done
#define RX_CKHEC_H4     0x0008  // hec on head byte 4 is done
#define RX_CKHEC_HEC    0x0010  // hec byte is loaded

typedef enum
{
  RX_ST_HUNT,
  RX_ST_PRESYNC,
  RX_ST_SYNC
} RxCoreState_t;

extern uint16 us_RxPipelineDelay, us_RxPipelineIdx;

/////////////////////////////////////////////////////////////////////////////
//             Function Prototypes
/////////////////////////////////////////////////////////////////////////////

void  InitCoreRx(void);
uint32   CoreRx(void);
bool     HuntState(void);
bool     PreSyncState(void);
bool     SyncState(void);

void     ResetToHunt(void);
void  GoToPreSync(void);
void  GoToSync(void);

void  ProcessHeaderByte(uint8 uc_HeaderByte);
void  ProcessHECByte(uint8 uc_HECByte);
uint8    ProcessPayloadByte(uint8 uc_PayloadByte);

void     GetShiftedData(uint32 *ul_w, uint8 *uc_b1, uint8 *uc_b2);
bool     GetByte(uint8 *puc_byte);
bool     PeekByte(uint8 *puc_byte);
void  FlushPeekByte(void);
void  WriteRxCellByte(uint8 uc_byte);

void  Set_RxPipelineDelay(uint8 uc_bc, uint16 us_delay);
uint8    RxPipeline(uint8 uc_byte, uint8 uc_shift, uint8 uc_peekonly);


void  ReadFromRxRegGSM(void);
void  WriteToRxRegGSM(void);
void  ResetRxStateReg(void);

#ifdef __cplusplus
}
#endif

#endif //_CORERX_H
