/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: mem.h
;
;  Functions for accessing Alphaeus cell buffers and registers.
;
*****************************************************************************/

#ifndef _MEM_H
#define _MEM_H

#include "alp_typedef.h"

extern uint8   uc_TXDONE,  uc_RXDONE;

#ifdef __cplusplus
extern "C" {
#endif


/* Global Variables */
extern uint8 guc_TxBC, guc_RxBC; // BC = bearer channel
extern uint8 uca_ALPHA[], uca_DELTA[];
extern uint8 uca_TXCLAV_x[], uca_RXCLAV_x[];
extern uint8 uca_TXPAGE_x[], uca_RXPAGE_x[];
extern uint8 uca_TXCB_NPAGES[], uca_RXCB_NPAGES[];
extern uint8 uc_RXDCP_FULL, uc_TXDCP_EMPTY;
extern uint8 uca_TXNO_IDLE_HEAD[];
extern uint8 uc_DCP_ENA, uc_DCP_CHK_DIS;
extern uint16     us_VCI, us_VPI;
extern DCPCell_t  t_TxDCPCell, t_RxDCPCell, t_TempRxDCPCell;

/* DSP interface */
void AlphaeusMemoryReset(void);
void SetTxFrameBuffer(uint8 *puca_TxFrameBuffer);
void SetRxFrameBuffer(uint8 *puca_RxFrameBuffer);

/* Internal Alphaeus interface */
/* ----- Registers ----- */
/* Global Registers */
// A_CFG
uint8 Read_RXENB(void);
uint8 Read_TXENB(void);

// A_STATUS
void Write_AAI_TXON(uint8 uc_value);
void Write_AAI_RXON(uint8 uc_value);

/* Tx Registers */
// AT_CNTL
uint8 Read_TX_BYTE_FLIP(void);
uint8 Read_TX_TPMODE(void);
uint8 Read_TX_SCRMENA(void);

// AT_FB_START, AT_FB_END
uint16 Read_AT_FB_SIZE(void);

// AT_CB_STAT - Reads\Writes
uint8 Read_TXCELLRDY(uint8 uc_bc);
void Assert_TXCELLRDY(void);
void Reset_TXCELLRDY(void);
uint8 Read_TXPAGE(void);
uint16 Read_TX_PGFULL(void);
void Set_TX_PGFULL(uint16 us_mask);
void Reset_TX_PGFULL(uint16 us_mask);
void Write_TXSEND(uint8 uc_bc);
void Check_TXSEND(void);

// AT_CELL
void Incr_TX_CELL_CNT(void);

// AT_IDLE_CNT
void Incr_TX_IDLE_CNT(void);

// AT_IDLE
uint8 Read_TX_IDLE_PL(void);

// Rx Register
// AR_CNTL
uint8 Read_INSERT_IMAHEC(void);
uint8 Read_IMA_ENA(void);
// AR_IMAHEC
uint8 Read_IMA_BADHEC(void);
uint8 Read_IMA_GOODHEC(void);

void ATMSyncLost(void);

void Write_ATM_ERR(uint8 uc_value);
uint8 Read_ATM_ERR(void);
void Set_ATM_ERR(void);
void Reset_ATM_ERR(void);

uint8 Read_RXIDLEKEEP(void);
uint8 Read_RX_DESCRMENA(void);
uint8 Read_RX_BYTE_FLIP(void);
uint8 Read_RX_TPMODE(void);

// AR_FB_START, AT_FB_END
uint16 Read_AR_FB_SIZE(void);

// AR_CB_STAT - Reads
uint8 Read_RXCELLRDY(uint8 uc_bc);
void Assert_RXCELLRDY(void);
uint8 Read_RXPAGE(void);
void Write_RXCLEAR(uint8 uc_bc);
void Check_RXCLEAR(void);

// AR_CELL
void Incr_RX_CELL_CNT(void);

// AR_IDLE_CNT
void Incr_RX_IDLE_CNT(void);

// AR_AIDLE_CNT
void Incr_ATM_IDLE_CNT(void);

// AR_BE_CNT
void Incr_BIT_ERR_CNT(void);
void CompareIdleBitError(uint8 uc_byte);
double Compute_BER(uint8 uc_bc);

// AR_ERR_CNT
void Incr_CD_CNT(void);
void Incr_HEC_ERR_CNT(void);

// AR_DELIN
uint8 Read_ALPHA(void);
uint8 Read_DELTA(void);

// AR_CURPG
uint16 Read_RX_PGFULL(void);
void Set_RX_PGFULL(uint16 us_mask);
void Reset_RX_PGFULL(uint16 us_mask);

// AT_CURPG
uint16 Read_TX_PGFULL(void);
void Set_TX_PGFULL(uint16 us_mask);
void Reset_TX_PGFULL(uint16 us_mask);

// Cell buffer page indexes for ATM processes
uint8 Read_AAITXCURPG(void);
void Incr_AAITXCURPG(void);
uint8 Read_AAIRXCURPG(void);
void Incr_AAIRXCURPG(void);

/* ----- Cell buffers ----- */
void ResetTxCellBuffer();
void ResetRxCellBuffer();

// Internal Representation Functions
Cell_t* Get_TxCellPage(uint8 uc_num);
Cell_t* Get_RxCellPage(uint8 uc_num);

// External Representation Functions
// Read
uint32 ReadRXCBLongWord(uint8 uc_bc, uint16 us_page, uint16 us_WordIdx);
// Write
void WriteTXCBLongWord(uint32 ul_data, uint8 uc_bc, uint16 us_page, uint16 us_WordIdx);

// A_PFLAGS
void Write_RXHECERR(uint8 uc_value);
uint8 Read_SYNCLOSS(void);
void Set_SYNCLOSS(void);
void Update_PFLAGS(void);

// A_PDONE
uint8 Read_RXDONE(void);
void Write_RXDONE(uint8 uc_value);
uint8 Read_TXDONE(void);
void Write_TXDONE(uint8 uc_value);

uint8 Read_AAI_GORX(void);
void Set_AAI_GORX(uint8 uc_active);
uint8 Read_GORX_SEL(void);
uint8 Read_AAI_GOTX(void);
void Set_AAI_GOTX(uint8 uc_active);
uint8 Read_GOTX_SEL(void);

uint8 Read_TXCB_NPAGES(uint8 uc_bc);
uint8 Read_RXCB_NPAGES(uint8 uc_bc);
uint8 Read_TX_PSTM_MODE(void);
uint8 Read_RX_PSTM_MODE(void);
uint8 Read_TXIFMODE(uint8 uc_bc);
uint8 Read_RXIFMODE(uint8 uc_bc);

uint16 ReadRxPgReadyDSP(void);
void SetRxPgReadyDSP(uint8 uc_bc, uint16 us_mask);
void ResetRxPgReadyDSP(uint8 uc_bc, uint16 us_mask);

uint16 ReadTxPgReadyDSP(void);
void SetTxPgReadyDSP(uint8 uc_bc, uint16 us_mask);
void ResetTxPgReadyDSP(uint8 uc_bc, uint16 us_mask);

uint8 Read_UTP_ADDR(uint8 uc_bc);
uint8 Read_DCP_ADDR(void);

#ifdef __cplusplus
}
#endif

#endif // _MEM_H
