/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: ele_const.h
*
*   This file contains constant definitions for the Electra BM.
*
*-------------------------------------------------------------------------------
*/

#ifndef _ELE_CONST_H
#define _ELE_CONST_H

//Flags
#ifndef TRUE
#define TRUE      (1)
#endif

#ifndef FALSE
#define FALSE     (0)
#endif


// Byte masks
#define ELE_BYTE0_MASK     (0x000000FF)
#define ELE_BYTE1_MASK     (0x0000FF00)
#define ELE_BYTE2_MASK     (0x00FF0000)
#define ELE_BYTE3_MASK     (0xFF000000)
#define ELE_LOWER_WORD_MASK   (ELE_BYTE1_MASK | ELE_BYTE0_MASK)
#define ELE_UPPER_WORD_MASK   (ELE_BYTE3_MASK | ELE_BYTE2_MASK)
#define ELE_LONGWORD_MASK  (ELE_UPPER_WORD_MASK | ELE_LOWER_WORD_MASK)

// Byte enable masks
#define ELE_NO_BYTE_EN     (0x0)
#define ELE_BYTE0_EN    (0x1)
#define ELE_BYTE1_EN    (0x2)
#define ELE_BYTE2_EN    (0x4)
#define ELE_BYTE3_EN    (0x8)
#define ELE_LOWER_WORD_EN  (ELE_BYTE1_EN | ELE_BYTE0_EN)
#define ELE_UPPER_WORD_EN  (ELE_BYTE3_EN | ELE_BYTE2_EN)
#define ELE_LONGWORD_EN    (ELE_UPPER_WORD_EN | ELE_LOWER_WORD_EN)

// Register bit masks
#define ELE_MASK_BIT0      (0x00000001)
#define ELE_MASK_BIT1      (0x00000002)
#define ELE_MASK_BIT2      (0x00000004)
#define ELE_MASK_BIT3      (0x00000008)
#define ELE_MASK_BIT4      (0x00000010)
#define ELE_MASK_BIT5      (0x00000020)
#define ELE_MASK_BIT6      (0x00000040)
#define ELE_MASK_BIT7      (0x00000080)
#define ELE_MASK_BIT8      (0x00000100)
#define ELE_MASK_BIT9      (0x00000200)
#define ELE_MASK_BIT10     (0x00000400)
#define ELE_MASK_BIT11     (0x00000800)
#define ELE_MASK_BIT12     (0x00001000)
#define ELE_MASK_BIT13     (0x00002000)
#define ELE_MASK_BIT14     (0x00004000)
#define ELE_MASK_BIT15     (0x00008000)
#define ELE_MASK_BIT16     (0x00010000)
#define ELE_MASK_BIT17     (0x00020000)
#define ELE_MASK_BIT18     (0x00040000)
#define ELE_MASK_BIT19     (0x00080000)
#define ELE_MASK_BIT20     (0x00100000)
#define ELE_MASK_BIT21     (0x00200000)
#define ELE_MASK_BIT22     (0x00400000)
#define ELE_MASK_BIT23     (0x00800000)
#define ELE_MASK_BIT24     (0x01000000)
#define ELE_MASK_BIT25     (0x02000000)
#define ELE_MASK_BIT26     (0x04000000)
#define ELE_MASK_BIT27     (0x08000000)
#define ELE_MASK_BIT28     (0x10000000)
#define ELE_MASK_BIT29     (0x20000000)
#define ELE_MASK_BIT30     (0x40000000)
#define ELE_MASK_BIT31     (0x80000000)


#endif //_ELE_CONST_H
