/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: ele_memmap.h
*
*   This file contains Electra BM memory map.
*
*-------------------------------------------------------------------------------
*/

#ifndef _ELE_MEMMAP_H
#define _ELE_MEMMAP_H

//=============================================================================
//Electra RAM block map
//=============================================================================
#define ELE_RAM_TX_PTM_FIFO_ADDR       (0x0000D000)
#define ELE_RAM_RX_PTM_FIFO_ADDR       (0x0000C800)

//============================================================================
// Sizes for Electra RAM block
//============================================================================
#define ELE_RAM_TX_PTM_FIFO_SIZE       (1160)      //number of 32-bit words
#define ELE_RAM_RX_PTM_FIFO_SIZE       (1160)      //number of 32-bit words

//==============================================================================
// Electra Register Map
//==============================================================================

//Register physical address
#define  ELE_REG_BASE_ADDR             (0x0000C300)

#define  ELE_REG_E_CONFIG_ADDR            (ELE_REG_BASE_ADDR+0x00)
#define  ELE_REG_E_CTRL_ADDR              (ELE_REG_BASE_ADDR+0x01)
#define  ELE_REG_E_HDLC_CTRL_ADDR         (ELE_REG_BASE_ADDR+0x02)
#define  ELE_REG_E_EFM_CHAR_ADDR          (ELE_REG_BASE_ADDR+0x03)
#define  ELE_REG_E_TXFIFO_PTR_ADDR        (ELE_REG_BASE_ADDR+0x04)
#define  ELE_REG_E_TX_FRMCNT_ADDR         (ELE_REG_BASE_ADDR+0x05)
#define  ELE_REG_E_TX_PKT_LEN_ADDR        (ELE_REG_BASE_ADDR+0x06)
#define  ELE_REG_E_TX_CRC_ADDR            (ELE_REG_BASE_ADDR+0x07)
#define  ELE_REG_E_RXFIFO_PTR_ADDR        (ELE_REG_BASE_ADDR+0x08)
#define  ELE_REG_E_RX_FRMCNT_ADDR         (ELE_REG_BASE_ADDR+0x09)
#define  ELE_REG_E_RX_PKT_LEN_ADDR        (ELE_REG_BASE_ADDR+0x0A)
#define  ELE_REG_E_RX_CRC_ADDR            (ELE_REG_BASE_ADDR+0x0B)
#define  ELE_REG_E_IDLE_STAT_ADDR         (ELE_REG_BASE_ADDR+0x0C)
#define  ELE_REG_MII_CTRL_ADDR            (ELE_REG_BASE_ADDR+0x10)
#define  ELE_REG_MII_STAT_ADDR            (ELE_REG_BASE_ADDR+0x11)
#define  ELE_REG_MII_PHY_ID0_ADDR         (ELE_REG_BASE_ADDR+0x12)
#define  ELE_REG_MII_PHY_ID1_ADDR         (ELE_REG_BASE_ADDR+0x13)
#define ELE_REG_AUTO_NEG_PROCESS_ADDR     (ELE_REG_BASE_ADDR+0x14)   //0x14-0x18 (not supported)
#define ELE_REG_AUTO_NEG_PROCESS1_ADDR    (ELE_REG_BASE_ADDR+0x15)
#define ELE_REG_AUTO_NEG_PROCESS2_ADDR    (ELE_REG_BASE_ADDR+0x16)
#define ELE_REG_AUTO_NEG_PROCESS3_ADDR    (ELE_REG_BASE_ADDR+0x17)
#define ELE_REG_AUTO_NEG_PROCESS4_ADDR    (ELE_REG_BASE_ADDR+0x18)
#define  ELE_REG_MASTER_SLAVE_ADDR        (ELE_REG_BASE_ADDR+0x19)   //0x19-0x1A (not supported)
#define  ELE_REG_MASTER_SLAVE1_ADDR       (ELE_REG_BASE_ADDR+0x1A)
#define  ELE_REG_PSE_CTRL_ADDR            (ELE_REG_BASE_ADDR+0x1B)   //0x1B-0x1C (not supported)
#define  ELE_REG_PSE_CTRL1_ADDR           (ELE_REG_BASE_ADDR+0x1C)
#define  ELE_REG_MMD_CTRL_ADDR            (ELE_REG_BASE_ADDR+0x1D)
#define  ELE_REG_MMD_ADR_DATA_ADDR        (ELE_REG_BASE_ADDR+0x1E)

//0x1F, reserved
#define ELE_REG_TC_CTRL_ADDR           (ELE_REG_BASE_ADDR+0x20)

//0x21 reserved

#define ELE_REG_TC_ID0_ADDR               (ELE_REG_BASE_ADDR+0x22)
#define ELE_REG_TC_ID1_ADDR               (ELE_REG_BASE_ADDR+0x23)
#define ELE_REG_TC_SPEED_ABILITY_ADDR     (ELE_REG_BASE_ADDR+0x24)
#define ELE_REG_TC_DEVICES_0_ADDR         (ELE_REG_BASE_ADDR+0x25)
#define ELE_REG_TC_DEVICES_1_ADDR         (ELE_REG_BASE_ADDR+0x26)

//0x27-0x2D, reserved

#define ELE_REG_TC_PKG_ID0_ADDR           (ELE_REG_BASE_ADDR+0x2E)
#define ELE_REG_TC_PKG_ID1_ADDR           (ELE_REG_BASE_ADDR+0x2F)
#define ELE_REG_TC_AGG_DIS_CTRL_ADDR      (ELE_REG_BASE_ADDR+0x30)   //(not supported)
#define ELE_REG_TC_AGG_DIS_STAT_ADDR      (ELE_REG_BASE_ADDR+0x31)   //(not supported)
#define ELE_REG_TC_AGG_DIS_CODE_ADDR      (ELE_REG_BASE_ADDR+0x32)   //0x32-0x34 (not supported)
#define ELE_REG_TC_AGG_DIS_CODE1_ADDR     (ELE_REG_BASE_ADDR+0x33)
#define ELE_REG_TC_AGG_DIS_CODE2_ADDR     (ELE_REG_BASE_ADDR+0x34)

#define ELE_REG_TC_LK_AGG_CTRL_ADDR       (ELE_REG_BASE_ADDR+0x35)   //(not supported)
#define ELE_REG_TC_LK_AGG_DATA_ADDR       (ELE_REG_BASE_ADDR+0x36)   //0x36-0x37 (not supported)
#define ELE_REG_TC_LK_AGG_DATA1_ADDR      (ELE_REG_BASE_ADDR+0x37)
#define ELE_REG_TC_RX_CRC_ERR_ADDR        (ELE_REG_BASE_ADDR+0x38)
#define ELE_REG_TC_RX_CODE_ERR_L_ADDR     (ELE_REG_BASE_ADDR+0x39)
#define ELE_REG_TC_RX_CODE_ERR_M_ADDR     (ELE_REG_BASE_ADDR+0x3A)
#define ELE_REG_TC_RX_TC_SYNC_ADDR        (ELE_REG_BASE_ADDR+0x3B)

//0x3C-0x7F reserved

#define  ELE_REG_PCS_CTRL_ADDR            (ELE_REG_BASE_ADDR+0x80)
#define  ELE_REG_PCS_STAT_ADDR            (ELE_REG_BASE_ADDR+0x81)
#define  ELE_REG_PCS_ID0_ADDR          (ELE_REG_BASE_ADDR+0x82)
#define  ELE_REG_PCS_ID1_ADDR          (ELE_REG_BASE_ADDR+0x83)
#define  ELE_REG_PCS_SPEED_ABILITY_ADDR      (ELE_REG_BASE_ADDR+0x84)
#define  ELE_REG_PCS_DEVICES_0_ADDR       (ELE_REG_BASE_ADDR+0x85)
#define  ELE_REG_PCS_DEVICES_1_ADDR       (ELE_REG_BASE_ADDR+0x86)
#define  ELE_REG_PCS_10G_CTRL_ADDR        (ELE_REG_BASE_ADDR+0x87)   //(not supported)
#define  ELE_REG_PCS_10G_STAT_ADDR        (ELE_REG_BASE_ADDR+0x88)   //(not supported)

//0x89-0x8D, reserved

#define  ELE_REG_PCS_PKG_ID0_ADDR         (ELE_REG_BASE_ADDR+0x8E)
#define  ELE_REG_PCS_PKG_ID1_ADDR         (ELE_REG_BASE_ADDR+0x8F)

//0x90-0x97, reserved

#define ELE_REG_PCS_10GX_STAT_ADDR        (ELE_REG_BASE_ADDR+0x98)   //(not supported)
#define ELE_REG_PCS_10GX_CTRL_ADDR        (ELE_REG_BASE_ADDR+0x99)   //(not supported)

//0x9A-0x9F, reserved

#define ELE_REG_PCS_10GR_STAT_ADDR        (ELE_REG_BASE_ADDR+0xA0)   //(not supported)
#define ELE_REG_PCS_10GR_CTRL_ADDR        (ELE_REG_BASE_ADDR+0xA1)   //(not supported)

#define ELE_REG_PCS_10GR_TEST_ADDR        (ELE_REG_BASE_ADDR+0xA2)   //0xA2-0xAB (not supported)
#define ELE_REG_PCS_10GR_TEST1_ADDR       (ELE_REG_BASE_ADDR+0xA3)
#define ELE_REG_PCS_10GR_TEST2_ADDR       (ELE_REG_BASE_ADDR+0xA4)
#define ELE_REG_PCS_10GR_TEST3_ADDR       (ELE_REG_BASE_ADDR+0xA5)
#define ELE_REG_PCS_10GR_TEST4_ADDR       (ELE_REG_BASE_ADDR+0xA6)
#define ELE_REG_PCS_10GR_TEST5_ADDR       (ELE_REG_BASE_ADDR+0xA7)
#define ELE_REG_PCS_10GR_TEST6_ADDR       (ELE_REG_BASE_ADDR+0xA8)
#define ELE_REG_PCS_10GR_TEST7_ADDR       (ELE_REG_BASE_ADDR+0xA9)
#define ELE_REG_PCS_10GR_TEST8_ADDR       (ELE_REG_BASE_ADDR+0xAA)
#define ELE_REG_PCS_10GR_TEST9_ADDR       (ELE_REG_BASE_ADDR+0xAB)

//0xAC-0xBB, reserved

#define ELE_REG_PCS_10P2B_ABILITY_ADDR    (ELE_REG_BASE_ADDR+0xBC)
#define ELE_REG_PCS_10P2B_CTRL_ADDR       (ELE_REG_BASE_ADDR+0xBD)
#define ELE_REG_PCS_PME_AVAIL_ADDR        (ELE_REG_BASE_ADDR+0xBE)   //0xBE-0xBF (not supported)
#define ELE_REG_PCS_PME_AVAIL1_ADDR       (ELE_REG_BASE_ADDR+0xBF)
#define ELE_REG_PCS_PME_AGG_ADDR       (ELE_REG_BASE_ADDR+0xC0)   //0xC0-0xC1 (not supported)
#define ELE_REG_PCS_PME_AGG1_ADDR         (ELE_REG_BASE_ADDR+0xC1)
#define ELE_REG_PCS_PAF_RX_ERR_ADDR       (ELE_REG_BASE_ADDR+0xC2)   //(not supported)
#define ELE_REG_PCS_PAF_SM_FRAG_ADDR      (ELE_REG_BASE_ADDR+0xC3)   //(not supported)
#define ELE_REG_PCS_PAF_LG_FRAG_ADDR      (ELE_REG_BASE_ADDR+0xC4)   //(not supported)
#define ELE_REG_PCS_PAF_OVF_ADDR       (ELE_REG_BASE_ADDR+0xC5)   //(not supported)
#define ELE_REG_PCS_PAF_BAD_FRAG_ADDR     (ELE_REG_BASE_ADDR+0xC6)   //(not supported)
#define ELE_REG_PCS_PAF_LST_FRAG_ADDR     (ELE_REG_BASE_ADDR+0xC7)   //(not supported)
#define ELE_REG_PCS_PAF_LST_SOF_ADDR      (ELE_REG_BASE_ADDR+0xC8)   //(not supported)
#define ELE_REG_PCS_PAF_LST_EOF_ADDR      (ELE_REG_BASE_ADDR+0xC9)   //(not supported)

//============================================================================
// Electra RAM Register Masks (mask off bits which are read-only)
//============================================================================
#define ELE_RAM_TX_PTM_FIFO_MASK       (0xFFFFFFFF)
#define ELE_RAM_RX_PTM_FIFO_MASK       (0xFFFFFFFF)

#define  ELE_REG_E_CONFIG_MASK            (0x00003FFF)
#define  ELE_REG_E_CTRL_MASK              (0x0000000F)
#define  ELE_REG_E_HDLC_CTRL_MASK         (0x0000FFFF)
#define  ELE_REG_E_EFM_CHAR_MASK          (0xFFFFFFFF)
#define  ELE_REG_E_TXFIFO_PTR_MASK        (0xFFFFFFFF)
#define  ELE_REG_E_TX_FRMCNT_MASK         (0xFFFFFFFF)
#define  ELE_REG_E_TX_PKT_LEN_MASK        (0x00000000)
#define  ELE_REG_E_TX_CRC_MASK            (0x00000000)
#define  ELE_REG_E_RXFIFO_PTR_MASK        (0xFFFFFFFF)
#define  ELE_REG_E_RX_FRMCNT_MASK         (0xFFFFFFFF)
#define  ELE_REG_E_RX_PKT_LEN_MASK        (0x00000000)
#define  ELE_REG_E_RX_CRC_MASK            (0x00000000)
#define  ELE_REG_E_IDLE_STAT_MASK         (0x00000000)

#define  ELE_REG_MII_CTRL_MASK            (0x0000AD80)
#define  ELE_REG_MII_STAT_MASK            (0x00000016)
#define  ELE_REG_MII_PHY_ID0_MASK         (0x0000FFFF)
#define  ELE_REG_MII_PHY_ID1_MASK         (0x0000FFFF)
#define ELE_REG_AUTO_NEG_PROCESS_MASK     (0x00000000)   //0x14-0x18 (not supported)
#define ELE_REG_AUTO_NEG_PROCESS1_MASK    (0x00000000)
#define ELE_REG_AUTO_NEG_PROCESS2_MASK    (0x00000000)
#define ELE_REG_AUTO_NEG_PROCESS3_MASK    (0x00000000)
#define ELE_REG_AUTO_NEG_PROCESS4_MASK    (0x00000000)
#define  ELE_REG_MASTER_SLAVE_MASK        (0x00000000)   //0x19-0x1A (not supported)
#define  ELE_REG_MASTER_SLAVE1_MASK       (0x00000000)
#define  ELE_REG_PSE_CTRL_MASK            (0x00000000)   //0x1B-0x1C (not supported)
#define  ELE_REG_PSE_CTRL1_MASK           (0x00000000)
#define  ELE_REG_MMD_CTRL_MASK            (0x0000C01F)
#define  ELE_REG_MMD_ADR_DATA_MASK        (0x0000FFFF)

#define ELE_REG_TC_CTRL_MASK           (0x00008000)
#define ELE_REG_TC_ID0_MASK               (0x0000FFFF)
#define ELE_REG_TC_ID1_MASK               (0x0000FFFF)
#define ELE_REG_TC_SPEED_ABILITY_MASK     (0x00000000)
#define ELE_REG_TC_DEVICES_0_MASK         (0x00000000)
#define ELE_REG_TC_DEVICES_1_MASK         (0x00000000)
#define ELE_REG_TC_PKG_ID0_MASK           (0x0000FFFF)
#define ELE_REG_TC_PKG_ID1_MASK           (0x0000FFFF)
#define ELE_REG_TC_AGG_DIS_CTRL_MASK      (0x00000000)   //(not supported)
#define ELE_REG_TC_AGG_DIS_STAT_MASK      (0x00000000)   //(not supported)
#define ELE_REG_TC_AGG_DIS_CODE_MASK      (0x00000000)   //0x32-0x34 (not supported)
#define ELE_REG_TC_AGG_DIS_CODE1_MASK     (0x00000000)
#define ELE_REG_TC_AGG_DIS_CODE2_MASK     (0x00000000)
#define ELE_REG_TC_LK_AGG_CTRL_MASK       (0x00000000)   //(not supported)
#define ELE_REG_TC_LK_AGG_DATA_MASK       (0x00000000)   //0x39-0x3A (not supported)
#define ELE_REG_TC_LK_AGG_DATA1_MASK      (0x00000000)
#define ELE_REG_TC_RX_CRC_ERR_MASK        (0x0000FFFF)
#define ELE_REG_TC_RX_CODE_ERR_L_MASK     (0x0000FFFF)
#define ELE_REG_TC_RX_CODE_ERR_M_MASK     (0x0000FFFF)
#define ELE_REG_TC_RX_TC_SYNC_MASK        (0x00000001)

#define  ELE_REG_PCS_CTRL_MASK            (0x00008800)
#define  ELE_REG_PCS_STAT_MASK            (0x00000084)
#define  ELE_REG_PCS_ID0_MASK          (0x0000FFFF)
#define  ELE_REG_PCS_ID1_MASK          (0x0000FFFF)
#define  ELE_REG_PCS_SPEED_ABILITY_MASK      (0x00000000)
#define  ELE_REG_PCS_DEVICES_0_MASK       (0x00000000)
#define  ELE_REG_PCS_DEVICES_1_MASK       (0x00000000)
#define  ELE_REG_PCS_10G_CTRL_MASK        (0x00000000)   //(not supported)
#define  ELE_REG_PCS_10G_STAT_MASK        (0x00000000)   //(not supported)
#define  ELE_REG_PCS_PKG_ID0_MASK         (0x0000FFFF)
#define  ELE_REG_PCS_PKG_ID1_MASK         (0x0000FFFF)
#define ELE_REG_PCS_10GX_STAT_MASK        (0x00000000)   //(not supported)
#define ELE_REG_PCS_10GX_CTRL_MASK        (0x00000000)   //(not supported)
#define ELE_REG_PCS_10GR_STAT_MASK        (0x00000000)   //(not supported)
#define ELE_REG_PCS_10GR_CTRL_MASK        (0x00000000)   //(not supported)
#define ELE_REG_PCS_10GR_TEST_MASK        (0x00000000)   //0xA2-0xAB (not supported)
#define ELE_REG_PCS_10GR_TEST1_MASK       (0x00000000)
#define ELE_REG_PCS_10GR_TEST2_MASK       (0x00000000)                                             //0x4C-0x5B, reserved
#define ELE_REG_PCS_10GR_TEST3_MASK       (0x00000000)
#define ELE_REG_PCS_10GR_TEST4_MASK       (0x00000000)
#define ELE_REG_PCS_10GR_TEST5_MASK       (0x00000000)                                             //0x4C-0x5B, reserved
#define ELE_REG_PCS_10GR_TEST6_MASK       (0x00000000)
#define ELE_REG_PCS_10GR_TEST7_MASK       (0x00000000)
#define ELE_REG_PCS_10GR_TEST8_MASK       (0x00000000)                                             //0x4C-0x5B, reserved
#define ELE_REG_PCS_10GR_TEST9_MASK       (0x00000000)
#define ELE_REG_PCS_10P2B_ABILITY_MASK    (0x00000000)
#define ELE_REG_PCS_10P2B_CTRL_MASK       (0x0000C000)

#define ELE_REG_PCS_PME_AVAIL_MASK        (0x00000000)   //0xBE-0xBF (not supported)
#define ELE_REG_PCS_PME_AVAIL1_MASK       (0x00000000)
#define ELE_REG_PCS_PME_AGG_MASK       (0x00000000)   //0xC0-0xC1 (not supported)
#define ELE_REG_PCS_PME_AGG1_MASK         (0x00000000)
#define ELE_REG_PCS_PAF_RX_ERR_MASK       (0x00000000)   //(not supported)
#define ELE_REG_PCS_PAF_SM_FRAG_MASK      (0x00000000)   //(not supported)
#define ELE_REG_PCS_PAF_LG_FRAG_MASK      (0x00000000)   //(not supported)
#define ELE_REG_PCS_PAF_OVF_MASK       (0x00000000)   //(not supported)
#define ELE_REG_PCS_PAF_BAD_FRAG_MASK     (0x00000000)   //(not supported)
#define ELE_REG_PCS_PAF_LST_FRAG_MASK     (0x00000000)   //(not supported)
#define ELE_REG_PCS_PAF_LST_SOF_MASK      (0x00000000)   //(not supported)
#define ELE_REG_PCS_PAF_LST_EOF_MASK      (0x00000000)   //(not supported)



#endif // _ELE_MEMMAP_H
