/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: ele_private.h
*
*   This file contains private functions and variables which are visible
*   by the Electra BM only.
*
*-------------------------------------------------------------------------------
*/

#ifndef _ELE_PRIVATE_H
#define _ELE_PRIVATE_H

#include "ele_typedef.h"
#include "ele_const.h"
#include "ele_ram.h"

//==============================================================================
// ELectra private variables
//==============================================================================
// Electra RAM arrays based on the RAM/REG ID
extern uint32 *gula_ELE_RAM_VirtualBaseAddr[ELE_MAX_RAM_ID+1];
extern uint32 gula_ELE_RAM_PhysBaseAddr[ELE_MAX_ID+1];
extern uint32 gula_ELE_RAM_Size[ELE_MAX_RAM_ID+1];
extern uint32 gula_ELE_RAM_Mask[ELE_MAX_RAM_ID+1];

// Electra RAM blocks and their respective aligned RAM pointers
extern uint32 gula_ELE_RAM_TxPtmFifo[ELE_RAM_TX_PTM_FIFO_SIZE];
extern uint32 *gpula_ELE_RAM_TxPtmFifo;

extern uint32 gula_ELE_RAM_RxPtmFifo[ELE_RAM_RX_PTM_FIFO_SIZE];
extern uint32 *gpula_ELE_RAM_RxPtmFifo;

extern ELE_Register_t gt_ELE_Register;

//==============================================================================
// ELectra private functions
//==============================================================================

// ELectra RAM functions
int32 ELE_WriteWordVirtualAddr(int16 s_RamName, uint32 ul_offset,  uint32 ul_data);
int32 ELE_ReadWordVirtualAddr(int16 s_RamName, uint32 ul_offset, uint32 *pul_data);
void ELE_MapRAM(uint32 ul_addr, int16 *ps_RAM_id, uint32 *pul_Offset);

//from ele_init.c
void ELE_SetMemoryMap(void);
void ELE_ResetRegisters(void);
#endif // _QT_PRIVATE_H
