/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: ele_ram.h
*
*   Header file for Eelectra RAM blocks.
*
*-------------------------------------------------------------------------------
*/

#ifndef _ELE_RAM_H
#define _ELE_RAM_H

#include "ele_memmap.h"


#define ELE_MIN_ID                     (0)

//============================================================================
// Electra RAM block IDs
//============================================================================
#define  ELE_MIN_RAM_ID                (ELE_MIN_ID)

#define ELE_RAM_TX_PTM_FIFO_ID            (ELE_MIN_RAM_ID+0)
#define ELE_RAM_RX_PTM_FIFO_ID            (ELE_MIN_RAM_ID+1)

#define  ELE_MAX_RAM_ID                (ELE_RAM_RX_PTM_FIFO_ID)


//=============================================================================
// Electra Register IDs
//=============================================================================

#define  ELE_MIN_REG_ID                (ELE_MAX_RAM_ID+1)

#define  ELE_REG_E_CONFIG_ID              (ELE_MIN_REG_ID+ELE_REG_E_CONFIG_ADDR-ELE_REG_BASE_ADDR)
#define  ELE_REG_E_CTRL_ID             (ELE_MIN_REG_ID+ELE_REG_E_CTRL_ADDR-ELE_REG_BASE_ADDR)
#define  ELE_REG_E_HDLC_CTRL_ID           (ELE_MIN_REG_ID+ELE_REG_E_HDLC_CTRL_ADDR-ELE_REG_BASE_ADDR)
#define  ELE_REG_E_EFM_CHAR_ID            (ELE_MIN_REG_ID+ELE_REG_E_EFM_CHAR_ADDR-ELE_REG_BASE_ADDR)
#define  ELE_REG_E_TXFIFO_PTR_ID          (ELE_MIN_REG_ID+ELE_REG_E_TXFIFO_PTR_ADDR-ELE_REG_BASE_ADDR)
#define  ELE_REG_E_TX_FRMCNT_ID           (ELE_MIN_REG_ID+ELE_REG_E_TX_FRMCNT_ADDR-ELE_REG_BASE_ADDR)
#define  ELE_REG_E_TX_PKT_LEN_ID          (ELE_MIN_REG_ID+ELE_REG_E_TX_PKT_LEN_ADDR-ELE_REG_BASE_ADDR)
#define  ELE_REG_E_TX_CRC_ID              (ELE_MIN_REG_ID+ELE_REG_E_TX_CRC_ADDR-ELE_REG_BASE_ADDR)
#define  ELE_REG_E_RXFIFO_PTR_ID          (ELE_MIN_REG_ID+ELE_REG_E_RXFIFO_PTR_ADDR-ELE_REG_BASE_ADDR)
#define  ELE_REG_E_RX_FRMCNT_ID           (ELE_MIN_REG_ID+ELE_REG_E_RX_FRMCNT_ADDR-ELE_REG_BASE_ADDR)
#define  ELE_REG_E_RX_PKT_LEN_ID          (ELE_MIN_REG_ID+ELE_REG_E_RX_PKT_LEN_ADDR-ELE_REG_BASE_ADDR)
#define  ELE_REG_E_RX_CRC_ID              (ELE_MIN_REG_ID+ELE_REG_E_RX_CRC_ADDR-ELE_REG_BASE_ADDR)
#define  ELE_REG_E_IDLE_STAT_ID           (ELE_MIN_REG_ID+ELE_REG_E_IDLE_STAT_ADDR-ELE_REG_BASE_ADDR)

#define  ELE_REG_MII_CTRL_ID              (ELE_MIN_REG_ID+ELE_REG_MII_CTRL_ADDR-ELE_REG_BASE_ADDR)
#define  ELE_REG_MII_STAT_ID              (ELE_MIN_REG_ID+ELE_REG_MII_STAT_ADDR-ELE_REG_BASE_ADDR)
#define  ELE_REG_MII_PHY_ID0_ID           (ELE_MIN_REG_ID+ELE_REG_MII_PHY_ID0_ADDR-ELE_REG_BASE_ADDR)
#define  ELE_REG_MII_PHY_ID1_ID           (ELE_MIN_REG_ID+ELE_REG_MII_PHY_ID1_ADDR-ELE_REG_BASE_ADDR)
#define ELE_REG_AUTO_NEG_PROCESS_ID       (ELE_MIN_REG_ID+ELE_REG_AUTO_NEG_PROCESS_ADDR-ELE_REG_BASE_ADDR)
#define ELE_REG_AUTO_NEG_PROCESS1_ID      (ELE_MIN_REG_ID+ELE_REG_AUTO_NEG_PROCESS1_ADDR-ELE_REG_BASE_ADDR)
#define ELE_REG_AUTO_NEG_PROCESS2_ID      (ELE_MIN_REG_ID+ELE_REG_AUTO_NEG_PROCESS2_ADDR-ELE_REG_BASE_ADDR)
#define ELE_REG_AUTO_NEG_PROCESS3_ID      (ELE_MIN_REG_ID+ELE_REG_AUTO_NEG_PROCESS3_ADDR-ELE_REG_BASE_ADDR)
#define ELE_REG_AUTO_NEG_PROCESS4_ID      (ELE_MIN_REG_ID+ELE_REG_AUTO_NEG_PROCESS4_ADDR-ELE_REG_BASE_ADDR)
#define  ELE_REG_MASTER_SLAVE_ID          (ELE_MIN_REG_ID+ELE_REG_MASTER_SLAVE_ADDR-ELE_REG_BASE_ADDR)
#define  ELE_REG_MASTER_SLAVE1_ID         (ELE_MIN_REG_ID+ELE_REG_MASTER_SLAVE1_ADDR-ELE_REG_BASE_ADDR)
#define  ELE_REG_PSE_CTRL_ID              (ELE_MIN_REG_ID+ELE_REG_PSE_CTRL_ADDR-ELE_REG_BASE_ADDR)
#define  ELE_REG_PSE_CTRL1_ID          (ELE_MIN_REG_ID+ELE_REG_PSE_CTRL1_ADDR-ELE_REG_BASE_ADDR)
#define  ELE_REG_MMD_CTRL_ID              (ELE_MIN_REG_ID+ELE_REG_MMD_CTRL_ADDR-ELE_REG_BASE_ADDR)
#define  ELE_REG_MMD_ADR_DATA_ID          (ELE_MIN_REG_ID+ELE_REG_MMD_ADR_DATA_ADDR-ELE_REG_BASE_ADDR)

#define ELE_REG_TC_CTRL_ID             (ELE_MIN_REG_ID+ELE_REG_TC_CTRL_ADDR-ELE_REG_BASE_ADDR)
#define ELE_REG_TC_ID0_ID              (ELE_MIN_REG_ID+ELE_REG_TC_ID0_ADDR-ELE_REG_BASE_ADDR)
#define ELE_REG_TC_ID1_ID              (ELE_MIN_REG_ID+ELE_REG_TC_ID1_ADDR-ELE_REG_BASE_ADDR)
#define ELE_REG_TC_SPEED_ABILITY_ID       (ELE_MIN_REG_ID+ELE_REG_TC_SPEED_ABILITY_ADDR-ELE_REG_BASE_ADDR)
#define ELE_REG_TC_DEVICES_0_ID           (ELE_MIN_REG_ID+ELE_REG_TC_DEVICES_0_ADDR-ELE_REG_BASE_ADDR)
#define ELE_REG_TC_DEVICES_1_ID           (ELE_MIN_REG_ID+ELE_REG_TC_DEVICES_1_ADDR-ELE_REG_BASE_ADDR)
#define ELE_REG_TC_PKG_ID0_ID          (ELE_MIN_REG_ID+ELE_REG_TC_PKG_ID0_ADDR-ELE_REG_BASE_ADDR)
#define ELE_REG_TC_PKG_ID1_ID          (ELE_MIN_REG_ID+ELE_REG_TC_PKG_ID1_ADDR-ELE_REG_BASE_ADDR)
#define ELE_REG_TC_AGG_DIS_CTRL_ID        (ELE_MIN_REG_ID+ELE_REG_TC_AGG_DIS_CTRL_ADDR-ELE_REG_BASE_ADDR)
#define ELE_REG_TC_AGG_DIS_STAT_ID        (ELE_MIN_REG_ID+ELE_REG_TC_AGG_DIS_STAT_ADDR-ELE_REG_BASE_ADDR)
#define ELE_REG_TC_AGG_DIS_CODE_ID        (ELE_MIN_REG_ID+ELE_REG_TC_AGG_DIS_CODE_ADDR-ELE_REG_BASE_ADDR)
#define ELE_REG_TC_AGG_DIS_CODE1_ID       (ELE_MIN_REG_ID+ELE_REG_TC_AGG_DIS_CODE1_ADDR-ELE_REG_BASE_ADDR)
#define ELE_REG_TC_AGG_DIS_CODE2_ID       (ELE_MIN_REG_ID+ELE_REG_TC_AGG_DIS_CODE2_ADDR-ELE_REG_BASE_ADDR)
#define ELE_REG_TC_LK_AGG_CTRL_ID         (ELE_MIN_REG_ID+ELE_REG_TC_LK_AGG_CTRL_ADDR-ELE_REG_BASE_ADDR)
#define ELE_REG_TC_LK_AGG_DATA_ID         (ELE_MIN_REG_ID+ELE_REG_TC_LK_AGG_DATA_ADDR-ELE_REG_BASE_ADDR)
#define ELE_REG_TC_LK_AGG_DATA1_ID        (ELE_MIN_REG_ID+ELE_REG_TC_LK_AGG_DATA1_ADDR-ELE_REG_BASE_ADDR)
#define ELE_REG_TC_RX_CRC_ERR_ID       (ELE_MIN_REG_ID+ELE_REG_TC_RX_CRC_ERR_ADDR-ELE_REG_BASE_ADDR)
#define ELE_REG_TC_RX_CODE_ERR_L_ID       (ELE_MIN_REG_ID+ELE_REG_TC_RX_CODE_ERR_L_ADDR-ELE_REG_BASE_ADDR)
#define ELE_REG_TC_RX_CODE_ERR_M_ID       (ELE_MIN_REG_ID+ELE_REG_TC_RX_CODE_ERR_M_ADDR-ELE_REG_BASE_ADDR)
#define ELE_REG_TC_RX_TC_SYNC_ID       (ELE_MIN_REG_ID+ELE_REG_TC_RX_TC_SYNC_ADDR-ELE_REG_BASE_ADDR)

#define  ELE_REG_PCS_CTRL_ID              (ELE_MIN_REG_ID+ELE_REG_PCS_CTRL_ADDR-ELE_REG_BASE_ADDR)
#define  ELE_REG_PCS_STAT_ID              (ELE_MIN_REG_ID+ELE_REG_PCS_STAT_ADDR-ELE_REG_BASE_ADDR)
#define  ELE_REG_PCS_ID0_ID               (ELE_MIN_REG_ID+ELE_REG_PCS_ID0_ADDR-ELE_REG_BASE_ADDR)
#define  ELE_REG_PCS_ID1_ID               (ELE_MIN_REG_ID+ELE_REG_PCS_ID1_ADDR-ELE_REG_BASE_ADDR)
#define  ELE_REG_PCS_SPEED_ABILITY_ID     (ELE_MIN_REG_ID+ELE_REG_PCS_SPEED_ABILITY_ADDR-ELE_REG_BASE_ADDR)
#define  ELE_REG_PCS_DEVICES_0_ID         (ELE_MIN_REG_ID+ELE_REG_PCS_DEVICES_0_ADDR-ELE_REG_BASE_ADDR)
#define  ELE_REG_PCS_DEVICES_1_ID         (ELE_MIN_REG_ID+ELE_REG_PCS_DEVICES_1_ADDR-ELE_REG_BASE_ADDR)
#define  ELE_REG_PCS_10G_CTRL_ID          (ELE_MIN_REG_ID+ELE_REG_PCS_10G_CTRL_ADDR-ELE_REG_BASE_ADDR)
#define  ELE_REG_PCS_10G_STAT_ID          (ELE_MIN_REG_ID+ELE_REG_PCS_10G_STAT_ADDR-ELE_REG_BASE_ADDR)
#define  ELE_REG_PCS_PKG_ID0_ID           (ELE_MIN_REG_ID+ELE_REG_PCS_PKG_ID0_ADDR-ELE_REG_BASE_ADDR)
#define  ELE_REG_PCS_PKG_ID1_ID           (ELE_MIN_REG_ID+ELE_REG_PCS_PKG_ID1_ADDR-ELE_REG_BASE_ADDR)
#define ELE_REG_PCS_10GX_STAT_ID       (ELE_MIN_REG_ID+ELE_REG_PCS_10GX_STAT_ADDR-ELE_REG_BASE_ADDR)
#define ELE_REG_PCS_10GX_CTRL_ID       (ELE_MIN_REG_ID+ELE_REG_PCS_10GX_CTRL_ADDR-ELE_REG_BASE_ADDR)
#define ELE_REG_PCS_10GR_STAT_ID       (ELE_MIN_REG_ID+ELE_REG_PCS_10GR_STAT_ADDR-ELE_REG_BASE_ADDR)
#define ELE_REG_PCS_10GR_CTRL_ID       (ELE_MIN_REG_ID+ELE_REG_PCS_10GR_CTRL_ADDR-ELE_REG_BASE_ADDR)
#define ELE_REG_PCS_10GR_TEST_ID       (ELE_MIN_REG_ID+ELE_REG_PCS_10GR_TEST_ADDR-ELE_REG_BASE_ADDR)
#define ELE_REG_PCS_10GR_TEST1_ID         (ELE_MIN_REG_ID+ELE_REG_PCS_10GR_TEST1_ADDR-ELE_REG_BASE_ADDR)
#define ELE_REG_PCS_10GR_TEST2_ID         (ELE_MIN_REG_ID+ELE_REG_PCS_10GR_TEST2_ADDR-ELE_REG_BASE_ADDR)
#define ELE_REG_PCS_10GR_TEST3_ID         (ELE_MIN_REG_ID+ELE_REG_PCS_10GR_TEST3_ADDR-ELE_REG_BASE_ADDR)
#define ELE_REG_PCS_10GR_TEST4_ID         (ELE_MIN_REG_ID+ELE_REG_PCS_10GR_TEST4_ADDR-ELE_REG_BASE_ADDR)
#define ELE_REG_PCS_10GR_TEST5_ID         (ELE_MIN_REG_ID+ELE_REG_PCS_10GR_TEST5_ADDR-ELE_REG_BASE_ADDR)
#define ELE_REG_PCS_10GR_TEST6_ID         (ELE_MIN_REG_ID+ELE_REG_PCS_10GR_TEST6_ADDR-ELE_REG_BASE_ADDR)
#define ELE_REG_PCS_10GR_TEST7_ID         (ELE_MIN_REG_ID+ELE_REG_PCS_10GR_TEST7_ADDR-ELE_REG_BASE_ADDR)
#define ELE_REG_PCS_10GR_TEST8_ID         (ELE_MIN_REG_ID+ELE_REG_PCS_10GR_TEST8_ADDR-ELE_REG_BASE_ADDR)
#define ELE_REG_PCS_10GR_TEST9_ID         (ELE_MIN_REG_ID+ELE_REG_PCS_10GR_TEST9_ADDR-ELE_REG_BASE_ADDR)
#define ELE_REG_PCS_10P2B_ABILITY_ID      (ELE_MIN_REG_ID+ELE_REG_PCS_10P2B_ABILITY_ADDR-ELE_REG_BASE_ADDR)
#define ELE_REG_PCS_10P2B_CTRL_ID         (ELE_MIN_REG_ID+ELE_REG_PCS_10P2B_CTRL_ADDR-ELE_REG_BASE_ADDR)
#define ELE_REG_PCS_PME_AVAIL_ID       (ELE_MIN_REG_ID+ELE_REG_PCS_PME_AVAIL_ADDR-ELE_REG_BASE_ADDR)
#define ELE_REG_PCS_PME_AVAIL1_ID         (ELE_MIN_REG_ID+ELE_REG_PCS_PME_AVAIL1_ADDR-ELE_REG_BASE_ADDR)
#define ELE_REG_PCS_PME_AGG_ID            (ELE_MIN_REG_ID+ELE_REG_PCS_PME_AGG_ADDR-ELE_REG_BASE_ADDR)
#define ELE_REG_PCS_PME_AGG1_ID           (ELE_MIN_REG_ID+ELE_REG_PCS_PME_AGG1_ADDR-ELE_REG_BASE_ADDR)
#define ELE_REG_PCS_PAF_RX_ERR_ID         (ELE_MIN_REG_ID+ELE_REG_PCS_PAF_RX_ERR_ADDR-ELE_REG_BASE_ADDR)
#define ELE_REG_PCS_PAF_SM_FRAG_ID        (ELE_MIN_REG_ID+ELE_REG_PCS_PAF_SM_FRAG_ADDR-ELE_REG_BASE_ADDR)
#define ELE_REG_PCS_PAF_LG_FRAG_ID        (ELE_MIN_REG_ID+ELE_REG_PCS_PAF_LG_FRAG_ADDR-ELE_REG_BASE_ADDR)
#define ELE_REG_PCS_PAF_OVF_ID            (ELE_MIN_REG_ID+ELE_REG_PCS_PAF_OVF_ADDR-ELE_REG_BASE_ADDR)
#define ELE_REG_PCS_PAF_BAD_FRAG_ID       (ELE_MIN_REG_ID+ELE_REG_PCS_PAF_BAD_FRAG_ADDR-ELE_REG_BASE_ADDR)
#define ELE_REG_PCS_PAF_LST_FRAG_ID       (ELE_MIN_REG_ID+ELE_REG_PCS_PAF_LST_FRAG_ADDR-ELE_REG_BASE_ADDR)
#define ELE_REG_PCS_PAF_LST_SOF_ID        (ELE_MIN_REG_ID+ELE_REG_PCS_PAF_LST_SOF_ADDR-ELE_REG_BASE_ADDR)
#define ELE_REG_PCS_PAF_LST_EOF_ID        (ELE_MIN_REG_ID+ELE_REG_PCS_PAF_LST_EOF_ADDR-ELE_REG_BASE_ADDR)

#define  ELE_MAX_REG_ID                (ELE_REG_PCS_PAF_LST_EOF_ID)

#define ELE_MAX_ID                     (ELE_MAX_REG_ID)

#endif //_ELE_RAM_H
