/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: ele_typedef.h
*
*   This file contains type definitions used by Electra BM files.
*
*-------------------------------------------------------------------------------
*/

#ifndef _ELE_TYPEDEF_H
#define _ELE_TYPEDEF_H


#ifndef _BASIC_TYPES
#define _BASIC_TYPES
// variable type definitions
typedef double           float64;     //prefix d in hungarian notation
typedef int              int32;       //prefix l
typedef char             int8;        //prefix c
typedef short            int16;       //prefix s
typedef unsigned char    uint8;       //prefix uc
typedef unsigned int     uint32;      //prefix ul
typedef unsigned short   uint16;      //prefix us
typedef unsigned int     Float32;     //prefix f
typedef unsigned char    FlagT;       //prefix ft
typedef unsigned short   bool;        //prefix b
#endif // _BASIC_TYPES

// Structure used for Electra registers
typedef struct {

   //E_CONFIG
   uint8 uc_LtrFreqSel; //bit (13)
   uint8 uc_NTRUpdate;     //bit (12)
   uint8 uc_TxPreamble; //bit (11:8)
   uint8 uc_MiiMode;    //bit (7:6)
   uint8 uc_RxFrmModel; //bit (5:4)
   uint8 uc_TxFrmModel; //bit (3:2)
   uint8 uc_RxEna;         //bit (1)
   uint8 uc_TxEna;         //bit (0)

   //E_CTRL
   uint8 uc_TxStart;    //bit (3)
   uint8 uc_RxStart;    //bit (2)
   uint8 uc_TxSwTrig;      //bit (1)
   uint8 uc_RxSwTrig;      //bit (0)

   //E_HDLC_CTRL
   uint8 uc_HDLCAddr;      //bit (15:8)
   uint8 uc_HDLCCtrl;      //bit (7:0)

   //E_EFM_CHAR
   uint8 uc_EFM_Y;         //bit (31:24)
   uint8 uc_EFM_C;         //bit (23:16)
   uint8 uc_EFM_Z;         //bit (15:8)
   uint8 uc_EFM_S;         //bit (7:0)

   //E_TXFIFO_PTR
   uint16 us_TxRdPtr;      //bit (31:16)
   uint16 us_TxWrPtr;      //bit (15:0)

   //E_TX_FRMCNT
   uint32 ul_TxFrmCnt;     //bit (31:0)

   //E_TX_PKT_LEN
   uint16 us_TxPktLen;     //bit (10:0)

   //E_TX_CRC
   uint32 ul_TxCrc;     //bit (31:0)

   //E_RXFIFO_PTR
   uint16 us_RxRdPtr;      //bit (31:16)
   uint16 us_RxWrPtr;      //bit (15:0)

   //E_RX_FRMCNT
   uint32 ul_RxFrmCnt;     //bit (31:0)

   //E_RX_PKT_LEN
   uint16 us_RxPktLen;     //bit (10:0)

   //E_RX_CRC
   uint32 ul_RxCrc;     //bit (31:0)

   //E_IDLE_STAT
   uint8 uc_PtIdleStat; //bit (1)
   uint8 uc_PrIdleStat; //bit (0)

   //MII_CTRL
   uint8 uc_MiiReset;      //bit (15)
   uint8 uc_MiiLpbk;    //bit (14)
   uint8 uc_MiiSpdSel13;   //bit (13)
   uint8 uc_AutoEnb;    //bit (12)
   uint8 uc_MiiPwrDown; //bit (11)
   uint8 uc_MiiIsolate; //bit (10)
   uint8 uc_RestartAuto;   //bit (9)
   uint8 uc_DuplexMode; //bit (8)
   uint8 uc_CollisionTest; //bit (7)
   uint8 uc_MiiSpdSel6; //bit (6)

   //MII_STAT
   uint8 uc_100BASE_T4;    //bit (15)
   uint8 uc_100BASE_X_FL_DUP; //bit (14)
   uint8 uc_100BASE_X_HF_DUP; //bit (13)
   uint8 uc_10MBS_FL_DUP;     //bit (12)
   uint8 uc_10MBS_HF_DUP;     //bit (11)
   uint8 uc_100BASE_T2_FL_DUP;   //bit (10)
   uint8 uc_100BASE_T2_HF_DUP;   //bit (9)
   uint8 uc_EXT_STAT;         //bit (8)
   uint8 uc_PreamSuppress;    //bit (6)
   uint8 uc_AutoDone;         //bit (5)
   uint8 uc_RemoteFault;      //bit (4)
   uint8 uc_AutoNegAble;      //bit (3)
   uint8 uc_LinkStat;         //bit (2)
   uint8 uc_JabDetect;        //bit (1)
   uint8 uc_ExtRegAble;    //bit (0)

   //MII_PHY_ID0
   uint16 us_MiiPhyId0;    //bit (15:0)

   //MII_PHY_ID1
   uint16 us_MiiPhyId1;    //bit (15:0)

   //AUTO_NEG_PROCESS (not supported)

   //MASTER_SLAVE (not supported)

   //PSE_CTRL (not supported)

   //MMD_CTRL
   uint8 uc_MMD_FUNC;         //bit (15:14)
   uint8 uc_MMD_DEVAD;        //bit (4:0)

   //MMD_ADR_DATA
   uint16 us_MmdAdrData;      //bit (15:0)

   //TC_CTRL
   uint8 uc_TcReset;       //bit (15)
   uint8 uc_TcSpdSel13;    //bit (13)
   uint8 uc_TcSpdSel6;        //bit (6)
   uint8 uc_TcSpd;            //bit (5:2)

   //TC_ID0
   uint16 us_TcId0;        //bit (15:0)

   //TC_ID1
   uint16 us_TcId1;        //bit (15:0)

   //TC_SPEED_ABILITY
   uint8 uc_TC_10P2B_ABLE;    //bit (1)

   //TC_DEVICES_0
   uint8 uc_TC_TcPresent;        //bit (6)
   uint8 uc_TC_DtePresent;       //bit (5)
   uint8 uc_TC_PhyPresent;       //bit (4)
   uint8 uc_TC_PcsPresent;       //bit (3)
   uint8 uc_TC_WisPresent;       //bit (2)
   uint8 uc_TC_PmdPresent;       //bit (1)
   uint8 uc_TC_CL22Present;      //bit (0)

   //TC_DEVICES_1
   uint8 uc_TC_Ven2Present;      //bit (15)
   uint8 uc_TC_Ven1Present;      //bit (14)
   uint8 uc_TC_CL22ExtPresent;      //bit (13)

   //TC_PKG_ID0
   uint16 us_TcPkgId0;           //bit (15:0)

   //TC_PKG_ID1
   uint16 us_TcPkgId1;           //bit (15:0)

   //TC_AGG_DIS_CTRL (not supported)

   //TC_AGG_DIS_STAT (not supported)

   //TC_AGG_DIS_CODE (not supported)

   //TC_LK_AGG_CTRL (not supported)

   //TC_LK_AGG_DATA (not supported)

   //TC_RX_CRC_ERR
   uint16 us_TcRxCrcErr;         //bit (15:0)

   //TC_RX_CODE_ERR_L
   uint16 us_TcRxCodeErrL;       //bit (15:0)

   //TC_RX_CODE_ERR_M
   uint16 us_TcRxCodeErrM;       //bit (15:0)

   //TC_RX_TC_SYNC
   uint8 uc_TcSync;           //bit (8)
   uint8 uc_RemoteSync;       //bit (0)

   //PCS_CTRL
   uint8 uc_PCSReset;         //bit (15)
   uint8 uc_PCSLpbk;       //bit (14)
   uint8 uc_PCSSpdSel13;      //bit (13)
   uint8 uc_PCSLowPow;        //bit (11)
   uint8 uc_PCSSpdSel6;    //bit (6)
   uint8 uc_PCSSpd;        //bit (5:2)

   //PCS_STAT
   uint8 uc_PCSFault;         //bit (7)
   uint8 uc_PCSLinkUp;        //bit (2)
   uint8 uc_PCSLowPowAbility; //bit (1)

   //PCS_ID0
   uint16 us_PCS_ID0;         //bit (15:0)

   //PCS_ID1
   uint16 us_PCS_ID1;         //bit (15:0)

   //PCS_SPEED_ABILITY
   uint8 uc_PCS_10P2B_ABLE;      //bit (1)
   uint8 uc_PCS_10G_ABLE;        //bit (0)

   //PCS_DEVICES_0
   uint8 uc_PCS_TcPresent;       //bit (6)
   uint8 uc_PCS_DtePresent;      //bit (5)
   uint8 uc_PCS_PhyPresent;      //bit (4)
   uint8 uc_PCS_PcsPresent;      //bit (3)
   uint8 uc_PCS_WisPresent;      //bit (2)
   uint8 uc_PCS_PmdPresent;      //bit (1)
   uint8 uc_PCS_CL22Present;     //bit (0)

   //PCS_DEVICES_1
   uint8 uc_PCS_Ven2Present;     //bit (15)
   uint8 uc_PCS_Ven1Present;     //bit (14)
   uint8 uc_PCS_CL22ExtPresent;  //bit (13)

   //PCS_10G_CTRL (not supported)

   //PCS_10G_STAT (not supported)

   //PCS_PKG_ID0
   uint16 us_PcsPkgId0;    //bit (15:0)

   //PCS_PKG_ID1
   uint16 us_PcsPkgId1;    //bit (15:0)

   //PCS_10GX_STAT (not supported)

   //PCS_10GX_CTRL (not supported)

   //PCS_10GR_STAT (not supported)

   //PCS_10GR_CTRL (not supported)

   //PCS_10GR_TEST (not supported)

   //PCS_10P2B_ABILITY
   uint8 uc_PAFAvail;         //bit (12)
   uint8 uc_RemotePAF;        //bit (11)

   //PCS_10P2B_CTRL
   uint8 uc_TxRxSimul;        //bit (15)
   uint8 uc_ColDisable;    //bit (14)
   uint8 uc_PafEnable;        //bit (0)

   //PCS_PME_AVAIL (not supported)

   //PCS_PME_AGG (not supported)

   //PCS_PAF_RX_ERR (not supported)

   //PCS_PAF_SM_FRAG (not supported)

   //PCS_PAF_LG_FRAG (not supported)

   //PCS_PAF_OVF (not supported)

   //PCS_PAF_BAD_FRAG (not supported)

   //PCS_PAF_LST_FRAG (not supported)

   //PCS_PAF_LST_SOF (not supported)

   //PCS_PAF_LST_EOF (not supported)

} ELE_Register_t;

#endif // _ELE_TYPEDEF_H
