/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: ft_cocomo_interface.h
*
*   This file Specifies the Cocomo to Iridia-FT interface.  This interface
*  includes the register read/write functions, core reset functions, BM
*  intialization functions, and any other cocomo/BM only functions/variables
*  that are required to run a HW Engine simulation.  These functions are NOT
*  required by, and unavailable for, actual HW.
*
*-------------------------------------------------------------------------------
*/

#ifndef _FT_COCOMO_INTERFACE_H
#define _FT_COCOMO_INTERFACE_H


#include "ft_typedef.h"
#include "ft_io_typedef.h"

//=============================================================================
// Iridia-FT BM clocking functions
//=============================================================================
void IRI_FT_Clock(void);

//=============================================================================
// Iridia-FT BM initialization functions
//=============================================================================
void IRI_FT_InitializeBM(void);

//=============================================================================
// Iridia-FT BM reset functions
//=============================================================================
void IRI_FT_Reset(void);

//=============================================================================
// Iridia-FT functions called from the Strymon BM.
//=============================================================================
// This function is called by the Strymon BM to read one data sample from
// the Iridia-FT IFFT buffers and to latch on to Iridia-FT's Tx output signals.
int32 IRI_FT_ReadTxSample(int32 *pl_DataSample, uint8 *puc_CsBetaStart, uint8 *puc_WindowStart, uint16 *pus_BetaSize,
                  uint8 *puc_OffsetIn, uint8 *puc_OffsetEr, uint8 uc_FdfOrVfdf);

// This function is called by the Strymon BM to write one data sample to
// the Iridia-FT FFT buffers and to latch on to Iridia-FT's Rx output signals.
int32 IRI_FT_WriteRxSample(int16 s_DataSample, uint8 *puc_CpOverlapStart, uint8 *puc_WindowStart, uint16 *pus_OverlapSize,
                     uint8 *puc_CpeIrsfs, uint8 uc_StrRxTdqLatency, uint8 uc_StrRxWinLatency, uint8 uc_StrRxVarGainLatency,
                     uint8 uc_FdfOrVfdf);

// Source of i/o
#define FDF_IO 0
#define VFDF_IO 1

//=============================================================================
// Iridia-FT functions called from the Iridia-QT BM.
//=============================================================================
// This function is called by the Iridia-QT BM to write one Tx QAM frame to
// the Iridia-FT IFFT buffers.
int32 IRI_FT_TxWriteIFFT(int32 *pla_Tx_InputArray, int16 s_Tx_num_tones);

// This function is called by the Iridia-QT BM to return a base address to the
// IFFT input buffer
int32 IRI_FT_GetIFFTInputBufferAddress(int32 **pl_BaseAddr, int32 **pl_BaseAddrLsb);

// This function is called by the Iridia-QT BM to read one Rx FFT frame from
// the Iridia-FT FFT buffers.
int32 IRI_FT_RxReadFFT(int32 *pla_Rx_OutputArray, int16 s_Rx_num_tones);

// This function is called by the Iridia-QT BM to write one Rx QAM frame to
// the Iridia-FT FFT buffers.
int32 IRI_FT_RxWriteFFT(int32 *pla_Rx_InputArray, int16 s_Rx_num_tones);

// This function is called by the Iridia-QT BM to return a base address to the
// FFT output buffer
int32 IRI_FT_GetFFTOutputBufferAddress(int32 **pl_BaseAddr, int32 **pl_BaseAddrLsb);

// This function is called by the Iridia-QT BM to return a base address to the
// FFT input buffer
int32 IRI_FT_GetFFTInputBufferAddress(int32 **pl_BaseAddr, int32 **pl_BaseAddrLsb);

//=============================================================================
// Iridia-FT functions for reading/writing RAM blocks and registers
//=============================================================================
int32 IRI_FT_WriteWord(uint32 addr, uint32 ul_data, uint8 uc_ByteEnable);
int32 IRI_FT_ReadWord(uint32 addr, uint32 *pul_data, uint8 uc_ByteEnable);


#endif // _FT_COCOMO_INTERFACE_H
