/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: ft_const.h
*
*   This file contains constant definitions for the Iridia-FT BM.
*
*-------------------------------------------------------------------------------
*/

#ifndef _FT_CONST_H
#define _FT_CONST_H

#ifndef TRUE
#define TRUE      (1)
#endif
#ifndef FALSE
#define FALSE     (0)
#endif

//==============================================================================
// Iridia-FT Constants
//==============================================================================
#define FT_MAX_18 0x0001FFFF
#define FT_MIN_18 0xFFFE0000

#define FT_MAX_32 0x7FFFFFFF
#define FT_MIN_32 0x80000000

// Iridia-FT RX
#define MAX_FT_RX_NUM_TONES            4096
#define MAX_FT_LOG4_RX_NUM_TONES    6
#define MAX_FT_RX_FFT_SIZE          (2 * MAX_FT_RX_NUM_TONES)

//  Iridia-FT TX
#define MAX_FT_TX_NUM_TONES            4096
#define MAX_FT_LOG4_TX_NUM_TONES    6
#define MAX_FT_TX_IFFT_SIZE            (2 * MAX_FT_TX_NUM_TONES)

// IFFT/FFT Stages
#define LOG4_FT_SIZE_4096_TONES        (6)
#define LOG4_FT_SIZE_1024_TONES        (5)
#define LOG4_FT_SIZE_256_TONES         (4)
#define LOG4_FT_SIZE_64_TONES       (3)

// States for the Tx Cyclic Extension (CE) Output state machine
#define TX_CYCLIC_PREFIX_FIRST_SAMPLE  (0)
#define  TX_CYCLIC_PREFIX_SAMPLES      (1)
#define  TX_DATA_SAMPLES               (2)
#define  TX_CYCLIC_SUFFIX_FIRST_SAMPLE (3)
#define TX_CYCLIC_SUFFIX_SAMPLES        (4)

// States for the Rx Cyclic Extension (CE) Input state machine
#define RX_CYCLIC_PREFIX_FIRST_SAMPLE  (0)
#define  RX_CYCLIC_PREFIX_SAMPLES      (1)
#define RX_DATA_FIRST_SAMPLE        (2)
#define  RX_DATA_SAMPLES               (3)
#define  RX_CYCLIC_SUFFIX_FIRST_SAMPLE (4)
#define RX_CYCLIC_SUFFIX_SAMPLES        (5)
#define RX_DISABLED                 (6)

// States for the Rx FFT engine state machine
#define  IRI_FT_RX_IDLE (0)
#define  IRI_FT_RX_BUSY (1)
#define  RX_FFT         (0)

// States for the Tx IFFT engine and PARR engine state machine
#define  IRI_FT_TX_IDLE (0)
#define  IRI_FT_TX_BUSY (1)
#define  TX_IFFT        (0)
#define  TX_PARR        (1)

// Tx latencies
#define IRI_FT_TX_IFFT_LATENCY      (1)
#define  IRI_FT_TX_PARR_LATENCY     (1)
#define  IRI_FT_TX_WINDOW_LATENCY   (1)

// Rx Latencies
#define  IRI_FT_RX_FFT_LATENCY      (1)

// PARR
#define MAX_FT_TX_PARR_PEAKS     (8)
#define PARR_DATA_GROUPS         (4)

// IFFT Pre-Processing and FFT Post-Processing scale bit masks
#define  TX_IFFT_SCALE_PRE_PROC_BIT    (0)
#define  RX_FFT_SCALE_POST_PROC_BIT    (LOG4_FT_SIZE_4096_TONES)

// Byte masks
#define FT_BYTE0_MASK      (0x000000FF)
#define FT_BYTE1_MASK      (0x0000FF00)
#define FT_BYTE2_MASK      (0x00FF0000)
#define FT_BYTE3_MASK      (0xFF000000)
#define FT_LOWER_WORD_MASK (FT_BYTE1_MASK | FT_BYTE0_MASK)
#define FT_UPPER_WORD_MASK (FT_BYTE3_MASK | FT_BYTE2_MASK)
#define FT_LONGWORD_MASK   (FT_UPPER_WORD_MASK | FT_LOWER_WORD_MASK)

// Byte enable masks
#define FT_NO_BYTE_EN      (0x0)
#define FT_BYTE0_EN        (0x1)
#define FT_BYTE1_EN        (0x2)
#define FT_BYTE2_EN        (0x4)
#define FT_BYTE3_EN        (0x8)
#define FT_LOWER_WORD_EN   (FT_BYTE1_EN | FT_BYTE0_EN)
#define FT_UPPER_WORD_EN   (FT_BYTE3_EN | FT_BYTE2_EN)
#define FT_LONGWORD_EN     (FT_UPPER_WORD_EN | FT_LOWER_WORD_EN)

// Register bit masks
#define FT_MASK_BIT0    (0x00000001)
#define FT_MASK_BIT1    (0x00000002)
#define FT_MASK_BIT2    (0x00000004)
#define FT_MASK_BIT3    (0x00000008)
#define FT_MASK_BIT4    (0x00000010)
#define FT_MASK_BIT5    (0x00000020)
#define FT_MASK_BIT6    (0x00000040)
#define FT_MASK_BIT7    (0x00000080)
#define FT_MASK_BIT8    (0x00000100)
#define FT_MASK_BIT9    (0x00000200)
#define FT_MASK_BIT10      (0x00000400)
#define FT_MASK_BIT11      (0x00000800)
#define FT_MASK_BIT12      (0x00001000)
#define FT_MASK_BIT13      (0x00002000)
#define FT_MASK_BIT14      (0x00004000)
#define FT_MASK_BIT15      (0x00008000)
#define FT_MASK_BIT16      (0x00010000)
#define FT_MASK_BIT17      (0x00020000)
#define FT_MASK_BIT18      (0x00040000)
#define FT_MASK_BIT19      (0x00080000)
#define FT_MASK_BIT20      (0x00100000)
#define FT_MASK_BIT21      (0x00200000)
#define FT_MASK_BIT22      (0x00400000)
#define FT_MASK_BIT23      (0x00800000)
#define FT_MASK_BIT24      (0x01000000)
#define FT_MASK_BIT25      (0x02000000)
#define FT_MASK_BIT26      (0x04000000)
#define FT_MASK_BIT27      (0x08000000)
#define FT_MASK_BIT28      (0x10000000)
#define FT_MASK_BIT29      (0x20000000)
#define FT_MASK_BIT30      (0x40000000)
#define FT_MASK_BIT31      (0x80000000)

// Core select modes
#define VFDF_NORMAL        0
#define FDF_NORMAL         1
#define VFDF_TX_TO_FDF_RX  2
#define FDF_TX_TO_VFDF_RX  3

#endif //_FT_CONST_H
