/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: ft_io_typedef.h
*
*   This file contains Iridia-FT I/O type definitions used by other BMs.
*
*-------------------------------------------------------------------------------
*/

#ifndef _FT_IO_TYPEDEF_H
#define _FT_IO_TYPEDEF_H


// Structure used for Iridia-FT input signals
typedef struct {

   // IRI_FT_TX
   uint8 uc_TX_IFFT_GO;
   uint8 uc_TX_PARR_GO;

   // IRI_FT_RX
   uint8 uc_RX_FFT_GO;

} IridiaFT_Input_t;

extern IridiaFT_Input_t gt_IridiaFT_Input;


// Structure used for Iridia-FT output signals
typedef struct {

   // IRI_FT_TX
   uint8 uc_TX_BUFSWAP;
   uint8 uc_TX_IFFT_DONE;
   uint8 uc_TX_IFFT_PRE_PROC_DONE;
   uint8 uc_TX_PARR_DONE;
   uint8 uc_TX_CSBETA_START;
   uint8 uc_TX_WINDOW_START;
   uint8 uc_TX_CORE_SELECT;
   uint16   us_TX_BETA_SIZE;
   uint8 uc_TX_OFFSET_IN;
   uint8 uc_TX_OFFSET_ER;

   // IRI_FT_RX
   uint8 uc_RX_BUFSWAP;
   uint8 uc_RX_FFT_DONE;
   uint8 uc_RX_FFT_POST_PROC_DONE;
   uint8 uc_RX_OVERLAP_START;
   uint8 uc_RX_WINDOW_START;
   uint16   us_RX_OVERLAP_SIZE;
   uint8 uc_RX_CPE_IRSFS;
   uint8 uc_RX_CPE_IRFS;
   uint8 uc_RX_CPE_IRFS_RXWINCAPT;
   uint8 uc_RX_CPE_IRWS;

} IridiaFT_Output_t;

extern IridiaFT_Output_t gt_IridiaFT_Output;

#endif // _FT_IO_TYPEDEF_H
