/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: ft_memmap.h
*
*   This file contains Iridia-FT BM memory map.
*
*-------------------------------------------------------------------------------
*/

#ifndef _FT_MEMMAP_H
#define _FT_MEMMAP_H

//==============================================================================
// Iridia-FT Memory Map
//==============================================================================
#define IRI_FT_RAM_BASE_ADDR              (0xE000)

#define IRI_FT_RAM_TX_IFFT_A_ADDR         (IRI_FT_RAM_BASE_ADDR+0x0000)
#define  IRI_FT_RAM_TX_IFFT_B_ADDR        (IRI_FT_RAM_BASE_ADDR+0x1000)
#define  IRI_FT_RAM_TX_IFFT_C_ADDR        (IRI_FT_RAM_BASE_ADDR+0x2000)
#define IRI_FT_RAM_RX_FFT_A_ADDR       (IRI_FT_RAM_BASE_ADDR+0x3000)
#define  IRI_FT_RAM_RX_FFT_B_ADDR         (IRI_FT_RAM_BASE_ADDR+0x4000)
#define  IRI_FT_RAM_RX_FFT_C_ADDR         (IRI_FT_RAM_BASE_ADDR+0x5000)
#define  IRI_FT_RAM_TX_PAR_PVEC_ADDR         (IRI_FT_RAM_BASE_ADDR+0x6000)

//==============================================================================
// Iridia-FT Register Map
//==============================================================================
#define  IRI_FT_REG_BASE_ADDR          (0xC100)

// Tx Registers
#define  IRI_FT_REG_TX_CTRL_ADDR          (IRI_FT_REG_BASE_ADDR+0x00)
#define  IRI_FT_REG_TX_STATUS_ADDR        (IRI_FT_REG_BASE_ADDR+0x01)
#define  IRI_FT_REG_TX_SCALE_ADDR         (IRI_FT_REG_BASE_ADDR+0x02)
#define  IRI_FT_REG_TX_EXTEN_ADDR         (IRI_FT_REG_BASE_ADDR+0x03)
#define  IRI_FT_REG_TX_AEXTEN_ADDR        (IRI_FT_REG_BASE_ADDR+0x04)
#define  IRI_FT_REG_TX_BETA_ADDR          (IRI_FT_REG_BASE_ADDR+0x05)
#define  IRI_FT_REG_TX_ABETA_ADDR         (IRI_FT_REG_BASE_ADDR+0x06)
#define  IRI_FT_REG_TX_FSIZE_ADDR         (IRI_FT_REG_BASE_ADDR+0x07)
#define  IRI_FT_REG_TX_AFSIZE_ADDR        (IRI_FT_REG_BASE_ADDR+0x08)
#define  IRI_FT_REG_TX_FSOFFSET_IN_ADDR      (IRI_FT_REG_BASE_ADDR+0x09)
#define  IRI_FT_REG_TX_FSOFFSET_ER_ADDR      (IRI_FT_REG_BASE_ADDR+0x0A)
#define  IRI_FT_REG_TX_PARR_PARAM_ADDR    (IRI_FT_REG_BASE_ADDR+0x0B)
#define  IRI_FT_REG_TX_PARR_MAX0_ADDR     (IRI_FT_REG_BASE_ADDR+0x0C)
#define  IRI_FT_REG_TX_PARR_MAX1_ADDR     (IRI_FT_REG_BASE_ADDR+0x0D)
#define  IRI_FT_REG_TX_PARR_MAX2_ADDR     (IRI_FT_REG_BASE_ADDR+0x0E)

// Rx Registers
#define  IRI_FT_REG_RX_CTRL_ADDR          (IRI_FT_REG_BASE_ADDR+0x0F)
#define  IRI_FT_REG_RX_STATUS_ADDR        (IRI_FT_REG_BASE_ADDR+0x10)
#define  IRI_FT_REG_RX_SCALE_ADDR         (IRI_FT_REG_BASE_ADDR+0x11)
#define  IRI_FT_REG_RX_EXTEN_ADDR         (IRI_FT_REG_BASE_ADDR+0x12)
#define  IRI_FT_REG_RX_AEXTEN_ADDR        (IRI_FT_REG_BASE_ADDR+0x13)
#define  IRI_FT_REG_RX_WSIZE_ADDR         (IRI_FT_REG_BASE_ADDR+0x14)
#define  IRI_FT_REG_RX_AWSIZE_ADDR        (IRI_FT_REG_BASE_ADDR+0x15)
#define  IRI_FT_REG_RX_FSIZE_ADDR         (IRI_FT_REG_BASE_ADDR+0x16)
#define  IRI_FT_REG_RX_AFSIZE_ADDR        (IRI_FT_REG_BASE_ADDR+0x17)

//==============================================================================
// Iridia-FT Sizes and Masks
//==============================================================================

// Sizes for Iridia-FT RAM block
#define IRI_FT_RAM_TX_IFFT_A_SIZE            (4096)
#define  IRI_FT_RAM_TX_IFFT_B_SIZE           (4096)
#define  IRI_FT_RAM_TX_IFFT_C_SIZE           (4096)
#define IRI_FT_RAM_RX_FFT_A_SIZE          (4096)
#define  IRI_FT_RAM_RX_FFT_B_SIZE            (4096)
#define  IRI_FT_RAM_RX_FFT_C_SIZE            (4096)
#define  IRI_FT_RAM_TX_PAR_PVEC_SIZE            (4096)

// Offsets for Iridia-FT RAM block
#define IRI_FT_RAM_TX_IFFT_A_OFFSET          (0)
#define  IRI_FT_RAM_TX_IFFT_B_OFFSET            (0)
#define  IRI_FT_RAM_TX_IFFT_C_OFFSET            (0)
#define IRI_FT_RAM_RX_FFT_A_OFFSET           (0)
#define  IRI_FT_RAM_RX_FFT_B_OFFSET          (0)
#define  IRI_FT_RAM_RX_FFT_C_OFFSET          (0)
#define  IRI_FT_RAM_TX_PAR_PVEC_OFFSET       (0)

// Iridia-FT RAM Masks
#define IRI_FT_RAM_TX_IFFT_A_MASK            (0xFFFFFFFF)
#define  IRI_FT_RAM_TX_IFFT_B_MASK           (0xFFFFFFFF)
#define  IRI_FT_RAM_TX_IFFT_C_MASK           (0xFFFFFFFF)
#define IRI_FT_RAM_RX_FFT_A_MASK          (0xFFFFFFFF)
#define  IRI_FT_RAM_RX_FFT_B_MASK            (0xFFFFFFFF)
#define  IRI_FT_RAM_RX_FFT_C_MASK            (0xFFFFFFFF)
#define  IRI_FT_RAM_TX_PAR_PVEC_MASK            (0xFFFFFFFF)

// Iridia-FT Register Masks
#define  IRI_FT_REG_TX_CTRL_MASK             (0x00007FCF)
#define  IRI_FT_REG_TX_STATUS_MASK           (0x000007FF)
#define  IRI_FT_REG_TX_SCALE_MASK            (0x00003FFF)
#define  IRI_FT_REG_TX_EXTEN_MASK            (0x03FFFFFF)
#define  IRI_FT_REG_TX_AEXTEN_MASK           (0x03FFFFFF)
#define  IRI_FT_REG_TX_BETA_MASK             (0x000001FF)
#define  IRI_FT_REG_TX_ABETA_MASK            (0x000001FF)
#define  IRI_FT_REG_TX_FSIZE_MASK            (0x00003FFF)
#define  IRI_FT_REG_TX_AFSIZE_MASK           (0x00003FFF)
#define  IRI_FT_REG_TX_FSOFFSET_IN_MASK         (0x00003FFF)
#define  IRI_FT_REG_TX_FSOFFSET_ER_MASK         (0x00003FFF)
#define  IRI_FT_REG_TX_PARR_PARAM_MASK       (0xFFFFBFB0)
#define  IRI_FT_REG_TX_PARR_MAX0_MASK        (0xFFFFFFFF)
#define  IRI_FT_REG_TX_PARR_MAX1_MASK        (0xFFFFFFFF)
#define  IRI_FT_REG_TX_PARR_MAX2_MASK        (0x0000FFFF)

#define  IRI_FT_REG_RX_CTRL_MASK             (0x00000FF7)
#define  IRI_FT_REG_RX_STATUS_MASK           (0x000001FF)
#define  IRI_FT_REG_RX_SCALE_MASK            (0x00003FFF)
#define  IRI_FT_REG_RX_EXTEN_MASK            (0x01FFFFFF)
#define  IRI_FT_REG_RX_AEXTEN_MASK           (0x01FFFFFF)
#define  IRI_FT_REG_RX_WSIZE_MASK            (0x000001FF)
#define  IRI_FT_REG_RX_AWSIZE_MASK           (0x000001FF)
#define  IRI_FT_REG_RX_FSIZE_MASK            (0x00003FFF)
#define  IRI_FT_REG_RX_AFSIZE_MASK           (0x00003FFF)

//==============================================================================
// Iridia-FT DSP interface register bit field masks
//==============================================================================

// Iridia-FT Tx register bit field masks
#define  IRI_FT_REG_TX_IFFT_SIZE_MASK           (0x000001C0)
#define  IRI_FT_REG_TX_IFFT_PRE_PROC_MASK       (0x00000004)
#define  IRI_FT_REG_TX_STR_BUF_STAT_MASK           (0x00000030)
#define  IRI_FT_REG_TX_IFFT_IN_BUF_STAT_MASK       (0x0000000C)
#define  IRI_FT_REG_TX_IFFT_OUT_BUF_STAT_MASK      (0x00000003)

// Iridia-FT Rx register bit field masks
#define  IRI_FT_REG_RX_FFT_SIZE_MASK               (0x00000070)
#define  IRI_FT_REG_RX_FFT_POST_PROC_MASK       (0x00000004)
#define  IRI_FT_REG_RX_STR_BUF_STAT_MASK           (0x00000030)
#define  IRI_FT_REG_RX_FFT_IN_BUF_STAT_MASK        (0x0000000C)
#define  IRI_FT_REG_RX_FFT_OUT_BUF_STAT_MASK       (0x00000003)

#endif // _FT_MEMMAP_H
