/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: ft_private.h
*
*   This file contains private functions and variables which are visible
*   by the Iridia-FT BM only.
*
*-------------------------------------------------------------------------------
*/

#ifndef _FT_PRIVATE_H
#define _FT_PRIVATE_H

#include "ft_typedef.h"
#include "ft_io_typedef.h"
#include "ft_const.h"

//==============================================================================
// Iridia-FT private variables
//==============================================================================

// Iridia FT register structure for internal use
extern IridiaFT_Register_t gt_IridiaFTRegister;
extern IridiaFT_Latencies_t gt_IridiaFTLatencies;

// Iridia-FT FFT Tables
extern int16 gsa_twid_real[MAX_FT_TX_NUM_TONES];
extern int16 gsa_twid_imag[MAX_FT_TX_NUM_TONES];
extern int16 gsa_sk_tab[(MAX_FT_TX_NUM_TONES >> 1) + 1];

// Iridia-FT IFFT and FFT sample counters
extern int16 gs_TxIFFTSampleIndex;
extern int16 gs_TxOffsetFromFrameStrobe;
extern int16 gs_RxFFTSampleIndex;
extern int16 gs_RxOffsetFromFrameStrobe;

// Iridia-FT Cyclic Extension (CE) state machine variables
extern uint16 gus_TxDataOutState;
extern uint16 gus_RxDataInState;
extern int16 gs_RxCPSizeCompare;
extern int32 gl_RxWindowEnable;

// Iridia-FT Internal strobes
extern uint8 guc_Tx_Frame_Strobe_Present;
extern uint8 guc_Rx_Frame_Strobe_Present;
extern uint8 guc_Rx_Overlap_Start_Strobe_Present;

// Iridia-FT Input Signal variables
extern uint8 guc_IRI_QT_TX_CRI_IFFT_GO_Input_Asserted;
extern uint8 guc_IRI_QT_TX_CRI_PARR_GO_Input_Asserted;
extern uint8 guc_IRI_QT_RX_CRI_FFT_GO_Input_Asserted;

// Iridia-FT Output Signal variables
extern uint8 guc_IRI_FT_TX_CRI_BUFSWAP_Output_Asserted;
extern uint8 guc_IRI_FT_TX_CRI_IFFT_DONE_Output_Asserted;
extern uint8 guc_IRI_FT_TX_CRI_IFFT_PRE_PROC_DONE_Output_Asserted;
extern uint8 guc_IRI_FT_TX_CRI_PARR_DONE_Output_Asserted;
extern uint8 guc_IRI_FT_RX_CRI_BUFSWAP_Output_Asserted;
extern uint8 guc_IRI_FT_RX_CRI_FFT_DONE_Output_Asserted;
extern uint8 guc_IRI_FT_RX_CRI_FFT_POST_PROC_DONE_Output_Asserted;

// Iridia-FT Rx FFT engine state machine variables
extern uint16 gus_RxFTEngineState;
extern uint16 gus_RxFTEngineNextState;
extern uint16 gus_RxFTEngineSubState;
extern uint16 gus_RxFTEngineNextSubState;
extern uint32 gul_RxFFTEngineLatency;

// Iridia-FT Tx IFFT engine and PARR engine state machine variables
extern uint16 gus_TxFTEngineState;
extern uint16 gus_TxFTEngineNextState;
extern uint16 gus_TxFTEngineSubState;
extern uint16 gus_TxFTEngineNextSubState;
extern uint32 gul_TxIFFTEngineLatency;
extern uint32 gul_TxPARREngineLatency;

// Iridia-FT local arrays
extern uint32 gula_Tx_IFFT_A_Lsb[MAX_FT_TX_NUM_TONES];
extern uint32 gula_Tx_IFFT_B_Lsb[MAX_FT_TX_NUM_TONES];
extern uint32 gula_Tx_IFFT_C_Lsb[MAX_FT_TX_NUM_TONES];
extern uint32 gula_Rx_FFT_A_Lsb[MAX_FT_RX_NUM_TONES];
extern uint32 gula_Rx_FFT_B_Lsb[MAX_FT_RX_NUM_TONES];
extern uint32 gula_Rx_FFT_C_Lsb[MAX_FT_RX_NUM_TONES];

// Iridia-FT overflow flag
extern FlagT gft_FTOverflow;

// Iridia-FT PARR flags
extern FlagT gft_TxPARR_IFFT_A;
extern FlagT gft_TxPARR_IFFT_B;
extern FlagT gft_TxPARR_IFFT_C;

// Iridia-FT Rx Window Overlap Strobe flag
extern FlagT gft_OffsetRxWindowCapture;

//==============================================================================
// Iridia-FT private functions
//==============================================================================

// Iridia-FT BM clocking function prototypes
int32 IridiaFT_Clock_Tx(void);
int32 IridiaFT_Clock_Rx(void);
void IridiaFT_Clock_Tx_Strobes(void);
void IridiaFT_Clock_Tx_IFFT_PARR(void);
void IridiaFT_Clock_Rx_Strobes(void);
void IridiaFT_Clock_Rx_FFT(void);
void Start_IFFT(void);
void Start_PARR(void);
void Start_FFT(void);
int32 Do_IFFT(void);
int32 Do_PARR(void);
int32 Do_FFT(void);
void Completed_IFFT(void);
void Completed_PARR(void);
void Completed_FFT(void);
void IridiaFT_CopyShadowTxRegisters(void);
void IridiaFT_CopyShadowRxRegisters(void);

// Iridia-FT reset function prototypes
void IridiaFT_ResetRegisters(void);
void IridiaFT_ResetGlobals(void);

// Iridia-FT initialization function prototypes
void IridiaFT_SetLatencies(void);
void IridiaFT_SetMemoryMap(void);
void IridiaFT_AlignRAMPointers(void);
void IridiaFT_Initialize_RAM_Lists(void);

// Iridia-FT RAM function prototypes
int32 IridiaFT_WriteWordVirtualAddr(int16 s_RamName, uint32 ul_offset,  uint32 ul_data);
int32 IridiaFT_ReadWordVirtualAddr(int16 s_RamName, uint32 ul_offset, uint32 *pul_data);
void IridiaFT_MapRAM(uint32 ul_addr, int16 *ps_RAM_id, uint32 *pul_Offset);
void IridiaFT_ConfigIfftBuffers(void);
void IridiaFT_ConfigFftBuffers(void);

// Iridia-FT IFFT/FFT function prototypes
void FFTPostProcess(int32* pla_inbuf, int32* pla_padbuf, int16 s_fftn, int16 s_log4n);
void FFTRadix4Dit(int32* pla_inbuf, int32* pla_outbuf, int32* pla_padbuf, int16 s_fftn, int16 s_log4n);
void IFFTPreProcess(int32* pla_inbuf, int32* pla_padbuf, int16 s_fftn, int16 s_log4n);
void IFFTRadix4Dit(int32* pla_inbuf, int32* pla_outbuf, int32* pla_padbuf, int16 s_fftn, int16 s_log4n);
void CheckTxPreProcessOverflow(void);
void CheckIFFTOverflow(void);
void CheckRxPostProcessOverflow(void);
void CheckFFTOverflow(void);

// Iridia-FT PARR function prototypes
void PARR(int32 *pla_inbuf, int32* pla_pvecbuf, int16 s_fftn, int16 s_iter, int16 s_peaks, uint32 ul_scalar, int16 s_shift);
void CheckPARROverflow(void);

// Iridia-FT operation function prototypes
uint32 DigitRev_ft(uint32 us_Index, int16 s_Log4BinSize);
int32 round_ft(int32 L_var, int16 s_bit_position);
int32 sature18_ft(int32 L_var1);
int32 add_ft(int32 L_var1, int32 L_var2);

#endif // _FT_PRIVATE_H
