/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: ft_ram.h
*
*   Header file for Iridia-FT RAM blocks.
*
*-------------------------------------------------------------------------------
*/

#ifndef _FT_RAM_H
#define _FT_RAM_H

#include "ft_memmap.h"

// Iridia-FT RAM block IDs
#define  IRI_FT_MIN_RAM_ID             (0)

#define IRI_FT_RAM_TX_IFFT_A_ID           (0)
#define  IRI_FT_RAM_TX_IFFT_B_ID          (1)
#define  IRI_FT_RAM_TX_IFFT_C_ID          (2)
#define IRI_FT_RAM_RX_FFT_A_ID            (3)
#define  IRI_FT_RAM_RX_FFT_B_ID           (4)
#define  IRI_FT_RAM_RX_FFT_C_ID           (5)
#define  IRI_FT_RAM_TX_PAR_PVEC_ID        (6)

#define  IRI_FT_MAX_RAM_ID             (IRI_FT_RAM_TX_PAR_PVEC_ID)

// Iridia-FT Register IDs
#define  IRI_FT_MIN_REG_ID             (IRI_FT_MAX_RAM_ID + 1)

// Tx Registers
#define  IRI_FT_REG_TX_CTRL_ID            (IRI_FT_MIN_REG_ID + 0)
#define  IRI_FT_REG_TX_STATUS_ID          (IRI_FT_MIN_REG_ID + 1)
#define  IRI_FT_REG_TX_SCALE_ID           (IRI_FT_MIN_REG_ID + 2)
#define  IRI_FT_REG_TX_EXTEN_ID           (IRI_FT_MIN_REG_ID + 3)
#define  IRI_FT_REG_TX_AEXTEN_ID          (IRI_FT_MIN_REG_ID + 4)
#define  IRI_FT_REG_TX_BETA_ID            (IRI_FT_MIN_REG_ID + 5)
#define  IRI_FT_REG_TX_ABETA_ID           (IRI_FT_MIN_REG_ID + 6)
#define  IRI_FT_REG_TX_FSIZE_ID           (IRI_FT_MIN_REG_ID + 7)
#define  IRI_FT_REG_TX_AFSIZE_ID          (IRI_FT_MIN_REG_ID + 8)
#define  IRI_FT_REG_TX_FSOFFSET_IN_ID     (IRI_FT_MIN_REG_ID + 9)
#define  IRI_FT_REG_TX_FSOFFSET_ER_ID     (IRI_FT_MIN_REG_ID + 10)
#define  IRI_FT_REG_TX_PARR_PARAM_ID         (IRI_FT_MIN_REG_ID + 11)
#define  IRI_FT_REG_TX_PARR_MAX0_ID       (IRI_FT_MIN_REG_ID + 12)
#define  IRI_FT_REG_TX_PARR_MAX1_ID       (IRI_FT_MIN_REG_ID + 13)
#define  IRI_FT_REG_TX_PARR_MAX2_ID       (IRI_FT_MIN_REG_ID + 14)

// Rx Registers
#define  IRI_FT_REG_RX_CTRL_ID            (IRI_FT_MIN_REG_ID + 15)
#define  IRI_FT_REG_RX_STATUS_ID          (IRI_FT_MIN_REG_ID + 16)
#define  IRI_FT_REG_RX_SCALE_ID           (IRI_FT_MIN_REG_ID + 17)
#define  IRI_FT_REG_RX_EXTEN_ID           (IRI_FT_MIN_REG_ID + 18)
#define  IRI_FT_REG_RX_AEXTEN_ID          (IRI_FT_MIN_REG_ID + 19)
#define  IRI_FT_REG_RX_WSIZE_ID           (IRI_FT_MIN_REG_ID + 20)
#define  IRI_FT_REG_RX_AWSIZE_ID          (IRI_FT_MIN_REG_ID + 21)
#define  IRI_FT_REG_RX_FSIZE_ID           (IRI_FT_MIN_REG_ID + 22)
#define  IRI_FT_REG_RX_AFSIZE_ID          (IRI_FT_MIN_REG_ID + 23)

#define  IRI_FT_MAX_REG_ID             (IRI_FT_REG_RX_AFSIZE_ID)

// Global Arrays
extern uint32 *IRI_FT_RAM_VirtualBaseAddr[IRI_FT_MAX_RAM_ID+1];
extern uint32 IRI_FT_RAM_PhysBaseAddr[IRI_FT_MAX_REG_ID+1];
extern uint32 IRI_FT_RAM_Size[IRI_FT_MAX_RAM_ID+1];
extern uint32 IRI_FT_RAM_Offset[IRI_FT_MAX_RAM_ID+1];
extern uint32 IRI_FT_RAM_Mask[IRI_FT_MAX_RAM_ID+1];

extern uint32 IRI_FT_RAM_Tx_IFFT_A_Unaligned[IRI_FT_RAM_TX_IFFT_A_SIZE+1];
extern uint32 *IRI_FT_RAM_Tx_IFFT_A;

extern uint32 IRI_FT_RAM_Tx_IFFT_B_Unaligned[IRI_FT_RAM_TX_IFFT_B_SIZE+1];
extern uint32 *IRI_FT_RAM_Tx_IFFT_B;

extern uint32 IRI_FT_RAM_Tx_IFFT_C_Unaligned[IRI_FT_RAM_TX_IFFT_C_SIZE+1];
extern uint32 *IRI_FT_RAM_Tx_IFFT_C;

extern uint32 IRI_FT_RAM_Rx_FFT_A_Unaligned[IRI_FT_RAM_RX_FFT_A_SIZE+1];
extern uint32 *IRI_FT_RAM_Rx_FFT_A;

extern uint32 IRI_FT_RAM_Rx_FFT_B_Unaligned[IRI_FT_RAM_RX_FFT_B_SIZE+1];
extern uint32 *IRI_FT_RAM_Rx_FFT_B;

extern uint32 IRI_FT_RAM_Rx_FFT_C_Unaligned[IRI_FT_RAM_RX_FFT_C_SIZE+1];
extern uint32 *IRI_FT_RAM_Rx_FFT_C;

extern uint32 IRI_FT_RAM_Tx_PAR_PVEC_Unaligned[IRI_FT_RAM_TX_PAR_PVEC_SIZE+1];
extern uint32 *IRI_FT_RAM_Tx_PAR_PVEC;

#endif //_FT_RAM_H
