/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: ft_typedef.h
*
*   This file contains type definitions used by different files.
*
*-------------------------------------------------------------------------------
*/

#ifndef _FT_TYPEDEF_H
#define _FT_TYPEDEF_H


#ifndef _BASIC_TYPES
#define _BASIC_TYPES
// variable type definitions
typedef double           float64;     //prefix d in hungarian notation
typedef int              int32;       //prefix l
typedef char             int8;        //prefix c
typedef short            int16;       //prefix s
typedef unsigned char    uint8;       //prefix uc
typedef unsigned int     uint32;      //prefix ul
typedef unsigned short   uint16;      //prefix us
typedef unsigned int     Float32;     //prefix f
typedef unsigned char    FlagT;       //prefix ft
typedef unsigned short   bool;        //prefix b
#endif // _BASIC_TYPES

// define 64-bit accumulator type
#ifdef UNIX_PLATFORM
#define acc_ft long long
#else
#ifdef MSVC_ONLY
#define acc_ft __int64
#else
#define acc_ft long
#endif
#endif

// Structure used for Iridia-FT registers
typedef struct {

   // IRI_FT_REG_TX_CTRL
   int32 l_TxCoreSelect;
   int32 l_TxIfftDropOddSamples;
   int32 l_TxIfftLsbEnable;
   int32 l_TxIfftBufferSwapDisable;
   int32 l_TxIfftDspReOrderEnable;
   int32 l_TxIfftSize;
   int32 l_TxParrEnable;
   int32 l_TxIfftPreProcessEnable;
   int32 l_TxIfftEnable;
   int32 l_TxInterfaceEnable;

   // IRI_FT_REG_TX_STATUS
   int32 l_TxStatusWriteEnable;
   int32 l_TxParrOn;
   int32 l_TxParrOverflow;
   int32 l_TxIfftOn;
   int32 l_TxIfftOverflow;
   int32 l_TxIfftStrymonBufferStatus;
   int32 l_TxIfftInputBufferStatus;
   int32 l_TxIfftOutputBufferStatus;

   // IRI_FT_REG_TX_SCALE
   int32 la_TxIfftScale[6+1];       //  0:Preprocessing, 1-6:IFFT stages

   // IRI_FT_REG_TX_EXTEN
   int32 l_TxShadowCyclicSuffixCaptureEnable;
   int32 l_TxShadowWindowEnable;
   int32 l_TxShadowCyclicSuffixEnable;
   int32 l_TxShadowCyclicPrefixEnable;
   int32 l_TxShadowCyclicSuffixSize;
   int32 l_TxShadowCyclicPrefixSize;

   // IRI_FT_REG_TX_AEXTEN
   int32 l_TxCyclicSuffixCaptureEnable;
   int32 l_TxWindowEnable;
   int32 l_TxCyclicSuffixEnable;
   int32 l_TxCyclicPrefixEnable;
   int32 l_TxCyclicSuffixSize;
   int32 l_TxCyclicPrefixSize;

   // IRI_FT_REG_TX_BETA
   int32 l_TxShadowBetaLength;

   // IRI_FT_REG_TX_ABETA
   int32 l_TxBetaLength;

   // IRI_FT_REG_TX_FSIZE
   int32 l_TxShadowFrameSize;

   // IRI_FT_REG_TX_AFSIZE
   int32 l_TxFrameSize;

   // IRI_FT_REG_TX_FSOFFSET_IN
   int32 l_TxFrameStrobeOffsetIn;

   // IRI_FT_REG_TX_FSOFFSET_ER
   int32 l_TxFrameStrobeOffsetEr;

   // IRI_FT_REG_TX_PARR_PARAM
   int32 l_TxParrScalarA;
   int32 l_TxParrScale;
   int32 l_TxParrNIT;
   int32 l_TxParrNGR;

   // IRI_FT_REG_TX_PARR_MAX0
   int32 l_TxParrPeak1;
   int32 l_TxParrPeak0;

   // IRI_FT_REG_TX_PARR_MAX1
   int32 l_TxParrPeak3;
   int32 l_TxParrPeak2;

   // IRI_FT_REG_TX_PARR_MAX2
   int32 l_TxParrPeak4;

   // IRI_FT_REG_RX_CTRL
   int32 l_RxIrsfsValue;
   int32 l_RxFftAddOddSamples;
   int32 l_RxFftLsbEnable;
   int32 l_RxSyncFrame;
   int32 l_RxFftBufferSwapDisable;
   int32 l_RxFftDspReOrderEnable;
   int32 l_RxFftSize;
   int32 l_RxFftPostProcessEnable;
   int32 l_RxFftEnable;
   int32 l_RxInterfaceEnable;

   // IRI_FT_REG_RX_STATUS
   int32 l_RxStatusWriteEnable;
   int32 l_RxFftOn;
   int32 l_RxFftOverflow;
   int32 l_RxFftStrymonBufferStatus;
   int32 l_RxFftInputBufferStatus;
   int32 l_RxFftOutputBufferStatus;

   // IRI_FT_REG_RX_SCALE
   int32 la_RxFftScale[6+1];        //  0-5:FFT stages, 6:Postprocessing

   // IRI_FT_REG_RX_EXTEN
   int32 l_RxShadowWindowEnable;
   int32 l_RxShadowCyclicSuffixEnable;
   int32 l_RxShadowCyclicPrefixEnable;
   int32 l_RxShadowCyclicSuffixSize;
   int32 l_RxShadowCyclicPrefixSize;

   // IRI_FT_REG_RX_AEXTEN
   int32 l_RxWindowEnable;
   int32 l_RxCyclicSuffixEnable;
   int32 l_RxCyclicPrefixEnable;
   int32 l_RxCyclicSuffixSize;
   int32 l_RxCyclicPrefixSize;

   // IRI_FT_REG_RX_WSIZE
   int32 l_RxShadowWindowOverlap;

   // IRI_FT_REG_RX_AWSIZE
   int32 l_RxWindowOverlap;

   // IRI_FT_REG_RX_FSIZE
   int32 l_RxShadowFrameSize;

   // IRI_FT_REG_RX_AFSIZE
   int32 l_RxFrameSize;

} IridiaFT_Register_t;

// Structure used for Iridia-FT latencies
typedef struct {

   // IRI_FT_TX
   uint16 us_TX_IFFT;
   uint16 us_TX_PARR;
   uint16 us_TX_WINDOW;

   // IRI_FT_RX
   uint16 us_TX_FFT;

} IridiaFT_Latencies_t;

#endif // _FT_TYPEDEF_H
