/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: qt_cocomo_interface.h
*
*   This file Specifies the Cocomo to Iridia-QT interface.  This interface
*  includes the register read/write functions, core reset functions, BM
*  intialization functions, and any other cocomo/BM only functions/variables
*  that are required to run a HW Engine simulation.  These functions are NOT
*  required by, and unavailable for, actual HW.
*
*-------------------------------------------------------------------------------
*/

#ifndef _QT_COCOMO_INTERFACE_H
#define _QT_COCOMO_INTERFACE_H


#include "qt_typedef.h"
#include "qt_io_typedef.h"

//=============================================================================
// Iridia-QT BM clocking functions
//=============================================================================
void IRI_QT_Clock(void);

//=============================================================================
// Iridia-QT BM initialization functions
//=============================================================================
void IRI_QT_InitializeBM(void);

//=============================================================================
// Iridia-QT BM reset functions
//=============================================================================
void IRI_QT_Reset(void);

//=============================================================================
// Iridia-QT functions called from other BMs.
//=============================================================================
int32 IRI_QT_GetToneReorderingTableAddress(uint16 **pus_BaseAddr, int16 s_SetNumber);
int32 IRI_QT_GetGainScaleTableAddress(uint16 **pus_BaseAddr, int16 s_SetNumber);
int32 IRI_QT_GetBitAllocationTableAddress(uint8 **puc_BaseAddr, int16 s_SetNumber);
int32 IRI_QT_GetExtendedGainTableAddress(uint8 **puc_BaseAddr, int16 s_SetNumber);
int32 IRI_QT_GetSFDQMantissaTableAddress(int16 **ps_BaseAddr);
int32 IRI_QT_GetMFDQFBMantissaTableAddress(int16 **ps_BaseAddr);
int32 IRI_QT_GetMFDQFFMantissaTableAddress(int16 **ps_BaseAddr);
int32 IRI_QT_GetMFDQFBExponentTableAddress(uint32 **pul_BaseAddr);
int32 IRI_QT_GetMFDQFBToneTableAddress(uint32 **pul_BaseAddr);
int32 IRI_QT_GetRTVBuffer0Address(int16 **ps_BaseAddr);
int32 IRI_QT_GetRTVBuffer1Address(int16 **ps_BaseAddr);
int32 IRI_QT_GetTxConstellationGainsTableAddress(uint32 **pul_BaseAddr);
int32 IRI_QT_GetRxConstellationGainsTableAddress(uint32 **pul_BaseAddr);

//=============================================================================
// Iridia-QT functions for reading/writing RAM blocks and registers
//=============================================================================
int32 IRI_QT_WriteWord(uint32 addr, uint32 ul_data, uint8 uc_ByteEnable);
int32 IRI_QT_ReadWord(uint32 addr, uint32 *pul_data, uint8 uc_ByteEnable);


#endif // _QT_COCOMO_INTERFACE_H
