/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: qt_memmap.h
*
*   This file contains Iridia-QT BM memory map.
*
*-------------------------------------------------------------------------------
*/

#ifndef _QT_MEMMAP_H
#define _QT_MEMMAP_H

//==============================================================================
// Iridia-QT Memory Map
//==============================================================================
#define IRI_QT_RAM_BASE_ADDR              (0x15000)

#define IRI_QT_RAM_TONE_REORDER_ADDR         (IRI_QT_RAM_BASE_ADDR+0x0000)
#define IRI_QT_RAM_GAIN_SCALE_ADDR           (IRI_QT_RAM_BASE_ADDR+0x1000)
#define IRI_QT_RAM_BIT_ALLOCATION_ADDR       (IRI_QT_RAM_BASE_ADDR+0x4000)
#define IRI_QT_RAM_EXT_GAIN_ADDR          (IRI_QT_RAM_BASE_ADDR+0x4800)
#define IRI_QT_RAM_SFDQ_COEF_MANT_ADDR       (IRI_QT_RAM_BASE_ADDR+0x2000)
#define IRI_QT_RAM_RX_XY_DECISION_ADDR       (IRI_QT_RAM_BASE_ADDR+0x3000)
#define IRI_QT_RAM_RX_SURVIVOR_PATH_ADDR     (IRI_QT_RAM_BASE_ADDR+0x3300)
#define IRI_QT_RAM_RX_VITERBI_DECISION_ADDR     (IRI_QT_RAM_BASE_ADDR+0x3380)
#define IRI_QT_RAM_RX_NOISY_POINT_SPAD_ADDR     (IRI_QT_RAM_BASE_ADDR+0x3400)
#define IRI_QT_RAM_TX_CONSTELLATION_GAINS_ADDR  (IRI_QT_RAM_BASE_ADDR+0x3460)
#define IRI_QT_RAM_RX_CONSTELLATION_GAINS_ADDR  (IRI_QT_RAM_BASE_ADDR+0x3470)
#define IRI_QT_RAM_RX_MFDQ_FB_TONE_TABLE_ADDR   (IRI_QT_RAM_BASE_ADDR+0x3480)
#define IRI_QT_RAM_RX_MFDQ_FINAL_DECISION_ADDR  (IRI_QT_RAM_BASE_ADDR+0x3500)
#define IRI_QT_RAM_RX_MFDQ_FB_COEF_MANT_ADDR (IRI_QT_RAM_BASE_ADDR+0x3600)
#define IRI_QT_RAM_RX_MFDQ_FF_COEF_MANT_ADDR (IRI_QT_RAM_BASE_ADDR+0x3640)
#define IRI_QT_RAM_RX_MFDQ_FB_COEF_EXP_ADDR     (IRI_QT_RAM_BASE_ADDR+0x3680)
#define IRI_QT_RAM_RX_TONE_VALUE0_ADDR       (IRI_QT_RAM_BASE_ADDR+0x3800)
#define IRI_QT_RAM_RX_TONE_VALUE1_ADDR       (IRI_QT_RAM_BASE_ADDR+0x3A00)

//==============================================================================
// Iridia-QT Register Map
//==============================================================================
#define  IRI_QT_REG_BASE_ADDR             (0xC0C0)

// Global Registers
#define  IRI_QT_REG_CNFG_ADDR             (IRI_QT_REG_BASE_ADDR+0x00)

// Tx Registers
#define  IRI_QT_REG_TX_CNFG_ADDR             (IRI_QT_REG_BASE_ADDR+0x08)
#define  IRI_QT_REG_TX_TCM_CTRL_ADDR            (IRI_QT_REG_BASE_ADDR+0x09)
#define  IRI_QT_REG_TX_MISC_ADDR             (IRI_QT_REG_BASE_ADDR+0x0A)
#define  IRI_QT_REG_TX_LP0_BITS_ADDR            (IRI_QT_REG_BASE_ADDR+0x0B)
#define  IRI_QT_REG_TX_LP1_BITS_ADDR            (IRI_QT_REG_BASE_ADDR+0x0C)
#define  IRI_QT_REG_TX_DUMMY_ADDR            (IRI_QT_REG_BASE_ADDR+0x0D)
#define  IRI_QT_REG_TX_LP0_BIT_FIFO_ADDR        (IRI_QT_REG_BASE_ADDR+0x0E)
#define  IRI_QT_REG_TX_LP1_BIT_FIFO_ADDR        (IRI_QT_REG_BASE_ADDR+0x0F)
#define  IRI_QT_REG_TX_PILOT_ADDR            (IRI_QT_REG_BASE_ADDR+0x10)
#define  IRI_QT_REG_TX_PTINDEX_ADDR          (IRI_QT_REG_BASE_ADDR+0x11)
#define  IRI_QT_REG_TX_PRBS_ADDR             (IRI_QT_REG_BASE_ADDR+0x12)
#define  IRI_QT_REG_TX_PRBS_MISC_ADDR        (IRI_QT_REG_BASE_ADDR+0x13)
#define  IRI_QT_REG_TX_PRBS_POLY_ADDR        (IRI_QT_REG_BASE_ADDR+0x14)
#define  IRI_QT_REG_TX_PRBS_DATA_ADDR        (IRI_QT_REG_BASE_ADDR+0x15)
#define  IRI_QT_REG_TX_REF_GAIN_ADDR            (IRI_QT_REG_BASE_ADDR+0x16)
#define IRI_QT_REG_TX_OS_NYQ_GAIN_ADDR       (IRI_QT_REG_BASE_ADDR+0x17)
#define IRI_QT_REG_TX_TBLCP_ADDR          (IRI_QT_REG_BASE_ADDR+0x18)
#define IRI_QT_REG_TX_TRTCP_RNG_ADDR         (IRI_QT_REG_BASE_ADDR+0x19)

// Rx Registers
#define  IRI_QT_REG_RX_CNFG_ADDR             (IRI_QT_REG_BASE_ADDR+0x20)
#define  IRI_QT_REG_RX_TCM_CTRL_ADDR            (IRI_QT_REG_BASE_ADDR+0x21)
#define  IRI_QT_REG_RX_MISC_ADDR             (IRI_QT_REG_BASE_ADDR+0x22)
#define  IRI_QT_REG_RX_TONES_ADDR            (IRI_QT_REG_BASE_ADDR+0x23)
#define  IRI_QT_REG_RX_LP0_BITS_ADDR            (IRI_QT_REG_BASE_ADDR+0x24)
#define  IRI_QT_REG_RX_LP1_BITS_ADDR            (IRI_QT_REG_BASE_ADDR+0x25)
#define  IRI_QT_REG_RX_DUMMY_ADDR            (IRI_QT_REG_BASE_ADDR+0x26)
#define  IRI_QT_REG_RX_LP0_BIT_FIFO_ADDR        (IRI_QT_REG_BASE_ADDR+0x27)
#define  IRI_QT_REG_RX_LP1_BIT_FIFO_ADDR        (IRI_QT_REG_BASE_ADDR+0x28)
#define  IRI_QT_REG_RX_PRBS_ADDR             (IRI_QT_REG_BASE_ADDR+0x29)
#define  IRI_QT_REG_RX_PRBS_MISC_ADDR        (IRI_QT_REG_BASE_ADDR+0x2A)
#define  IRI_QT_REG_RX_PRBS_POLY_ADDR        (IRI_QT_REG_BASE_ADDR+0x2B)
#define  IRI_QT_REG_RX_PRBS_OFFSET_ADDR         (IRI_QT_REG_BASE_ADDR+0x2C)
#define IRI_QT_REG_RX_RTV0_PRBS_ADDR         (IRI_QT_REG_BASE_ADDR+0x2D)
#define IRI_QT_REG_RX_RTV1_PRBS_ADDR         (IRI_QT_REG_BASE_ADDR+0x2E)
#define  IRI_QT_REG_RX_DPRBS_MISC_ADDR       (IRI_QT_REG_BASE_ADDR+0x2F)
#define  IRI_QT_REG_RX_DPRBS_POLY_ADDR       (IRI_QT_REG_BASE_ADDR+0x30)
#define IRI_QT_REG_RX_RTV0_ADDR              (IRI_QT_REG_BASE_ADDR+0x31)
#define IRI_QT_REG_RX_RTV1_ADDR              (IRI_QT_REG_BASE_ADDR+0x32)
#define IRI_QT_REG_RX_QUAD_ADDR              (IRI_QT_REG_BASE_ADDR+0x33)
#define IRI_QT_REG_RX_SLOWDOWN_ADDR          (IRI_QT_REG_BASE_ADDR+0x34)
#define IRI_QT_REG_RX_PTINDEX_ADDR           (IRI_QT_REG_BASE_ADDR+0x35)
#define IRI_QT_REG_RX_PILOT_ADDR          (IRI_QT_REG_BASE_ADDR+0x36)
#define IRI_QT_REG_RX_TBLCP_ADDR          (IRI_QT_REG_BASE_ADDR+0x37)
#define IRI_QT_REG_RX_TRTCP_RNG_ADDR         (IRI_QT_REG_BASE_ADDR+0x38)

//==============================================================================
// Iridia-QT Sizes and Masks
//==============================================================================

// Sizes for Iridia-QT RAM block
#define  IRI_QT_RAM_TONE_REORDER_SIZE           (4096)
#define  IRI_QT_RAM_BIT_ALLOCATION_SIZE            (2048)
#define  IRI_QT_RAM_GAIN_SCALE_SIZE             (4096)
#define  IRI_QT_RAM_EXT_GAIN_SIZE               (2048)
#define IRI_QT_RAM_SFDQ_COEF_MANT_SIZE          (4096)
#define  IRI_QT_RAM_RX_XY_DECISION_SIZE            (512)
#define  IRI_QT_RAM_RX_SURVIVOR_PATH_SIZE       (96)
#define  IRI_QT_RAM_RX_VITERBI_DECISION_SIZE       (48)
#define  IRI_QT_RAM_RX_NOISY_POINT_SPAD_SIZE       (96)
#define  IRI_QT_RAM_RX_MFDQ_FB_COEF_EXP_SIZE       (64)
#define  IRI_QT_RAM_RX_MFDQ_FB_COEF_MANT_SIZE      (64)
#define  IRI_QT_RAM_RX_MFDQ_FF_COEF_MANT_SIZE      (64)
#define  IRI_QT_RAM_RX_MFDQ_FINAL_DECISION_SIZE    (128)
#define  IRI_QT_RAM_RX_MFDQ_FB_TONE_TABLE_SIZE     (64)
#define  IRI_QT_RAM_RX_TONE_VALUE0_SIZE            (512)
#define  IRI_QT_RAM_RX_TONE_VALUE1_SIZE            (512)
#define IRI_QT_RAM_TX_CONSTELLATION_GAINS_SIZE     (16)
#define IRI_QT_RAM_RX_CONSTELLATION_GAINS_SIZE     (16)

// Offsets for Iridia-QT RAM block
#define  IRI_QT_RAM_TONE_REORDER_OFFSET            (0)
#define  IRI_QT_RAM_BIT_ALLOCATION_OFFSET       (0)
#define  IRI_QT_RAM_GAIN_SCALE_OFFSET           (0)
#define  IRI_QT_RAM_EXT_GAIN_OFFSET             (0)
#define  IRI_QT_RAM_SFDQ_COEF_MANT_OFFSET       (0)
#define  IRI_QT_RAM_RX_XY_DECISION_OFFSET       (0)
#define  IRI_QT_RAM_RX_SURVIVOR_PATH_OFFSET        (0)
#define  IRI_QT_RAM_RX_VITERBI_DECISION_OFFSET     (0)
#define  IRI_QT_RAM_RX_NOISY_POINT_SPAD_OFFSET     (0)
#define  IRI_QT_RAM_RX_MFDQ_FB_COEF_EXP_OFFSET     (0)
#define  IRI_QT_RAM_RX_MFDQ_FB_COEF_MANT_OFFSET    (0)
#define  IRI_QT_RAM_RX_MFDQ_FF_COEF_MANT_OFFSET    (0)
#define  IRI_QT_RAM_RX_MFDQ_FINAL_DECISION_OFFSET  (0)
#define  IRI_QT_RAM_RX_MFDQ_FB_TONE_TABLE_OFFSET      (0)
#define IRI_QT_RAM_RX_TONE_VALUE0_OFFSET        (0)
#define IRI_QT_RAM_RX_TONE_VALUE1_OFFSET        (0)
#define IRI_QT_RAM_TX_CONSTELLATION_GAINS_OFFSET   (0)
#define IRI_QT_RAM_RX_CONSTELLATION_GAINS_OFFSET   (0)

// Iridia-QT RAM Masks
#define  IRI_QT_RAM_TONE_REORDER_MASK           (0x0FFF0FFF)
#define  IRI_QT_RAM_BIT_ALLOCATION_MASK            (0x1F1F1F1F)
#define  IRI_QT_RAM_GAIN_SCALE_MASK             (0xFFFFFFFF)
#define  IRI_QT_RAM_EXT_GAIN_MASK               (0xFFFFFFFF)
#define  IRI_QT_RAM_SFDQ_COEF_MANT_MASK            (0xFFFFFFFF)
#define  IRI_QT_RAM_RX_XY_DECISION_MASK            (0xFFFFFFFF)
#define  IRI_QT_RAM_RX_SURVIVOR_PATH_MASK       (0x0000FFFF)
#define  IRI_QT_RAM_RX_VITERBI_DECISION_MASK       (0xFFFFFFFF)
#define  IRI_QT_RAM_RX_NOISY_POINT_SPAD_MASK       (0x003FFFFF)
#define  IRI_QT_RAM_RX_MFDQ_FB_COEF_EXP_MASK       (0x0000000F)
#define  IRI_QT_RAM_RX_MFDQ_FB_COEF_MANT_MASK      (0xFFFFFFFF)
#define  IRI_QT_RAM_RX_MFDQ_FF_COEF_MANT_MASK      (0xFFFFFFFF)
#define  IRI_QT_RAM_RX_MFDQ_FINAL_DECISION_MASK    (0xFF00FF00)
#define  IRI_QT_RAM_RX_MFDQ_FB_TONE_TABLE_MASK     (0x0FFF0FFF)
#define IRI_QT_RAM_RX_TONE_VALUE0_MASK          (0xFFFFFFFF)
#define IRI_QT_RAM_RX_TONE_VALUE1_MASK          (0xFFFFFFFF)
#define IRI_QT_RAM_TX_CONSTELLATION_GAINS_MASK     (0x0007FFFF)
#define IRI_QT_RAM_RX_CONSTELLATION_GAINS_MASK     (0x0007FFFF)

// Iridia-QT Register Masks
#define  IRI_QT_REG_CNFG_MASK                (0x00000007)
#define  IRI_QT_REG_TX_CNFG_MASK                (0x00007777)
#define  IRI_QT_REG_TX_TCM_CTRL_MASK               (0x017FF000)
#define  IRI_QT_REG_TX_MISC_MASK                (0x00000FFF)
#define  IRI_QT_REG_TX_LP0_BITS_MASK               (0x0001FFFF)
#define  IRI_QT_REG_TX_LP1_BITS_MASK               (0x0001FFFF)
#define  IRI_QT_REG_TX_DUMMY_MASK               (0x0000FFFF)
#define  IRI_QT_REG_TX_LP0_BIT_FIFO_MASK           (0x000007FF)
#define  IRI_QT_REG_TX_LP1_BIT_FIFO_MASK           (0x000007FF)
#define  IRI_QT_REG_TX_PILOT_MASK               (0xFFFFFFFF)
#define  IRI_QT_REG_TX_PTINDEX_MASK             (0x00001FFF)
#define  IRI_QT_REG_TX_PRBS_MASK                (0xFFFFFFFF)
#define  IRI_QT_REG_TX_PRBS_MISC_MASK           (0xFFF1FFF0)
#define  IRI_QT_REG_TX_PRBS_POLY_MASK           (0xFFFFFFFF)
#define  IRI_QT_REG_TX_PRBS_DATA_MASK           (0xFFFFFFFF)
#define  IRI_QT_REG_TX_REF_GAIN_MASK               (0x00007FFF)
#define  IRI_QT_REG_TX_OS_NYQ_GAIN_MASK            (0x00007FFF)
#define  IRI_QT_REG_TX_TBLCP_MASK               (0x00003FFF)
#define  IRI_QT_REG_TX_TRTCP_RNG_MASK           (0x0FFF0FFF)

#define  IRI_QT_REG_RX_CNFG_MASK                (0x00007707)
#define  IRI_QT_REG_RX_TCM_CTRL_MASK               (0x017FFFFF)
#define  IRI_QT_REG_RX_MISC_MASK                (0x0001FFFF)
#define  IRI_QT_REG_RX_TONES_MASK               (0x0FFF0FFF)
#define  IRI_QT_REG_RX_LP0_BITS_MASK               (0x0001FFFF)
#define  IRI_QT_REG_RX_LP1_BITS_MASK               (0x0001FFFF)
#define  IRI_QT_REG_RX_DUMMY_MASK               (0x0000FFFF)
#define  IRI_QT_REG_RX_LP0_BIT_FIFO_MASK           (0x000007FF)
#define  IRI_QT_REG_RX_LP1_BIT_FIFO_MASK           (0x000007FF)
#define  IRI_QT_REG_RX_PRBS_MASK                (0xFFFFFFFF)
#define  IRI_QT_REG_RX_PRBS_MISC_MASK           (0x0000F9F3)
#define  IRI_QT_REG_RX_PRBS_POLY_MASK           (0xFFFFFFFF)
#define  IRI_QT_REG_RX_PRBS_OFFSET_MASK            (0x0FFF0FFF)
#define  IRI_QT_REG_RX_RTV0_PRBS_MASK           (0xFFFFFFFF)
#define  IRI_QT_REG_RX_RTV1_PRBS_MASK           (0xFFFFFFFF)
#define  IRI_QT_REG_RX_DPRBS_MISC_MASK          (0xFF0105F0)
#define  IRI_QT_REG_RX_DPRBS_POLY_MASK          (0xFFFFFFFF)
#define  IRI_QT_REG_RX_RTV0_MASK                (0x03FFFFFF)
#define  IRI_QT_REG_RX_RTV1_MASK                (0x03FFFFFF)
#define  IRI_QT_REG_RX_QUAD_MASK                (0x83FF03FF)
#define  IRI_QT_REG_RX_SLOWDOWN_MASK               (0x000000FF)
#define  IRI_QT_REG_RX_PTINDEX_MASK             (0x00001FFF)
#define  IRI_QT_REG_RX_PILOT_MASK               (0xFFFFFFFF)
#define  IRI_QT_REG_RX_TBLCP_MASK               (0x00003FFF)
#define  IRI_QT_REG_RX_TRTCP_RNG_MASK           (0x0FFF0FFF)
#endif // _QT_MEMMAP_H
