/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: qt_private.h
*
*   This file contains private functions and variables which are visible
*   by the Iridia-QT BM only.
*
*-------------------------------------------------------------------------------
*/

#ifndef _QT_PRIVATE_H
#define _QT_PRIVATE_H

#include "qt_typedef.h"
#include "qt_io_typedef.h"
#include "qt_const.h"

//==============================================================================
// Iridia-QT private variables
//==============================================================================

// Iridia QT register structure for internal use
extern IridiaQT_Register_t gt_IridiaQTRegister;
extern IridiaQT_Latencies_t gt_IridiaQTLatencies;

// Iridia-QT QAM Tables
extern int16 gsa_TxQamXTab3[QT_3BIT_CONSTELLATION_POINTS];
extern int16 gsa_TxQamYTab3[QT_3BIT_CONSTELLATION_POINTS];
extern uint8 guca_TxQamXcYcTab[QT_ODDBITS_CONSTELLATION_POINTS];
extern uint8 guca_IRI_ByteMaskTable[9];
extern uint16 gusa_WordMaskTable[16];
extern uint32 gula_LongWordMaskTable[32];
extern uint8 guca_TxGainScaleExp[16];
extern uint16 gusa_TxGainScale[16];
extern uint16 gusa_RxGainScale[16];
extern uint8 guca_RxGainScaleExp[16];
extern int16 gsa_RxQamXYTab3[QT_3BIT_CONSTELLATION_POINTS << 1];
extern uint8 guca_RxQamXcYcTab[16];
extern int16 gsa_RxQamMaxCoordInner[16];
extern int16 gsa_RxQamMaxCoordOuter[16];

// Iridia-QT Rx QAM decode state machine variables
extern uint16 gus_RxQTEngineState;
extern uint16 gus_RxQTEngineNextState;
extern uint16 gus_RxQTEngineSubState;
extern uint16 gus_RxQTEngineNextSubState;
extern uint32 gul_RxQTEngineLatency;

// Iridia-QT Tx QAM Encode state machine variables
extern uint16 gus_TxQTEngineState;
extern uint16 gus_TxQTEngineNextState;
extern uint16 gus_TxQTEngineSubState;
extern uint16 gus_TxQTEngineNextSubState;
extern uint32 gul_TxQTEngineLatency;

// Iridia-QT Input Signal variables
extern uint8 guc_IRI_QT_TX_CRI_GO_Input_Asserted;
extern uint8 guc_IRI_QT_RX_CRI_GO_Input_Asserted;

// Iridia-QT Output Signal variables
extern uint8 guc_IRI_QT_TX_CRI_DONE_Output_Asserted;
extern uint8 guc_IRI_QT_RX_CRI_DONE_Output_Asserted;
extern uint8 guc_IRI_QT_TX_CRI_BATERR_Output_Asserted;
extern uint8 guc_IRI_QT_RX_CRI_BATERR_Output_Asserted;
extern uint16 gus_IRI_QT_TX_ILV_SIZE0_Output_Asserted;
extern uint16 gus_IRI_QT_TX_ILV_SIZE1_Output_Asserted;
extern uint16 gus_IRI_QT_RX_ILV_SIZE0_Output_Asserted;
extern uint16 gus_IRI_QT_RX_ILV_SIZE1_Output_Asserted;

// Iridia-QT to Interleave memory bit extraction interface variables
extern uint32 gul_InWordLP0;
extern uint32 gul_InWordLP1;
extern uint16 gus_EncDummyBitsLP0;
extern uint16 gus_EncDummyBitsLP1;
extern uint32 gul_EncBitsLP0;
extern uint32 gul_EncBitsLP1;
extern int16  gs_EncBitPtrLP0;
extern int16  gs_EncBitPtrLP1;

// Iridia-QT to Deinterleave memory bit stuffing interface variables
extern uint32 gula_OutWordLP[2];
extern uint16 gusa_DecDummyBitsLP[2];
extern uint16 gusa_DecBitsLP[2];
extern int16  gsa_DecBitPtrLP[2];
extern int16  gsa_QtRxSize[2];
extern int8   gc_StartLPath;

// Iridia-QT local arrays
extern int32 gla_Tx_QAMOutput[MAX_QT_TX_NUM_TONES<<1];
extern uint8 guca_Tx_ModifiedBitAlloc[MAX_QT_TX_NUM_TONES<<1];
extern int32 gla_Rx_QtToneBuf[MAX_QT_RX_NUM_TONES<<1];
extern int32 gla_Rx_FftOutBuf[MAX_QT_RX_NUM_TONES<<1];
extern uint8 guca_BitAllocTable[MAX_QT_RX_NUM_TONES];

extern int16 gs_MaxLogToneIdxWithFbTone;
extern uint16 *gpusa_Rx_ToneReorder;
extern uint16 *gpusa_RxGainTable;
extern int16  **gpsa_RTVBuf;

// Iridia-QT overflow flag
extern FlagT gft_QTOverflow;
extern int16 gs_QTFeedbackOverflowFlag;

// Iridia-QT flag to indicate it is QAM encode or Decode
extern FlagT gft_QamEncDec;

// Iridia-QT flag indicating whether the QAM decoder constellation point was clipped
extern FlagT gft_QamDecClippedInput;

// Iridia-QT variables for RAM blocks
extern uint32 *gpula_NoisyPointScratchPad;
extern uint32 *gpula_ViterbiDecisionTable;
extern uint32 *gpula_MfdqFinalDecisionTable;
extern int16 gs_NPSP_ReadPtr;
extern int16 gs_NPSP_WritePtr;
extern int16 gs_FLT_ReadPtr;
extern int16 gs_FLT_WritePtr;
extern int16 gs_MFDT_ReadPtr;
extern int16 gs_MFDT_WritePtr;

// Iridia-QT Tx PRBS Generator
extern int16 gs_TxPRBSOutput;
extern int32 gl_TxPRBSState;

// Iridia-QT Rx PRBS State Generator
extern int32 gl_RxPRBSState;
extern int32 gl_RxPRBSStateRTV0;
extern int32 gl_RxPRBSStateRTV1;

// Iridia-QT Rx PRBS Descrambler
extern int16 gs_RxDPRBSOutput;
extern int32 gl_RxDPRBSState;

// Nyquist tone value
extern int32 gl_OsNyqToneValue;

//==============================================================================
// Iridia-QT private functions
//==============================================================================

// Iridia-QT BM clocking functions
int32 IridiaQT_Clock_Tx(void);
int32 IridiaQT_Clock_Rx(void);
int32 Do_TxQT(void);
int32 Do_RxQT(void);
void Completed_TxProcessing(void);
void Completed_RxProcessing(void);

// Iridia-QT reset functions
void IridiaQT_ResetRegisters(void);
void IridiaQT_ResetRAMs(void);
void IridiaQT_ResetGlobals(void);
void IridiaQT_ResetIOSignals(void);

// Iridia-QT initialization functions
void IridiaQT_SetLatencies(void);
void IridiaQT_SetMemoryMap(void);
void IridiaQT_AlignRAMPointers(void);
void IridiaQT_Initialize_RAM_Lists(void);

// Iridia-QT RAM functions
int32 IridiaQT_WriteWordVirtualAddr(int16 s_RamName, uint32 ul_offset,  uint32 ul_data, uint8 uc_ByteEnable);
int32 IridiaQT_ReadWordVirtualAddr(int16 s_RamName, uint32 ul_offset, uint32 *pul_data, uint8 uc_ByteEnable);
void IridiaQT_MapRAM(uint32 ul_addr, int16 *ps_RAM_id, uint32 *pul_Offset);

// Iridia-QT Tx function prototypes
void QAMEncoder(int16* psa_OutputReal, int16* psa_OutputImag, int16 s_num_tones, uint8 *puca_BitAlloc, uint16 *pusa_ToneReorder, uint8 *puca_ExtGain);
void TCMEncoder(int16* psa_OutputReal, int16* psa_OutputImag, int16 s_num_tones, uint8 *puca_BitAlloc, uint16 *pusa_ToneReorder, uint8 *puca_ExtGain);
uint16 GetBits(int16 s_BitLoad, uint8 s_newsymbol, uint32 *pul_Datum, int16 *ps_extrabits);
void ProcessTxTones(uint8 *puca_BitAlloc, uint8 *puca_ExtGain, uint16 *pusa_ToneReorder, uint8 *puca_ModifiedBitAlloc);
void ApplyTxOversampling(void);
void TxPRBSGenerator(int16 s_output_bits);
void PRBSPilotScrambler(int32 *pl_data_real, int32 *pl_data_imag, int16 s_PRBS_output);
int16 GetPRBS2bitData(int16 s_PRBS_data_index);
void PRBSScrambler(int16 *ps_PRBS_data, int16 s_PRBS_output);
void FindConstellation(uint32 ul_input, int16 s_BitLoad, int16 *ps_X, int16 *ps_Y);
void ApplyTxGainScale(uint8 *puca_ExtGain, uint8 *puca_ModifiedBitAlloc, uint16 *pusa_GainScale, uint16 *pusa_ToneReorder, uint32 *pula_TxConstellationGains);
void CheckTxGainScaleOverflow(void);

//Iridia-QT RX functions
void QT_RPPtoOffset(int16 *ps_offset);
int16 QT_SaveRTV(int16 s_DebugFlag, int16 s_InputDataType, int32 *pla_ToneBuf, int16 s_ToneIdx, int16 **psa_RTVBuf_BaseAddr);
int16 QT_IsToneInRTV(int16 s_ToneIdx);
int32 Do_RxPRBSStateGeneration(void);
int32 Do_RxPRBSDeScrambling(uint16 *pusa_ToneReorder, uint8 *puca_ExtGain);
int32 CopyRxPRBSRegisters(void);
void RxPRBSGenerator(int16 s_output_bits);
void RxPRBSStateGenerator(int16 s_output_bits);
void PRBSDeScrambler(int16 s_PRBS_Output, int16 *psa_ToneData);
void QT_SFDQ(int32 *pla_ToneBuf, int16 *psa_SfdqCoefMant, uint8 uc_SfdqExt);
void QT_ComplexMult(int32 *pla_ToneBuf, int16 *psa_FdqMant, acc_qt *pla_64BitBuf);
void ApplyFdqExp(int16 s_exp, acc_qt *pacc_InToneBuf, int32 *pla_OutToneBuf);
void FindFeedbackTone(int16 s_LogToneIdx, uint32 ul_MfdqFbToneTable, int16 *ps_FbLogToneIdx);
void QT_FormatFeedforwardTaps(int32 *pla_ToneBuf);
void QT_RxGainScale(int32 *pla_LocalToneBuf, uint16 us_GainMantissa, uint32 ul_ConstellationGain);
void CheckRxGainScaleOverflow(void);
void QT_QAMDecode(uint32 *pula_MfdqFbToneTable, uint16 *pusa_ToneReorder, uint8 *puca_BitAlloc,
                  uint16 *pusa_GainScale, uint8 *puca_ExtGain, int16 **psa_RTVBuf, int16 *ps_ProcRTVToneOnlyFlag);
void QT_TcmQAMDecode(uint16 *pusa_Rx_ToneReorder, uint8 *puca_BAT, int16 **psa_RTVBuf);
void QT_MfdqTcmQAMDecode(uint16 *pusa_Rx_ToneReorder, uint8 *puca_BAT, uint16 *pusa_RxGain,
                  uint8 *puca_ExtGain, int16 **psa_RTVBuf);
void QT_MSFBTPreProcess(void);
void QT_MfdqFeedback(uint32 ul_MfdqScratchPad, int16 *psa_MfdqFbCoefMant, uint8 uc_MfdqFbCoefExp,
               int32 *la_LocalToneBuf);
void AddMfdqFeedback(int32 *pla_GSOutputTone, int32 *pla_FeedbackTone, int32 *pla_OutputTone);
void QT_QAMDemapper(int16* psa_QamInput, int16 *psa_FinalDecision, uint8 uc_BitAlloc, uint16 *pus_Datum);
void DecodeConstellation(int16 s_X, int16 s_Y, int16 s_BitLoad, uint16 *pus_Datum);
void InitQamDecoderClipTable(void);
void QamDecoderClipInput(int16 s_X, int16 s_Y, int16 *s_XClipped, int16 *s_YClipped, int16 s_Bits);
void QamDecoderClipInput3Bit(int16 s_X, int16 s_Y, int16 *s_XClipped, int16 *s_YClipped);
uint16 QT_BitStuffer(int16 s_BitLoad, uint8 *puc_newsymbol, uint32 ul_Datum);
void InitReadWritePointers(void);
void ReadNoisyPointScratchPad(int32 *pla_OutputBuf);
void WriteNoisyPointScratchPad(int32 *pla_InputBuf);
void SaveNoisyConstellationPoint(int32 *pla_LocalToneBuf);
void ReadFLT(int16 *ps_FB_len);
void WriteFLT(int16 s_FB_Len);
void CalcDecodingError(int16 *psa_FeedBackTone, int32 *pla_LocalToneBuf);
void GetQAMInputTone(int32 *pla_InputToneBuf, int16 s_PhyToneIdx, int16 *psa_OutputToneBuf);
void QT_RxGainBypass(int32 *pla_ToneBuf);

// Iridia-QT functions shared by Tx and Rx
void QT_CopyTable(int32 l_path);

// Iridia-QT operation function prototypes
int32 round_qt(int32 L_var, int16 s_bit_position);
acc_qt round64_qt(acc_qt acc_var, int16 s_bit_position);
int32 sature_qt(int32 l_var, int16 s_bitwidth);
acc_qt sature64_qt(acc_qt acc_var, int16 s_bitwidth);
int32 add_qt(int32 L_var1, int32 L_var2);
uint8 XLSBs_ge_YLSBs(int16 s_X, int16 s_Y);


#endif // _QT_PRIVATE_H
