/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: qt_ram.h
*
*   Header file for Iridia-QT RAM blocks.
*
*-------------------------------------------------------------------------------
*/

#ifndef _QT_RAM_H
#define _QT_RAM_H

#include "qt_memmap.h"

// Iridia-QT RAM block IDs
#define  IRI_QT_MIN_RAM_ID                   (0)

#define IRI_QT_RAM_TONE_REORDER_ID              (0)
#define IRI_QT_RAM_BIT_ALLOCATION_ID            (1)
#define IRI_QT_RAM_GAIN_SCALE_ID             (2)
#define IRI_QT_RAM_EXT_GAIN_ID                  (3)
#define IRI_QT_RAM_SFDQ_COEF_MANT_ID            (4)
#define IRI_QT_RAM_RX_XY_DECISION_ID            (5)
#define IRI_QT_RAM_RX_SURVIVOR_PATH_ID          (6)
#define IRI_QT_RAM_RX_VITERBI_DECISION_ID       (7)
#define IRI_QT_RAM_RX_NOISY_POINT_SPAD_ID       (8)
#define IRI_QT_RAM_RX_MFDQ_FB_COEF_EXP_ID       (9)
#define IRI_QT_RAM_RX_MFDQ_FB_COEF_MANT_ID         (10)
#define IRI_QT_RAM_RX_MFDQ_FF_COEF_MANT_ID         (11)
#define IRI_QT_RAM_RX_MFDQ_FINAL_DECISION_ID    (12)
#define IRI_QT_RAM_RX_MFDQ_FB_TONE_TABLE_ID        (13)
#define IRI_QT_RAM_RX_TONE_VALUE0_ID            (14)
#define IRI_QT_RAM_RX_TONE_VALUE1_ID            (15)
#define IRI_QT_RAM_TX_CONSTELLATION_GAINS_ID    (16)
#define IRI_QT_RAM_RX_CONSTELLATION_GAINS_ID    (17)

#define  IRI_QT_MAX_RAM_ID                   (IRI_QT_RAM_RX_CONSTELLATION_GAINS_ID)

// Iridia-QT Register IDs
#define  IRI_QT_MIN_REG_ID                   (IRI_QT_MAX_RAM_ID + 1)

// Global Registers
#define IRI_QT_REG_CNFG_ID                   (IRI_QT_MIN_REG_ID + 0)

// Tx Registers
#define  IRI_QT_REG_TX_CNFG_ID                  (IRI_QT_MIN_REG_ID + 1)
#define  IRI_QT_REG_TX_TCM_CTRL_ID              (IRI_QT_MIN_REG_ID + 2)
#define  IRI_QT_REG_TX_MISC_ID                  (IRI_QT_MIN_REG_ID + 3)
#define  IRI_QT_REG_TX_LP0_BITS_ID              (IRI_QT_MIN_REG_ID + 4)
#define  IRI_QT_REG_TX_LP1_BITS_ID              (IRI_QT_MIN_REG_ID + 5)
#define  IRI_QT_REG_TX_DUMMY_ID                 (IRI_QT_MIN_REG_ID + 6)
#define  IRI_QT_REG_TX_LP0_BIT_FIFO_ID          (IRI_QT_MIN_REG_ID + 7)
#define  IRI_QT_REG_TX_LP1_BIT_FIFO_ID          (IRI_QT_MIN_REG_ID + 8)
#define  IRI_QT_REG_TX_PILOT_ID                 (IRI_QT_MIN_REG_ID + 9)
#define  IRI_QT_REG_TX_PTINDEX_ID               (IRI_QT_MIN_REG_ID + 10)
#define  IRI_QT_REG_TX_PRBS_ID                  (IRI_QT_MIN_REG_ID + 11)
#define  IRI_QT_REG_TX_PRBS_MISC_ID             (IRI_QT_MIN_REG_ID + 12)
#define  IRI_QT_REG_TX_PRBS_POLY_ID             (IRI_QT_MIN_REG_ID + 13)
#define  IRI_QT_REG_TX_PRBS_DATA_ID             (IRI_QT_MIN_REG_ID + 14)
#define  IRI_QT_REG_TX_REF_GAIN_ID              (IRI_QT_MIN_REG_ID + 15)
#define  IRI_QT_REG_TX_OS_NYQ_GAIN_ID           (IRI_QT_MIN_REG_ID + 16)
#define IRI_QT_REG_TX_TBLCP_ID              (IRI_QT_MIN_REG_ID + 17)
#define IRI_QT_REG_TX_TRTCP_RNG_ID          (IRI_QT_MIN_REG_ID + 18)

// Rx Registers
#define IRI_QT_MIN_RX_REG_ID                 (IRI_QT_REG_TX_TRTCP_RNG_ID+1)
#define  IRI_QT_REG_RX_CNFG_ID                  (IRI_QT_MIN_RX_REG_ID + 0)
#define  IRI_QT_REG_RX_TCM_CTRL_ID              (IRI_QT_MIN_RX_REG_ID + 1)
#define  IRI_QT_REG_RX_MISC_ID                  (IRI_QT_MIN_RX_REG_ID + 2)
#define  IRI_QT_REG_RX_TONES_ID                 (IRI_QT_MIN_RX_REG_ID + 3)
#define  IRI_QT_REG_RX_LP0_BITS_ID              (IRI_QT_MIN_RX_REG_ID + 4)
#define  IRI_QT_REG_RX_LP1_BITS_ID              (IRI_QT_MIN_RX_REG_ID + 5)
#define  IRI_QT_REG_RX_DUMMY_ID                 (IRI_QT_MIN_RX_REG_ID + 6)
#define  IRI_QT_REG_RX_LP0_BIT_FIFO_ID          (IRI_QT_MIN_RX_REG_ID + 7)
#define  IRI_QT_REG_RX_LP1_BIT_FIFO_ID          (IRI_QT_MIN_RX_REG_ID + 8)
#define  IRI_QT_REG_RX_PRBS_ID                  (IRI_QT_MIN_RX_REG_ID + 9)
#define  IRI_QT_REG_RX_PRBS_MISC_ID             (IRI_QT_MIN_RX_REG_ID + 10)
#define  IRI_QT_REG_RX_PRBS_POLY_ID             (IRI_QT_MIN_RX_REG_ID + 11)
#define  IRI_QT_REG_RX_PRBS_OFFSET_ID           (IRI_QT_MIN_RX_REG_ID + 12)
#define  IRI_QT_REG_RX_RTV0_PRBS_ID             (IRI_QT_MIN_RX_REG_ID + 13)
#define  IRI_QT_REG_RX_RTV1_PRBS_ID             (IRI_QT_MIN_RX_REG_ID + 14)
#define  IRI_QT_REG_RX_DPRBS_MISC_ID               (IRI_QT_MIN_RX_REG_ID + 15)
#define  IRI_QT_REG_RX_DPRBS_POLY_ID               (IRI_QT_MIN_RX_REG_ID + 16)
#define  IRI_QT_REG_RX_RTV0_ID                  (IRI_QT_MIN_RX_REG_ID + 17)
#define  IRI_QT_REG_RX_RTV1_ID                  (IRI_QT_MIN_RX_REG_ID + 18)
#define IRI_QT_REG_RX_QUAD_ID                (IRI_QT_MIN_RX_REG_ID + 19)
#define IRI_QT_REG_RX_SLOWDOWN_ID               (IRI_QT_MIN_RX_REG_ID + 20)
#define IRI_QT_REG_RX_PTINDEX_ID             (IRI_QT_MIN_RX_REG_ID + 21)
#define IRI_QT_REG_RX_PILOT_ID               (IRI_QT_MIN_RX_REG_ID + 22)
#define IRI_QT_REG_RX_TBLCP_ID            (IRI_QT_MIN_RX_REG_ID + 23)
#define IRI_QT_REG_RX_TRTCP_RNG_ID        (IRI_QT_MIN_RX_REG_ID + 24)
#define  IRI_QT_MAX_REG_ID                   (IRI_QT_REG_RX_TRTCP_RNG_ID)

// Global Arrays
extern uint32 *IRI_QT_RAM_VirtualBaseAddr[IRI_QT_MAX_RAM_ID+1];
extern uint32 IRI_QT_RAM_PhysBaseAddr[IRI_QT_MAX_REG_ID+1];
extern uint32 IRI_QT_RAM_Size[IRI_QT_MAX_RAM_ID+1];
extern uint32 IRI_QT_RAM_Offset[IRI_QT_MAX_RAM_ID+1];
extern uint32 IRI_QT_RAM_Mask[IRI_QT_MAX_RAM_ID+1];

extern uint32 IRI_QT_RAM_TONE_REORDER_Unaligned[IRI_QT_RAM_TONE_REORDER_SIZE+1];
extern uint32 *IRI_QT_RAM_TONE_REORDER;

extern uint32 IRI_QT_RAM_BIT_ALLOCATION_Unaligned[IRI_QT_RAM_BIT_ALLOCATION_SIZE+1];
extern uint32 *IRI_QT_RAM_BIT_ALLOCATION;

extern uint32 IRI_QT_RAM_GAIN_SCALE_Unaligned[IRI_QT_RAM_GAIN_SCALE_SIZE+1];
extern uint32 *IRI_QT_RAM_GAIN_SCALE;

extern uint32 IRI_QT_RAM_EXT_GAIN_Unaligned[IRI_QT_RAM_EXT_GAIN_SIZE+1];
extern uint32 *IRI_QT_RAM_EXT_GAIN;

extern uint32 IRI_QT_RAM_SFDQ_COEF_MANT_Unaligned[IRI_QT_RAM_SFDQ_COEF_MANT_SIZE+1];
extern uint32 *IRI_QT_RAM_SFDQ_COEF_MANT;

extern uint32 IRI_QT_RAM_Rx_XY_DECISION_Unaligned[IRI_QT_RAM_RX_XY_DECISION_SIZE+1];
extern uint32 *IRI_QT_RAM_Rx_XY_DECISION;

extern uint32 IRI_QT_RAM_Rx_SURVIVOR_PATH_Unaligned[IRI_QT_RAM_RX_SURVIVOR_PATH_SIZE+1];
extern uint32 *IRI_QT_RAM_Rx_SURVIVOR_PATH;

extern uint32 IRI_QT_RAM_Rx_VITERBI_DECISION_Unaligned[IRI_QT_RAM_RX_VITERBI_DECISION_SIZE+1];
extern uint32 *IRI_QT_RAM_Rx_VITERBI_DECISION;

extern uint32 IRI_QT_RAM_Rx_NOISY_POINT_SPAD_Unaligned[IRI_QT_RAM_RX_NOISY_POINT_SPAD_SIZE+1];
extern uint32 *IRI_QT_RAM_Rx_NOISY_POINT_SPAD;

extern uint32 IRI_QT_RAM_RX_MFDQ_FB_COEF_EXP_Unaligned[IRI_QT_RAM_RX_MFDQ_FB_COEF_EXP_SIZE+1];
extern uint32 *IRI_QT_RAM_RX_MFDQ_FB_COEF_EXP;

extern uint32 IRI_QT_RAM_RX_MFDQ_FB_COEF_MANT_Unaligned[IRI_QT_RAM_RX_MFDQ_FB_COEF_MANT_SIZE+1];
extern uint32 *IRI_QT_RAM_RX_MFDQ_FB_COEF_MANT;

extern uint32 IRI_QT_RAM_RX_MFDQ_FF_COEF_MANT_Unaligned[IRI_QT_RAM_RX_MFDQ_FF_COEF_MANT_SIZE+1];
extern uint32 *IRI_QT_RAM_RX_MFDQ_FF_COEF_MANT;

extern uint32 IRI_QT_RAM_Rx_MFDQ_FINAL_DECISION_Unaligned[IRI_QT_RAM_RX_MFDQ_FINAL_DECISION_SIZE+1];
extern uint32 *IRI_QT_RAM_Rx_MFDQ_FINAL_DECISION;

extern uint32 IRI_QT_RAM_Rx_MFDQ_FB_TONE_TABLE_Unaligned[IRI_QT_RAM_RX_MFDQ_FB_TONE_TABLE_SIZE+1];
extern uint32 *IRI_QT_RAM_Rx_MFDQ_FB_TONE_TABLE;

extern uint32 IRI_QT_RAM_Rx_TONE_VALUE0_Unaligned[IRI_QT_RAM_RX_TONE_VALUE0_SIZE+1];
extern uint32 *IRI_QT_RAM_Rx_TONE_VALUE0;

extern uint32 IRI_QT_RAM_Rx_TONE_VALUE1_Unaligned[IRI_QT_RAM_RX_TONE_VALUE1_SIZE+1];
extern uint32 *IRI_QT_RAM_Rx_TONE_VALUE1;

extern uint32 IRI_QT_RAM_Tx_CONSTELLATION_GAINS_Unaligned[IRI_QT_RAM_TX_CONSTELLATION_GAINS_SIZE+1];
extern uint32 *IRI_QT_RAM_Tx_CONSTELLATION_GAINS;

extern uint32 IRI_QT_RAM_Rx_CONSTELLATION_GAINS_Unaligned[IRI_QT_RAM_RX_CONSTELLATION_GAINS_SIZE+1];
extern uint32 *IRI_QT_RAM_Rx_CONSTELLATION_GAINS;


#endif //_QT_RAM_H
