/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: qt_typedef.h
*
*   This file contains type definitions used by different files.
*
*-------------------------------------------------------------------------------
*/

#ifndef _QT_TYPEDEF_H
#define _QT_TYPEDEF_H


#ifndef _BASIC_TYPES
#define _BASIC_TYPES
// variable type definitions
typedef double           float64;     //prefix d in hungarian notation
typedef int              int32;       //prefix l
typedef char             int8;        //prefix c
typedef short            int16;       //prefix s
typedef unsigned char    uint8;       //prefix uc
typedef unsigned int     uint32;      //prefix ul
typedef unsigned short   uint16;      //prefix us
typedef unsigned int     Float32;     //prefix f
typedef unsigned char    FlagT;       //prefix ft
typedef unsigned short   bool;        //prefix b
#endif // _BASIC_TYPES

// define 64-bit accumulator type
#ifdef UNIX_PLATFORM
#define acc_qt long long
#else
#ifdef MSVC_ONLY
#define acc_qt __int64
#else
#define acc_qt long
#endif
#endif

// Structure used for Iridia-QT registers
typedef struct {

   // IRI_QT_REG_CNFG
   int32 l_TotalNumSubCarrierTones;

   // IRI_QT_REG_TX_CNFG
   int32 l_TxUnitNumSubCarrierTones;
   int32 l_TxSingleBitConstellationMode;
   int32 l_TxNumIfftTones;
   int32 l_TxNumSubCarrierTones;

   // IRI_QT_REG_TX_TCM_CTRL
   int32 l_TxTrellisEnable;
   int32 l_TxTrellisOneBitTonePairs;

   // IRI_QT_REG_TX_MISC
   int32 l_TxOversamplingType;
   int32 l_TxFIFOPushError;
   int32 l_TxFIFOPopError;
   int32 l_TxGainScaleOverflow;
   int32 l_TxTRTDisable;
   int32 l_Tx4QAMSenseSelect;
   int32 l_TxPRBSGENEnable;
   int32 l_TxREFGENGainEnable;
   int32 l_TxPingPongBit;

   // IRI_QT_REG_TX_LP0_BITS
   int32 l_TxLp0Bits;

   // IRI_QT_REG_TX_LP1_BITS
   int32 l_TxLp1Bits;

   // IRI_QT_REG_TX_DUMMY
   int32 l_TxLp1DummyBits;
   int32 l_TxLp0DummyBits;

   // IRI_QT_REG_TX_LP0_BIT_FIFO
   int32 l_TxLp0ValidBits;
   int32 l_TxLp0BitExtractState;

   // IRI_QT_REG_TX_LP1_BIT_FIFO
   int32 l_TxLp1ValidBits;
   int32 l_TxLp1BitExtractState;

   // IRI_QT_REG_TX_PILOT
   int32 l_TxPilotReal;
   int32 l_TxPilotImag;

   // IRI_QT_REG_TX_PTINDEX
   int32 l_TxPilotInsertEnable;
   int32 l_TxPilotIndex;

   // IRI_QT_REG_TX_PRBS
   int32 l_TxPRBSState;

   // IRI_QT_REG_TX_PRBS_MISC
   int32 l_TxPRBSScrambling11;
   int32 l_TxPRBSScrambling10;
   int32 l_TxPRBSScrambling01;
   int32 l_TxPRBSScrambling00;
   int32 l_TxPRBSModulo;
   int32 l_TxPRBSOutput;
   int32 l_TxPRBSSkip;
   int32 l_TxPRBSReset;
   int32 l_TxPRBSInvert;
   int32 l_TxPRBSPilotRotate;
   int32 l_TxPRBSLength;

   // IRI_QT_REG_TX_PRBS_POLY
   int32 l_TxPRBSPolynomial;

   // IRI_QT_REG_TX_PRBS_DATA
   int32 l_TxPRBS2BitInput[16];

   // IRI_QT_REG_TX_REF_GAIN
   int32 l_TxREFGain;

   // IRI_QT_REG_TX_OS_NYQ_GAIN
   int32 l_TxOsNyqGain;

  // IRI_QT_REG_TX_TBLCP
  int32 l_TxNoCopyTRT;
  int32 l_TxNoCopyGST;
  int32 l_TxNoCopyBAT;
  int32 l_TxCopySegment;
  int32 l_TxCopyWhole;
  int32 l_TxCopyAtQTEnd;
  int32 l_TxCopyTbl0To1;
  int32 l_TxCopyTblEna;
  int32 l_TxCopyEGTMaskn;

  // IRI_QT_REG_TX_TRTCP_RNG
  int32 l_TxTRTCopyStart;
  int32 l_TxTRTCopyEnd;

   // IRI_QT_REG_RX_CNFG
   int32 l_RxUnitNumSubCarrierTones;
   int32 l_RxSingleBitConstellationMode;
   int32 l_RxNumSubCarrierTones;

   // IRI_QT_REG_RX_TCM_CTRL
   int32 l_RxTrellisEnable;
   int32 l_RxTrellisOneBitTonePairs;
   int32 l_RxFirst1BitToneIndex;

   // IRI_QT_REG_RX_MISC
   int32 l_RxMFDQFeedbackToneTableDisable;
   int32 l_RxBitStufferDisable;
   int32 l_RxSFDQBypass;
   int32 l_RxMFDQFeedForwardBypass;
   int32 l_RxGainScaleBypass;
   int32 l_RxMFDQFeedBackBypass;
   int32 l_RxMFDQFeedBackToneTableError;
   int32 l_RxMFDQFeedBackOverflow;
   int32 l_RxMFDQFeedForwardOverflow;
   int32 l_RxGainScaleOverflow;
   int32 l_RxTRTDisable;
   int32 l_Rx4QAMSenseSelect;
   int32 l_RxPRBSDeScramblingEnable;
   int32 l_RxPingPongBit;

   // IRI_QT_REG_RX_TONES
   int32 l_RxMaxTone;
   int32 l_RxMinTone;

   // IRI_QT_REG_RX_LP0_BITS
   int32 l_RxLp0Bits;

   // IRI_QT_REG_RX_LP1_BITS
   int32 l_RxLp1Bits;

   // IRI_QT_REG_RX_DUMMY
   int32 l_RxLp1DummyBits;
   int32 l_RxLp0DummyBits;

   // IRI_QT_REG_RX_LP0_BIT_FIFO
   int32 l_RxLp0ValidBits;
   int32 l_RxLp0BitExtractState;

   // IRI_QT_REG_RX_LP1_BIT_FIFO
   int32 l_RxLp1ValidBits;
   int32 l_RxLp1BitExtractState;

   // IRI_QT_REG_RX_PRBS
   int32 l_RxPRBSState;

   // IRI_QT_REG_RX_PRBS_MISC
   int32 l_RxPRBSSkip;
   int32 l_RxPRBSReset;
   int32 l_RxPRBSLength;
   int32 l_RxPRBSDone;
   int32 l_RxPRBSEnable;

   // IRI_QT_REG_RX_PRBS_POLY
   int32 l_RxPRBSPolynomial;

   // IRI_QT_REG_RX_PRBS_OFFSET
   int32 l_RxRTV1PRBSOffset;
   int32 l_RxRTV0PRBSOffset;

   // IRI_QT_REG_RX_RTV0_PRBS
   int32 l_RxRTV0PRBSState;

   // IRI_QT_REG_RX_RTV1_PRBS
   int32 l_RxRTV1PRBSState;

   // IRI_QT_REG_RX_DPRBS_MISC
   int32 l_RxDPRBSRotation11;
   int32 l_RxDPRBSRotation10;
   int32 l_RxDPRBSRotation01;
   int32 l_RxDPRBSRotation00;
   int32 l_RxDPRBSOutput;
   int32 l_RxDPRBSInvert;
   int32 l_RxDPRBSLength;

   // IRI_QT_REG_RX_DPRBS_POLY
   int32 l_RxDPRBSPolynomial;

   // IRI_QT_REG_RX_RTV0
   int32 l_RxRTVBuffer0Unrot;
   int32 l_RxRTVBuffer0Format;
   int32 l_RxRTVBuffer0WriteEnable;
   int32 l_RxRTVBuffer0DataType;
   int32 l_RxRTVBuffer0Count;
   int32 l_RxRTVBuffer0Offset;

   // IRI_QT_REG_RX_RTV1
   int32 l_RxRTVBuffer1Unrot;
   int32 l_RxRTVBuffer1Format;
   int32 l_RxRTVBuffer1WriteEnable;
   int32 l_RxRTVBuffer1DataType;
   int32 l_RxRTVBuffer1Count;
   int32 l_RxRTVBuffer1Offset;

   // IRI_QT_REG_RX_QUAD
   int32 l_RxQuadrantCountEnable;
   int32 l_RxRTV1QuadrantMatch;
   int32 l_RxRTV0QuadrantMatch;

   // IRI_QT_REG_RX_SLOWDOWN
   int32 l_RxSlowdown;

   int32 l_RxPtEna;
   int32 l_RxPtIndex;
   int32 l_RxPilot;

  // IRI_QT_REG_RX_TBLCP
  int32 l_RxNoCopyTRT;
  int32 l_RxNoCopyGST;
  int32 l_RxNoCopyBAT;
  int32 l_RxCopySegment;
  int32 l_RxCopyWhole;
  int32 l_RxCopyAtQTEnd;
  int32 l_RxCopyTbl0To1;
  int32 l_RxCopyTblEna;
  int32 l_RxCopyEGTMaskn;

  // IRI_QT_REG_RX_TRTCP_RNG
  int32 l_RxTRTCopyStart;
  int32 l_RxTRTCopyEnd;

} IridiaQT_Register_t;

// Structure used for Iridia-QT latencies
typedef struct {

   // IRI_QT_TX
   uint16 us_QAMENC;
   uint16 us_TCM_QAMENC;

   // IRI_QT_RX
   uint16 us_QAMDEC;
   uint16 us_TCM_QAMDEC;

} IridiaQT_Latencies_t;

#endif // _QT_TYPEDEF_H
