/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: v_str_const.h
;
;   This file contains constant definitions for the Strymon BM.
;
*****************************************************************************/

#ifndef _V_STR_CONST_H
#define _V_STR_CONST_H

#include "v_str_compiler.h"

// Variable gain product
#define RIGHT_SHIFT_FOR_18BIT_BY_16BIT_PRODUCT (17)
#define RIGHT_SHIFT_FOR_16BIT_BY_16BIT_PRODUCT (15)

// Tx Window precision
#define WIN_LACC_MAX       ((int32) 0x3FFFFFFF) // maximum value of window accumulator
#define WIN_LACC_MIN       ((int32) 0xC0000000) // minimum value of window accumulator

// DEC
#define MAX_DEC_DELAY         (8)               // DEC maximum delay at 552 Ks/s rate
#define MAX_DS2USRATERATIO    (16)
#define DEC_INPUT_BUFFER_SIZE MAX_DS2USRATERATIO << 1 // DEC input buffer size, divided into two pages.
#define DEC_DELAY_BUFFER_SIZE (MAX_DEC_DELAY*MAX_DS2USRATERATIO+1) // DEC delay buffer size

// Tx IIR
#define TX_IIR_ORDER       (15)              // Tx IIR filter order
#define NUM_TX_IIR_BIQUADS    ((TX_IIR_ORDER+1) >> 1) // Number of Tx IIR bi-quad sections
#define TX_IIR_SEC_SIZE       (5)                  // Number of Tx IIR coefficients/section (including unused mem)

#define MAX_NUM_BIQUADS       (NUM_TX_IIR_BIQUADS)

#define MAX_TDQ_LENGTH_VDSL      (24)

// Tx IIR1, TX IIR2, RX IIR engine precision
#define W_IIR_ACC 52       // width of accumulator
#define W_IIR_ACC_FRACTION 48 // width of "fractional part"
#define W_IIR_SHFTR_IN  49    // width of input to shifter
#define W_IIR_COEF   18       // width of coef
#define W_IIR_PR  32       // width of past results

// SRC FIR
#define NUM_SRC_FIR_PARAMS (3072)

// Tx Interp
#define MAX_TX_INTERP_FIR_LEN (24)

// Tx SRC
#define TX_SRC_FIR_PHASE_LEN  (24)
#define MAX_TX_SRC_FIR_LEN    (2*TX_SRC_FIR_PHASE_LEN)

// Rx SRC
#define RX_SRC_FIR_LEN        (24)
#define MAX_RX_SRC_FIR_LEN    (2*RX_SRC_FIR_LEN)

// Delay of SRCFR's taking effect.
#define SRCFR_DELAY_DEBUGTRIGGER (1)
#define SRCFR_DELAY_17664        (1)
#define SRCFR_DELAY_35328        (2)
#define SRCFR_DELAY_70656        (4)

// Rx AFE Decim IIR engine precision
#define W_AFE_ACC 41       // width of accumulator
#define W_AFE_ACC_FRACTION 37 // width of "fractional part"
#define W_AFE_SHFTR_IN  38    // width of input to shifter
#define W_AFE_COEF   14       // width of coef
#define W_AFE_PR  25       // width of past results

// Rx AFE Decim
#define AFE_DECIM_FIR_LEN        (25)
#define AFE_DECIM_IIR_ORDER         (3)                        // AFE Decim IIR filter order
#define NUM_AFE_DECIM_IIR_BIQUADS   ((AFE_DECIM_IIR_ORDER+1) >> 1)   // Number of AFE Decim IIR bi-quad sections
#define AFE_DECIM_IIR_SEC_SIZE      (5)                        // Number of AFE Decim IIR coefficients/section (including unused mem)
#define AFE_DECIM_IIR_COEF_RAM_SIZE ((AFE_DECIM_IIR_SEC_SIZE*NUM_AFE_DECIM_IIR_BIQUADS)+1)   // Size of AFE Decim IIR coefficient RAM + input scale

// Rx Decim
#define MAX_DECIM_LEN   (240)

// Rx IIR
#define RX_IIR_ORDER       (7)                  // Rx IIR filter order
#define NUM_RX_IIR_BIQUADS    ((RX_IIR_ORDER+1) >> 1) // Number of Rx IIR bi-quad sections
#define RX_IIR_SEC_SIZE       (5)                  // Number of Rx IIR coefficients/section (including unused mem)
#define RX_IIR_COEF_RAM_SIZE  ((RX_IIR_SEC_SIZE*NUM_RX_IIR_BIQUADS)+1)  // Size of Rx IIR coefficient RAM + input scale

// MAX_RX_WINDOW_LENGTH = CPmax-beta = (CEmax+beta)-beta = CEmax which is regarded as 640
#define MAX_RX_WINDOW_LENGTH  (640)
#define VW_LPBK_FIFO_DEPTH     (5)
#define VW_LPBK_FIFO_DEPTH_DBG (2)

// FIR filter definitions
#define DELAY              (0)
#define OUTPUT             (1)

// Accumulator widths
#define RX_SRC_FIR_ACC_WIDTH  (37)
#define AFE_DECIM_FIR_ACC_WIDTH  (37)
#define RX_DECIM_FIR_ACC_WIDTH   (40)
#define DEC_TDQ_FIR_ACC_WIDTH (41)
#define SUM_JUNC_ACC_WIDTH    (45)
#define SUM_JUNC_IN_WIDTH     (SUM_JUNC_ACC_WIDTH-1)
#define TX_SRC_FIR_ACC_WIDTH  (37)
#define TX_INTERP_FIR_ACC_WIDTH  (37)

#ifdef UNIX_PLATFORM
#define SRC_FIR_ACC_MIN (0xFFFFFFFF80000000LL)  // minimum value of SRC FIR accumulator
#define SRC_FIR_ACC_MAX (0x000000007FFFFFFFLL)  // maximum value of SRC FIR accumulator
#define AFE_DECIM_FIR_ACC_MIN (0xFFFFFFFFFF000000LL)  // minimum value of AFE Decim FIR accumulator
#define AFE_DECIM_FIR_ACC_MAX (0x0000000000FFFFFFLL)  // maximum value of AFE Decim FIR accumulator
#define FIR_ACC_MIN  (0xFFFFFFFFC0000000LL)  // minimum value of all other FIR accumulators
#define FIR_ACC_MAX  (0x000000003FFFFFFFLL)  // maximum value of all other FIR accumulators
#define TX_VARGAIN_OUT_MAX (0x00000000FFFFFFFFLL)  // maximum value of Tx variable gain output
#define TX_VARGAIN_OUT_MIN (0xFFFFFFFF00000000LL)  // minimum value of Tx variable gain output
#define RX_VARGAIN_OUT_MAX (0x000000003FFFFFFFLL)  // maximum value of Rx variable gain output
#define RX_VARGAIN_OUT_MIN (0xFFFFFFFFC0000000LL)  // minimum value of Rx variable gain output
#else
#define SRC_FIR_ACC_MIN (0xFFFFFFFF80000000) // minimum value of SRC FIR accumulator
#define SRC_FIR_ACC_MAX (0x000000007FFFFFFF) // maximum value of SRC FIR accumulator
#define AFE_DECIM_FIR_ACC_MIN (0xFFFFFFFFFF000000) // minimum value of AFE Decim FIR accumulator
#define AFE_DECIM_FIR_ACC_MAX (0x0000000000FFFFFF) // maximum value of AFE Decim FIR accumulator
#define FIR_ACC_MIN  (0xFFFFFFFFC0000000) // minimum value of all other FIR accumulators
#define FIR_ACC_MAX  (0x000000003FFFFFFF) // maximum value of all other FIR accumulators
#define TX_VARGAIN_OUT_MAX (0x00000000FFFFFFFF) // maximum value of Rx variable gain output
#define TX_VARGAIN_OUT_MIN (0xFFFFFFFF00000000) // minimum value of Rx variable gain output
#define RX_VARGAIN_OUT_MAX (0x000000003FFFFFFF) // maximum value of Rx variable gain output
#define RX_VARGAIN_OUT_MIN (0xFFFFFFFFC0000000) // minimum value of Rx variable gain output
#endif

#define FIR_OUT_MAX           (0x7FFF)          // maximum FIR output
#define FIR_OUT_MIN           (0x8000)          // minimum FIR output

// Define FIR filter types
#define AFE_DECIM_FIR   (0)
#define RX_SRC_FIR      (1)
#define RX_DECIM_FIR (2)
#define TDQ_FIR         (3)
#define DEC_FIR         (4)
#define TX_INTERP_FIR   (5)
#define TX_SRC_FIR      (6)

#define MAX_STR_LATENCY       (512) // maximum latency in reference to the 70656 Ks/s clock

// Individual normal mode block latencies
#define TX_FT_ENABLE (0)
#define TX_FT_DELAY (0)
#define TX_VAR_GAIN_ENABLE (0)
#define TX_VAR_GAIN_DELAY (1)
#define TX_WIN_ENABLE (0)
#define TX_WIN_DELAY (0)
#define TX_IIR_ENABLE (0)
#define TX_IIR_DELAY (0)
#define TX_SRC_DELAY (0)
#define TX_SRC_FIFO_DEPTH (3)
#define TX_DEC_ENABLE (0)
#define TX_DEC_DELAY (0)
#define TX_INTERP_ENABLE (0)
#define TX_INTERP_DELAY (0)
#define TX_AFE_ENABLE (0)
#define TX_AFE_DELAY (0)
#define RX_AFE_ENABLE (0)
#define RX_AFE_DELAY (0)
#define RX_SRC_ENABLE (0)
#define RX_AFE_DECIM_FIR_DELAY (1)
#define RX_DECIM_ENABLE (0)
#define RX_DECIM_DELAY (0)
#define RX_IIR_ENABLE (0)
#define RX_IIR_DELAY (0)
#define RX_TDQ_ENABLE (0)
#define RX_TDQ_DELAY (1)
#define RX_FT_ENABLE (0)
#define RX_FT_DELAY (0)
#define RX_VAR_GAIN_ENABLE (0)
#define RX_VAR_GAIN_DELAY (0)
#define RX_WIN_ENABLE (0)
#define RX_WIN_DELAY (2)
#define RX_SRC_DELAY (0)
#define RX_TOTAL_CLOCK_DELAY (23) //Model RTL's total latency in Rx path, in unit of 70.7MHz clock.

// Individual debug trigger mode block latencies
#define TX_FT_ENABLE_DBG (0)
#define TX_FT_DELAY_DBG (0)
#define TX_VAR_GAIN_ENABLE_DBG (0)
#define TX_VAR_GAIN_DELAY_DBG (1)
#define TX_WIN_ENABLE_DBG (0)
#define TX_WIN_DELAY_DBG (0)
#define TX_IIR_ENABLE_DBG (0)
#define TX_IIR_DELAY_DBG (0)
#define TX_DEC_ENABLE_DBG (0)
#define TX_DEC_DELAY_DBG (0)
#define TX_INTERP_ENABLE_DBG (0)
#define TX_INTERP_DELAY_DBG (0)
#define TX_SRC_ENABLE_DBG (0)
#define TX_SRC_DELAY_DBG (0)
#define TX_SRC_FIFO_DEPTH_DBG (2)
#define TX_AFE_ENABLE_DBG (0)
#define TX_AFE_DELAY_DBG (0)
#define RX_AFE_ENABLE_DBG (37)
#define RX_AFE_DELAY_DBG (0)
#define RX_SRC_ENABLE_DBG (0)
#define RX_SRC_DELAY_DBG (0)
#define RX_AFE_DECIM_FIR_DELAY_DBG (1)
#define RX_DECIM_ENABLE_DBG (0)
#define RX_DECIM_DELAY_DBG (0)
#define RX_IIR_ENABLE_DBG (0)
#define RX_IIR_DELAY_DBG (0)
#define RX_TDQ_ENABLE_DBG (0)
#define RX_TDQ_DELAY_DBG (1)
#define RX_FT_ENABLE_DBG (0)
#define RX_FT_DELAY_DBG (0)
#define RX_VAR_GAIN_ENABLE_DBG (0)
#define RX_VAR_GAIN_DELAY_DBG (0)
#define RX_WIN_ENABLE_DBG (0)
#define RX_WIN_DELAY_DBG (2)

// Register bit masks
#ifndef MASK_BIT0
#define MASK_BIT0             (0x0001)
#define MASK_BIT1             (0x0002)
#define MASK_BIT2             (0x0004)
#define MASK_BIT3             (0x0008)
#define MASK_BIT4             (0x0010)
#define MASK_BIT5             (0x0020)
#define MASK_BIT6             (0x0040)
#define MASK_BIT7             (0x0080)
#define MASK_BIT8             (0x0100)
#define MASK_BIT9             (0x0200)
#define MASK_BIT10               (0x0400)
#define MASK_BIT11               (0x0800)
#define MASK_BIT12               (0x1000)
#define MASK_BIT13               (0x2000)
#define MASK_BIT14               (0x4000)
#define MASK_BIT15               (0x8000)
#define MASK_BIT16               (0x00010000)
#define MASK_BIT17               (0x00020000)
#define MASK_BIT18               (0x00040000)
#define MASK_BIT19               (0x00080000)
#define MASK_BIT20               (0x00100000)
#define MASK_BIT21               (0x00200000)
#define MASK_BIT22               (0x00400000)
#define MASK_BIT23               (0x00800000)
#define MASK_BIT24               (0x01000000)
#define MASK_BIT25               (0x02000000)
#define MASK_BIT26               (0x04000000)
#define MASK_BIT27               (0x08000000)
#define MASK_BIT28               (0x10000000)
#define MASK_BIT29               (0x20000000)
#define MASK_BIT30               (0x40000000)
#define MASK_BIT31               (0x80000000)
#endif // MASK_BIT0

// Byte enable masks
#define STR_NO_BYTE_EN     (0x0)
#define STR_BYTE0_EN    (0x1)
#define STR_BYTE1_EN    (0x2)
#define STR_BYTE2_EN    (0x4)
#define STR_BYTE3_EN    (0x8)
#define STR_LOWER_WORD_EN  (STR_BYTE1_EN | STR_BYTE0_EN)
#define STR_UPPER_WORD_EN  (STR_BYTE3_EN | STR_BYTE2_EN)
#define STR_LONGWORD_EN    (STR_UPPER_WORD_EN | STR_LOWER_WORD_EN)

// Byte masks
#define BYTE0_MASK      (0x000000FF)
#define BYTE1_MASK      (0x0000FF00)
#define BYTE2_MASK      (0x00FF0000)
#define BYTE3_MASK      (0xFF000000)
#define LOWER_WORD_MASK (BYTE1_MASK | BYTE0_MASK)
#define UPPER_WORD_MASK (BYTE3_MASK | BYTE2_MASK)
#define LONGWORD_MASK   (UPPER_WORD_MASK | LOWER_WORD_MASK)

// Sampling rates (Ks/s)
#define SAMPLE_RATE_552    (552)
#define SAMPLE_RATE_1104   (1104)
#define SAMPLE_RATE_2208   (2208)
#define SAMPLE_RATE_4416   (4416)
#define SAMPLE_RATE_8832   (8832)
#define SAMPLE_RATE_17664  (17664)
#define SAMPLE_RATE_35328  (35328)
#define SAMPLE_RATE_70656  (70656)

// DEC Training
#define DEC_TRN_IDLE 0x0
#define DEC_TRN_CNT     0x1
#define DEC_TRN_CAPT 0x2
#define DEC_TRN_WAIT 0x22
#define DEC_TRN_DONE 0x3
#define DEC_TRN_MAX_SAMPLE_CNT 255
#define DEC_TRN_MAX_CAPT_CNT 16
#define MAX_DEC_IN_SAMPLES 240

// SRC coefficient memory
#define SRCCO_NUM_96BITS_SECTIONS      384
#define NUM_32BITS_PER_96BITS       3  // 96 bits = 32 bits x 3
#define SRC_COEF                 0  // Flag

#define MASK_COEF_POSITION_INDEX_0     0xFFF00000  // srcco0 95:84
#define MASK_SLOPE_POSITION_INDEX_0    0x000FE000  // srcco0 83:77
#define MASK_COEF_POSITION_INDEX_1_HI  0x00001FFF  // srcco0 76:64
#define MASK_COEF_POSITION_INDEX_1_LO  0x80000000  // srcco0 63:63
#define MASK_SLOPE_POSITION_INDEX_1    0x7F800000  // srcco0 62:55
#define MASK_COEF_POSITION_INDEX_2     0x007FFF80  // srcco0 54:39
#define MASK_SLOPE_POSITION_INDEX_2_HI 0x0000007F  // srcco0 38:32
#define MASK_SLOPE_POSITION_INDEX_2_LO 0xE0000000  // srcco0 31:29
#define MASK_COEF_POSITION_INDEX_3     0x1FFFF000  // srcco0 28:12
#define MASK_SLOPE_POSITION_INDEX_3    0x00000FFF  // srcco0 11:0

#define MASK_COEF_POSITION_INDEX_4     0xFFFF8000  // srcco1 95:79
#define MASK_SLOPE_POSITION_INDEX_4    0x00007FF8  // srcco1 78:67
#define MASK_COEF_POSITION_INDEX_5_HI  0x00000007  // srcco1 66:64
#define MASK_COEF_POSITION_INDEX_5_LO  0xFFF80000  // srcco1 63:51
#define MASK_SLOPE_POSITION_INDEX_5    0x0007FE00  // srcco1 50:41
#define MASK_COEF_POSITION_INDEX_6_HI  0x000001FF  // srcco1 40:32
#define MASK_COEF_POSITION_INDEX_6_LO  0xF8000000  // srcco1 31:27
#define MASK_SLOPE_POSITION_INDEX_6    0x07F80000  // srcco1 26:19
#define MASK_COEF_POSITION_INDEX_7     0x0007FF80  // srcco1 18:7
#define MASK_SLOPE_POSITION_INDEX_7    0x0000007F  // srcco1 6:0

#define LSB_COEF_POSITION_INDEX_0      20
#define LSB_COEF_POSITION_INDEX_1_HI   (-1)
#define LSB_COEF_POSITION_INDEX_1_LO   31
#define LSB_COEF_POSITION_INDEX_2      7
#define LSB_COEF_POSITION_INDEX_3      12
#define LSB_COEF_POSITION_INDEX_4      15
#define LSB_COEF_POSITION_INDEX_5_HI   (-13)
#define LSB_COEF_POSITION_INDEX_5_LO   19
#define LSB_COEF_POSITION_INDEX_6_HI   (-5)
#define LSB_COEF_POSITION_INDEX_6_LO   27
#define LSB_COEF_POSITION_INDEX_7      7

#define LSB_SLOPE_POSITION_INDEX_0     13
#define LSB_SLOPE_POSITION_INDEX_1     23
#define LSB_SLOPE_POSITION_INDEX_2_HI  (-3)
#define LSB_SLOPE_POSITION_INDEX_2_LO  29
#define LSB_SLOPE_POSITION_INDEX_3     0
#define LSB_SLOPE_POSITION_INDEX_4     3
#define LSB_SLOPE_POSITION_INDEX_5     9
#define LSB_SLOPE_POSITION_INDEX_6     19
#define LSB_SLOPE_POSITION_INDEX_7     0

// --------------------------
//   Exception definitions
// --------------------------
#define NO_EXCEPTION       0     // Default value
#define INVALID_DEC_LENGTH    1     // DEC length not a multiple of 4
#define INVALID_TDQ_LENGTH    2     // TDQ length not a multiple of 4
#define INVALID_RATE_CFG      3     // Tx DAC rate > Tx path sample rate
#define INVALID_MEM_ACCESS    4     // Invalid access to memory
#define INVALID_DEC_IN_SAMPLES   5     // Exceeded max number of DEC input samples

#endif // _V_STR_CONST_H
