/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;   Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;   Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;   File Name: v_str_io_typedef.h
;
;   Data types of the Strymon behavioral model.
;
*****************************************************************************/

#ifndef _V_STR_IO_TYPEDEF_H
#define _V_STR_IO_TYPEDEF_H

#ifndef _BASIC_TYPES
#define _BASIC_TYPES

//Variable type definitions
typedef char           int8;     // prefix c
typedef short          int16;    // prefix s
typedef int            int32;    // prefix l
typedef unsigned char  uint8;    // prefix uc
typedef unsigned short uint16;      // prefix us
typedef unsigned int   uint32;      // prefix ul
typedef unsigned char  FlagT;    // prefix ft
typedef unsigned int Float32;
typedef double float64;          // prefix d
#endif //#ifndef _BASIC_TYPES

#ifndef acc
// define 64-bit accumulator type
#ifdef UNIX_PLATFORM
#define acc long long
#else
#ifdef MSVC_ONLY
#define acc __int64
#else
#define acc long
#endif
#endif
#endif //#ifndef acc

#ifndef FALSE
#define FALSE           0
#endif
#ifndef TRUE
#define TRUE            1
#endif

// Strymon input strobe structures
typedef struct {
   uint8 uc_TX_BUFSWAP;       // Transmit IFFT buffer swap Strobe
   uint8 uc_TX_CSCAPTURE_START;  // Strobe starting saving of Tx frame's last-beta portion
   uint8 uc_TX_WINDOW_START;     // Strobe kicking off windowed summation of Tx frame's
                           // CP and last frame's last-beta portion of CS
   uint16 us_TX_BETA_SIZE;       // Beta length
   uint8 uc_TOFS_IN;          // Tx Offset Input Strobe
   uint8 uc_TOFS_ER;          // Tx Offset Error Strobe
   uint8 uc_RX_BUFSWAP;       // Transmit IFFT buffer swap Strobe
   uint8 uc_RX_CPCAPTURE_START;  // Strobe starting saving of Rx CP's last-Lw portion
   uint8 uc_RX_WINDOW_START;     // Strobe kicking off windowed summation of Rx frame's
                           // last-Lw portion and last-Lw portion of CP.
   uint16 us_RX_LW_SIZE;         // length of Lw.
   uint8 uc_IRSFS;               // Receive Sync Frame Strobe
   uint8 uc_RSTN;             // Asynchronous reset
} V_Str_Input_t;

// Strymon output strobe structures
typedef struct {
   int16 s_DECDONE;
} V_Str_Output_t;

// Strymon Core I/O structure
typedef struct {
   int32 l_TxIn;
   int16 s_TxOut;
   int16 s_RxIn;
   int16 s_RxOut;
} StrymonCoreIO_t;

#endif // _V_STR_IO_TYPEDEF_H
