/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: v_str_memmap.h
;
;  This file contains Strymon memory map.
;
*****************************************************************************/
#ifndef _V_STR_MEMMAP_H
#define _V_STR_MEMMAP_H

// Register offsets
#define V_CONTROL_OFFSET      (0x00)
#define V_OVERFLOW_OFFSET     (0x01)
#define V_TXIIR1_CFG_OFFSET      (0x02)
#define V_TXIIR2_CFG_OFFSET      (0x03)
#define V_RXIIR_CFG_OFFSET    (0x04)
#define V_AFE_DECIM_CFG_OFFSET   (0x05)
#define V_SRCFR_OFFSET        (0x06)
#define V_SRCCTL_OFFSET       (0x07)
#define V_RESAMP_CFG_OFFSET      (0x08)
#define V_DEC_TDQ_CFG_OFFSET  (0x09)
#define V_DEC_TRAIN_OFFSET    (0x0A)
#define V_TX_VARGAIN_OFFSET      (0x0B)
#define V_TX_AVARGAIN_OFFSET  (0x0C)
#define V_RX_VARGAIN_OFFSET      (0x0D)
#define V_RX_AVARGAIN_OFFSET  (0x0E)
#define V_AFE_DECIM_IN_DBG_OFFSET   (0x20)
#define V_DECIM_IN_DBG_OFFSET (0x21)
#define V_RXIIR_IN_DBG_OFFSET (0x22)
#define V_TDQ_LSB_IN_DBG_OFFSET  (0x23)
#define V_DEC_IN_DBG_OFFSET      (0x24)
#define V_TXIIR_IN_DBG_OFFSET (0x25)
#define V_INTERP_IN_DBG_OFFSET   (0x26)
#define V_INTERP_OUT_DBG_OFFSET  (0x27)
#define V_WINDOW_DBG_OFFSET      (0x28)
#define V_RXSRC_PHASE_IN_DBG_OFFSET (0x29)
#define V_TDQ_MSB_IN_DBG_OFFSET  (0x2A)

#define V_STR_REG_SIZE        (V_TDQ_MSB_IN_DBG_OFFSET+1)
#define V_STR_RESET_REG_SIZE  (V_RX_AVARGAIN_OFFSET + 1)

// Memory offsets
#define V_DEC_TDQ_CO_OFFSET      (0x0) // DEC/TDQ coefficients.
#define V_DEC_TDQ_PS_OFFSET      (0x200)  // DEC/TDQ past samples.
#define V_DECIM_PS_OFFSET     (0x400)  // DECIM past samples.
#define V_DECIM_CO_OFFSET     (0x500)  // DECIM coefficients.
#define V_TXWIN_COPS_OFFSET      (0x600)  // Tx window coefficients and past samples.
#define V_RXWIN_COPS_OFFSET      (0x800)  // Rx window coefficients and past samples.
#define V_TXIIR_CO_OFFSET     (0x900)  // Tx IIR1 coefficients.
#define V_INTERP_PS_OFFSET    (0xA00)  // Interp past samples.
#define V_INTERP_CO_OFFSET    (0xB00)  // Interp coefficients.
#define V_DEC_CAPTURE_OFFSET  (0xC00)  // DEC showtime capture samples.
#define V_RXIIR_CO_OFFSET     (0xD00)  // Rx IIR coefficients.
#define V_AFEDECIM_CO_OFFSET  (0xD40)  // AFE DECIM coefficients.
#define V_SRCCO0_OFFSET       (0x1000) // Lower-half Coefficients for VDSL Tx & Rx SRC
#define V_SRCCO1_OFFSET       (0x1800) // Upper-half Coefficients for VDSL Tx & Rx SRC

// Memory sizes
#define V_DEC_TDQ_CO_SIZE  (256)
#define V_DEC_TDQ_PS_SIZE  (320)
#define V_DECIM_PS_SIZE    (128)
#define V_DECIM_CO_SIZE    (128)
#define V_TXWIN_COPS_SIZE  (288)
#define V_TXWIN_CO_SIZE_VDSL (96)
#define V_TXWIN_PS_SIZE_VDSL (192)
#define V_TXWIN_CO_SIZE_ADSL (144)
#define V_TXWIN_PS_SIZE_ADSL (144)
#define V_RXWIN_COPS_SIZE  (192)
#define V_RXWIN_CO_SIZE    (64)
#define V_RXWIN_PS_SIZE    (128)
#define V_TXIIR_CO_SIZE (41)
#define V_INTERP_PS_SIZE   (12)
#define V_INTERP_CO_SIZE   (96)
#define V_DEC_CAPTURE_SIZE (128)
#define V_DEC_ERROR_CAPTURE_SIZE (8)
#define V_RXIIR_CO_SIZE    (21)
#define V_AFE_DECIM_FIR_CO_SIZE  (13)
#define V_AFE_DECIM_IIR_CO_SIZE  (11)
#define V_AFEDECIM_CO_SIZE (V_AFE_DECIM_FIR_CO_SIZE+V_AFE_DECIM_IIR_CO_SIZE)
#define V_SRCCO0_SIZE      (1152)
#define V_SRCCO1_SIZE      (1152)

#define V_STR_RAM_SIZE     (V_SRCCO1_OFFSET + V_SRCCO1_SIZE - V_DEC_TDQ_CO_OFFSET)

// AFE DECIM IIR coefficient memory offsets
#define AFE_DECIM_IIR_IN_SC_OFFSET  (0x00)
#define AFE_DECIM_IIR_A2_OFFSET     (0x01)
#define AFE_DECIM_IIR_A1_OFFSET     (0x02)
#define AFE_DECIM_IIR_B2_OFFSET     (0x03)
#define AFE_DECIM_IIR_B1_OFFSET     (0x04)
#define AFE_DECIM_IIR_B0_OFFSET     (0x05)

#define AFE_DECIM_IIR_SEC0_IN_SC_OFFSET      (V_AFEDECIM_CO_OFFSET + V_AFE_DECIM_FIR_CO_SIZE)
#define AFE_DECIM_IIR_SEC0_A2_OFFSET      (AFE_DECIM_IIR_SEC0_IN_SC_OFFSET + AFE_DECIM_IIR_A2_OFFSET)
#define AFE_DECIM_IIR_SEC0_A1_OFFSET      (AFE_DECIM_IIR_SEC0_IN_SC_OFFSET + AFE_DECIM_IIR_A1_OFFSET)
#define AFE_DECIM_IIR_SEC0_B2_OFFSET      (AFE_DECIM_IIR_SEC0_IN_SC_OFFSET + AFE_DECIM_IIR_B2_OFFSET)
#define AFE_DECIM_IIR_SEC0_B1_OFFSET      (AFE_DECIM_IIR_SEC0_IN_SC_OFFSET + AFE_DECIM_IIR_B1_OFFSET)
#define AFE_DECIM_IIR_SEC0_B0_OFFSET      (AFE_DECIM_IIR_SEC0_IN_SC_OFFSET + AFE_DECIM_IIR_B0_OFFSET)

// Rx IIR coefficient memory offsets
#define V_RXIIR_IN_SC_OFFSET  (0x00)
#define V_RXIIR_A1_OFFSET     (0x01)
#define V_RXIIR_A2_OFFSET     (0x02)
#define V_RXIIR_B0_OFFSET     (0x03)
#define V_RXIIR_B1_OFFSET     (0x04)
#define V_RXIIR_B2_OFFSET     (0x05)

#define V_RXIIR_SEC0_IN_SC_OFFSET      (V_RXIIR_CO_OFFSET)
#define V_RXIIR_SEC0_A1_OFFSET      (V_RXIIR_SEC0_IN_SC_OFFSET + V_RXIIR_A1_OFFSET)
#define V_RXIIR_SEC0_A2_OFFSET      (V_RXIIR_SEC0_IN_SC_OFFSET + V_RXIIR_A2_OFFSET)
#define V_RXIIR_SEC0_B0_OFFSET      (V_RXIIR_SEC0_IN_SC_OFFSET + V_RXIIR_B0_OFFSET)
#define V_RXIIR_SEC0_B1_OFFSET      (V_RXIIR_SEC0_IN_SC_OFFSET + V_RXIIR_B1_OFFSET)
#define V_RXIIR_SEC0_B2_OFFSET      (V_RXIIR_SEC0_IN_SC_OFFSET + V_RXIIR_B2_OFFSET)

// Tx IIR coefficient memory offsets
#define V_TXIIR_IN_SC_OFFSET  (0x00)
#define V_TXIIR_A1_OFFSET     (0x01)
#define V_TXIIR_A2_OFFSET     (0x02)
#define V_TXIIR_B0_OFFSET     (0x03)
#define V_TXIIR_B1_OFFSET     (0x04)
#define V_TXIIR_B2_OFFSET     (0x05)

#define V_TXIIR_SEC0_IN_SC_OFFSET   (V_TXIIR_CO_OFFSET)
#define V_TXIIR_SEC0_A1_OFFSET      (V_TXIIR_SEC0_IN_SC_OFFSET + V_TXIIR_A1_OFFSET)
#define V_TXIIR_SEC0_A2_OFFSET      (V_TXIIR_SEC0_IN_SC_OFFSET + V_TXIIR_A2_OFFSET)
#define V_TXIIR_SEC0_B0_OFFSET      (V_TXIIR_SEC0_IN_SC_OFFSET + V_TXIIR_B0_OFFSET)
#define V_TXIIR_SEC0_B1_OFFSET      (V_TXIIR_SEC0_IN_SC_OFFSET + V_TXIIR_B1_OFFSET)
#define V_TXIIR_SEC0_B2_OFFSET      (V_TXIIR_SEC0_IN_SC_OFFSET + V_TXIIR_B2_OFFSET)

// Register masks
#define V_CONTROL_MASK        (0x0001FF3E)
#define V_OVERFLOW_MASK       (0xC0006FFF)
#define V_TXIIR1_CFG_MASK     (0x0007FFFF)
#define V_TXIIR2_CFG_MASK     (0x000FFFFF)
#define V_RXIIR_CFG_MASK      (0x000FFFFF)
#define V_AFE_DECIM_CFG_MASK  (0x00000FFF)
#define V_SRCFR_MASK       (0x000FFFFF)
#define V_SRCCTL_MASK         (0x00FFFFFF)
#define V_RESAMP_CFG_MASK     (0xFFF31FFF)
#define V_DEC_TDQ_CFG_MASK    (0x2FEF7FFF)
#define V_DEC_TDQ_LENGTHS     ((0x7F << 21) | (0x7F << 8))
#define V_DEC_TRAIN_MASK      (0x000007F9)
#define V_TX_VARGAIN_MASK     (0x0007FFFF)
#define V_TX_AVARGAIN_MASK    (0x0007FFFF)
#define V_RX_VARGAIN_MASK     (0x0007FFFF)
#define V_RX_AVARGAIN_MASK    (0x0007FFFF)

// Memory masks
#define V_DEC_TDQ_CO_MASK     (0xFFFFFFFF)   // DEC/TDQ coefficients.
#define V_DEC_TDQ_PS_MASK     (0xFFFFFFFF)   // DEC/TDQ past samples.
#define V_DECIM_PS_MASK       (0xFFFFFFFF)   // DECIM past samples.
#define V_DECIM_CO_MASK       (0xFFFFFFFF)   // DECIM coefficients.
#define V_TXWIN_COPS_MASK     (0xFFFFFFFF)   // Tx window coefficients and past samples.
#define V_RXWIN_COPS_MASK     (0xFFFFFFFF)   // Rx window coefficients and past samples.
#define V_TXIIR_CO_MASK       (0x0003FFFF)   // Tx IIR coefficients.
#define V_INTERP_PS_MASK      (0xFFFFFFFF)   // Interp past samples.
#define V_INTERP_CO_MASK      (0xFFFFFFFF)   // Interp coefficients.
#define V_DEC_CAPTURE_MASK    (0xFFFFFFFF)   // DEC showtime capture samples.
#define V_RXIIR_CO_MASK       (0x00003FFF)   // Rx IIR coefficients.
#define V_AFEDECIM_CO_MASK    (0x0000FFFF)   // AFE DECIM coefficients.
#define V_SRCCO0_MASK         (0xFFFFFFFF)   // SRC coefficients and slopes
#define V_SRCCO1_MASK         (0xFFFFFFFF)   // SRC coefficients and slopes

/**********************************************************************
 * Memory map for STRYMON
 **********************************************************************/
#define     V_STR_REG_BASE_ADDR     (0xC140)
#define     V_STR_MEM_BASE_ADDR     (0x1D000)

// Register addresses
#define V_CONTROL_ADDR     (V_STR_REG_BASE_ADDR + V_CONTROL_OFFSET)
#define V_OVERFLOW_ADDR    (V_STR_REG_BASE_ADDR + V_OVERFLOW_OFFSET)
#define V_TXIIR1_CFG_ADDR  (V_STR_REG_BASE_ADDR + V_TXIIR1_CFG_OFFSET)
#define V_TXIIR2_CFG_ADDR  (V_STR_REG_BASE_ADDR + V_TXIIR2_CFG_OFFSET)
#define V_RXIIR_CFG_ADDR   (V_STR_REG_BASE_ADDR + V_RXIIR_CFG_OFFSET)
#define V_AFE_DECIM_CFG_ADDR (V_STR_REG_BASE_ADDR + V_AFE_DECIM_CFG_OFFSET)
#define V_SRCFR_ADDR    (V_STR_REG_BASE_ADDR + V_SRCFR_OFFSET)
#define V_SRCCTL_ADDR      (V_STR_REG_BASE_ADDR + V_SRCCTL_OFFSET)
#define V_RESAMP_CFG_ADDR  (V_STR_REG_BASE_ADDR + V_RESAMP_CFG_OFFSET)
#define V_DEC_TDQ_CFG_ADDR (V_STR_REG_BASE_ADDR + V_DEC_TDQ_CFG_OFFSET)
#define V_DEC_TRAIN_ADDR   (V_STR_REG_BASE_ADDR + V_DEC_TRAIN_OFFSET)
#define V_TX_VARGAIN_ADDR  (V_STR_REG_BASE_ADDR + V_TX_VARGAIN_OFFSET)
#define V_TX_AVARGAIN_ADDR (V_STR_REG_BASE_ADDR + V_TX_AVARGAIN_OFFSET)
#define V_RX_VARGAIN_ADDR  (V_STR_REG_BASE_ADDR + V_RX_VARGAIN_OFFSET)
#define V_RX_AVARGAIN_ADDR (V_STR_REG_BASE_ADDR + V_RX_AVARGAIN_OFFSET)
#define V_AFE_DECIM_IN_DBG_ADDR (V_STR_REG_BASE_ADDR + V_AFE_DECIM_IN_DBG_OFFSET)
#define V_DECIM_IN_DBG_ADDR      (V_STR_REG_BASE_ADDR + V_DECIM_IN_DBG_OFFSET)
#define V_RXIIR_IN_DBG_ADDR   (V_STR_REG_BASE_ADDR + V_RXIIR_IN_DBG_OFFSET)
#define V_TDQ_LSB_IN_DBG_ADDR (V_STR_REG_BASE_ADDR + V_TDQ_LSB_IN_DBG_OFFSET)
#define V_DEC_IN_DBG_ADDR  (V_STR_REG_BASE_ADDR + V_DEC_IN_DBG_OFFSET)
#define V_TXIIR_IN_DBG_ADDR   (V_STR_REG_BASE_ADDR + V_TXIIR_IN_DBG_OFFSET)
#define V_INTERP_IN_DBG_ADDR  (V_STR_REG_BASE_ADDR + V_INTERP_IN_DBG_OFFSET)
#define V_INTERP_OUT_DBG_ADDR (V_STR_REG_BASE_ADDR + V_INTERP_OUT_DBG_OFFSET)
#define V_WINDOW_DBG_ADDR  (V_STR_REG_BASE_ADDR + V_WINDOW_DBG_OFFSET)
#define V_RXSRC_PHASE_IN_DBG_ADDR   (V_STR_REG_BASE_ADDR + V_RXSRC_PHASE_IN_DBG_OFFSET)
#define V_TDQ_MSB_IN_DBG_ADDR (V_STR_REG_BASE_ADDR + V_TDQ_MSB_IN_DBG_OFFSET)

#define V_MAX_REG_ADDR        V_TDQ_MSB_IN_DBG_ADDR

// Memory addresses
#define V_DEC_TDQ_CO_ADDR  (V_STR_MEM_BASE_ADDR + V_DEC_TDQ_CO_OFFSET)
#define V_DEC_TDQ_PS_ADDR  (V_STR_MEM_BASE_ADDR + V_DEC_TDQ_PS_OFFSET)
#define V_DECIM_PS_ADDR    (V_STR_MEM_BASE_ADDR + V_DECIM_PS_OFFSET)
#define V_DECIM_CO_ADDR    (V_STR_MEM_BASE_ADDR + V_DECIM_CO_OFFSET)
#define V_TXWIN_COPS_ADDR  (V_STR_MEM_BASE_ADDR + V_TXWIN_COPS_OFFSET)
#define V_RXWIN_COPS_ADDR  (V_STR_MEM_BASE_ADDR + V_RXWIN_COPS_OFFSET)
#define V_TXIIR_CO_ADDR    (V_STR_MEM_BASE_ADDR + V_TXIIR_CO_OFFSET)
#define V_INTERP_PS_ADDR   (V_STR_MEM_BASE_ADDR + V_INTERP_PS_OFFSET)
#define V_INTERP_CO_ADDR   (V_STR_MEM_BASE_ADDR + V_INTERP_CO_OFFSET)
#define V_DEC_CAPTURE_ADDR (V_STR_MEM_BASE_ADDR + V_DEC_CAPTURE_OFFSET)
#define V_RXIIR_CO_ADDR    (V_STR_MEM_BASE_ADDR + V_RXIIR_CO_OFFSET)
#define V_AFEDECIM_CO_ADDR (V_STR_MEM_BASE_ADDR + V_AFEDECIM_CO_OFFSET)
#define V_SRCCO0_ADDR      (V_STR_MEM_BASE_ADDR + V_SRCCO0_OFFSET)
#define V_SRCCO1_ADDR      (V_STR_MEM_BASE_ADDR + V_SRCCO1_OFFSET)
#define V_MAX_RAM_ADDR     (V_STR_MEM_BASE_ADDR + V_STR_RAM_SIZE)

#endif //_V_STR_MEMMAP_H
