/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: v_str_private.h
;
;
*****************************************************************************/
#ifndef _V_STR_PRIVATE_H
#define _V_STR_PRIVATE_H

#include "v_str_typedef.h"
#include "v_str_io_typedef.h"
#include "v_str_memmap.h"

// Strymon core memory
extern int32 gla_StrymonMemory[V_STR_RAM_SIZE];
extern int32 gla_StrymonRegister[V_STR_REG_SIZE];

// Strymon register structure
extern StrymonReg_t gt_StrymonReg;

// Strymon filters I/O structure
extern StrymonFilterIO_t gt_StrymonFilterIO;

// Strymon strobe I/O structures
extern V_Str_Input_t gt_V_Str_Input;
extern V_Str_Output_t gt_V_Str_Output;

// SRC Controller
extern SrcControl_t gt_SrcControl;
extern int32 gla_SrcFirCoef[NUM_SRC_FIR_PARAMS];
extern int16 gsa_SrcFirSlope[NUM_SRC_FIR_PARAMS];

// SRC FR
extern int16 gs_SRCFRDelay;
extern int32 gla_SRCFR[SRCFR_DELAY_70656+1];

// Tx Window
extern int16 *gpsa_TxCPCoef, *gpsa_TxCSCapture;
extern int16 gsa_TxCSCaptureStrobe[MAX_STR_LATENCY], gsa_TxWindowStrobe[MAX_STR_LATENCY];
extern uint16 gus_V_TXWIN_CO_SIZE, gus_V_TXWIN_PS_SIZE;
extern int32 gl_TxVWDebugTriggerClock;

// DEC
extern FirStruc_t gt_DEC;
extern int16 gs_LatchTxOffsetDecInputStrobe, gs_LatchTxOffsetDecErrorStrobe, gs_DelayLatchTxOffsetDecErrorStrobe;
extern int16 gs_DecInCaptCnt, gs_DecInCaptDelay, gs_DecErrCaptCnt;
extern int16 gsa_DecInputBuffer[DEC_INPUT_BUFFER_SIZE], gsa_DecDelayBuffer[DEC_DELAY_BUFFER_SIZE];
extern int16 gs_DecTrnWait, gs_DecTrnWaitCnt;
extern int16 gs_DecErrorStrobePhase;

// Tx IIR filter
extern IirStruc_t gt_TxIir;
extern biquadSection_t gt_TxIirBiquad[NUM_TX_IIR_BIQUADS];
extern int32 gla_TxIirPastResults[TX_IIR_ORDER+1];

// Tx SRC
extern FirStruc_t gt_TxSrc;
extern int32 gla_TxSrcCoef[MAX_TX_SRC_FIR_LEN];
extern int16 gsa_TxSrcStates[TX_SRC_FIR_PHASE_LEN];
extern int16 gsa_TxSrcIn[TX_SRC_FIFO_DEPTH+1];
extern int16 gs_TxSrcLen;
extern int16 gs_TxSrcInterpFactor;

// Tx Interp
extern FirStruc_t gt_TxInterp;
extern int16 gs_TxInterpFactor;
extern int16 gs_TxInterpTriggerIndex;

// Rx SRC
extern FirStruc_t gt_RxSrc;
extern int32 gla_RxSrcCoef[MAX_RX_SRC_FIR_LEN], gla_RxPhaseAccOut[2];
extern int16 gsa_RxSrcStates[MAX_RX_SRC_FIR_LEN];
extern int16 gs_RxSrcLen;

// Rx AFE Decim
extern FirStruc_t gt_AfeDecimFir;
extern int16 gsa_AfeDecimFirCoef[AFE_DECIM_FIR_LEN];
extern int16 gsa_AfeDecimFirStates[AFE_DECIM_FIR_LEN];
extern int16 gs_AfeDecimFirLen;
extern IirStruc_t gt_AfeDecimIir;
extern biquadSection_t gt_AfeDecimIirBiquad[NUM_AFE_DECIM_IIR_BIQUADS];
extern int32 gla_AfeDecimIirPastResults[AFE_DECIM_IIR_ORDER+1];

// Rx Decimator
extern FirStruc_t gt_Decim;

// Rx IIR filter
extern IirStruc_t gt_RxIir;
extern biquadSection_t gt_RxIirBiquad[NUM_RX_IIR_BIQUADS];
extern int32 gla_RxIirPastResults[RX_IIR_ORDER+1];

// TDQ
extern FirStruc_t gt_TDQ;

// Rx window
extern int16 *gpsa_RxCPCoef, *gpsa_RxCPCapture;
extern int16 gs_RxCPCapture, gs_RxWindow;
extern int16 gs_RxWindowCounter;
extern int16 gs_RxWindowStoreCP;

// Individual block latencies
extern int16 gs_TxFTEnable;
extern int16 gs_TxFTDelay;
extern int16 gs_TxVarGainEnable;
extern int16 gs_TxVarGainDelay;
extern int16 gs_TxWinEnable;
extern int16 gs_TxWinDelay;
extern int16 gs_TxIirEnable;
extern int16 gs_TxIirDelay;
extern int16 gs_TxDecEnable;
extern int16 gs_TxDecDelay;
extern int16 gs_TxInterpEnable;
extern int16 gs_TxInterpDelay;
extern int16 gs_TxSrcEnable;
extern int16 gs_TxSrcDelay;
extern int16 gs_TxAfeEnable;
extern int16 gs_TxAfeDelay;
extern int16 gs_RxAfeEnable;
extern int16 gs_RxAfeDelay;
extern int16 gs_RxSrcEnable;
extern int16 gs_RxSrcDelay;
extern int16 gs_RxAfeDecimFirDelay;
extern int16 gs_RxDecimEnable;
extern int16 gs_RxDecimDelay;
extern int16 gs_RxIirEnable;
extern int16 gs_RxIirDelay;
extern int16 gs_RxTdqEnable;
extern int16 gs_RxTdqDelay;
extern int16 gs_RxFTEnable;
extern int16 gs_RxFTDelay;
extern int16 gs_RxVarGainEnable;
extern int16 gs_RxVarGainDelay;
extern int16 gs_RxWinEnable;
extern int16 gs_RxWinDelay;
extern int16 gsa_RoundtripTriggerDelay[MAX_TDQ_LENGTH_VDSL>>2][MAX_NUM_BIQUADS];

// Output arrays for each Strymon block
extern int32 gla_TxStrymonFTOut[MAX_STR_LATENCY];
extern int16 gsa_TxVarGainOut[MAX_STR_LATENCY];
extern int16 gsa_TxWinOut[MAX_STR_LATENCY];
extern int16 gsa_TxDecIn[MAX_STR_LATENCY];
extern int16 gsa_TxIirOut[MAX_STR_LATENCY];
extern int16 gsa_TxInterpOut[MAX_STR_LATENCY];
extern int16 gsa_TxSrcOut[MAX_STR_LATENCY];
extern int16 gsa_TxAfeOut[MAX_STR_LATENCY];
extern int16 gsa_RxAfeOut[MAX_STR_LATENCY];
extern int16 gsa_RxSrcOut[MAX_STR_LATENCY];
extern int32 gla_RxAfeDecimFirOut[MAX_STR_LATENCY];
extern int16 gsa_RxDecimOut[MAX_STR_LATENCY];
extern acc gacca_RxIirOut[MAX_STR_LATENCY];
extern acc gacc_SumJuncIn;
extern acc gacca_RxDecOut[MAX_STR_LATENCY];
extern int16 gsa_RxTdqOut[MAX_STR_LATENCY];
extern int16 gsa_RxTdqOvf[MAX_STR_LATENCY];
extern int16 gsa_RxFTOut[MAX_STR_LATENCY];
extern int16 gsa_RxVarGainOut[MAX_STR_LATENCY];
extern int16 gsa_RxWinOut[MAX_STR_LATENCY];

// Strymon master clock
extern int32 gl_StrymonMasterClock;

// Flag used for triggering the Strymon components - always enabled when not VDSL CPE mode
extern FlagT gfta_TriggerStrymonTx[2];
extern FlagT gft_TriggerStrymonRx;

// Strymon component clock
extern int32 gl_StrymonClockTx, gl_StrymonClockRx;

// Exception array (see strymon_const.h for exception definitions)
extern int16 gs_StrymonException;

// Flag used for clearing the FIR block memories
extern FlagT gft_ClearFirPastSamples;

// Prototypes
void StrymonSrcControl(void);
void StrymonRxSrcControl(void);
void StrymonTxSrcControl(void);
void InterpSrcCoef(int16 s_FirParamAddr, int16 s_CoefOffset, int16 s_NumCoefPerSet, int32 *pl_outputCoef);
void StrymonRxClock(void);
void StrymonTxClock(void);
void StrymonTxVarGainClock(void);
void StrymonTxWinClock(void);
int16 TxIir(IirStruc_t *pt_filt, int16 s_numBiquads, int16 *s_in, int16 *s_out, int32 *la_prHistory, int16 s_ClearPrHistory);
void StrymonTxDecInputClock(void);
void StrymonTxInterpClock(void);
void StrymonTxSrcClock(void);
void StrymonTxAfeClock(void);
void StrymonRxAfeClock(void);
void StrymonRxAfeDecimClock(void);
int16 AfeDecimIir(IirStruc_t *pt_filt, int16 s_numBiquads, int32 *l_in, int16 *s_out, int32 *la_prHistory, int16 s_ClearPrHistory);
void StrymonRxSrcClock(void);
void StrymonRxDecimClock(void);
void StrymonRxIirClock(void);
int16 RxIir(IirStruc_t *pt_filt, int16 s_numBiquads, int16 *s_in, acc *acc_out, int32 *la_prHistory, int16 s_ClearPrHistory );
void StrymonRxTdqClock(void);
void StrymonRxWinClock(void);
void StrymonRxVarGainClock(void);
void ResyncRegister(uint32 ul_offset, uint32 ul_word, uint32 ul_pastRegVal);
void ResetStrymonBlocks(void);
void StrymonDecInputCapture(int16 s_inputSample);
void StrymonDecErrorCapture(int16 s_inputSample);
void StrymonDecTrain(void);
void TxRoundOutput(int16 *ps_SamplePtr);

#endif // _V_STR_PRIVATE_H
