/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;   Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;   Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;   File Name: v_str_typedef.h
;
;   Data types of the Strymon behavioral model.
;
****************************************************************************/

#ifndef _V_STR_TYPEDEF_H
#define _V_STR_TYPEDEF_H

#ifndef _BASIC_TYPES
#define _BASIC_TYPES

//Variable type definitions
typedef char           int8;     // prefix c
typedef short          int16;    // prefix s
typedef int            int32;    // prefix l
typedef unsigned char  uint8;    // prefix uc
typedef unsigned short uint16;      // prefix us
typedef unsigned int   uint32;      // prefix ul
typedef unsigned char  FlagT;    // prefix ft
typedef unsigned int Float32;
typedef double float64;          // prefix d
#endif //#ifndef _BASIC_TYPES

#ifndef acc
// define 64-bit accumulator type
#ifdef UNIX_PLATFORM
#define acc long long
#else
#ifdef MSVC_ONLY
#define acc __int64
#else
#define acc long
#endif
#endif
#endif //#ifndef acc

#ifndef FALSE
#define FALSE           0
#endif
#ifndef TRUE
#define TRUE            1
#endif

// Structure used for registers
typedef struct {
   // V_CONTROL

#ifndef UNIX_PLATFORM
   int16 s_MASTER_CLOCK_OVERRIDE;   // bit 31
   int32 l_MASTER_CLOCK;         // bits [30:28]
   int16 s_ZERO_LATENCIES;       // bit 27
#else
    int16 s_LRVDSL;                 // bit 26
#endif // UNIX_PLATFORM

   int16 s_TX_ROUND;
   int16 s_DAC_FS;
   int16 s_WIN_LOOPBACK;
   int16 s_RX_BYPASS;
   int16 s_ADC_FS;
   int16 s_RESET_STATEN;
   int16 s_TRIG_SEL;
   int16 s_MODE;

   // V_OVERFLOW
   int16 s_RX_SRC_EVENT;
   int16 s_TX_SRC_EVENT;
   int16 s_AFE_DECIM_IIR_OVERFLOW;
   int16 s_AFE_DECIM_FIR_OVERFLOW;
   int16 s_TXIIR_OVERFLOW;
   int16 s_RXIIR_OVERFLOW;
   int16 s_INTERP_OVERFLOW;
   int16 s_TX_SRC_OVERFLOW;
   int16 s_RX_SRC_OVERFLOW;
   int16 s_DECIM_OVERFLOW;
   int16 s_SJ_OVERFLOW;
   int16 s_TDQ_OVERFLOW;
   int16 s_TXWIN_OVERFLOW;
   int16 s_RXWIN_OVERFLOW;
   int16 s_TXVARGAIN_OVERFLOW;
   int16 s_RXVARGAIN_OVERFLOW;

   // V_TXIIR1_CFG
   int16 s_TX_LAST_SEC;
   int16 s_TX_SEC3_SHIFT;
   int16 s_TX_SEC2_SHIFT;
   int16 s_TX_SEC1_SHIFT;
   int16 s_TX_SEC0_SHIFT;

   // V_TXIIR2_CFG
   int16 s_TX_OUT_SHIFT;
   int16 s_TX_SEC7_SHIFT;
   int16 s_TX_SEC6_SHIFT;
   int16 s_TX_SEC5_SHIFT;
   int16 s_TX_SEC4_SHIFT;

   // V_RXIIR_CFG
   int16 s_RX_OUT_SHIFT;
   int16 s_RX_SEC3_SHIFT;
   int16 s_RX_SEC2_SHIFT;
   int16 s_RX_SEC1_SHIFT;
   int16 s_RX_SEC0_SHIFT;

   // V_AFE_DECIM
   int16 s_AFE_DECIM_CLEAR_PS;
   int16 s_AFE_DECIM_IIR_OUT_SHIFT;
   int16 s_AFE_DECIM_IIR_SEC1_SHIFT;
   int16 s_AFE_DECIM_IIR_SEC0_SHIFT;
   int16 s_AFE_DECIM_FIR_SCALE;

   // V_SRCFR
   int32 l_SRCFR;

   // V_SRCCTL
   int32 l_SRCCTL;

   // V_RESAMP_CFG
   int16 s_INTERP_MASK;
   int16 s_INTERP_SCALE;
   int16 s_DECIM_MASK;
   int16 s_DECIM_SCALE;
   int16 s_DECIM_PHASE;
   int16 s_SHORT_FILTER;
   int16 s_INTERP_BYPASS;
   int16 s_DECIM_BYPASS;
   int16 s_A_INTERP_LEN;
   int16 s_A_DECIM_LEN;

   // V_DEC_TDQ_CFG
   int16 s_TDQ_MASK;
   int16 s_TDQ_LENGTH;
   int16 s_DEC_DELAY;
   int16 s_DEC_LENGTH;
   int16 s_TDQ_SCALE;
   int16 s_DEC_SCALE;
   int16 s_DEC_MASK;
   int16 s_DEC_SOURCE;

   // V_DEC_TRAIN
   int16 s_IN_CAPTURE_ER;
   int16 s_SAMPLE_COUNT_RX;
   int16 s_DEC_TRAIN_STATE;
   int16 s_I_SAMPLES;
   int16 s_DEC_TRAINING_EN;

   // V_TX_VARGAIN
   int16 s_TX_VARGAIN_SCALE;
   int16 s_TX_VARGAIN;

   // V_TX_AVARGAIN
   int16 s_TX_AVARGAIN_SCALE;
   int16 s_TX_AVARGAIN;

   // V_RX_VARGAIN
   int16 s_RX_VARGAIN_SCALE;
   int16 s_RX_VARGAIN;

   // V_RX_AVARGAIN
   int16 s_RX_AVARGAIN_SCALE;
   int16 s_RX_AVARGAIN;

   // V_AFE_DECIM_IN_DBG
   int16 s_AFE_DECIM_SAMPLE_IN;
   int16 s_AFE_DECIM_DEBUG;
   int16 s_DSP_AFE_DECIM_TRIGGER;
   int16 s_AFE_DECIM_SAMPLE_IN_WR;

   // V_DECIM_IN_DBG
   int16 s_DECIM_SAMPLE_IN;
   int16 s_DECIM_DEBUG;
   int16 s_DSP_DECIM_TRIGGER;
   int16 s_DECIM_SAMPLE_IN_WR;

   // V_RXIIR_IN_DBG
   int16 s_RXIIR_SAMPLE_IN;
   int16 s_RXIIR_DEBUG;
   int16 s_DSP_RXIIR_TRIGGER;
   int16 s_RXIIR_SAMPLE_IN_WR;

   // V_TDQ_MSB_IN_DBG
   int32 l_TDQ_MSB_SAMPLE_IN;
   int16 s_TDQ_MSB_SAMPLE_IN_WR;

   // V_TDQ_LSB_IN_DBG
   int32 l_TDQ_LSB_SAMPLE_IN;
   int16 s_TDQ_DEBUG;
   int16 s_DSP_DT_TRIGGER;
   int16 s_TDQ_LSB_SAMPLE_IN_WR;

   // V_DEC_IN_DBG
   int16 s_DEC_SAMPLE_IN;
   int16 s_DEC_IN_ADDR;
   int16 s_DEC_DEBUG;
   int16 s_DEC_SAMPLE_IN_WR;

   // V_TXIIR_IN_DBG
   int16 s_TXIIR_SAMPLE_IN;
   int16 s_TXIIR_DEBUG;
   int16 s_DSP_TXIIR_TRIGGER;
   int16 s_TXIIR_SAMPLE_IN_WR;

   // V_INTERP_IN_DBG_OFFSET
   int16 s_INTERP_SAMPLE_IN;
   int16 s_INTERP_DEBUG;
   int16 s_DSP_INTERP_TRIGGER;
   int16 s_INTERP_SAMPLE_IN_WR;

   // V_INTERP_OUT_DBG
   int16 s_INTERP_SAMPLE_OUT;
   int16 s_INTERP_SAMPLE_PHASE;

   // V_WINDOW_DBG
   int16 s_RXWIN_SAMPLE_IN;
   int16 s_VW_DEBUG;
   int16 s_DSP_VW_TRIGGER;
   int16 s_VW_SAMPLE_IN_WR;

   // V_RXSRC_PHASE_IN_DBG
   int32 l_RXSRC_PHASE_IN;
   int16 s_RXSRC_PHASE_IN_WR;

   // Pseudo register bit fields
   int32 l_AdcSamplingRate;   // ADC sampling rate.
   int32 l_DacSamplingRate;   // DAC sampling rate.
   int16 s_TxAfeOutRate;      // Clock rate of Tx Afe output
   int16 s_TxSrcRate;         // Clock rate of Tx Src
   int16 s_TxInterpRate;      // Clock rate of Tx Interp
   int16 s_RxPathRate;        // Clock rate of Rx IIR and TDQ
   int32 l_RxPathSamplingRate;   // Sampling rate of Rx IIR, TDQ, Win, Var Gain
   int16 s_TxPathRate;        // Clock rate of Tx Var Gain, Win, DEC, IIR
   int32 l_TxPathSamplingRate;   // Sampling rate of Tx Win, DEC, IIR
   int16 s_Ds2UsRateRatio;    // Ratio of Tx path rate to Rx path rate
   int16 s_RxSrcRate;         // Clock rate of Rx Src
   int16 s_RxSrcDecimRate;    // Decimation rate of Rx Src
   int16 s_RxAfeInRate;    // Clock rate of Rx Afe input
   int16 s_AfeDecimDsFactor;  // AFE Decim downsampling factor
   int16 s_RxDecimInRate;     // Clock rate of Rx decimator
   int16 s_RxDecimDsFactor;   // Rx decimator downsampling factor
   int16 s_DecSampleInput;    // Flag to indicate that a sample has been written to the
                        // DEC IN debug register
} StrymonReg_t;

// Structure used for Strymon filter IO
typedef struct{
   // Tx filter IO
   int32 l_TxVarGainIn;
   int16 s_TxVarGainOut;
   int16 s_TxWinIn;
   int16 s_TxWinOut;
   int16 s_TxDecIn;
   int16 s_TxIirIn;
   int16 s_TxIirOut;
   int16 s_TxInterpIn;
   acc acc_TxInterpOut;
   int16 s_TxInterpOut;
   int16 s_TxSrcIn;
   acc acc_TxSrcOut;
   int16 s_TxSrcOut;

   // Rx filter IO
   int16 s_RxSrcIn;
   acc acc_RxSrcOut;
   int16 s_RxSrcOut;
   int16 s_RxAfeDecimFirIn;
   acc acc_RxAfeDecimFirOut;
   int32 l_RxAfeDecimIirIn;
   int16 s_RxAfeDecimIirOut;
   int16 s_RxDecimIn;
   acc acc_RxDecimOut;
   int16 s_RxDecimOut;
   int16 s_RxIirIn;
   acc acc_RxIirOut;
   acc acc_SumJuncIn;
   acc acc_RxDecOut;
   acc acc_RxTdqIn;
   int16 s_RxTdqIn;
   acc acc_RxTdqOut;
   int16 s_RxTdqOut;
   int16 s_RxWinIn;
   int16 s_RxWinOut;
   int16 s_RxVarGainIn;
   int16 s_RxVarGainOut;
} StrymonFilterIO_t;

// structure used for FIR filter routine
typedef struct {
   int16 s_FirType;
   int16 *ps_inbuf;           // pointer to input buffer
   acc *pacc_outbuf;          // pointer to output buffer
   int16 *psa_state;          // pointer to state buffer
   int16 s_state_write_ptr;      // write pointer to state buffer
   int16 *psa_h;              // int16 pointer to impulse response buffer
   int32 *pla_h;              // int32 pointer to impulse response buffer (used by Rx and Tx SRC only)
   int16 *ps_h_length;           // pointer to impulse response length
   int16 *ps_h_exp;           // pointer to impulse response exponent
   int16 *ps_interp_rate;        // pointer to interpolation rate
   int16 s_AccWidth;          // accumulator width in bits
} FirStruc_t;

// Bi-quad structures used by IIR sections
typedef struct {
   int32 *a[2];                  // a1, a2
   int32 *b[3];                  // b0, b1, b2
   int16 *ps_accumShift0;
} biquadSection_t;

// IIR structure used by Tx and Rx
typedef struct {
   int32 *pl_inScale;
   biquadSection_t *pt_biquad[MAX_NUM_BIQUADS];
   int16 *ps_outputShift;
   int16 s_AccWidth;       // width of accumulator
   int16 s_AccFracWidth;      // width of fractional part
   int16 s_ShiftInWidth;      // width of input to shifter
   int16 s_CoefWidth;         // width of coef
   int16 s_PastResultWidth;   // width of past results
} IirStruc_t;

typedef struct {
   int32 l_RxPhaseAcc;
   int32 l_RxPhaseAccOut;
   int16 s_RxSrcAddr;
   int16 s_RxSrcOffset;
   int16 s_GenOutput;

   int32 l_TxPhaseAcc;
   int16 s_TxSrcAddr;
   int16 s_TxSrcOffset;
} SrcControl_t;

#endif // _V_STR_TYPEDEF_H
