/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: strymon_cpe_compiler.h
;
;  Options for building the Strymon CPE behavioral model.
;
*****************************************************************************/

#ifndef _STRYMON_COMPILER_H
#define _STRYMON_COMPILER_H

/* If this variable is defined at compile time, the behavioral model
   will print a timing diagram to a file *debug_time if the file
   has been opened by the calling application. */
/*#define DEBUG_TIMING */

/* If this variable is defined at compile time, the behavioral model
   will print debugging info. about the SRC to a file *debug_src if
   the file has been opened by the calling application. */
/*#define DEBUG_SRC */

/* If this macro is defined at compile time, the behavioral model will
   print the input to each filter at each 8832 kHz clock cycle. */
/*#define DEBUG_FILTERS*/

/* ==== Temporary switches ==== */

/* If this variable is defined at compile time, the behavioral model
   will support only 32-bit access of the DEC/TDQ/RXWIN (B1) coefficient
   and past-sample RAMS.  If this variable is not defined, only 16-bit
   access of the B1 RAMS is supported (Strymon 2.0 mode). */
#define STRYMON_B1_32BIT_ACCESS

/* If this variable is defined at compile time, the behavioral model
   will support only 32-bit access of the AEC/Interp3/4 (B3) coefficient
   and past-sample RAMS.  If this variable is not defined, only 16-bit
   access of the B3 RAMS is supported (Strymon 2.0 mode). */
#define STRYMON_B3_32BIT_ACCESS

/* If this variable is defined at compile time, the behavioral model
   will utilize the Strymon_3.0 RX SRC filter coefficient set.  If this
   variable is not defined, the Strymon_2.0 RX SRC filter coefficients
   will be used. */
#define STRYMON_NEW_RX_SRC


#endif /* _STRYMON_COMPILER_H */
