/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: conf.h
;
;  Prototypes of functions for configuring and reading the parameters
;  of the Strymon CPE behavioral model.
;
*****************************************************************************/

#ifndef _CONF_H
#define _CONF_H

#include "strymon_cpe_typedef.h"
#include "strymon_cpe_compiler.h"

/* Strymon CPE core configuration functions. */

/* "Write" functions: */
void Write_TX_ROUND(int16 s_flag);
void Write_SRCBYPASS(int16 s_flag);
void Write_ADCBYPASS(int16 s_flag);
void Write_AECDISABLE(int16 s_flag);
void Write_DAC_FS(int16 s_flag);
void Write_ADC_FS(int16 s_flag);
void Write_RX_FS(int16 s_flag);
void Write_RX_WIN_ENABLE(int16 s_flag);
void Write_RX_WIN_DELAY(int16 s_flag);
void Write_DEC_SUM(int16 s_flag);
void Write_DECDELAY(int16 s_delay);
void Write_RESET(int16 s_flag);
void Write_AECDELAY(int16 s_delay);
void Write_LOWPOWER(int16 s_flag);
void Write_STARTMODE(int16 s_flag);
void Write_SOFTSTART(int16 s_flag);
void Write_B1_RX_IN(int16 s_flag);
void Write_B2_RX_IN(int16 s_flag);
void Write_B3_TX_IN(int16 s_flag);
void Write_B4_RX_IN(int16 s_flag);
void Write_B6_RX_IN(int16 s_flag);
void Write_B1_TRIG(int16 s_flag);
void Write_B2_TRIG(int16 s_flag);
void Write_B5_TRIG(int16 s_flag);
void Write_RAM_EN(int16 s_flag);
void Write_B6_TRIG(int16 s_flag);
void Write_B5_TX_IN(int16 s_flag);
void Write_B3_COUNTER(int16 s_value);
void Write_B5_COUNTER(int16 s_value);
void Write_DT_COUNTER(int16 s_value);
void Write_DT_STATE(int16 s_state);
void Write_DT_ENABLE(int16 s_flag);
void Write_DECCOEFFDONE(int16 s_flag);
void Write_DECCOEFFENA(int16 s_flag);
void Write_DECCOEFFADDR(int16 s_addr);
#ifndef STRYMON_B1_32BIT_ACCESS
void Write_DECCOEFF(int16 s_value);
#else
void Write_DECCOEFF1(int16 s_value);
void Write_DECCOEFF2(int16 s_value);
#endif
void Write_SM_POTSHPF(int16 s_value);
void Write_SM_INTERP1(int16 s_value);
void Write_SM_TXSRC(int16 s_value);
void Write_SM_INTERP3(int16 s_value);
void Write_SM_INTERP4(int16 s_value);
void Write_SM_RXSRC(int16 s_value);
void Write_SM_DECIMHPF(int16 s_value);
void Write_SM_VARGAIN(int16 s_value);
void Write_SM_AEC(int16 s_value);
void Write_SM_DEC(int16 s_value);
void Write_SM_RXINPUT(int16 s_value);
void Write_SM_DECIM0_IN_0(int16 s_value);
void Write_SM_DECIM0_IN_1(int16 s_value);
void Write_SM_TDQ(int16 s_value);
void Write_UPDATEFILTERS(int16 s_flag);
void Write_GAINVAL(int16 s_value);
void Init_TxGain(int16 s_Coeff, int16 s_OutputShift);
int16 Init_POTSHPF(int16 s_Length, int16 *psa_Fir, int16 s_OutputShift);
int16 Init_Interp1(int16 s_Length, int16 *psa_Fir, int16 s_OutputShift);
int16 Init_Interp3(int16 s_Length, int16 *psa_Fir, int16 s_OutputShift);
int16 Init_Interp4(int16 s_Length, int16 *psa_Fir, int16 s_OutputShift);
int16 Init_Decim2_HPF(int16 s_Length, int16 *psa_Fir, int16 s_OutputShift);
int16 Init_TDQ(int16 s_Length, int16 *psa_Fir, int16 s_OutputShift);
int16 Init_DEC(int16 s_Length, int16 *psa_Fir, int16 s_OutputShift);
int16 Init_AEC(int16 s_Length, int16 *psa_Fir, int16 s_OutputShift);
int16 Init_SRC(int16 s_R, uint8 uc_FixedRxAddrIncr, int32 l_RxPhaseOffset, int16 s_RxOutputShift, int16 s_TxOutputShift);
int16 Update_SRCFreqRatio(int32 l_R);
int16 DECCoeffAddr(int16 s_index);
int16 Interp3CoeffAddr(int16 s_index);
int16 Interp4CoeffAddr(int16 s_index);
int16 AECCoeffAddr(int16 s_index);
void Update_Filters(void);
void StrymonCPE_Reset(void);

/* "Read" functions: */
int16 Read_TX_ROUND(void);
int16 Read_SRCBYPASS(void);
int16 Read_ADCBYPASS(void);
int16 Read_AECDISABLE(void);
int16 Read_DAC_FS(void);
int16 Read_ADC_FS(void);
int16 Read_RX_FS(void);
int16 Read_DAC_FS_flag(void);
int16 Read_ADC_FS_flag(void);
int16 Read_RX_FS_flag(void);
int16 Read_RX_WIN_ENABLE(void);
int16 Read_RX_WIN_DELAY(void);
int16 Read_DEC_SUM(void);
int16 Read_DECDELAY(void);
int16 Read_RESET(void);
int16 Read_AECDELAY(void);
int16 Read_LOWPOWER(void);
int16 Read_STARTMODE(void);
int16 Read_SOFTSTART(void);
int16 Read_B1_RX_IN(void);
int16 Read_B2_RX_IN(void);
int16 Read_B3_TX_IN(void);
int16 Read_B4_RX_IN(void);
int16 Read_B6_RX_IN(void);
int16 Read_B1_TRIG(void);
int16 Read_B2_TRIG(void);
int16 Read_B5_TRIG(void);
int16 Read_RAM_EN(void);
int16 Read_B6_TRIG(void);
int16 Read_B5_TX_IN(void);
int16 Read_B1_DONE(void);
int16 Read_B2_DONE(void);
int16 Read_B3_DONE(void);
int16 Read_B5_DONE(void);
int16 Read_B6_DONE(void);
int16 Read_B3_COUNTER(void);
int16 Read_B5_COUNTER(void);
int16 Read_DT_COUNTER(void);
int16 Read_DT_STATE(void);
int16 Read_DT_ENABLE(void);
int16 Read_DECCOEFFDONE(void);
int16 Read_DECCOEFFENA(void);
int16 Read_DECCOEFFADDR(void);
#ifndef STRYMON_B1_32BIT_ACCESS
int16 Read_DECCOEFF(void);
#else
int16 Read_DECCOEFF1(void);
int16 Read_DECCOEFF2(void);
#endif
int16 Read_SM_POTSHPF(void);
int16 Read_SM_INTERP1(void);
int16 Read_SM_TXSRC(void);
int16 Read_SM_INTERP3(void);
int16 Read_SM_INTERP4(void);
int16 Read_SM_RXSRC(void);
int16 Read_SM_DECIMHPF(void);
int16 Read_SM_VARGAIN(void);
int16 Read_SM_AEC(void);
int16 Read_SM_DEC(void);
int16 Read_SM_RXINPUT(void);
int16 Read_SM_DECIM0_IN_0(void);
int16 Read_SM_DECIM0_IN_1(void);
int16 Read_SM_TDQ(void);
int16 Read_UPDATEFILTERS(void);
int16 Read_GAINVAL(void);
int32 Read_SRCFreqRatio(void);
InterpFir_t *Get_TxGain(void);
InterpFir_t *Get_POTSHPF(void);
InterpFir_t *Get_Interp1(void);
InterpFir_t *Get_Interp3(void);
InterpFir_t *Get_Interp4(void);
DecimFir_t *Get_Decim2_HPF(void);
DecimFir_t *Get_TDQ(void);
RxWindow_t *Get_RxWindow(void);
InterpFir_t *Get_DEC(void);
InterpFir_t *Get_AEC(void);
SRC_t *Get_SRC(void);
int16 *Get_S_CO_RAM_1(void);
int16 *Get_S_CO_RAM_2(void);
int16 *Get_S_CO_RAM_3(void);
int16 *Get_S_CO_RAM_5(void);
int16 *Get_S_DT_RAM(void);

void Strymon_ClearPastSamples(int16 bnum);

// Decimator 0
extern FDF_FirStruct_t gt_RxDecim0;
extern int16 gsa_RxDecim0Coef[DECIM0_LEN];
extern int16 gsa_RxDecim0PastSamples[DECIM0_LEN];
extern int16 gs_RxDecim0Length;
extern int16 gsa_RxDecim0In[MAX_STR_LATENCY];
extern int16 gs_RxDecim0Delay;

// Master clock
extern int32 gl_StrymonClock;

// Registers
extern StrReg_t gt_StrReg;

// Strymon filter IO
extern StrFilterIO_t gt_StrFilterIO;

#endif /* _CONF_H */
