/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: rx_tx.h
;
;  Prototypes of functions for implementing the Tx, Rx, AEC, and DEC
;  data paths, and the SRC controller.
;
*****************************************************************************/

#ifndef _RX_TX_H
#define _RX_TX_H

#include "strymon_cpe_typedef.h"

void Update_Interp1Reg(void);
void Set_RXSRC_Delay(int16 s_delay);
void Set_Dec_Delay1(int16 s_delay);
void Set_Dec_Delay2(int16 s_delay);
void Set_Decim2_HPF_Delay(int16 s_delay) ;
dAcc_t* Get_Decim2_HPFDelayedAcc(void);
dAcc_t* Get_DECDelayedAcc(void);
void Update_DTOffsetCounter(void);
void Update_DTCaptureCounter(void);
int16 Read_DTCaptureCounter(void);
void Connect_StrymonCPE_TxInput(int32 (*pf)(int32 *pl_Input, uint8 *puc_CsBetaStart, uint8 *puc_WindowStart, uint8 *puc_CoreSelect, uint16 *pus_BetaSize, uint8 *puc_OffsetIn, uint8 *puc_OffsetEr));
void Connect_StrymonCPE_RxInput(int16 (*pf)(int16 *s_Input));
void Reset_RxTx(void);
void SRCControl(void);
void CancelEcho(void);
int16 DEC(int16 s_OutputLength, int16 *ps_Output);
int16 TDQ(int16 s_Input, int16 s_InputLength, int16 *ps_Output);
void DTStateMachine(StrymonCPE_Input_t *pt_Input);
void CaptureSample(dAcc_t *pt_dAcc, int16 s_OutputShift, int16 *ps_LSW);
void DelayOutput(int16 s_FilterLabel, int16 *ps_sample);
int16 Rx_Path(StrymonCPE_Input_t *pt_Input, StrymonCPE_Output_t *pt_Output);
void DEC_Path(void);
void AEC_Path(StrymonCPE_Output_t* pt_Output);
int16 Tx_Path(StrymonCPE_Input_t *pt_Input, StrymonCPE_Output_t* pt_Output);
void Update_Counters(void);
int16 StrymonCPE_8832kHzClock(StrymonCPE_Input_t *pt_Input, StrymonCPE_Output_t *pt_Output);


int16 StrymonCPE(StrymonCPE_Input_t *pt_Input, StrymonCPE_Output_t *pt_Output);

#endif /* _RX_TX_H */
