/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: strymon_cpe_const.h
;
;  Fixed parameters of the Strymon CPE behavioral model.
;
*****************************************************************************/

#ifndef _STRYMON_CPE_CONST_H
#define _STRYMON_CPE_CONST_H

#include "strymon_cpe_compiler.h"

/* Core version. */
#define MAJOR_REVISION  (3) /* <= 15 */
#define MINOR_REVISION  (1) /* <= 15 */

/* Register addresses. */
#define SVERSION_OFFSET       (0x00)
#define SMODE_OFFSET       (0x01)
#define SCONTROL_OFFSET       (0x03)
#define SCOUNTER_OFFSET       (0x04)
#define ST_POTSHPF_OFFSET     (0x05)
#define ST_INTERP1_OFFSET     (0x06)
#define ST_INTERP3_OFFSET     (0x07)
#define ST_INTERP4_OFFSET     (0x08)
#define SE_AEC_OFFSET         (0x09)
#define SE_AECDELAY_OFFSET    (0x0A)
#define SE_DEC_OFFSET         (0x0B)
#define SE_DECDELAY_OFFSET    (0x0C)
#define ST_GAINCTL_OFFSET     (0x0D)
#define ST_GAINVAL_OFFSET     (0x0E)
#define SR_DECIM2_HPF_OFFSET  (0x0F)
#define SE_TDQ_OFFSET         (0x10)
#define SB_SRCFR_OFFSET       (0x11)
#define SB_SRCCTL_OFFSET      (0x12)

#define ST_SRCTX_OFFSET       (0x14)
#define SR_SRCRX_OFFSET       (0x15)
#define SE_DECTRAIN_OFFSET    (0x16)
#define SE_DECADDR_OFFSET     (0x17)

#ifndef STRYMON_B1_32BIT_ACCESS
#define SE_DECCOEFF_OFFSET    (0x18)
#else
#define SE_DECCOEFF1_OFFSET      (0x18)
#define SE_DECCOEFF2_OFFSET      (0x19)

#endif

#define SR_WINDOW_OFFSET      (0x1A)
#define SOVERFLOW_OFFSET      (0x1B)
#define SR_VARGAIN_OFFSET     (0x1C)
#define SR_AVARGAIN_OFFSET    (0x1D)
#define SR_DECIM0_OFFSET      (0x1E)

#define SM_POTSHPF_OFFSET       (0x20)
#define SM_INTERP1_OFFSET       (0x21)
#define SM_TXSRC_OFFSET         (0x22)
#define SM_INTERP3_OFFSET       (0x23)
#define SM_INTERP4_OFFSET       (0x24)
#define SM_RXSRC_OFFSET         (0x25)
#define SM_DECIMHPF_OFFSET      (0x26)
#define SM_VARGAIN_OFFSET       (0x27)
#define SM_AEC_OFFSET           (0x28)
#define SM_DEC_OFFSET           (0x29)
#define SM_RXINPUT_OFFSET       (0x2A)    // 4 x 16 bit registers
#define SM_TDQ_OFFSET         (0x2E)
#define SM_DECIM0_IN_0_OFFSET (0x2F)
#define SM_DECIM0_IN_1_OFFSET (0x30)

#define S_MAX_REG_OFFSET        (SM_DECIM0_IN_1_OFFSET)

/* Addresses of memory blocks mapped to the address space of the DSP. */
/* Previously the registers and rams reside in one contiguous memory block. */
/* Now they reside in separate blocks, hence offset S_CO_RAM_2_LOW_OFFSET is now 0. */
#define S_CO_RAM_2_LOW_OFFSET (0x000)     // coefficient memory, FB2 (Decim)
#define S_CO_RAM_2_HIGH_OFFSET   (0x07F)

#define S_PS_RAM_2_LOW_OFFSET   (0x080)      // past sample memory, FB2 (Decim)
#define S_PS_RAM_2_HIGH_OFFSET  (0x0FF)

#define S_PS_RAM_4_LOW_OFFSET   (0x100)      // past sample memory, FB4 (SRC)
#define S_PS_RAM_4_HIGH_OFFSET  (0x17F)

#ifndef STRYMON_B3_32BIT_ACCESS

#define S_CO_RAM_3_LOW_OFFSET (0x180)     // coefficient memory, FB3 (AEC); 16-bit R/W
#define S_CO_RAM_3_HIGH_OFFSET   (0x1CF)

#define S_PS_RAM_3_LOW_OFFSET   (0x200)      // past sample memory, FB3 (AEC); 16-bit R/W
#define S_PS_RAM_3_HIGH_OFFSET  (0x24F)

#else

#define S_CO_RAM_3_LOW_OFFSET (0x180)     // coefficient memory, FB3 (AEC); 32-bit R/W
#define S_CO_RAM_3_HIGH_OFFSET   (0x1BF)

#define S_PS_RAM_3_LOW_OFFSET   (0x1C0)      // past sample memory, FB3 (AEC); 32-bit R/W
#define S_PS_RAM_3_HIGH_OFFSET  (0x1FF)

#endif

#define S_CO_RAM_5_LOW_OFFSET (0x200)     // coefficient memory, FB5 (Interp)
#define S_CO_RAM_5_HIGH_OFFSET   (0x2FF)

#define S_PS_RAM_5_LOW_OFFSET   (0x300)      // past sample memory, FB5 (Interp)
#define S_PS_RAM_5_HIGH_OFFSET  (0x3FF)

#define S_DT_RAM_LOW_OFFSET      (0x400)     // DEC summing junction capture memory
#define S_DT_RAM_HIGH_OFFSET  (0x47F)

#ifndef STRYMON_B1_32BIT_ACCESS

#define S_PS_RAM_1_LOW_OFFSET   (0x480)      // past sample memory, FB1 (DEC); 16-bit R/W
#define S_PS_RAM_1_HIGH_OFFSET  (0x57F)

#define S_CO_RAM_1_LOW_OFFSET   (0x600)      // coefficient memory, FB1 (DEC); 16-bit R/W
#define S_CO_RAM_1_HIGH_OFFSET  (0x7FF)

#else

#define S_PS_RAM_1_LOW_OFFSET   (0x480)      // past sample memory, FB1 (DEC); 32-bit R/W
#define S_PS_RAM_1_HIGH_OFFSET  (0x4FF)

#define S_CO_RAM_1_LOW_OFFSET   (0x500)      // coefficient memory, FB1 (DEC); 32-bit R/W
#define S_CO_RAM_1_HIGH_OFFSET  (0x5FF)

#endif

// Latency model macros
#define MAX_STR_LATENCY 512
#define RX_DECIM_DELAY (0)
#define RX_DECIM_DELAY_DBG (0)

// Decimator 0 parameters
#define DECIM0_LEN   10
#define RX_DECIM0_FIR_ACC_WIDTH 35

// FIR filter definitions
#define DELAY     (0)
#define OUTPUT    (1)

// Rx overflow macros
#ifdef UNIX_PLATFORM
#define DECIM0_FIR_ACC_MIN (0xFFFFFFFFE0000000LL)  // minimum value of DECIM0 FIR accumulator
#define DECIM0_FIR_ACC_MAX (0x000000001FFFFFFFLL)  // maximum value of DECIM0 FIR accumulator
#define RX_VARGAIN_OUT_MAX (0x000000003FFFFFFFLL)  // maximum value of Rx variable gain output
#define RX_VARGAIN_OUT_MIN (0xFFFFFFFFC0000000LL)  // minimum value of Rx variable gain output
#else
#define DECIM0_FIR_ACC_MIN (0xFFFFFFFFE0000000) // minimum value of DECIM0 FIR accumulator
#define DECIM0_FIR_ACC_MAX (0x000000001FFFFFFF) // maximum value of DECIM0 FIR accumulator
#define RX_VARGAIN_OUT_MAX (0x000000003FFFFFFF) // maximum value of Rx variable gain output
#define RX_VARGAIN_OUT_MIN (0xFFFFFFFFC0000000) // minimum value of Rx variable gain output
#endif


/* SRC parameters and memory sizes. */
#ifndef STRYMON_NEW_RX_SRC
#define LOG2_DOWN_FACTOR 6    /* log2 of fixed downsampling factor of Rx SRC */
#else
#define LOG2_DOWN_FACTOR 7    /* log2 of fixed downsampling factor of Rx SRC */
#endif
#define LOG2_UP_FACTOR 6      /* log2 of fixed upsampling factor of Tx SRC */
#define LOG2_INTERP_FACTOR 7  /* log2 of no. of interpolated filter coeff. */
                        /* per stored filter coeff. */
#define RX_HALF_NUM_CYCLES 6  /* half no. of cycles in Rx SRC filter */
#define TX_HALF_NUM_CYCLES 6  /* half no. of cycles in Tx SRC filter */
#define RX_CYCLE_LENGTH (1 << (LOG2_INTERP_FACTOR+LOG2_DOWN_FACTOR))
#define TX_CYCLE_LENGTH (1 << (LOG2_INTERP_FACTOR+LOG2_UP_FACTOR))
#define LOG2_MAX_PHASE 24  /* >= LOG2_INTERP_FACTOR+max(LOG2_UP_FACTOR,LOG2_DOWN_FACTOR) */
#define BASE_FREQ_RATIO (1 << (LOG2_MAX_PHASE-2))
#define MIN_DELTA_FREQ_RATIO (-(1 << 15))
#define MIN_FREQ_RATIO (BASE_FREQ_RATIO+MIN_DELTA_FREQ_RATIO)

#define SRC_TX_FIR_HALFLENGTH (TX_HALF_NUM_CYCLES*TX_CYCLE_LENGTH+1)
#define SRC_RX_FIR_HALFLENGTH (RX_HALF_NUM_CYCLES*RX_CYCLE_LENGTH+1)
#define SRC_TX_STATE_LENGTH (2*TX_HALF_NUM_CYCLES+1)
#define MAX_SRC_RX_STATE_LENGTH (((2*RX_HALF_NUM_CYCLES+1)*(1 << LOG2_MAX_PHASE)-1)/MIN_FREQ_RATIO+1)

/* Filter parameters and memory sizes. */
#define MAX_POTSHPF_LENGTH    (160)
#define MAX_INTERP1_LENGTH    (160)
#define MAX_INTERP3_LENGTH    (128)
#define MAX_INTERP4_LENGTH    (128)
#define MAX_DECIM2_HPF_LENGTH (180)
#define MAX_TDQ_LENGTH        (64)
#define MAX_RX_WINDOW_LENGTH  (64)

#define MAX_DEC_LENGTH        (512)
#define MAX_DECDELAY       (31)

#define MAX_AEC_LENGTH        (64)
#define MAX_AECDELAY       (31)

/* Accumulator sizes. */

/* Setting ACC1_LENGTH, ACC2_lENGTH, ACC3_LENGTH, */
/* and ACC5_LENGTH equal to N+31 guarantees that */
/* up to 2^N 32-bit numbers can be accumulated */
/* without overflowing/underflowing the accumulator, */
/* except when all the accumulated numbers have the */
/* minimum value 0x80000000. */

#define ACC1_LENGTH 41  /* Filter length <= 512. */
#define ACC2_LENGTH 40  /* Filter length <= 512. */
#define ACC3_LENGTH 38  /* Filter length <= 128. */
#define ACC4_LENGTH 40  /* Filter length <= 128. */
                  /* Setting ACC4_LENGTH equal to N+33 */
                  /* guarantees that up to 2^N 32-bit numbers */
                  /* can be accumulated without overflowing/ */
                  /* underflowing the accumulator, except when */
                  /* all the added numbers have the minimum */
                  /* value 0x200000000. */
#define ACC5_LENGTH 40  /* Filter length <= 128. */

/* States and parameters of DEC training state machine */
#define DT_IDLE         (0)
#define DT_COUNT     (1)
#define DT_CAPTURE      (2)
#define DT_DONE         (3)
#define NUM_DT_SAMPLES     (64)
#define LENGTH_RX_FRAME    (544)

/* Filter pipeline delays */
#define IRIDIA_DELAY    (0)
#define TXGAIN_DELAY    (1)
#define POTSHPF_DELAY      (1)
#define INTERP1_DELAY      (0)
#define TXSRC_DELAY        (0)
#define INTERP3_DELAY      (8)
#define AEC_DELAY       (1)
#define INTERP4_DELAY      (8)
#define DECIM2_HPF_DELAY   (0)
#define RX_DECIM0_DELAY    (1)
#define RXSRC_DELAY        (1)
#define TDQ_DELAY       (1)
#define RX_WIN_DELAY    (2)   // delay before RxWindow output written to Rx VarGain input buffer
#define RX_VARGAIN_DELAY   (0)   // delay before Rx VarGain output written to FFT input buffer
#define DEC_DELAY1         (1) // delay for DEC summing junction before TDQ
#define DEC_DELAY2         (1) // delay for DEC summing junction after TDQ

/* Upper bounds for programmable delays */
#define MAX_DECIM2_HPF_DELAY        (4)
#define MAX_DEC_DELAY1              (4)
#define MAX_DEC_DELAY2              (4)


/*Input phase selection of decim2_hpf when downsampling by 2*/
// Change to -1 if input phase is even
// Change to -2 if input phase is odd

#define DECIM2_INPUT_PHASE   -2

#endif /* _STRYMON_CPE_CONST_H */
