/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: strymon_cpe_memmap.h
*
*   This file contains Strymon CPE BM memory map.
*
*-------------------------------------------------------------------------------
*/

#ifndef _STRYMON_CPE_MEMMAP_H
#define _STRYMON_CPE_MEMMAP_H

#include "strymon_cpe_const.h"

#define STR_REG_BASE_ADDR     (uint32)(0x0C500)

#define SVERSION_ADDR         (uint32)(STR_REG_BASE_ADDR + SVERSION_OFFSET)
#define SMODE_ADDR            (uint32)(STR_REG_BASE_ADDR + SMODE_OFFSET)
#define SCONTROL_ADDR         (uint32)(STR_REG_BASE_ADDR + SCONTROL_OFFSET)
#define SCOUNTER_ADDR         (uint32)(STR_REG_BASE_ADDR + SCOUNTER_OFFSET)
#define ST_POTSHPF_ADDR       (uint32)(STR_REG_BASE_ADDR + ST_POTSHPF_OFFSET)
#define ST_INTERP1_ADDR       (uint32)(STR_REG_BASE_ADDR + ST_INTERP1_OFFSET)
#define ST_INTERP3_ADDR       (uint32)(STR_REG_BASE_ADDR + ST_INTERP3_OFFSET)
#define ST_INTERP4_ADDR       (uint32)(STR_REG_BASE_ADDR + ST_INTERP4_OFFSET)
#define SE_AEC_ADDR           (uint32)(STR_REG_BASE_ADDR + SE_AEC_OFFSET)
#define SE_AECDELAY_ADDR      (uint32)(STR_REG_BASE_ADDR + SE_AECDELAY_OFFSET)
#define SE_DEC_ADDR           (uint32)(STR_REG_BASE_ADDR + SE_DEC_OFFSET)
#define SE_DECDELAY_ADDR      (uint32)(STR_REG_BASE_ADDR + SE_DECDELAY_OFFSET)
#define ST_GAINCTL_ADDR       (uint32)(STR_REG_BASE_ADDR + ST_GAINCTL_OFFSET)
#define ST_GAINVAL_ADDR       (uint32)(STR_REG_BASE_ADDR + ST_GAINVAL_OFFSET)
#define SR_DECIM2_HPF_ADDR    (uint32)(STR_REG_BASE_ADDR + SR_DECIM2_HPF_OFFSET)
#define SE_TDQ_ADDR           (uint32)(STR_REG_BASE_ADDR + SE_TDQ_OFFSET)
#define SB_SRCFR_ADDR         (uint32)(STR_REG_BASE_ADDR + SB_SRCFR_OFFSET)
#define SB_SRCCTL_ADDR        (uint32)(STR_REG_BASE_ADDR + SB_SRCCTL_OFFSET)
#define ST_SRCTX_ADDR         (uint32)(STR_REG_BASE_ADDR + ST_SRCTX_OFFSET)
#define SR_SRCRX_ADDR         (uint32)(STR_REG_BASE_ADDR + SR_SRCRX_OFFSET)
#define SE_DECTRAIN_ADDR      (uint32)(STR_REG_BASE_ADDR + SE_DECTRAIN_OFFSET)
#define SE_DECADDR_ADDR       (uint32)(STR_REG_BASE_ADDR + SE_DECADDR_OFFSET)
#define SE_DECCOEFF1_ADDR     (uint32)(STR_REG_BASE_ADDR + SE_DECCOEFF1_OFFSET)
#define SE_DECCOEFF2_ADDR     (uint32)(STR_REG_BASE_ADDR + SE_DECCOEFF2_OFFSET)
#define SR_WINDOW_ADDR        (uint32)(STR_REG_BASE_ADDR + SR_WINDOW_OFFSET)
#define SOVERFLOW_ADDR        (uint32)(STR_REG_BASE_ADDR + SOVERFLOW_OFFSET)
#define SR_VARGAIN_ADDR       (uint32)(STR_REG_BASE_ADDR + SR_VARGAIN_OFFSET)
#define SR_AVARGAIN_ADDR      (uint32)(STR_REG_BASE_ADDR + SR_AVARGAIN_OFFSET)
#define SR_DECIM0_ADDR        (uint32)(STR_REG_BASE_ADDR + SR_DECIM0_OFFSET)

#define STR_MEM_BASE_ADDR     (uint32)(0x1C000)

#define S_DT_RAM_LOW_ADDR     (uint32)(STR_MEM_BASE_ADDR + S_DT_RAM_LOW_OFFSET)
#define S_DT_RAM_HIGH_ADDR    (uint32)(STR_MEM_BASE_ADDR + S_DT_RAM_HIGH_OFFSET)
#define S_CO_RAM_2_LOW_ADDR      (uint32)(STR_MEM_BASE_ADDR + S_CO_RAM_2_LOW_OFFSET)
#define S_CO_RAM_2_HIGH_ADDR  (uint32)(STR_MEM_BASE_ADDR + S_CO_RAM_2_HIGH_OFFSET)
#define S_CO_RAM_5_LOW_ADDR      (uint32)(STR_MEM_BASE_ADDR + S_CO_RAM_5_LOW_OFFSET)
#define S_CO_RAM_5_HIGH_ADDR  (uint32)(STR_MEM_BASE_ADDR + S_CO_RAM_5_HIGH_OFFSET)
#define S_CO_RAM_3_LOW_ADDR      (uint32)(STR_MEM_BASE_ADDR + S_CO_RAM_3_LOW_OFFSET)
#define S_CO_RAM_3_HIGH_ADDR  (uint32)(STR_MEM_BASE_ADDR + S_CO_RAM_3_HIGH_OFFSET)
#define S_CO_RAM_1_LOW_ADDR      (uint32)(STR_MEM_BASE_ADDR + S_CO_RAM_1_LOW_OFFSET)
#define S_CO_RAM_1_HIGH_ADDR  (uint32)(STR_MEM_BASE_ADDR + S_CO_RAM_1_HIGH_OFFSET)

#endif // _STRYMON_CPE_MEMMAP_H
