/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: strymon_cpe_typedef.h
;
;  Data types of the Strymon CPE behavioral model.
;
*****************************************************************************/

#ifndef _STRYMON_CPE_TYPEDEF_H
#define _STRYMON_CPE_TYPEDEF_H


#ifndef FALSE
   #define FALSE           0
#endif
#ifndef TRUE
   #define TRUE            1
#endif

#ifndef _BASIC_TYPES
#define _BASIC_TYPES

typedef void  (*PtrToFunc)(void);

/* Variable type definitions */
typedef double float64;          /* prefix d in hungarian notation */
typedef long  int32;          /* prefix l */
typedef char  int8;              /* prefix c */
typedef short int16;          /* prefix s */
typedef unsigned char uint8;     /* prefix uc */
typedef unsigned long uint32;    /* prefix ul */
typedef unsigned short uint16;      /* prefix us */
typedef unsigned long Float32;      /* prefix f */
typedef unsigned char FlagT;     /* prefix ft */
typedef unsigned short bool;     /* prefix b */

#endif /* _BASIC_TYPES */

#ifndef acc
// define 64-bit accumulator type
#ifdef UNIX_PLATFORM
#define acc long long
#else
#ifdef MSVC_ONLY
#define acc __int64
#else
#define acc long
#endif
#endif
#endif //#ifndef acc

/* Data structures for Strymon CPE behavioral model */
typedef struct {
   int16 s_Status;   /* normal = 0, overflow/underflow = 1. */
   int16 s_Length;   /* length of accumulator (<= 53) */
   float64  d_Value; /* value stored in accumulator */
   float64  d_MaxValue; /* MAX value that can be stored in accumulator */
   float64  d_MinValue; /* MIN value that can be stored in accumulator */
} dAcc_t;

typedef struct {
   dAcc_t   *pt_dAcc;         /* pointer to accumulator */
   int16 s_Length;         /* length of impulse response */
   int16 *psa_Fir;         /* pointer to impulse response */
   int16 *psa_State;       /* pointer to state vector */
   int16 s_OutputShift;    /* Shift applied to contents of the */
                        /* accumulator to produce the output. */
   int16 s_Overflow;       /* output overflow flag */
   //int16  s_ClearOverflow;  /* clear output overflow flag */
   int16 s_UpsamplingFactor;  /* upsampling factor */
   int16 s_PhaseIdx;       /* filter phase index */
   int16 s_MaskOutputToZero;  /* mask output to zero */
} InterpFir_t;

typedef struct {
   dAcc_t   *pt_dAcc;            /* pointer to accumulator */
   int16 s_Length;            /* length of impulse response */
   int16 *psa_Fir;            /* pointer to impulse response */
   int16 *psa_State;          /* pointer to state vector */
   int16 s_OutputShift;       /* Shift applied to contents of the */
                           /* accumulator to produce the output. */
   int16 s_Overflow;          /* output overflow flag */
// int16 s_ClearOverflow;     /* clear output overflow flag */
   int16 s_DownsamplingFactor;   /* downsampling factor */
   int16 s_CyclicTimeRef;     /* time reference of downsampler */
   int16 s_MaskOutputToZero;     /* mask output to zero */
} DecimFir_t;

typedef struct {
   dAcc_t   *pt_dAcc;            /* pointer to accumulator */
   int16 *psa_Coeff;          /* pointer to coefficients */
   int16 *psa_State;          /* pointer to state vector */
   int16 s_OutputShift;       /* Shift applied to contents of the */
                           /* accumulator to produce the output. */
   int16 s_Overflow;          /* output overflow flag */
} RxWindow_t;

typedef struct {
   dAcc_t   *pt_dAcc;               /* pointer to accumulator */
   int32 l_RxHalfLength;            /* length of Rx impulse response = */
                              /* 2*l_HalfLength-1 */
   int32 *pla_RxFir;             /* pointer to Rx impulse response */
   int16 *psa_RxState;           /* pointer to Rx state vector */
   int16 s_RxOutputShift;        /* Shift applied to contents of the */
                              /* accumulator to produce Rx output. */
   int16 s_RxOutOverflow;        /* Rx output overflow flag */
// int16 s_ClearRxOutOverflow;      /* clear Rx output overflow flag */
   int16 s_MaskRxOutputToZero;      /* mask Rx output to zero */
   int32 l_TxHalfLength;            /* length of Tx impulse response = */
                              /* 2*l_HalfLength-1 */
   int32 *pla_TxFir;             /* pointer to Tx impulse response */
   int16 *psa_TxState;           /* pointer to Tx state vector */
   int16 s_TxOutputShift;        /* Shift applied to contents of the */
                              /* accumulator to produce Tx output. */
   int16 s_TxOutOverflow;        /* Tx output overflow flag */
// int16 s_ClearTxOutOverflow;      /* clear Tx output overflow flag */
   int16 s_MaskTxOutputToZero;      /* mask Tx output to zero */
   int32 l_FreqRatio;            /* frequency ratio */
   int32 l_PhaseCounter;            /* phase reference of downsampler */
   int32 l_RxPhaseOffset;        /* phase offset of Rx SRC */
   int16 s_RxPhaseOverflow;         /* Rx phase overflow flag */
   int16 s_TxPhaseOverflow;         /* Tx phase overflow flag */
   int16 s_RxOutTxInSync;        /* SRC Rx ouput-Tx input sync. counter */
   uint8 uc_FixedRxAddrIncr;        /* 1 = fixed ROM address increment for */
                              /* all down-sampling ratios, */
                              /* 0 = variable ROM address increment. */
} SRC_t;

// Structure used for registers
typedef struct {

   // SOVERFLOW
   int16 s_DECIM0_OVF;
   int16 s_RXVG_OVF;

   // SR_VARGAIN
   int16 s_VarGainScale;
   int16 s_VarGainCoef;

   // SR_AVARGAIN
   int16 s_AVarGainScale;
   int16 s_AVarGainCoef;

   // SR_DECIM0
   int16 s_DECIM0_PHASE;
   int16 s_DECIM0_BYPASS;
   int16 s_DECIM0_SCALE;

} StrReg_t;

// Structure used for Strymon filter IO
typedef struct{
   // Tx filter IO

   // Rx filter IO
   int16 s_RxDecim0In;
   acc acc_RxDecim0Out;
   int16 s_RxDecim0Out;
} StrFilterIO_t;

// structure used for FIR filter routine
typedef struct {
   int16 *ps_inbuf;           // pointer to input buffer
   acc *pacc_outbuf;          // pointer to output buffer
   int16 *psa_state;          // pointer to state buffer
   int16 s_state_write_ptr;      // write pointer to state buffer
   int16 *psa_h;              // int16 pointer to impulse response buffer
   int16 *ps_h_length;           // pointer to impulse response length
   int16 *ps_h_exp;           // pointer to impulse response exponent
   int16 s_AccWidth;          // accumulator width in bits
} FDF_FirStruct_t;

typedef struct {
   int16 s_ITOFS;       /* Transmit Offset Frame Strobe */
   int16 s_IRSFS;       /* Receive Sync Frame Strobe */
   int16 s_IRFS;        /* Receive Frame Strobe:  1 = copy Rx var gain shadow reg to active reg */
   int16 s_IRFS_RXWIN_CAPT;/* Receive Frame Strobe Window:  1 = start saving CP samples */
   int16 s_IRWS;        /* Receive Window Strobe: 1 = start windowing */
} StrymonCPE_Input_t;

typedef struct {
   int16 s_RxOutputValid;
   int16 s_RxOutput;
   int16 s_RxOutput2;      // Used only in ADC bypass mode when ADC = 17.664 Ms/s
   int16 s_TxOutputValid;
   int16 s_TxOutput;
   int16 s_TxOutput2;
   int16 s_AECOutputValid;
   int16 s_AECOutput;
   int16 s_AECDONE;
   int16 s_DECDONE;
} StrymonCPE_Output_t;

#endif /*_STRYMON_CPE_TYPEDEF_H */
