/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _ZEPHYRBM_H
#define _ZEPHYRBM_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             zephyrbm.h
 * DESCRIPTION:      Header file for Zephyr Bit-True Behavioral Model (BTBM).
 *
 **********************************************************************/



// these are needed by the cocomo hwenginelib functions
// Byte enable masks
#ifndef BYTE0_EN
#define NO_BYTE_EN      (0x0)
#define BYTE0_EN     (0x1)
#define BYTE1_EN     (0x2)
#define BYTE2_EN     (0x4)
#define BYTE3_EN     (0x8)
#define LOWER_WORD_EN   (BYTE1_EN | BYTE0_EN)
#define UPPER_WORD_EN   (BYTE3_EN | BYTE2_EN)
#define LONGWORD_EN     (UPPER_WORD_EN | LOWER_WORD_EN)
#endif // BYTE0_EN

// =============================================================================
// Functions for reading/writing RAM blocks
// =============================================================================

/* Writes a 16-bit word at given offset in specified RAM.*/
 int32 ZEP_WriteWord(uint32 us_address, uint32 ul_data, uint8 uc_ByteEnable);

/* Reads a 16-bit word from given offset in specified RAM. */
 int32 ZEP_ReadWord(uint32 us_address, uint32 *ul_data, uint8 uc_ByteEnable);


// =============================================================================
// Functions for initializing Zephry BM
// =============================================================================

int32 ZEP_InitializeBM();
//  Function for performing Asynchronous Reset
int32 ZEP_Reset(void);

// =============================================================================
// Functions for clocking core
// =============================================================================
int32 ZEP_Clock();

#endif //_ZEPHYRBM_H    Do not add anything below this line.


