/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _ZEP_CONST_H
#define _ZEP_CONST_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             zep_const.h
 * DESCRIPTION:      Constants for Zephyr Bit-True Behavioral Model (BTBM).
 *
 **********************************************************************/
// Useful Masks
#ifndef  MASK_BIT0
#define  MASK_BIT0   0x1
#define  MASK_BIT1   0x2
#define  MASK_BIT2   0x4
#define  MASK_BIT3   0x8
#define  MASK_BIT4   0x10
#define  MASK_BIT5   0x20
#define  MASK_BIT6   0x40
#define  MASK_BIT7   0x80
#define  MASK_BIT8   0x100
#define  MASK_BIT9   0x200
#define  MASK_BIT10  0x400
#define  MASK_BIT11  0x800
#define  MASK_BIT12  0x1000
#define  MASK_BIT13  0x2000
#define  MASK_BIT14  0x4000
#define  MASK_BIT15  0x8000
#endif   // MASK_BIT0

// Masks for Z_STATUS
#define MASK_TX_DONE MASK_BIT0
#define MASK_RX_DONE MASK_BIT4

// Masks for ZT_ENABLE and ZR_ENABLE
#define MASK_ENABLE_FAST   MASK_BIT4
#define MASK_ENABLE_INLV   MASK_BIT0

// Masks for Z_SYNC
#define MASK_TX_SYNC MASK_BIT0
#define MASK_RX_SYNC MASK_BIT4



// RS constants
#define  RS_CHECKBYTES     (16)
#define LOG2_RS_CHECKBYTES (4)
#define MAX_CW_SIZE        (255)

#define     ZEP_MAX_NUM_PORTS    8

#ifndef NUM_DSP
#define NUM_DSP      4 // number of DSP cores
#endif



#ifndef FALSE
   #define FALSE  0
#endif

#ifndef TRUE
   #define TRUE   1
#endif


#ifndef NUM_LP
#define NUM_LP    2
#endif

#ifndef NUM_BC
#define NUM_BC    2
#endif

#ifndef LP0
#define LP0       0
#define LP1       1
#endif

#ifndef BC0
#define BC0       0
#define BC1       1
#endif


// Estimated TX/RX  Latencies in clock cycles
#define  LATENCY_ZT_TOTAL        4
#define  LATENCY_ZR_TOTAL        4

// framing mode definitions
#define FULL_ASYNC         0
#define FULL_SYNC       1
#define REDUCED_SEPARATE   2
#define REDUCED_MERGED     3
#define ADSL2           4
#define SIMPLIFIED         7
#define VDSL1               5

// Sizes needed in framing/deframing
#define     TX_MUX_DATA_NBYTES               (512)
#define     RX_MUX_DATA_NBYTES               (256)



/**********************************************************************
 *
 * RAM Sizes
 *
 **********************************************************************/



#define DZ_BYTE     (0x3A)

#define DRS_BYTE    (0xD3)

#define VDSL_SYNC_BYTE   (0x3C)

#define  IB_FIFO         (0x2)

#define  HDLC_FIFO        (0x0)

#define  VDSL_DUMMY_BYTE  (0xFF)

#define  EOC_FIFO         (0x0)

#define  VOC_FIFO         (0x1)

#define  PROCESS_LP0      (0x1)

#define  PROCESS_LP1      (0x2)

#define  WAIT_FOR_TXDTBUSY_LOW_FOR_LP0  (0x3)

#define  WAIT_FOR_TXDTBUSY_LOW_FOR_LP1  (0x4)

#define  WAIT_FOR_RXDTBUSY_LOW_FOR_LP1  (0x5)

#define  WAIT_FOR_RXDTBUSY_LOW_FOR_LP0  (0x6)

#define  RX_RS_DATA_BYTES  (0x1)

#define  RX_FRAMER         (0x2)

#define  WAIT_FOR_CODEWORD_AVAIL  (0x3)

#define  RS_DATA_BYTES     (0x1)

#define  RS_CHECK_BYTES    (0x2)

#define  FIFO0              (0)

#define  FIFO1              (1)

#define  FIFO2              (2)

#define  WAIT_FOR_ILV_RX_ON    (1)

#define   WAIT_FOR_ILV_RX_OFF  (2)

#define  WAIT_FOR_ILV_NEXT_FRAME  (3)

#define  FAST_BYTE_STATE      (0)

#define  BC0_MUX_DATA_STATE      (1)

#define  BC1_MUX_DATA_STATE      (2)

#define  AEX_LEX_STATE        (3)

#define  SYNC_BYTE_STATE      (0)

#define  ILV_BC0_MUX_DATA_STATE     (1)

#define  ILV_BC1_MUX_DATA_STATE     (2)

#define  ILV_AEX_LEX_STATE       (3)

#define  RX_FAST_BYTE_STATE        (1)

#define  RX_BC0_MUX_DATA_STATE     (2)

#define  RX_BC1_MUX_DATA_STATE     (3)

#define  RX_AEX_LEX_STATE          (4)

#define  RX_LEX_STATE              (5)

#define  RX_SYNC_BYTE_STATE         (1)

#define  RX_ILV_BC0_MUX_DATA_STATE     (2)

#define  RX_ILV_BC1_MUX_DATA_STATE     (3)

#define  RX_ILV_AEX_LEX_STATE          (4)

#define  RX_ILV_LEX_STATE              (5)


// VDSL states

#define  VDSL_TX_OVERHEAD_STATE         (1)

#define  VDSL_TX_PAYLOAD_STATE          (2)

#define  VDSL_TX_DRS_STATE              (3)


#define  VDSL_RX_OVERHEAD_STATE         (1)

#define  VDSL_RX_PAYLOAD_STATE          (2)

#define  VDSL_RX_DRS_STATE              (3)


#define  AEX_LEX_ZERO_BYTE              (0x0)
#define  AEX_LEX_AOC_BYTE               (0xC)   // to indicate it is AOC byte



#endif //_ZEP_CONST_H   Do not add anything below this line.


